/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework.ui.newconfig.containers;

import com.nxp.swtools.common.ui.utils.swt.ColumnCenteredImagePainter;
import com.nxp.swtools.common.ui.utils.swt.GraphUtils;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.lang.Triplet;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.os.OSDetect;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.configuration.SwToolsProductConfiguration;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISWToolsDataFilterInfo;
import com.nxp.swtools.expert.processordb.ISWToolsDataFolderInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.ITemplateInfo;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedToolsByProcessor;
import com.nxp.swtools.framework.Messages;
import com.nxp.swtools.framework.ui.newconfig.NewConfigWizard;
import com.nxp.swtools.framework.ui.newconfig.ProcessorMergeHelper;
import com.nxp.swtools.framework.ui.newconfig.ProcessorNode;
import com.nxp.swtools.framework.ui.newconfig.ProcessorProvider;
import com.nxp.swtools.framework.ui.newconfig.TemplateInfoProxy;
import com.nxp.swtools.framework.ui.newconfig.containers.IProcessorSelectionContainer;
import com.nxp.swtools.framework.ui.newconfig.containers.ProcessorCategoryLabelProvider;
import com.nxp.swtools.kex.api.IBaseInfo;
import com.nxp.swtools.kex.api.IProcessorInfo;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.processors.ISWToolsBoardInfo;
import com.nxp.swtools.provider.processors.ISWToolsKitInfo;
import com.nxp.swtools.provider.processors.ISWToolsProcessorInfo;
import com.nxp.swtools.provider.processors.KExProcessorsProvider;
import com.nxp.swtools.provider.processors.OnlineDataInfo;
import com.nxp.swtools.utils.ConfigurationUtils;
import com.nxp.swtools.utils.command.SelectPackageDialog;
import com.nxp.swtools.utils.resources.ToolsImages;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class ProcessorSelectionContainer
implements IProcessorSelectionContainer {
    private static final int COMBO_WIDTH_HINT = 280;
    @NonNull
    private static final String DEFAULT_PACKAGE = "<default>";
    @NonNull
    static final Logger LOGGER = LogManager.getLogger(ProcessorSelectionContainer.class);
    private static final int MIN_VISIBLE_ROWS = 14;
    @NonNull
    WritableValue<String> selectedMcu = new WritableValue((Object)"", String.class);
    @NonNull
    WritableValue<String> selectedBoard = new WritableValue((Object)"", String.class);
    @NonNull
    WritableValue<String> selectedKit = new WritableValue((Object)"", String.class);
    @NonNull
    WritableValue<String> selectedMexVariant = new WritableValue((Object)"", String.class);
    @NonNull
    WritableValue<String> selectedTemplate = new WritableValue((Object)"", String.class);
    @NonNull
    WritableValue<String> configurationName = new WritableValue((Object)"", String.class);
    @NonNull
    WritableValue<Object> sdkVersion = new WritableValue(null, ISWToolsDataFolderInfo.class);
    IObservableList<Object> sdkVersions = Properties.selfList(ISWToolsProcessorInfo.class).observe(new ArrayList());
    @NonNull
    WritableValue<PackageTriplet> selectedPackage = new WritableValue(null, PackageTriplet.class);
    IObservableList<Object> packages = Properties.selfList(PackageTriplet.class).observe(new ArrayList());
    @NonNull
    final WritableValue<ProcessorCore> selectedCore = new WritableValue(null, ProcessorCore.class);
    @NonNull
    IObservableList<ProcessorCore> cores = Properties.selfList(ProcessorCore.class).observe(new ArrayList());
    @NonNull
    final ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
    DataBindingContext ctx = new DataBindingContext();
    @NonNull
    final OnlineDataInfo onlineDataInfo = new OnlineDataInfo();
    boolean switchingProcessor = false;
    @NonNull
    private @NonNull Consumer<@NonNull Boolean> canFinishCallback;
    @NonNull
    private @NonNull Consumer<@NonNull Boolean> doFinishCallback;
    FilteredTree processorFT;
    Label searchLabel;
    private boolean createFromTemplateAllowed = true;
    private static final char[] INVALID_RESOURCE_CHARACTERS = new char[]{'\\', '/', ':', '*', '?', '\"', '<', '>', '|', '@'};
    @NonNull
    private static final String UNSUPPORTED_TEMPLATE_TYPE = "unsupported template type";

    public ProcessorSelectionContainer(@NonNull Consumer<@NonNull Boolean> canFinishCallback, @NonNull Consumer<@NonNull Boolean> doFinishCallback) {
        this.configurationName.setValue((Object)"");
        this.selectedMcu.setValue((Object)"");
        this.selectedBoard.setValue((Object)"");
        this.selectedKit.setValue((Object)"");
        this.selectedMexVariant.setValue((Object)"");
        this.selectedTemplate.setValue((Object)"");
        this.canFinishCallback = canFinishCallback;
        this.doFinishCallback = doFinishCallback;
    }

    @Override
    public @Nullable String getConfigurationName() {
        return (String)this.configurationName.getValue();
    }

    @Override
    public @Nullable String getSelectedMcu() {
        return (String)this.selectedMcu.getValue();
    }

    @Override
    public @Nullable String getSelectedBoard() {
        return (String)this.selectedBoard.getValue();
    }

    @Override
    public @Nullable String getSelectedKit() {
        return (String)this.selectedKit.getValue();
    }

    @Override
    public @Nullable String getSelectedMexVariant() {
        return (String)this.selectedMexVariant.getValue();
    }

    @Override
    public @Nullable String getSelectedPackage() {
        PackageTriplet triplet = (PackageTriplet)((Object)this.selectedPackage.getValue());
        String value = triplet != null ? (String)triplet.getFirst() : null;
        return DEFAULT_PACKAGE.equals(value) ? null : value;
    }

    @Override
    public @Nullable ProcessorCore getSelectedCore() {
        ProcessorCore core = (ProcessorCore)this.selectedCore.getValue();
        return core == ProcessorCore.CORE_NOT_SELECTED ? null : core;
    }

    @Override
    public @Nullable String getSelectedTemplate() {
        return (String)this.selectedTemplate.getValue();
    }

    @Override
    public @Nullable Object getSelectedSdkVersion() {
        return this.sdkVersion.getValue();
    }

    public void setSwitchingProcessor(boolean value) {
        this.switchingProcessor = value;
    }

    @Override
    public boolean isSwitchingProcessor() {
        return this.switchingProcessor;
    }

    public void createControls(@NonNull Composite container) {
        this.createSearchPart(container);
        this.createNamePart(container);
        this.createPackageCodeSdkVersionPart(container);
        if (OSDetect.isMac()) {
            container.getDisplay().asyncExec(() -> ((Composite)container).layout());
        }
    }

    private void createSearchPart(@Nullable Composite container) {
        this.searchLabel = new Label(container, 0);
        GridDataFactory.swtDefaults().grab(true, false).applyTo((Control)this.searchLabel);
        ProcessorPatternFilter filter = new ProcessorPatternFilter();
        filter.setPattern("org.eclipse.ui.keys.optimization.false");
        filter.setIncludeLeadingWildcard(true);
        this.processorFT = new FilteredTree(container, 66304, (PatternFilter)filter, true);
        TreeViewer processorTV = this.processorFT.getViewer();
        Tree processorTree = processorTV.getTree();
        this.processorFT.setFocus();
        SWTFactoryProxy.INSTANCE.setTestId((Widget)this.processorFT.getFilterControl(), "NewConfigurationFilterText");
        SWTFactoryProxy.INSTANCE.setTestId((Widget)processorTree, "NewConfigurationTree");
        if (!SWToolsProperties.isDevelopmentWithNoDataUpdateOn()) {
            this.onlineDataInfo.refresh();
        }
        ProcessorProvider processorProvider = new ProcessorProvider(this.onlineDataInfo, p -> true, b -> true, this::isTemplateVisible, null, false);
        processorProvider.setIsBoardIncluded(!this.switchingProcessor);
        processorTV.setContentProvider((IContentProvider)processorProvider);
        this.createColumns(processorTV);
        assert (this.derivatives != null);
        processorTV.setInput((Object)this.derivatives);
        processorTree.addListener(13, event -> this.processorSelectionChanged(processorTree));
        if (this.switchingProcessor) {
            ICommonConfig sharedCommonConfig = SWToolsPlatform.getSharedConfigurationSingleton().getCommonConfig();
            String selMcu = UtilsText.safeString((String)sharedCommonConfig.getMcu());
            String selSdkVersion = UtilsText.safeString((String)sharedCommonConfig.getSdkVersion());
            String selSeries = UtilsText.safeString((String)this.derivatives.getSeries(selMcu, selSdkVersion));
            ProcessorMergeHelper mergeHelper = new ProcessorMergeHelper(this.derivatives, this.onlineDataInfo);
            IProcessorMasterToolInfo processorInfo = (IProcessorMasterToolInfo)CollectionsUtils.nullableOptionalGet(mergeHelper.getMasterToolInfos(selMcu).reduce((i, j) -> i instanceof ISWToolsProcessorInfo ? i : j));
            processorTV.setSelection((ISelection)new TreeSelection(new TreePath(new Object[]{new ProcessorNode(UtilsText.safeString((String)Messages.get().ProcessorProvider_ProcessorsNode)), new ProcessorNode(selSeries), processorInfo})), true);
            processorTV.getTree().showSelection();
            this.selectedMcu.setValue((Object)selMcu);
            this.processorSelectionChanged(processorTree);
            if (sharedCommonConfig.getSelectedCore() != null) {
                this.selectedCore.doSetValue((Object)sharedCommonConfig.getSelectedCore());
            }
        }
        processorTree.addListener(8, e -> {
            Object data;
            TreeItem item = processorTree.getItem(new Point(e.x, e.y));
            if (item != null && item.getItemCount() >= 0) {
                processorTV.setExpandedState(data, !processorTV.getExpandedState(data = item.getData()));
            }
            if (item != null) {
                boolean isTemplateWithMoreMexFiles;
                data = item.getData();
                boolean bl = isTemplateWithMoreMexFiles = data instanceof ITemplateInfo && ((ITemplateInfo)data).getTemplateVariants().size() > 1;
                if (!(isTemplateWithMoreMexFiles || UtilsText.isEmpty((String)((String)this.selectedMcu.getValue())) && UtilsText.isEmpty((String)((String)this.selectedBoard.getValue())) && UtilsText.isEmpty((String)((String)this.selectedKit.getValue())) && UtilsText.isEmpty((String)((String)this.selectedTemplate.getValue())))) {
                    this.fireFinishDialog();
                }
            }
        });
        GridData treeData = new GridData();
        treeData.grabExcessHorizontalSpace = true;
        treeData.grabExcessVerticalSpace = true;
        treeData.horizontalAlignment = 4;
        treeData.verticalAlignment = 4;
        treeData.heightHint = processorTree.getItemHeight() > 0 ? processorTree.getItemHeight() * 14 : 224;
        processorTree.setLayoutData((Object)treeData);
        this.setSearchTitle();
        if (this.onlineDataInfo.getOnlineProcessors().isEmpty() && !this.derivatives.getAllProcessorMasterToolInfos().findAny().isPresent()) {
            String message = SwToolsProduct.isUctProduct() ? Messages.get().NewConfigDialog_NoDataAvailable : Messages.get().NewConfigDialog_OfflineModeNoData;
            processorTree.getDisplay().asyncExec(() -> MessageDialog.openError((Shell)processorTree.getShell(), (String)Messages.get().NewConfigDialog_ErrorDialogTitle, (String)message));
        }
    }

    private void processorSelectionChanged(@NonNull Tree processorTree) {
        TreeItem[] selection = processorTree.getSelection();
        if (selection.length < 1) {
            return;
        }
        Object prevSelectedMcu = this.selectedMcu.getValue();
        Object prevSelectedBoard = this.selectedBoard.getValue();
        Object prevSelectedKit = this.selectedKit.getValue();
        Object prevSelectedTemplate = this.selectedTemplate.getValue();
        ProcessorCore prevCore = this.getSelectedCore();
        Object selectionData = selection[0].getData();
        if (selection[0].getItemCount() == 0 && !(selectionData instanceof ProcessorNode) || this.createFromTemplateAllowed && selectionData instanceof ITemplateInfo) {
            ProcessorCore newCore;
            String selText = "";
            if (selectionData instanceof IProcessorMasterToolInfo) {
                selText = ((IProcessorMasterToolInfo)selectionData).getId();
            }
            String mcu = selText;
            this.sdkVersions.clear();
            this.packages.clear();
            this.cores.clear();
            this.cores.add((Object)ProcessorCore.CORE_NOT_SELECTED);
            ProcessorMergeHelper mergeHelper = new ProcessorMergeHelper(this.derivatives, this.onlineDataInfo);
            if (selectionData instanceof ITemplateInfo) {
                ITemplateInfo templInfo = (ITemplateInfo)selectionData;
                mcu = templInfo.getMasterToolName();
                this.selectedBoard.setValue((Object)"");
                this.selectedKit.setValue((Object)"");
                this.selectedMexVariant.setValue((Object)templInfo.getRelFileName());
                switch (templInfo.getTemplateType()) {
                    case ttTemplate: {
                        this.selectedTemplate.setValue((Object)templInfo.getId());
                        break;
                    }
                    case ttBoard: {
                        this.selectedBoard.setValue((Object)templInfo.getId());
                        break;
                    }
                    case ttKit: {
                        this.selectedKit.setValue((Object)templInfo.getId());
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                @NonNull Map<String, ITemplateInfo> sdkMap = mergeHelper.getSdkBoardMap(templInfo.getId(), templInfo.getTemplateType());
                if (ITemplateInfo.TemplateType.ttTemplate == templInfo.getTemplateType()) {
                    sdkMap = ProcessorSelectionContainer.getSdkMapForTemplate(templInfo);
                }
                ArrayList<ITemplateInfo> sortedSdks = new ArrayList<ITemplateInfo>(sdkMap.values());
                sortedSdks.sort((s1, s2) -> s1.getSWToolsDataFolderID().compareToIgnoreCase(s2.getSWToolsDataFolderID()));
                this.sdkVersions.addAll(sortedSdks);
            } else if (selectionData instanceof IProcessorMasterToolInfo) {
                this.selectedMexVariant.setValue((Object)"");
                this.selectedBoard.setValue((Object)"");
                this.selectedKit.setValue((Object)"");
                Map<String, IProcessorMasterToolInfo> sdkMap = mergeHelper.getSdkProcessorMap(mcu);
                Collection sdks = sdkMap.values();
                String series = ((IProcessorMasterToolInfo)selectionData).getSeries();
                sdks = sdkMap.values().stream().filter(s -> series.equals(s.getSeries())).collect(Collectors.toList());
                ArrayList sortedSdks = new ArrayList(sdks);
                sortedSdks.sort((s1, s2) -> s1.getSWToolsDataFolderID().compareToIgnoreCase(s2.getSWToolsDataFolderID()));
                this.sdkVersions.addAll(sortedSdks);
            } else assert (false) : "Unsupported object: " + selectionData;
            this.selectedMcu.setValue((Object)mcu);
            this.sdkVersions.stream().findFirst().ifPresent(s -> this.sdkVersion.setValue(s));
            if (!(selectionData instanceof ITemplateInfo)) {
                this.packages.addAll(this.getPackagesForProcessor(mcu, this.getSelectedSdk()));
            }
            if (this.packages.isEmpty()) {
                this.packages.add((Object)new PackageTriplet(((String)this.selectedMcu.getValue()).toString(), this.sdkVersion.getValue().toString(), "", "", Boolean.TRUE, Boolean.FALSE, Boolean.FALSE));
            }
            this.packages.stream().filter(p -> (Boolean)((PackageTriplet)((Object)((Object)p))).getThird()).findFirst().ifPresent(s -> this.selectedPackage.setValue((Object)((PackageTriplet)((Object)((Object)s)))));
            ISWToolsDataFolderInfo selSdk = (ISWToolsDataFolderInfo)this.sdkVersion.getValue();
            if (selSdk != null) {
                this.loadCoresBySdkVersion(mcu, selSdk);
            }
            this.selectedCore.setValue((Object)((newCore = SWToolsPlatform.findCoreOrGetMasterCore(this.cores, (ProcessorCore)prevCore)) != null ? newCore : ProcessorCore.CORE_NOT_SELECTED));
            this.canFinishCallback.accept(Boolean.TRUE);
        } else {
            this.clearSelection();
        }
        if (prevSelectedBoard.equals(this.configurationName.getValue()) || prevSelectedMcu.equals(this.configurationName.getValue()) || prevSelectedKit.equals(this.configurationName.getValue()) || prevSelectedTemplate.equals(this.configurationName.getValue())) {
            if (!UtilsText.isEmpty((String)((String)this.selectedBoard.getValue()))) {
                this.configurationName.setValue((Object)((String)this.selectedBoard.getValue()));
            } else if (!UtilsText.isEmpty((String)((String)this.selectedKit.getValue()))) {
                this.configurationName.setValue((Object)((String)this.selectedKit.getValue()));
            } else if (!UtilsText.isEmpty((String)((String)this.selectedTemplate.getValue()))) {
                this.configurationName.setValue((Object)((String)this.selectedTemplate.getValue()));
            } else {
                this.configurationName.setValue((Object)((String)this.selectedMcu.getValue()));
            }
        }
    }

    private void loadCoresBySdkVersion(@NonNull String mcu, @NonNull ISWToolsDataFolderInfo selectedSdk) {
        SWToolsPlatform.CoresInfoLoader coresInfo = SWToolsPlatform.getCoresInfo((String)mcu, (String)selectedSdk.getSWToolsDataFolderID(), (ISupportedDerivativesForSwTools)this.derivatives);
        if (coresInfo == null && NewConfigWizard.isDownloadOrUpdatePossible()) {
            IProcessorInfo info = null;
            if (selectedSdk instanceof ISWToolsProcessorInfo) {
                info = ((ISWToolsProcessorInfo)selectedSdk).getProcessorInfo();
            } else if (selectedSdk instanceof ISWToolsBoardInfo) {
                info = ((ISWToolsBoardInfo)selectedSdk).getBoardInfo();
            } else if (selectedSdk instanceof ISWToolsKitInfo) {
                info = ((ISWToolsKitInfo)selectedSdk).getKitInfo();
            }
            String apiVersion = info != null ? KExProcessorsProvider.getRestApiForInfo((IBaseInfo)info, (String)selectedSdk.getSWToolsDataFolderID()) : KExProcessorsProvider.getRestApiDataVersion();
            coresInfo = SWToolsPlatform.getCoresInfoFromWeb((String)mcu, (String)selectedSdk.getSWToolsDataFolderID(), (String)apiVersion);
        }
        if (coresInfo != null && !coresInfo.cores.isEmpty() && !coresInfo.cores.equals(this.cores)) {
            this.cores.clear();
            this.cores.addAll((Collection)coresInfo.cores);
        }
    }

    protected void createColumns(@NonNull TreeViewer treeViewer) {
        Tree tree = treeViewer.getTree();
        SWTFactoryProxy.INSTANCE.enableHtmlTooltipFor((ColumnViewer)treeViewer);
        tree.setToolTipText("");
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        ProcessorSelectionContainer.createNameColumn(treeViewer, this.derivatives);
        ProcessorSelectionContainer.createProductColumns(treeViewer, this.derivatives, this.onlineDataInfo, this::getSelectedSdk, false);
        ProcessorSelectionContainer.createStatusColumn(treeViewer, this.derivatives, this.onlineDataInfo);
    }

    public static void createNameColumn(@NonNull TreeViewer treeViewer, @NonNull ISupportedDerivativesForSwTools derivatives) {
        TreeViewerColumn firstColumn = new TreeViewerColumn(treeViewer, 0);
        TreeColumn firstCol = firstColumn.getColumn();
        firstCol.setWidth(300);
        firstCol.setText(Messages.get().NewConfigDialog_Search);
        firstColumn.setLabelProvider((CellLabelProvider)new ProcessorCategoryLabelProvider(derivatives));
    }

    public static void createProductColumns(@NonNull TreeViewer treeViewer, @NonNull ISupportedDerivativesForSwTools derivatives, @NonNull OnlineDataInfo onlineDataInfo, @Nullable Supplier<String> selectedSdkSupplier, boolean isSdkOfItemStatusRelevant) {
        Tree tree = treeViewer.getTree();
        for (SwToolsProduct product : SwToolsProductConfiguration.getRegisteredProductsSorted()) {
            if (product.isHeadless()) continue;
            TreeViewerColumn viewerColumn = new TreeViewerColumn(treeViewer, 0);
            TreeColumn column = viewerColumn.getColumn();
            int index = tree.indexOf(column);
            ColumnCenteredImagePainter listener = new ColumnCenteredImagePainter(index, item -> {
                Object element = item.getData();
                String mcu = null;
                String sdkVersion = null;
                if (element instanceof ITemplateInfo) {
                    ITemplateInfo template = (ITemplateInfo)element;
                    switch (template.getTemplateType()) {
                        case ttTemplate: {
                            return null;
                        }
                        case ttBoard: 
                        case ttKit: {
                            mcu = template.getMasterToolName();
                            sdkVersion = template.getSWToolsDataFolderID();
                        }
                    }
                } else if (element instanceof IProcessorMasterToolInfo) {
                    mcu = ((IProcessorMasterToolInfo)element).getId();
                    sdkVersion = ((IProcessorMasterToolInfo)element).getSWToolsDataFolderID();
                }
                if (mcu != null) {
                    String mcuFinal = mcu;
                    Optional<IProcessorInfo> proc = onlineDataInfo.getOnlineProcessorsWeb().stream().filter(p -> Objects.equals(mcuFinal, p.getName())).findFirst();
                    if (proc.isPresent()) {
                        IProcessorInfo p2 = proc.get();
                        Pattern patt = Pattern.compile("sdk\\.[^.]+\\.tools\\." + product.getProductId().toLowerCase(Locale.ENGLISH));
                        for (String key : p2.getAttributeKeys()) {
                            Matcher m = patt.matcher(key);
                            if (!m.matches() || !Boolean.parseBoolean(p2.getAttribute(key))) continue;
                            return ToolsImages.getImage((String)"icons/check_simple.png");
                        }
                    } else {
                        String locSdkVersion = null;
                        if (ProcessorSelectionContainer.isSelectedItem(tree, item) && selectedSdkSupplier != null) {
                            locSdkVersion = (String)selectedSdkSupplier.get();
                        }
                        if (locSdkVersion == null && isSdkOfItemStatusRelevant) {
                            locSdkVersion = sdkVersion;
                        }
                        List<@NonNull T> allMcuInfos = derivatives.getProcessorMasterToolInfos(mcu).collect(Collectors.toList());
                        allMcuInfos.sort((s1, s2) -> s1.getSWToolsDataFolderID().compareToIgnoreCase(s2.getSWToolsDataFolderID()));
                        Optional<Object> info = null;
                        if (locSdkVersion == null) {
                            info = allMcuInfos.stream().findFirst();
                        } else {
                            String sdkVersionFinal = locSdkVersion;
                            info = allMcuInfos.stream().filter(i -> sdkVersionFinal.equals(i.getSWToolsDataFolderID())).findFirst();
                            if (!info.isPresent()) {
                                info = allMcuInfos.stream().findFirst();
                            }
                        }
                        if (info.isPresent() && SupportedToolsByProcessor.isToolSuported((IProcessorMasterToolInfo)((IProcessorMasterToolInfo)info.get()), (String)product.getProductId())) {
                            return ToolsImages.getImage((String)"icons/check_simple.png");
                        }
                    }
                    return ToolsImages.getImage((String)"icons/remove_cross_simple.png");
                }
                return null;
            });
            tree.addListener(41, (Listener)listener);
            tree.addListener(42, (Listener)listener);
            tree.addListener(40, (Listener)listener);
            column.setText(product.getProductName());
            column.setToolTipText(product.getProductDescription());
            viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider());
            column.pack();
            if (column.getWidth() != 0) continue;
            Point size = GraphUtils.textExtent((Drawable)tree, (String)column.getText());
            column.setWidth(size.x + 16);
        }
    }

    public static void createStatusColumn(@NonNull TreeViewer treeViewer, final @NonNull ISupportedDerivativesForSwTools derivatives, final @NonNull OnlineDataInfo onlineDataInfo) {
        TreeViewerColumn viewerColumn = new TreeViewerColumn(treeViewer, 0);
        TreeColumn column = viewerColumn.getColumn();
        column.setText(Messages.get().ProcessorProvider_StatusColumn);
        column.setWidth(100);
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ProcessorNode) {
                    return null;
                }
                if (ProcessorSelectionContainer.isElementAvailableOffline(element, derivatives)) {
                    return ProcessorSelectionContainer.isUpdateAvailable(element, derivatives, onlineDataInfo) ? Messages.get().ProcessorProvider_StatusColumnUpdateAvailable : Messages.get().ProcessorProvider_StatusColumnCached;
                }
                return Messages.get().ProcessorProvider_StatusColumnOnline;
            }

            public String getToolTipText(Object element) {
                if (element instanceof ProcessorNode) {
                    return null;
                }
                if (ProcessorSelectionContainer.isElementAvailableOffline(element, derivatives)) {
                    return ProcessorSelectionContainer.isUpdateAvailable(element, derivatives, onlineDataInfo) ? Messages.get().ProcessorProvider_StatusColumnUpdateAvailableTooltip : Messages.get().ProcessorProvider_StatusColumnCachedTooltip;
                }
                return Messages.get().ProcessorProvider_StatusColumnOnlineTooltip;
            }
        });
    }

    public static void createSdkVersionColumn(@NonNull TreeViewer viewer) {
        TreeViewerColumn sdkVersionColumn = new TreeViewerColumn(viewer, 0);
        TreeColumn sdkVerColumn = sdkVersionColumn.getColumn();
        sdkVerColumn.setText(Messages.get().DataManager_ColumnSdkVersion);
        sdkVersionColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public @Nullable String getText(Object element) {
                if (element instanceof ISWToolsDataFolderInfo) {
                    ISWToolsDataFolderInfo info = (ISWToolsDataFolderInfo)element;
                    return info.getSWToolsDataFolderName();
                }
                return null;
            }
        });
        sdkVerColumn.pack();
    }

    public static boolean isElementAvailableOffline(@Nullable Object element, @NonNull ISupportedDerivativesForSwTools derivatives) {
        if (element instanceof ITemplateInfo) {
            ITemplateInfo template = (ITemplateInfo)element;
            switch (template.getTemplateType()) {
                case ttTemplate: {
                    return true;
                }
                case ttBoard: {
                    return derivatives.getBoardById(template.getId(), template.getSWToolsDataFolderID()) != null;
                }
                case ttKit: {
                    return derivatives.getKitById(template.getId(), template.getSWToolsDataFolderID()) != null;
                }
            }
            assert (false) : "unsupported template type";
        } else if (element instanceof IProcessorMasterToolInfo) {
            IProcessorMasterToolInfo info = (IProcessorMasterToolInfo)element;
            return derivatives.getProcessorMasterToolInfo(info.getId(), info.getSWToolsDataFolderID()) != null;
        }
        return false;
    }

    public static @Nullable String getOfflineElementVersion(@Nullable Object element, @NonNull ISupportedDerivativesForSwTools derivatives) {
        if (element instanceof ITemplateInfo) {
            ITemplateInfo template = (ITemplateInfo)element;
            switch (template.getTemplateType()) {
                case ttTemplate: {
                    return null;
                }
                case ttBoard: {
                    ITemplateInfo brd = derivatives.getBoardById(template.getId(), template.getSWToolsDataFolderID());
                    if (brd != null) {
                        return brd.getVersion();
                    }
                    return null;
                }
                case ttKit: {
                    ITemplateInfo kit = derivatives.getKitById(template.getId(), template.getSWToolsDataFolderID());
                    if (kit != null) {
                        return kit.getVersion();
                    }
                    return null;
                }
            }
            assert (false) : "unsupported template type";
        } else if (element instanceof IProcessorMasterToolInfo) {
            IProcessorMasterToolInfo info = (IProcessorMasterToolInfo)element;
            Optional<@NonNull String> opt = derivatives.getProcessorMasterToolInfos(info.getId()).map(IProcessorMasterToolInfo::getVersion).findFirst();
            if (opt.isPresent()) {
                return opt.get();
            }
        } else assert (false) : "Unsupported type";
        return null;
    }

    public static boolean isUpdateAvailable(@Nullable Object element, @NonNull ISupportedDerivativesForSwTools derivatives, @NonNull OnlineDataInfo onlineDataInfo) {
        if (element instanceof ITemplateInfo) {
            ITemplateInfo template = (ITemplateInfo)element;
            switch (template.getTemplateType()) {
                case ttTemplate: {
                    return false;
                }
                case ttBoard: {
                    return Objects.nonNull(derivatives.getBoardById(template.getId(), template.getSWToolsDataFolderID())) && KExProcessorsProvider.isBoardUpdateAvailable((String)template.getId(), (String)template.getSWToolsDataFolderID(), (Collection)onlineDataInfo.getOnlineBoardsWeb());
                }
                case ttKit: {
                    return Objects.nonNull(derivatives.getKitById(template.getId(), template.getSWToolsDataFolderID())) && KExProcessorsProvider.isKitUpdateAvailable((String)template.getId(), (String)template.getSWToolsDataFolderID(), (Collection)onlineDataInfo.getOnlineKitsWeb());
                }
            }
            assert (false) : "unsupported template type";
        } else if (element instanceof IProcessorMasterToolInfo) {
            IProcessorMasterToolInfo info = (IProcessorMasterToolInfo)element;
            return derivatives.getProcessorMasterToolInfos(info.getId()).anyMatch(p -> KExProcessorsProvider.isProcessorUpdateAvailable((String)p.getId(), (String)p.getSWToolsDataFolderID(), (Collection)onlineDataInfo.getOnlineProcessorsWeb()));
        }
        return false;
    }

    private static @NonNull Map<String, ITemplateInfo> getSdkMapForTemplate(@NonNull ITemplateInfo template) {
        HashMap<String, ITemplateInfo> result = new HashMap<String, ITemplateInfo>();
        ISharedConfiguration config = ProcessorSelectionContainer.getTemplateMexConfig(template);
        if (config != null) {
            String sdk = config.getCommonConfig().getSdkVersion();
            if (!UtilsText.isEmpty((String)sdk)) {
                String sdkName = UtilsText.safeString((String)SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools().getSwtoolsFolderIDName(sdk));
                result.put(sdk, new TemplateInfoProxy(template, sdk, sdkName));
            }
        } else {
            LOGGER.warning("Cannot read MEX template " + template.getRelFileName());
        }
        return result;
    }

    private @NonNull Collection<@NonNull PackageTriplet> getPackagesForProcessor(@NonNull String mcu, @Nullable String version) {
        ArrayList<@NonNull PackageTriplet> result = new ArrayList<PackageTriplet>();
        if (version == null) {
            return result;
        }
        IProcessorMasterToolInfo info = this.derivatives.getProcessorMasterToolInfo(mcu, version);
        if (info == null) {
            PackageTriplet tr;
            Matcher m = Pattern.compile("^sdk\\." + version + "\\.package\\.[^.]+$").matcher("");
            this.onlineDataInfo.getOnlineProcessorsWeb().stream().filter(p -> mcu.equals(p.getName())).filter(p -> Objects.nonNull(p.getAttribute("sdk." + version + ".default.package"))).findFirst().ifPresent(p -> p.getAttributeKeys().stream().filter(a -> m.reset((CharSequence)a).matches()).sorted(String::compareTo).forEach(a -> {
                String packageName = UtilsText.safeString((String)p.getAttribute(a));
                String packageUiName = p.getAttribute(String.valueOf(a) + ".label");
                packageUiName = packageUiName == null ? packageName : MessageFormat.format(com.nxp.swtools.utils.Messages.get().SelectPackageDialog_package, packageName, packageUiName);
                result.add(new PackageTriplet(mcu, version, packageName, packageUiName, UtilsText.safeString((String)p.getAttribute(a)).equals(p.getAttribute("sdk." + version + ".default.package")), Boolean.valueOf(p.getAttribute("sdk." + version + ".packagex." + packageName + ".requiresNDA")), Boolean.valueOf(p.getAttribute("sdk." + version + ".packagex." + packageName + ".deprecated"))));
            }));
            if (result.size() == 1 && !((Boolean)(tr = result.get(0)).getThird()).booleanValue()) {
                LOGGER.warning("Online processor does not contain default package defined");
                result.set(0, new PackageTriplet(mcu, version, (String)tr.getFirst(), (String)tr.getSecond(), Boolean.TRUE, tr.isRequireNDA(), tr.isDeprecated()));
            }
            if (result.isEmpty()) {
                LOGGER.warning("Online processor does not contain any package defined");
                result.add(new PackageTriplet(mcu, version, DEFAULT_PACKAGE, DEFAULT_PACKAGE, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE));
            }
            return result;
        }
        result.addAll((Collection)SelectPackageDialog.getAvailablePackagesMap((ISupportedDerivativesForSwTools)this.derivatives, (IProcessorMasterToolInfo)info).entrySet().stream().map(map -> new PackageTriplet(mcu, version, (String)map.getValue(), (String)map.getKey(), info.getDefaultPartNumber().equals(map.getValue()), SWToolsPlatform.isPartRequiresNDA((String)mcu, (String)version, (String)((String)map.getValue()), (ISupportedDerivativesForSwTools)this.derivatives), SWToolsPlatform.isPartDeprecated((String)mcu, (String)version, (String)((String)map.getValue()), (ISupportedDerivativesForSwTools)this.derivatives))).collect(CollectorsUtils.toList()));
        return result;
    }

    private void clearSelection() {
        this.selectedMcu.setValue((Object)"");
        this.selectedBoard.setValue((Object)"");
        this.selectedKit.setValue((Object)"");
        this.selectedTemplate.setValue((Object)"");
        this.sdkVersion.setValue(null);
        this.sdkVersions.clear();
        this.selectedPackage.setValue(null);
        this.packages.clear();
        this.cores.clear();
        this.cores.add((Object)ProcessorCore.CORE_NOT_SELECTED);
        this.selectedCore.setValue(null);
        this.canFinishCallback.accept(Boolean.FALSE);
    }

    private void fireFinishDialog() {
        this.doFinishCallback.accept(Boolean.TRUE);
    }

    private void createSdkVersionSelectionPart(Composite container) {
        ProcessorMergeHelper helper = new ProcessorMergeHelper(this.derivatives, this.onlineDataInfo);
        if (!this.isVersionComboVisibleForOneOption() && helper.getAllSdks().size() == 1) {
            return;
        }
        Label sdkLabel = new Label(container, 0);
        sdkLabel.setText(Messages.get().NewConfigDialog_SelectVersionCombo);
        Composite sdkVersionComposite = new Composite(container, 2048);
        sdkVersionComposite.setLayout((Layout)new FillLayout());
        CCombo sdkVersionCombo = new CCombo(sdkVersionComposite, 8);
        sdkVersionCombo.addListener(24, e -> this.processorFT.getViewer().getTree().redraw());
        sdkVersionCombo.addListener(13, e -> this.reloadParts(sdkVersionCombo.getSelectionIndex()));
        ProcessorSelectionContainer.fixCComboBackGround((Composite)sdkVersionCombo);
        ComboViewer cv = new ComboViewer(sdkVersionCombo);
        cv.setContentProvider((IContentProvider)new ObservableListContentProvider());
        cv.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ISWToolsDataFolderInfo) {
                    ISWToolsDataFolderInfo info = (ISWToolsDataFolderInfo)element;
                    return info.getSWToolsDataFolderName();
                }
                return super.getText(element);
            }
        });
        cv.setInput(this.sdkVersions);
        GridDataFactory.swtDefaults().align(4, 128).grab(true, false).hint(280, -1).applyTo((Control)sdkVersionComposite);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)sdkVersionCombo, "NewConfigurationSDK");
        IViewerObservableValue targetCombo = ViewerProperties.singleSelection().observe((Viewer)cv);
        this.ctx.bindValue((IObservableValue)targetCombo, this.sdkVersion);
    }

    private void reloadParts(int selectedIndex) {
        ISWToolsDataFolderInfo currentSdkVersion;
        if (this.sdkVersions.size() > 1 && (currentSdkVersion = (ISWToolsDataFolderInfo)this.sdkVersions.get(selectedIndex)) != null) {
            this.sdkVersion.setValue((Object)currentSdkVersion);
            String mcu = UtilsText.safeString((String)((String)this.selectedMcu.getValue()));
            this.loadCoresBySdkVersion(mcu, currentSdkVersion);
            ProcessorCore newCore = SWToolsPlatform.findCoreOrGetMasterCore(this.cores, null);
            this.selectedCore.setValue((Object)(newCore != null ? newCore : ProcessorCore.CORE_NOT_SELECTED));
            Collection<@NonNull PackageTriplet> newPackages = this.getPackagesForProcessor(mcu, currentSdkVersion.getSWToolsDataFolderID());
            if (!this.packages.equals(newPackages)) {
                this.packages.clear();
                this.packages.addAll(newPackages);
                if (this.packages.isEmpty()) {
                    this.packages.add((Object)new PackageTriplet(((String)this.selectedMcu.getValue()).toString(), this.sdkVersion.getValue().toString(), "", "", Boolean.TRUE, Boolean.FALSE, Boolean.FALSE));
                }
                this.packages.stream().filter(p -> (Boolean)((PackageTriplet)((Object)((Object)p))).getThird()).findFirst().ifPresent(s -> this.selectedPackage.setValue((Object)((PackageTriplet)((Object)((Object)s)))));
            }
            if (currentSdkVersion instanceof ITemplateInfo) {
                this.selectedMexVariant.setValue((Object)((ITemplateInfo)currentSdkVersion).getRelFileName());
            }
        }
    }

    private void createNamePart(@NonNull Composite container) {
        Label name = new Label(container, 0);
        name.setText(Messages.get().NewConfigDialog_ConfigName);
        GridData dataFirstName = new GridData();
        dataFirstName.grabExcessHorizontalSpace = true;
        dataFirstName.horizontalAlignment = 4;
        dataFirstName.verticalAlignment = 4;
        Text configName = new Text(container, 2048);
        configName.setLayoutData((Object)dataFirstName);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)configName, "NewConfigurationNameText");
        ISWTObservableValue target = WidgetProperties.text((int)24).observe((Widget)configName);
        this.ctx.bindValue((IObservableValue)target, this.configurationName);
        configName.addListener(24, event -> {
            Object mcuValue = this.selectedMcu.getValue();
            Object boardValue = this.selectedBoard.getValue();
            Object kitValue = this.selectedKit.getValue();
            Object templValue = this.selectedTemplate.getValue();
            boolean isBoardSelected = !UtilsText.isEmpty((String)((String)boardValue)) && boardValue != null;
            boolean isMcuSelected = !UtilsText.isEmpty((String)((String)mcuValue)) && mcuValue != null;
            boolean isKitSelected = !UtilsText.isEmpty((String)((String)kitValue)) && kitValue != null;
            boolean isTemplateSelected = !UtilsText.isEmpty((String)((String)templValue)) && templValue != null;
            this.canFinishCallback.accept(!configName.getText().isEmpty() && (isBoardSelected || isMcuSelected || isKitSelected || isTemplateSelected));
        });
        configName.addListener(25, event -> {
            char[] chars = INVALID_RESOURCE_CHARACTERS;
            int i = 0;
            while (i < chars.length) {
                if (event.text.indexOf(chars[i]) >= 0) {
                    event.doit = false;
                    break;
                }
                ++i;
            }
        });
        if (this.switchingProcessor) {
            String previousConfigName = UtilsText.safeString((String)SWToolsPlatform.getSharedConfigurationSingleton().getCommonConfig().getName());
            configName.setText(previousConfigName);
        }
    }

    private void createPackagePart(@Nullable Composite container) {
        Label packagesLabel = new Label(container, 0);
        packagesLabel.setText(com.nxp.swtools.utils.Messages.get().SelectPackageDialog_SelectProcessorPackage);
        Composite packagesComposite = new Composite(Objects.requireNonNull(container), 2048);
        packagesComposite.setLayout((Layout)new FillLayout());
        CCombo packagesCombo = new CCombo(packagesComposite, 8);
        ProcessorSelectionContainer.fixCComboBackGround((Composite)packagesCombo);
        ComboViewer cv = new ComboViewer(packagesCombo);
        cv.setContentProvider((IContentProvider)new ObservableListContentProvider());
        cv.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof PackageTriplet) {
                    PackageTriplet triplet = (PackageTriplet)((Object)element);
                    if (triplet.isRequireNDA().booleanValue() || triplet.isDeprecated().booleanValue()) {
                        ArrayList<@NonNull String> flags = new ArrayList<String>();
                        if (triplet.isRequireNDA().booleanValue()) {
                            flags.add(Messages.get().ProcessorSelectionContainer_NDA);
                        }
                        if (triplet.isDeprecated().booleanValue()) {
                            flags.add(Messages.get().ProcessorSelectionContainer_Deprecated);
                        }
                        return String.valueOf((String)triplet.getSecond()) + " (" + UtilsText.join(flags, (String)",") + ")";
                    }
                    return (String)triplet.getSecond();
                }
                return Objects.toString(element);
            }
        });
        cv.setInput(this.packages);
        GridDataFactory.swtDefaults().align(4, 128).grab(true, false).hint(280, -1).applyTo((Control)packagesComposite);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)packagesCombo, "NewConfigurationPackage");
        IViewerObservableValue targetCombo = ViewerProperties.singleSelection().observe((Viewer)cv);
        this.ctx.bindValue((IObservableValue)targetCombo, this.selectedPackage);
        ISWTObservableValue targetComboEnablement = WidgetProperties.enabled().observe((Widget)packagesCombo);
        IObservableValue modelEnablement = ComputedValue.create(() -> !UtilsText.isEmpty((String)this.getSelectedMcu()) && UtilsText.isEmpty((String)this.getSelectedBoard()) && UtilsText.isEmpty((String)this.getSelectedKit()));
        this.ctx.bindValue((IObservableValue)targetComboEnablement, modelEnablement);
        ISWTObservableValue targetLabelEnablement = WidgetProperties.enabled().observe((Widget)packagesLabel);
        this.ctx.bindValue((IObservableValue)targetLabelEnablement, modelEnablement);
    }

    private void createCoreSelectionPart(@NonNull Composite container) {
        Label selCoreLabel = new Label(container, 0);
        selCoreLabel.setText(Messages.get().NewConfigDialog_SelectCore_Label);
        Composite coresComposite = new Composite(container, 2048);
        coresComposite.setLayout((Layout)new FillLayout());
        CCombo coresCombo = new CCombo(coresComposite, 8);
        ProcessorSelectionContainer.fixCComboBackGround((Composite)coresCombo);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)coresCombo, "NewConfigurationCore");
        ComboViewer cv = new ComboViewer(coresCombo);
        cv.setContentProvider((IContentProvider)new ObservableListContentProvider());
        cv.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ProcessorCore) {
                    ProcessorCore core = (ProcessorCore)element;
                    return core.getName();
                }
                return Objects.toString(element);
            }
        });
        cv.setInput(this.cores);
        GridDataFactory.swtDefaults().align(4, 128).grab(true, false).hint(280, -1).applyTo((Control)coresComposite);
        IViewerObservableValue targetCombo = ViewerProperties.singleSelection().observe((Viewer)cv);
        this.ctx.bindValue((IObservableValue)targetCombo, this.selectedCore);
        ISWTObservableValue targetComboEnablement = WidgetProperties.enabled().observe((Widget)coresCombo);
        IObservableValue modelEnablement = ComputedValue.create(() -> !UtilsText.isEmpty((String)this.getSelectedMcu()) || !UtilsText.isEmpty((String)this.getSelectedBoard()) || !UtilsText.isEmpty((String)this.getSelectedKit()));
        this.ctx.bindValue((IObservableValue)targetComboEnablement, modelEnablement);
        ISWTObservableValue targetLabelEnablement = WidgetProperties.enabled().observe((Widget)selCoreLabel);
        this.ctx.bindValue((IObservableValue)targetLabelEnablement, modelEnablement);
    }

    private static void fixCComboBackGround(@NonNull Composite combo) {
        combo.setBackground(combo.getDisplay().getSystemColor(25));
    }

    private void createPackageCodeSdkVersionPart(@NonNull Composite container) {
        Composite panel = new Composite(container, 0);
        panel.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(true).margins(0, 0).spacing(15, 3).create());
        panel.setLayoutData((Object)new GridData(4, 1024, true, false));
        Composite firstCol = new Composite(panel, 0);
        firstCol.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(0, 0).create());
        firstCol.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createPackagePart(firstCol);
        Composite secondCol = new Composite(panel, 0);
        secondCol.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(0, 0).create());
        secondCol.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createCoreSelectionPart(secondCol);
        Composite thirdCol = new Composite(panel, 0);
        thirdCol.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(0, 0).create());
        thirdCol.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createSdkVersionSelectionPart(thirdCol);
    }

    boolean isVersionComboVisibleForOneOption() {
        return !SWToolsProperties.isPropertyTrue((String)"com.nxp.swtools.framework.hide.sdk.version");
    }

    public boolean isTemplateVisible(@NonNull ITemplateInfo template) {
        if (!this.createFromTemplateAllowed) {
            return false;
        }
        if (template.getTemplateType() != ITemplateInfo.TemplateType.ttTemplate) {
            return this.createFromTemplateAllowed;
        }
        return true;
    }

    private static @Nullable ISharedConfiguration getTemplateMexConfig(@NonNull ITemplateInfo template) {
        assert (template.getTemplateType() == ITemplateInfo.TemplateType.ttTemplate) : "allowed only for user templates";
        File preSetMex = new File(String.valueOf(SupportedDerivativesForSwTools.getUserTemplatesDir()) + File.separator + template.getRelFileName());
        return ConfigurationUtils.loadConfigurationFromFile((File)preSetMex);
    }

    private static boolean isSelectedItem(Tree tree, TreeItem item) {
        Object data;
        TreeItem[] selection = tree.getSelection();
        if (selection.length > 0 && (data = selection[0].getData()) instanceof IProcessorMasterToolInfo && item.getData() instanceof IProcessorMasterToolInfo) {
            IProcessorMasterToolInfo selInfoElement = (IProcessorMasterToolInfo)data;
            IProcessorMasterToolInfo infoElement = (IProcessorMasterToolInfo)item.getData();
            if (selInfoElement != null && infoElement != null && selInfoElement.getId().equals(infoElement.getId()) && selInfoElement.getDefaultPartNumber().equals(infoElement.getDefaultPartNumber()) && selInfoElement.getSWToolsDataFolderID().equals(infoElement.getSWToolsDataFolderID()) && selInfoElement.getFamily().equals(infoElement.getFamily())) {
                return true;
            }
        }
        return false;
    }

    public void setCreateFromTemplateAllowed(boolean value) {
        this.createFromTemplateAllowed = value;
    }

    public @NonNull IProcessorSelectionContainer getImmutableSelection() {
        final String mcuValue = this.getSelectedMcu();
        final String boardValue = this.getSelectedBoard();
        final String kitValue = this.getSelectedKit();
        final String templateValue = this.getSelectedTemplate();
        final String configurationNameValue = this.getConfigurationName();
        final Object sdkVal = this.getSelectedSdkVersion();
        final String sdk = this.getSelectedSdk();
        final String selPackage = this.getSelectedPackage();
        final ProcessorCore selCore = this.getSelectedCore();
        final String selectedMexVariant = this.getSelectedMexVariant();
        return new IProcessorSelectionContainer(){

            @Override
            public boolean isSwitchingProcessor() {
                return ProcessorSelectionContainer.this.switchingProcessor;
            }

            @Override
            public @Nullable String getSelectedTemplate() {
                return templateValue;
            }

            @Override
            public @Nullable Object getSelectedSdkVersion() {
                return sdkVal;
            }

            @Override
            public @Nullable String getSelectedSdk() {
                return sdk;
            }

            @Override
            public @Nullable String getSelectedMcu() {
                return mcuValue;
            }

            @Override
            public @Nullable String getSelectedKit() {
                return kitValue;
            }

            @Override
            public @Nullable String getSelectedBoard() {
                return boardValue;
            }

            @Override
            public @Nullable String getConfigurationName() {
                return configurationNameValue;
            }

            @Override
            public @Nullable String getSelectedPackage() {
                return selPackage;
            }

            @Override
            public @Nullable ProcessorCore getSelectedCore() {
                return selCore;
            }

            @Override
            public @NonNull OnlineDataInfo getOnlineDataInfo() {
                return ProcessorSelectionContainer.this.onlineDataInfo;
            }

            @Override
            public @Nullable String getSelectedMexVariant() {
                return selectedMexVariant;
            }
        };
    }

    @Override
    public @Nullable String getSelectedSdk() {
        Object sdkVal = this.getSelectedSdkVersion();
        if (sdkVal instanceof ISWToolsDataFolderInfo) {
            ISWToolsDataFolderInfo sdkInfo = (ISWToolsDataFolderInfo)sdkVal;
            return sdkInfo.getSWToolsDataFolderID();
        }
        return null;
    }

    public @NonNull FilteredTree getTree() {
        assert (this.processorFT != null);
        return this.processorFT;
    }

    public void setSearchTitle() {
        String text = this.switchingProcessor ? Messages.get().NewConfigDialog_SearchForSwitch : Messages.get().NewConfigDialog_Search;
        this.searchLabel.setText(text);
    }

    @Override
    public OnlineDataInfo getOnlineDataInfo() {
        return this.onlineDataInfo;
    }

    @NonNullByDefault
    static class PackageTriplet
    extends Triplet<String, String, Boolean> {
        private String sdkVersion;
        private String mcu;
        private Boolean requireNDA;
        private Boolean deprecated;

        public PackageTriplet(String mcu, String sdkVersion, String aPackage, String uiText, Boolean defaultPackage, Boolean requiresNDA, Boolean deprecated) {
            super((Object)aPackage, (Object)uiText, (Object)defaultPackage);
            this.mcu = mcu;
            this.sdkVersion = sdkVersion;
            this.requireNDA = requiresNDA;
            this.deprecated = deprecated;
        }

        public String getSdkVersion() {
            return this.sdkVersion;
        }

        public String getMcu() {
            return this.mcu;
        }

        public Boolean isRequireNDA() {
            return this.requireNDA;
        }

        public Boolean isDeprecated() {
            return this.deprecated;
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + Objects.hash(this.deprecated, this.mcu, this.requireNDA, this.sdkVersion);
            return result;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof PackageTriplet)) {
                return false;
            }
            PackageTriplet other = (PackageTriplet)((Object)obj);
            return Objects.equals(this.deprecated, other.deprecated) && Objects.equals(this.mcu, other.mcu) && Objects.equals(this.requireNDA, other.requireNDA) && Objects.equals(this.sdkVersion, other.sdkVersion);
        }
    }

    static class ProcessorPatternFilter
    extends PatternFilter {
        ProcessorPatternFilter() {
        }

        protected boolean isEndLeaf(@NonNull Viewer viewer, @NonNull Object element) {
            Object[] children = ((ITreeContentProvider)((AbstractTreeViewer)viewer).getContentProvider()).getChildren(element);
            return Objects.isNull(children) || children.length == 0;
        }

        protected boolean isNodeNotForFinish(Object element) {
            return element instanceof ProcessorNode;
        }

        protected boolean isLeafMatch(Viewer viewer, Object element) {
            assert (viewer != null);
            assert (element != null);
            return this.isEndLeaf(viewer, element) && !this.isNodeNotForFinish(element) && element instanceof ISWToolsDataFilterInfo ? ((ISWToolsDataFilterInfo)element).isAnyKeyWordMatch(w -> super.isLeafMatch(viewer, w)) : super.isLeafMatch(viewer, element);
        }
    }
}

