/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework.ui.newconfig;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.ArraysUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.ITemplateInfo;
import com.nxp.swtools.framework.Messages;
import com.nxp.swtools.framework.ui.newconfig.ProcessorMergeHelper;
import com.nxp.swtools.framework.ui.newconfig.ProcessorNode;
import com.nxp.swtools.framework.ui.newconfig.ProductSupportsProcessor;
import com.nxp.swtools.framework.ui.newconfig.TemplateInfoProxy;
import com.nxp.swtools.provider.processors.OnlineDataInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

@NonNullByDefault
public class ProcessorProvider
implements ITreeContentProvider {
    @Nullable
    ISupportedDerivativesForSwTools derivatives;
    OnlineDataInfo onlineDataInfo;
    private Object[] rootElements = new Object[0];
    private boolean isBoardIncluded = true;
    private boolean showProcessorDuplicates = false;
    Predicate<@NonNull String> processorFilter = b -> true;
    Predicate<@NonNull String> boardKitFilter = b -> true;
    Predicate<? super @NonNull ITemplateInfo> showBoardOrKitTemplate = b -> true;
    @Nullable
    private ProductSupportsProcessor productSupportsProcessor;

    public ProcessorProvider(OnlineDataInfo onlineDataInfo, Predicate<@NonNull String> processorFilter, Predicate<@NonNull String> boardKitFilter, Predicate<? super @NonNull ITemplateInfo> showBoardOrKitTemplate, @Nullable ProductSupportsProcessor productSupportsProcessor, boolean showProcessorDuplicates) {
        this.onlineDataInfo = onlineDataInfo;
        this.processorFilter = processorFilter;
        this.boardKitFilter = boardKitFilter;
        this.showBoardOrKitTemplate = showBoardOrKitTemplate;
        this.productSupportsProcessor = productSupportsProcessor;
        this.showProcessorDuplicates = showProcessorDuplicates;
    }

    public void setIsBoardIncluded(boolean isBoardIncluded) {
        this.isBoardIncluded = isBoardIncluded;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, @Nullable Object oldInput, @Nullable Object newInput) {
        this.derivatives = (ISupportedDerivativesForSwTools)newInput;
        if (newInput == null) {
            this.rootElements = new Object[0];
            return;
        }
        ISupportedDerivativesForSwTools der = this.derivatives;
        assert (der != null);
        ProcessorNode processors = new ProcessorNode(UtilsText.safeString((String)Messages.get().ProcessorProvider_ProcessorsNode));
        processors.setChildrenSupplier(this::getProcessors);
        ProcessorNode boards = new ProcessorNode(UtilsText.safeString((String)Messages.get().ProcessorProvider_BoardsNode));
        boards.setChildrenSupplier(this::getBoards);
        ProcessorNode kits = new ProcessorNode(UtilsText.safeString((String)Messages.get().ProcessorProvider_KitsNode));
        kits.setChildrenSupplier(this::getKits);
        ProcessorNode templates = new ProcessorNode(UtilsText.safeString((String)Messages.get().ProcessorProvider_TemplatesNode));
        templates.setChildrenSupplier(this::getTemplates);
        this.rootElements = this.onlineDataInfo.getOnlineBoards().isEmpty() && der.getAllBoardsInfos().isEmpty() || !this.isBoardIncluded ? new Object[]{processors} : new Object[]{templates, kits, boards, processors};
    }

    public Object[] getElements(Object inputElement) {
        return Arrays.stream(this.rootElements).filter(this::hasChildren).toArray();
    }

    protected @Nullable ProcessorMergeHelper getProcessorMergeHelper() {
        ISupportedDerivativesForSwTools der = this.derivatives;
        if (der == null) {
            return null;
        }
        ProcessorMergeHelper helper = new ProcessorMergeHelper(der, this.onlineDataInfo);
        helper.setCustomProcessorSupported(this.productSupportsProcessor);
        return helper;
    }

    protected Object[] getProcessors() {
        ProcessorMergeHelper helper = this.getProcessorMergeHelper();
        if (helper != null) {
            Collection<String> series = helper.getAllSeries(this.processorFilter);
            return series.stream().map(i -> new ProcessorNode((String)i, (String)i, () -> this.getSeriesProcessors((String)i))).sorted().toArray();
        }
        return new Object[0];
    }

    protected Object[] getTemplates(Function<ProcessorMergeHelper, Collection<ITemplateInfo>> tmplProvider) {
        ProcessorMergeHelper helper = this.getProcessorMergeHelper();
        if (helper != null) {
            return tmplProvider.apply(helper).stream().filter(b -> this.boardKitFilter.test(b.getId())).sorted((b1, b2) -> b1.getId().compareTo(b2.getId())).toArray();
        }
        return new Object[0];
    }

    protected Object[] getBoards() {
        return this.getTemplates(merger -> merger.getAllBoardsFilteredById());
    }

    protected Object[] getKits() {
        return this.getTemplates(merger -> merger.getAllKitsFilteredById());
    }

    protected Object[] getTemplates() {
        ISupportedDerivativesForSwTools der = this.derivatives;
        assert (der != null);
        return der.getAllTemplatesInfos().stream().filter(t -> this.showBoardOrKitTemplate.test((ITemplateInfo)t)).toArray();
    }

    Object[] getSeriesProcessors(String series) {
        ProcessorMergeHelper helper = this.getProcessorMergeHelper();
        assert (helper != null);
        return helper.getMasterToolsForSeriesFilteredById(series, this.showProcessorDuplicates).stream().filter(i -> this.processorFilter.test(i.getId())).sorted((a, b) -> a.getId().compareTo(b.getId())).toArray();
    }

    public Object[] getChildren(Object parentElement) {
        ITemplateInfo info;
        if (parentElement instanceof ProcessorNode) {
            ProcessorNode node = (ProcessorNode)parentElement;
            return node.getChildren();
        }
        if (parentElement instanceof ITemplateInfo && (info = (ITemplateInfo)parentElement).getTemplateVariants().size() > 1) {
            return info.getTemplateVariants().stream().map(i -> new TemplateInfoProxy(info, (String)i)).toArray();
        }
        return new Object[0];
    }

    public static String firstSegmentOfPath(String path) {
        int p = path.indexOf(47);
        return p > 0 ? path.substring(0, p) : path;
    }

    public static String withoutFirstSegmentOfPath(String path) {
        int p = path.indexOf(47);
        return p > 0 ? path.substring(p + 1) : path;
    }

    public @Nullable Object getParent(Object element) {
        if (Objects.isNull(element)) {
            return null;
        }
        return this.findParentForElement(this.rootElements, element, null);
    }

    private @Nullable Object findParentForElement(@NonNull Object @Nullable [] array, Object element, @Nullable Object parentElement) {
        if (array == null || array.length == 0) {
            return null;
        }
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (element.equals(o)) {
                return parentElement;
            }
            Object[] arr = this.getChildren(o);
            Object res = this.findParentForElement(arr, element, o);
            if (res != null) {
                return res;
            }
            ++n2;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ProcessorNode) {
            return !ArraysUtils.isEmpty((Object[])this.getChildren(element));
        }
        if (element instanceof ITemplateInfo) {
            return !ArraysUtils.isEmpty((Object[])this.getChildren(element));
        }
        return false;
    }
}

