/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework.ui.newconfig;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsDecryption;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.runtime.ExecutableExtensionProvider;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.PEConfiguration;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.configuration.logging.UserLogger;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.ITemplateInfo;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedToolsByProcessor;
import com.nxp.swtools.expert.processordb.sdkcomponents.SdkComponentsTable;
import com.nxp.swtools.framework.Messages;
import com.nxp.swtools.framework.ui.newconfig.IWizardPageProvider;
import com.nxp.swtools.framework.ui.newconfig.NewConfigWizardPage;
import com.nxp.swtools.framework.ui.newconfig.NewConfigurationModePage;
import com.nxp.swtools.framework.ui.newconfig.NewConfigurationProcessorPage;
import com.nxp.swtools.framework.ui.newconfig.WizardData;
import com.nxp.swtools.framework.ui.newconfig.containers.IProcessorSelectionContainer;
import com.nxp.swtools.kex.api.IProcessorInfo;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.kex.selector.IMcuSelection;
import com.nxp.swtools.kex.selector.IMcuSelectionWritable;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.ConfigChangeReason;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.IConfigChangeContext;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.change.DefaultConfigChangeContext;
import com.nxp.swtools.provider.configuration.change.DefaultConfigChangeContextHelper;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.processors.DownloadStatus;
import com.nxp.swtools.provider.processors.ISWToolsKitInfo;
import com.nxp.swtools.provider.processors.KExProcessorsProvider;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.sdkproject.ImportProjectResultStatus;
import com.nxp.swtools.sdkproject.ImportProjectResultStatusWithDescription;
import com.nxp.swtools.sdkproject.ImportToolchainProjectFactory;
import com.nxp.swtools.sdkproject.ToolchainProjectFactory;
import com.nxp.swtools.utils.ConfigurationUtils;
import com.nxp.swtools.utils.preferences.KEPreferences;
import com.nxp.swtools.utils.processors.ProcessorDataUpdateUI;
import com.nxp.swtools.utils.tools.Tools;
import com.nxp.swtools.utils.undo.UndoRedoConfig;
import com.nxp.swtools.utils.wizards.KExWizard;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewConfigWizard
extends KExWizard
implements INewWizard {
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(NewConfigWizard.class);
    @Nullable
    protected NewConfigurationProcessorPage configurationProcessorPage;
    @NonNull
    protected final WizardData wizardData;
    @NonNull
    protected @NonNull Map<@NonNull String, @NonNull IWizardPageProvider> pageProviders = new HashMap<String, IWizardPageProvider>();
    @Nullable
    protected final UserLogger userLogger;
    private boolean showDashboard;

    public NewConfigWizard(@NonNull WizardData.WizardType wizardType) {
        this.wizardData = new WizardData(wizardType, SharedConfigurationFactory.createSharedConfiguration());
        this.userLogger = UserLogger.getInstance();
        this.initWizard();
        this.readPageProviders();
    }

    private final void initWizard() {
        this.setWindowTitle(this.getWindowTitleForWizardType());
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    void log2Ui(@NonNull Shell shell, @NonNull Level level, @Nullable String msg) {
        if (msg == null) {
            assert (false);
            return;
        }
        UserLogger usrLogger = this.userLogger;
        if (usrLogger != null) {
            shell.getDisplay().asyncExec(() -> usrLogger.log(level, msg));
        }
    }

    void logInfo2Ui(@NonNull Shell shell, @Nullable String msg) {
        this.log2Ui(shell, Level.INFO, msg);
    }

    private boolean importToolchainProject(@NonNull Shell shell, @NonNull ISharedConfiguration sharedConfig, @NonNull SubMonitor monitor) {
        Path path;
        try {
            path = Paths.get(this.wizardData.getPath(), new String[0]);
        }
        catch (InvalidPathException invalidPathException) {
            ConfigurationUtils.logAndShowError((Shell)shell, (String)Messages.get().DlgModeSelection_ErrPathIsInavalid, null);
            return false;
        }
        monitor.worked(5);
        SubMonitor subSdkPrjMonitor = monitor.newChild(20, 0);
        IToolchainProjectWithSdk prj = ToolchainProjectFactory.createToolchainProjectForImport((Path)path, (IProgressMonitor)subSdkPrjMonitor);
        if (!prj.wasProjectDetected()) {
            String msg = String.valueOf(Messages.get().DlgModeSelection_ErrNoToolchainPrjDetected) + " " + UtilsText.safeString((String)prj.getProjectDetectionProblem()) + "\n" + "\n" + com.nxp.swtools.sdkproject.Messages.get().SdkProject_TextSupportedToolchainsAre;
            ConfigurationUtils.logAndShowError((Shell)shell, (String)msg, null);
            return false;
        }
        subSdkPrjMonitor.done();
        String mexFilePath = ImportToolchainProjectFactory.getExistingMexPathForProject((String)this.wizardData.getPath());
        boolean openMex = false;
        if (mexFilePath != null) {
            openMex = true;
        } else {
            mexFilePath = String.valueOf(this.wizardData.getPath()) + File.separator + prj.getProjectName() + ".mex";
        }
        String processor = prj.getProcessor();
        if (NewConfigWizard.isDownloadOrUpdatePossible() && processor != null) {
            String sdkVersion = SWToolsPlatform.getSdkVersionForProcessor((String)processor);
            ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
            IProcessorMasterToolInfo procLocal = derivatives.getProcessorMasterToolInfo(processor, sdkVersion);
            if (procLocal != null && SupportedToolsByProcessor.isToolSuported((IProcessorMasterToolInfo)procLocal, (String)"Peripherals")) {
                String apiVersion = procLocal.getFrozenApiVersion();
                if (apiVersion == null) {
                    apiVersion = KExProcessorsProvider.getRestApiDataVersion();
                }
                KExProcessorsProvider.downloadOrUpdateComponents((String)sdkVersion, (SdkComponentsTable)derivatives.getSdkComponentsTable(procLocal), (String)apiVersion, (IProgressMonitor)monitor.newChild(10, 0));
            }
        }
        if (openMex) {
            monitor.setTaskName(UtilsText.safeString((String)Messages.get().DlgModeSelection_RadioOpenExistingMex));
            AtomicBoolean result = new AtomicBoolean(false);
            SubMonitor subImport = monitor.newChild(75, 0);
            assert (mexFilePath != null);
            IRunnableWithProgress runnable = ConfigurationUtils.createRunnableToOpenConfiguration((Shell)shell, (String)mexFilePath, null, (ConfigurationUtils.OpenAction)ConfigurationUtils.OpenAction.OPEN_INSTEAD_IMPORT, (AtomicBoolean)result);
            try {
                runnable.run((IProgressMonitor)subImport);
            }
            catch (InterruptedException | InvocationTargetException e) {
                result.set(false);
                LOGGER.log(Level.SEVERE, "Failed to open selected configuration", e);
            }
            monitor.done();
        } else if (!this.importFromSources(shell, sharedConfig, prj, mexFilePath, monitor)) {
            return false;
        }
        return true;
    }

    private boolean importFromSources(@NonNull Shell shell, @NonNull ISharedConfiguration sharedConfig, @NonNull IToolchainProjectWithSdk prj, @NonNull String mexFilePath, @NonNull SubMonitor monitor) {
        boolean firstTimeOpened;
        this.logInfo2Ui(shell, String.valueOf(Messages.get().ImportToolchainProject_LogImportProject) + this.wizardData.getPath());
        ConfigurationUtils.fireBeforeConfigurationCreated((Shell)shell, (IProgressMonitor)monitor.newChild(1, 0));
        SubMonitor subImport = monitor.newChild(60, 0);
        ISharedConfiguration importedSharedCfg = SharedConfigurationFactory.createSharedConfiguration();
        ImportProjectResultStatusWithDescription status = ImportToolchainProjectFactory.importToolchainProject((Shell)shell, (ISharedConfiguration)importedSharedCfg, (IToolchainProjectWithSdk)prj, (boolean)false, (IProgressMonitor)subImport, (boolean)false);
        if (!ImportProjectResultStatus.SUCCEED.equals((Object)status.getStatus())) {
            this.log2Ui(shell, Level.SEVERE, Messages.get().ImportToolchainProject_ErrImportFailed);
            ConfigurationUtils.logAndShowError((Shell)shell, (String)status.getDescription(), null);
            SharedConfigurationFactory.clearSharedConfig((ISharedConfiguration)sharedConfig);
            return false;
        }
        Tools.disableUnconfiguredTools((ISharedConfiguration)importedSharedCfg);
        subImport.done();
        monitor.worked(5);
        boolean bl = firstTimeOpened = !KEPreferences.getAllRecentConfigFileNames().contains(mexFilePath);
        assert (firstTimeOpened || !firstTimeOpened);
        StringBuilder logMsg = new StringBuilder();
        boolean res = ImportToolchainProjectFactory.saveMexAfterProjectImport((ISharedConfiguration)importedSharedCfg, (ISharedConfiguration)sharedConfig, (String)mexFilePath, (Shell)shell, (StringBuilder)logMsg);
        if (logMsg.length() > 0) {
            this.logInfo2Ui(shell, logMsg.toString());
        }
        if (!res) {
            return false;
        }
        sharedConfig.setFirstTimeOpen(firstTimeOpened);
        ConfigurationUtils.fireAfterConfigurationCreated((Shell)shell, (ISharedConfiguration)sharedConfig, (IProgressMonitor)monitor.newChild(1, 0));
        monitor.worked(10);
        return true;
    }

    public boolean performFinish() {
        Shell shell = Objects.requireNonNull(this.getShell());
        NewConfigurationProcessorPage confPageLoc = Objects.requireNonNull(this.configurationProcessorPage);
        AtomicBoolean result = new AtomicBoolean(false);
        try {
            ISharedConfiguration sharedConfig = SWToolsPlatform.getSharedConfigurationSingleton();
            IProcessorSelectionContainer immutableSelection = this.wizardData.getMode().selectBoardProcessor() ? confPageLoc.getSelectionContainer().getImmutableSelection() : null;
            String taskName = this.wizardData.getMode().getUiCaption();
            this.getContainer().run(true, false, monitor -> {
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)taskName, (int)100);
                boolean preFinishResult = this.performPreFinishContributors(sub);
                if (preFinishResult) {
                    switch (this.wizardData.getMode()) {
                        case CREATE_NEW_CFG: 
                        case SWITCH_PROCESSOR: {
                            result.set(this.switchProcessorOrNewConfig(shell, taskName, Objects.requireNonNull(immutableSelection), sub));
                            break;
                        }
                        case IMPORT_TOOLCHAIN_PROJECT: 
                        case CLONE_EXAMPLE: {
                            result.set(this.importToolchainProject(shell, sharedConfig, sub));
                            break;
                        }
                        case OPEN_EXISTING_CFG: {
                            this.logInfo2Ui(shell, String.valueOf(Messages.get().NewConfigWizard_LogReOpenPrevMex) + this.wizardData.getPath());
                            IRunnableWithProgress runnable = ConfigurationUtils.createRunnableToOpenConfiguration((Shell)shell, (String)this.wizardData.getPath(), null, (ConfigurationUtils.OpenAction)ConfigurationUtils.OpenAction.OPEN_CMD, (AtomicBoolean)result);
                            runnable.run((IProgressMonitor)sub);
                            break;
                        }
                        default: {
                            assert (false);
                            result.set(false);
                        }
                    }
                }
                if (result.get()) {
                    boolean res = this.performFinishContributors(sub);
                    result.set(res);
                }
                sub.done();
                if (!result.get()) {
                    SharedConfigurationFactory.clearSharedConfig((ISharedConfiguration)sharedConfig);
                } else if ((this.wizardData.getMode() == WizardData.Mode.CREATE_NEW_CFG || this.wizardData.getMode() == WizardData.Mode.IMPORT_TOOLCHAIN_PROJECT || this.wizardData.getMode() == WizardData.Mode.CLONE_EXAMPLE) && Tools.getTools().size() > 1) {
                    this.showDashboard = true;
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
        return result.get();
    }

    private boolean switchProcessorOrNewConfig(@NonNull Shell shell, @NonNull String taskName, @NonNull IProcessorSelectionContainer immutableSelection, @NonNull SubMonitor sub) {
        boolean result = false;
        ISharedConfiguration sharedConfig = SWToolsPlatform.getSharedConfigurationSingleton();
        boolean createUndoPoint = this.wizardData.wizardType.equals((Object)WizardData.WizardType.SWITCHING_PROCESSOR);
        if (createUndoPoint) {
            UndoRedoConfig.startUndoPointForMultiOp((ISharedConfiguration)sharedConfig, (String)taskName);
        }
        ConfigurationUtils.fireBeforeConfigurationCreated((Shell)shell, (IProgressMonitor)sub.newChild(1, 0));
        result = this.createConfiguration(shell, immutableSelection, sharedConfig, (IProgressMonitor)sub);
        shell.getDisplay().syncExec(() -> {
            NewConfigurationProcessorPage confPageLoc = Objects.requireNonNull(this.configurationProcessorPage);
            ProcessorCore selCore = confPageLoc.getSelectionContainer().getSelectedCore();
            if (selCore != null) {
                sharedConfig.getCommonConfig().setSelectedCore(selCore);
            }
            sharedConfig.setDirty(DefaultConfigChangeContextHelper.processorChanged((ISharedConfiguration)sharedConfig, (String)taskName));
            if (!createUndoPoint) {
                UndoRedoConfig.clearUndoHistory((ISharedConfiguration)sharedConfig);
            }
        });
        if (createUndoPoint) {
            UndoRedoConfig.finishUndoPointForMultiOp((ISharedConfiguration)sharedConfig);
        } else if (result) {
            sharedConfig.setFirstTimeOpen(true);
            ConfigurationUtils.fireAfterConfigurationCreated((Shell)shell, (ISharedConfiguration)sharedConfig, (IProgressMonitor)sub.newChild(1, 0));
        }
        return result;
    }

    private @NonNull String getWindowTitleForWizardType() {
        String title;
        switch (this.wizardData.wizardType) {
            case NEW_CONFIGURATION: {
                title = Messages.get().NewConfigDialog_Title;
                break;
            }
            case STARTUP: {
                title = Messages.get().NewConfigDialog_TitleForStartup;
                break;
            }
            case SWITCHING_PROCESSOR: {
                title = Messages.get().NewConfigDialog_TitleForSwitch;
                break;
            }
            default: {
                assert (false);
                title = null;
            }
        }
        return UtilsText.safeString((String)title);
    }

    public void addPages() {
        super.addPages();
        if (!SWToolsPlatform.isRunningInEclipseIde() && !SwToolsProduct.isUctProduct() || SWToolsProperties.isTestOn()) {
            NewConfigurationModePage modePageLoc = new NewConfigurationModePage(this.wizardData);
            if (!this.wizardData.wizardType.equals((Object)WizardData.WizardType.SWITCHING_PROCESSOR)) {
                this.addPage((IWizardPage)modePageLoc);
            } else {
                this.wizardData.setMode(WizardData.Mode.SWITCH_PROCESSOR);
            }
        }
        String title = this.getWindowTitleForWizardType();
        NewConfigurationProcessorPage processorPageLoc = this.configurationProcessorPage = new NewConfigurationProcessorPage(title, this.wizardData);
        processorPageLoc.selectionContainer.setSwitchingProcessor(this.wizardData.wizardType.equals((Object)WizardData.WizardType.SWITCHING_PROCESSOR));
        this.addPage((IWizardPage)processorPageLoc);
        this.createPagesFromProviders();
    }

    boolean createConfiguration(@NonNull Shell shell, @NonNull IProcessorSelectionContainer selectionContainer, @NonNull ISharedConfiguration targetConfig, @NonNull IProgressMonitor monitor) {
        String boardId;
        String templateValue;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        if (NewConfigWizard.isDownloadOrUpdatePossible()) {
            SubMonitor subMonitorChild = subMonitor.newChild(1, 0);
            ProcessorDataUpdateUI.downloadOrUpdateConfigFiles((ProcessorDataUpdateUI.DisplayProvider)ProcessorDataUpdateUI.DisplayProvider.create((Control)shell), (IProgressMonitor)subMonitorChild);
        }
        if (!UtilsText.isEmpty((String)(templateValue = selectionContainer.getSelectedTemplate())) && templateValue != null) {
            return this.createTemplateConfiguration(shell, selectionContainer, targetConfig, templateValue, subMonitor);
        }
        String sdkVersion = UtilsText.safeString((String)selectionContainer.getSelectedSdk());
        assert (!UtilsText.isEmpty((String)sdkVersion)) : "sdk version must be defined for kit, board and processor (not for template)";
        ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        String mcuValue = selectionContainer.getSelectedMcu();
        String kitId = selectionContainer.getSelectedKit();
        if (!UtilsText.isEmpty((String)kitId) && kitId != null) {
            ITemplateInfo kitTempl = selectionContainer.getSelectedKitTemplateOnline();
            NewConfigResult result = NewConfigWizard.createKitConfiguration(shell, selectionContainer, targetConfig, kitId, kitTempl, subMonitor);
            switch (result) {
                case CREATED: {
                    return true;
                }
                case FAILED: {
                    return false;
                }
            }
            if (kitTempl == null) {
                kitTempl = derivatives.getKitById(kitId, sdkVersion);
            }
            if (kitTempl != null) {
                mcuValue = kitTempl.getMasterToolName();
            }
        }
        if (!UtilsText.isEmpty((String)(boardId = selectionContainer.getSelectedBoard())) && boardId != null) {
            ITemplateInfo boardTempl = selectionContainer.getSelectedBoardTemplateOnline();
            NewConfigResult result = NewConfigWizard.createBoardConfiguration(shell, selectionContainer, targetConfig, boardId, boardTempl, subMonitor);
            switch (result) {
                case CREATED: {
                    return true;
                }
                case FAILED: {
                    return false;
                }
            }
            if (boardTempl == null) {
                boardTempl = derivatives.getBoardById(boardId, sdkVersion);
            }
            if (boardTempl != null) {
                mcuValue = boardTempl.getMasterToolName();
            }
        }
        if (!UtilsText.isEmpty((String)mcuValue) && mcuValue != null) {
            return this.createProcessorConfiguration(shell, selectionContainer, targetConfig, subMonitor);
        }
        return false;
    }

    private boolean createTemplateConfiguration(@NonNull Shell shell, @NonNull IProcessorSelectionContainer selectionContainer, @NonNull ISharedConfiguration targetConfig, @NonNull String templateId, @NonNull SubMonitor subMonitor) {
        ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        ITemplateInfo template = derivatives.getTemplateById(templateId);
        if (template == null) {
            LOGGER.log(Level.SEVERE, "Displayed template not found, internal error");
            assert (false);
            return false;
        }
        Display display = Objects.requireNonNull(shell.getDisplay());
        ISharedConfiguration newConfig = !Objects.isNull(this.wizardData) ? this.wizardData.newConfiguration : SharedConfigurationFactory.createSharedConfiguration();
        File preSetMex = new File(String.valueOf(SupportedDerivativesForSwTools.getUserTemplatesDir()) + File.separator + template.getRelFileName());
        if (preSetMex.exists()) {
            try {
                Throwable throwable = null;
                Object var12_14 = null;
                try (FileInputStream is = new FileInputStream(preSetMex);){
                    SharedConfigurationFactory.loadSharedConfigurationFromXml((ISharedConfiguration)newConfig, (InputStream)is);
                    ICommonConfig mcuSelection = newConfig.getCommonConfig();
                    mcuSelection.setName(selectionContainer.getConfigurationName());
                    ProcessorDataUpdateUI.DisplayProvider displayProvider = ProcessorDataUpdateUI.DisplayProvider.create((Control)shell);
                    NewConfigWizard.updateOrDownloadProcessor(displayProvider, (IMcuSelection)mcuSelection, selectionContainer.getOnlineDataInfo().getOnlineProcessorsWeb(), (IProgressMonitor)subMonitor.newChild(1));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
            Tools.disableUnconfiguredTools((ISharedConfiguration)newConfig);
            targetConfig.setLocationPath(null);
            targetConfig.setCreatedFromUserTemplate(true);
            display.syncExec(() -> {
                SharedConfigurationFactory.applyNewConfig((ISharedConfiguration)newConfig, (ISharedConfiguration)targetConfig, (ConfigChangeReason)ConfigChangeReason.NEW_CONFIG);
                targetConfig.setDirty((IConfigChangeContext)new DefaultConfigChangeContext(IConfigChangeContext.ConfigChangeType.CONFIGURATION_NEW, "McuConfiguration", (Object)targetConfig, this.wizardData.getMode().getUiCaption()));
            });
            SWToolsPlatform.getAnalytics().logUserAction(2, targetConfig.getUUID(), "project_new", UtilsText.safeString((String)targetConfig.getCommonConfig().getMcu()), UtilsText.safeString((String)targetConfig.getCommonConfig().getSdkVersion()));
            return true;
        }
        display.syncExec(() -> {
            String msg = MessageFormat.format("Cannot open file {0}", preSetMex);
            MessageDialog.openError((Shell)shell, (String)Messages.get().NewConfigDialog_ErrorDialogTitle, (String)msg);
        });
        return false;
    }

    private static NewConfigResult createKitConfiguration(@NonNull Shell shell, @NonNull IProcessorSelectionContainer selectionContainer, @NonNull ISharedConfiguration targetConfig, @NonNull String kitId, @Nullable ITemplateInfo kitOnline, @NonNull SubMonitor subMonitor) {
        ISupportedDerivativesForSwTools derivatives;
        ITemplateInfo template;
        ProcessorCore selCore = selectionContainer.getSelectedCore();
        String sdkVersion = UtilsText.safeString((String)selectionContainer.getSelectedSdk());
        Display display = Objects.requireNonNull(shell.getDisplay());
        ProcessorDataUpdateUI.DisplayProvider displayProvider = ProcessorDataUpdateUI.DisplayProvider.create((Control)shell);
        AtomicBoolean templateLoadResult = new AtomicBoolean();
        AtomicBoolean alreadyDataUpdated = new AtomicBoolean();
        if (NewConfigWizard.isDownloadOrUpdatePossible()) {
            SubMonitor subMonitorChild = subMonitor.newChild(1, 0);
            ProcessorDataUpdateUI.downloadOrUpdateKit((ProcessorDataUpdateUI.DisplayProvider)displayProvider, (String)kitId, (String)sdkVersion, (IProgressMonitor)subMonitorChild, (Collection)selectionContainer.getOnlineDataInfo().getOnlineKitsWeb());
            if (kitOnline != null) {
                String masterToolName;
                DownloadStatus status;
                if (kitOnline instanceof ISWToolsKitInfo) {
                    ISWToolsKitInfo kitInfo = (ISWToolsKitInfo)kitOnline;
                    String boardName = kitInfo.getKitInfo().getBoardName();
                    ProcessorDataUpdateUI.downloadOrUpdateBoard((ProcessorDataUpdateUI.DisplayProvider)displayProvider, (String)boardName, (String)sdkVersion, (IProgressMonitor)subMonitorChild, (Collection)selectionContainer.getOnlineDataInfo().getOnlineBoardsWeb());
                }
                if ((status = NewConfigWizard.updateOrDownloadData(displayProvider, masterToolName = kitOnline.getMasterToolName(), sdkVersion, selectionContainer.getOnlineDataInfo().getOnlineProcessorsWeb(), (IProgressMonitor)subMonitor.newChild(1, 0))).isCurrentOrUpdated()) {
                    alreadyDataUpdated.set(true);
                } else {
                    display.syncExec(() -> NewConfigWizard.showDownloadError(shell, status));
                }
            }
        } else {
            subMonitor.worked(2);
        }
        if ((template = (derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools()).getKitById(kitId, sdkVersion)) == null) {
            return NewConfigResult.FAILED;
        }
        display.syncExec(() -> templateLoadResult.set(ConfigurationUtils.applyMexTemplate((ISharedConfiguration)targetConfig, (ITemplateInfo)template, (String)selectionContainer.getSelectedMexVariant(), (String)selectionContainer.getConfigurationName(), (ProcessorCore)selCore, selection -> {
            if (!alreadyDataUpdated.get()) {
                NewConfigWizard.updateOrDownloadProcessor(displayProvider, selection, selectionContainer.getOnlineDataInfo().getOnlineProcessorsWeb(), (IProgressMonitor)new NullProgressMonitor());
            }
        })));
        if (templateLoadResult.get()) {
            SWToolsPlatform.getAnalytics().logUserAction(2, targetConfig.getUUID(), "project_new", UtilsText.safeString((String)targetConfig.getCommonConfig().getMcu()), UtilsText.safeString((String)targetConfig.getCommonConfig().getSdkVersion()));
            return NewConfigResult.CREATED;
        }
        return NewConfigResult.NOT_CREATED;
    }

    private static NewConfigResult createBoardConfiguration(@NonNull Shell shell, @NonNull IProcessorSelectionContainer selectionContainer, @NonNull ISharedConfiguration targetConfig, @NonNull String boardId, @Nullable ITemplateInfo boardOnline, @NonNull SubMonitor subMonitor) {
        Display display = Objects.requireNonNull(shell.getDisplay());
        ProcessorDataUpdateUI.DisplayProvider displayProvider = ProcessorDataUpdateUI.DisplayProvider.create((Control)shell);
        AtomicBoolean templateLoadResult = new AtomicBoolean();
        AtomicBoolean alreadyDataUpdated = new AtomicBoolean();
        String sdkVersion = UtilsText.safeString((String)selectionContainer.getSelectedSdk());
        if (NewConfigWizard.isDownloadOrUpdatePossible()) {
            SubMonitor subMonitorChild = subMonitor.newChild(1, 0);
            ProcessorDataUpdateUI.downloadOrUpdateBoard((ProcessorDataUpdateUI.DisplayProvider)displayProvider, (String)boardId, (String)sdkVersion, (IProgressMonitor)subMonitorChild, (Collection)selectionContainer.getOnlineDataInfo().getOnlineBoardsWeb());
            ITemplateInfo board = boardOnline;
            if (board != null) {
                String masterToolName = board.getMasterToolName();
                DownloadStatus status = NewConfigWizard.updateOrDownloadData(displayProvider, masterToolName, sdkVersion, selectionContainer.getOnlineDataInfo().getOnlineProcessorsWeb(), (IProgressMonitor)subMonitor.newChild(1, 0));
                if (status.isCurrentOrUpdated()) {
                    alreadyDataUpdated.set(true);
                } else {
                    display.syncExec(() -> NewConfigWizard.showDownloadError(shell, status));
                }
            }
        } else {
            subMonitor.worked(2);
        }
        ProcessorCore selCore = selectionContainer.getSelectedCore();
        ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        ITemplateInfo template = derivatives.getBoardById(boardId, sdkVersion);
        if (template == null) {
            return NewConfigResult.FAILED;
        }
        display.syncExec(() -> templateLoadResult.set(ConfigurationUtils.applyMexTemplate((ISharedConfiguration)targetConfig, (ITemplateInfo)template, (String)selectionContainer.getSelectedMexVariant(), (String)selectionContainer.getConfigurationName(), (ProcessorCore)selCore, selection -> {
            if (!alreadyDataUpdated.get()) {
                NewConfigWizard.updateOrDownloadProcessor(displayProvider, selection, selectionContainer.getOnlineDataInfo().getOnlineProcessorsWeb(), (IProgressMonitor)new NullProgressMonitor());
            }
        })));
        if (templateLoadResult.get()) {
            SWToolsPlatform.getAnalytics().logUserAction(2, targetConfig.getUUID(), "project_new", UtilsText.safeString((String)targetConfig.getCommonConfig().getMcu()), UtilsText.safeString((String)targetConfig.getCommonConfig().getSdkVersion()));
            return NewConfigResult.CREATED;
        }
        return NewConfigResult.NOT_CREATED;
    }

    private boolean createProcessorConfiguration(@NonNull Shell shell, @NonNull IProcessorSelectionContainer selectionContainer, @NonNull ISharedConfiguration targetConfig, @NonNull SubMonitor subMonitor) {
        File presetMex;
        IProcessorMasterToolInfo procLocal;
        ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        ISharedConfiguration newConfig = !selectionContainer.isSwitchingProcessor() ? (!Objects.isNull(this.wizardData) ? this.wizardData.newConfiguration : SharedConfigurationFactory.createSharedConfiguration()) : targetConfig;
        String mcu = Objects.requireNonNull(selectionContainer.getSelectedMcu());
        @NonNull IMcuSelectionWritable mcuSelection = (IMcuSelectionWritable)(!selectionContainer.isSwitchingProcessor() ? newConfig.getCommonConfig() : SharedConfigurationFactory.getSharedConfigurationSingleton().getCommonConfig());
        String boardValue = selectionContainer.getSelectedBoard();
        if (UtilsText.isEmpty((String)boardValue)) {
            mcuSelection.setBoard(null);
        } else {
            mcuSelection.setBoard(boardValue);
        }
        String kitValue = selectionContainer.getSelectedKit();
        if (UtilsText.isEmpty((String)kitValue)) {
            mcuSelection.setKit(null);
        } else {
            mcuSelection.setKit(kitValue);
        }
        mcuSelection.setMcu(mcu);
        mcuSelection.setPackage(null);
        String sdkVersion = UtilsText.safeString((String)selectionContainer.getSelectedSdk());
        mcuSelection.setSdkVersion(sdkVersion);
        mcuSelection.setExample(null);
        DownloadStatus downloadStatus = DownloadStatus.CURRENT;
        Display display = Objects.requireNonNull(shell.getDisplay());
        if (NewConfigWizard.isDownloadOrUpdatePossible()) {
            downloadStatus = NewConfigWizard.updateOrDownloadData(ProcessorDataUpdateUI.DisplayProvider.create((Control)shell), mcu, sdkVersion, selectionContainer.getOnlineDataInfo().getOnlineProcessorsWeb(), (IProgressMonitor)subMonitor.newChild(2, 0));
            DownloadStatus status = downloadStatus;
            if (!status.isCurrentOrUpdated()) {
                display.syncExec(() -> NewConfigWizard.showDownloadError(shell, status));
            }
        } else {
            subMonitor.worked(2);
        }
        if ((procLocal = derivatives.getProcessorMasterToolInfo(mcu, sdkVersion)) == null) {
            if (!downloadStatus.isCurrentOrUpdated()) {
                return false;
            }
            display.syncExec(() -> MessageDialog.openError((Shell)shell, (String)Messages.get().NewConfigDialog_ErrorDialogTitle, (String)Messages.get().NewConfigDialog_CannotDownloadData));
            return false;
        }
        String selectedPackage = selectionContainer.getSelectedPackage();
        mcuSelection.setPackage(selectedPackage != null && !selectedPackage.isEmpty() ? selectedPackage : procLocal.getDefaultPartNumber());
        if (!selectionContainer.isSwitchingProcessor() && (presetMex = ConfigurationUtils.getPresetMex((IMcuIdentification)mcuSelection)) != null && presetMex.exists()) {
            try {
                Throwable throwable = null;
                Object var18_20 = null;
                try (InputStream is = UtilsDecryption.getFileInputStream((File)presetMex);){
                    SharedConfigurationFactory.loadSharedConfigurationFromXml((ISharedConfiguration)newConfig, (InputStream)is);
                    mcuSelection = (IMcuSelectionWritable)newConfig.getCommonConfig();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        mcuSelection.setName(selectionContainer.getConfigurationName());
        SWToolsPlatform.applyCores((ISharedConfiguration)newConfig, (ISupportedDerivativesForSwTools)derivatives);
        if (!selectionContainer.isSwitchingProcessor()) {
            targetConfig.setLocationPath(null);
        }
        targetConfig.setCreatedFromUserTemplate(false);
        if (!WizardData.Mode.SWITCH_PROCESSOR.equals((Object)this.wizardData.getMode())) {
            ProcessorCore selCore = selectionContainer.getSelectedCore();
            Tools.disableToolsWithUnsupportedProcessor((ISharedConfiguration)newConfig);
            if (selCore != null) {
                newConfig.getCommonConfig().setSelectedCore(selCore);
            }
        }
        display.syncExec(() -> {
            ConfigChangeReason changeReason = selectionContainer.isSwitchingProcessor() ? ConfigChangeReason.MCU_CHANGE : ConfigChangeReason.NEW_CONFIG;
            SharedConfigurationFactory.applyNewConfig((ISharedConfiguration)newConfig, (ISharedConfiguration)targetConfig, (ConfigChangeReason)changeReason);
            IConfigChangeContext.ConfigChangeType change = selectionContainer.isSwitchingProcessor() ? IConfigChangeContext.ConfigChangeType.PROCESSOR_CHANGE : IConfigChangeContext.ConfigChangeType.CONFIGURATION_NEW;
            targetConfig.setDirty((IConfigChangeContext)new DefaultConfigChangeContext(change, "McuConfiguration", (Object)targetConfig, this.wizardData.getMode().getUiCaption()));
        });
        SWToolsPlatform.getAnalytics().logUserAction(2, targetConfig.getUUID(), "project_new", UtilsText.safeString((String)targetConfig.getCommonConfig().getMcu()), UtilsText.safeString((String)targetConfig.getCommonConfig().getSdkVersion()));
        return true;
    }

    private static void showDownloadError(@NonNull Shell shell, @NonNull DownloadStatus status) {
        String message = DownloadStatus.DISK_ERROR == status ? MessageFormat.format(com.nxp.swtools.utils.Messages.get().ConfigurationUtils_DiskOperationError, PEConfiguration.getDataDirectory()) : Messages.get().NewConfigDialog_CannotDownloadData;
        MessageDialog.openError((Shell)shell, (String)Messages.get().NewConfigDialog_ErrorDialogTitle, (String)message);
    }

    public static boolean isDownloadOrUpdatePossible() {
        return !SWToolsProperties.isDevelopmentWithNoDataUpdateOn() && !KExProcessorsProvider.isOffline();
    }

    public static @NonNull DownloadStatus updateOrDownloadProcessor(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ProcessorDataUpdateUI.DisplayProvider displayProvider, @NonNull IMcuSelection selection, @NonNull Collection<@NonNull IProcessorInfo> onlineProcessorsWeb, @NonNull IProgressMonitor monitor) {
        return NewConfigWizard.updateOrDownloadData(displayProvider, selection.getMcu(), selection.getSdkVersion(), onlineProcessorsWeb, monitor);
    }

    public static @NonNull DownloadStatus updateOrDownloadData(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ProcessorDataUpdateUI.DisplayProvider displayProvider, @NonNull String masterToolName, @NonNull String sdkVersion, @NonNull Collection<@NonNull IProcessorInfo> onlineProcessorsWeb, @NonNull IProgressMonitor monitor) {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        if (NewConfigWizard.isDownloadOrUpdatePossible()) {
            DownloadStatus status = ProcessorDataUpdateUI.downloadOrUpdateProcessor((ProcessorDataUpdateUI.DisplayProvider)displayProvider, (String)masterToolName, (String)sdkVersion, onlineProcessorsWeb, (IProgressMonitor)subMon.newChild(1, 0));
            if (status.isErrorOrCancelled()) {
                return status;
            }
            return ProcessorDataUpdateUI.downloadOrUpdateComponents((ProcessorDataUpdateUI.DisplayProvider)displayProvider, (String)masterToolName, (String)sdkVersion, (IProgressMonitor)subMon.newChild(1, 0));
        }
        subMon.done();
        return DownloadStatus.OFFLINE;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage newPage = super.getNextPage(page);
        while (newPage != null) {
            if (newPage instanceof NewConfigWizardPage) {
                NewConfigWizardPage ourWizardPage = (NewConfigWizardPage)newPage;
                if (ourWizardPage.canBeShown()) break;
                newPage = super.getNextPage(newPage);
                continue;
            }
            assert (false) : "All our pages must be extended from NewConfigWizardPage";
        }
        return newPage;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void readPageProviders() {
        @NonNull ExecutableExtensionProvider provider = new ExecutableExtensionProvider("com.nxp.swtools.framework.newconfigwizard", "page", "class", null, null, "priority");
        @NonNull @NonNull Map pagesMap = provider.getExtensionsMap("id");
        for (Map.Entry val : pagesMap.entrySet()) {
            this.pageProviders.put((String)val.getKey(), (IWizardPageProvider)val.getValue());
        }
    }

    private void createPagesFromProviders() {
        for (Map.Entry<String, IWizardPageProvider> val : this.pageProviders.entrySet()) {
            assert (val != null);
            @Nullable IWizardPageProvider value = val.getValue();
            assert (value != null);
            NewConfigWizardPage page = value.createPage(this.wizardData);
            if (page == null) continue;
            this.addPage((IWizardPage)page);
        }
    }

    private boolean performPreFinishContributors(SubMonitor monitor) {
        boolean result = true;
        SubMonitor providerMonitor = monitor.newChild(this.pageProviders.entrySet().size());
        for (Map.Entry<String, IWizardPageProvider> val : this.pageProviders.entrySet()) {
            assert (val != null);
            @Nullable IWizardPageProvider value = val.getValue();
            assert (value != null);
            SubMonitor monit = providerMonitor.newChild(1);
            assert (monit != null);
            result = value.performPreFinish(this.wizardData, (IProgressMonitor)monit);
            if (!result) break;
        }
        return result;
    }

    private boolean performFinishContributors(SubMonitor monitor) {
        boolean result = true;
        SubMonitor providerMonitor = monitor.newChild(this.pageProviders.entrySet().size());
        for (Map.Entry<String, IWizardPageProvider> val : this.pageProviders.entrySet()) {
            assert (val != null);
            @Nullable IWizardPageProvider value = val.getValue();
            assert (value != null);
            SubMonitor monit = providerMonitor.newChild(1);
            assert (monit != null);
            result = value.performFinish(this.wizardData, (IProgressMonitor)monit);
            if (!result) break;
        }
        return result;
    }

    public boolean showDashboard() {
        return this.showDashboard;
    }

    private static enum NewConfigResult {
        CREATED,
        FAILED,
        NOT_CREATED;

    }
}

