/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework.handlers;

import com.nxp.swtools.common.ui.utils.perspectives.PerspectivesHelper;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.configuration.SwToolsProductConfiguration;
import com.nxp.swtools.framework.Messages;
import com.nxp.swtools.utils.resources.ToolsImages;
import com.nxp.swtools.utils.tools.Tools;
import com.nxp.swtools.validation.engine.FilteredProblems;
import com.nxp.swtools.validation.engine.IBaseProblem;
import com.nxp.swtools.validation.engine.IValidationProblem;
import com.nxp.swtools.validation.engine.IValidationProblemListener;
import com.nxp.swtools.validation.engine.ValidationEngineFactory;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;

public class ShowProblemsViewHandler
extends AbstractHandler
implements IElementUpdater {
    public ShowProblemsViewHandler() {
        ValidationEngineFactory.addListener((IValidationProblemListener)new IValidationProblemListener(){

            public void validationProblemsChanged(@NonNull Collection<@NonNull IValidationProblem> problems) {
                ShowProblemsViewHandler.this.refreshCommand();
            }

            public void toolProblemsChanged(@NonNull Collection<@NonNull IBaseProblem> problems) {
                ShowProblemsViewHandler.this.refreshCommand();
            }
        });
    }

    public @Nullable Object execute(@NonNull ExecutionEvent event) throws ExecutionException {
        PerspectivesHelper.showView((String)"com.nxp.swtools.validation.problems.view");
        return Boolean.TRUE;
    }

    void refreshCommand() {
        ICommandService commandService;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ICommandService iCommandService = commandService = window != null ? (ICommandService)window.getService(ICommandService.class) : null;
        if (commandService != null) {
            commandService.refreshElements("com.nxp.swtools.framework.showProblemsView", null);
        }
    }

    public void updateElement(UIElement element, Map parameters) {
        ArrayList<@NonNull E> problems = new ArrayList(ValidationEngineFactory.getValidationProblemsCollection());
        problems.addAll(ValidationEngineFactory.getProblemsCollection());
        long numErrors = problems.stream().filter(p -> p.getProblemLevel() >= 2).count();
        long numWarnings = problems.stream().filter(p -> p.getProblemLevel() == 1).count();
        if (numErrors > 0L) {
            element.setIcon(ToolsImages.getImageDescriptorWithUrl((String)"icons/problems_red.png"));
        } else if (numWarnings > 0L) {
            element.setIcon(ToolsImages.getImageDescriptorWithUrl((String)"icons/problems_yellow.png"));
        } else {
            element.setIcon(ToolsImages.getImageDescriptorWithUrl((String)"icons/problems.png"));
        }
        StringBuilder tooltipBuilder = new StringBuilder(MessageFormat.format(Messages.get().ShowProblemsView_Tooltip, String.valueOf(numErrors), String.valueOf(numWarnings)));
        List toolProblems = (List)Tools.getTools().stream().map(FilteredProblems::countNumberOfProblemsForTool).filter(p -> p.getHighestLevel() >= 1).sorted().collect(CollectorsUtils.toList());
        if (!toolProblems.isEmpty()) {
            tooltipBuilder.append("\n").append(Messages.get().ShowProblemsView_ToolsWithProblems);
            toolProblems.forEach(p -> {
                StringBuilder stringBuilder2 = tooltipBuilder.append("\n").append(MessageFormat.format(Messages.get().ShowProblemsView_ToolContainsNumProblems, Objects.requireNonNull(SwToolsProductConfiguration.getRegisteredProduct((String)p.getToolId())).getProductName(), Objects.requireNonNull(p.getProblemsCount(1))));
            });
        }
        element.setTooltip(tooltipBuilder.toString());
    }
}

