/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework;

import com.nxp.swtools.common.ui.utils.dialogs.ShellProvider;
import com.nxp.swtools.common.ui.utils.perspectives.PerspectivesHelper;
import com.nxp.swtools.common.ui.utils.progress.UIJobHelper;
import com.nxp.swtools.common.ui.utils.services.Rap;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.cmd.CmdArguments;
import com.nxp.swtools.common.utils.cmd.CmdProgressMonitor;
import com.nxp.swtools.common.utils.cmd.CmdSection;
import com.nxp.swtools.common.utils.cmd.ICmdApplication;
import com.nxp.swtools.common.utils.cmd.bulk.CmdBulkFile;
import com.nxp.swtools.common.utils.cmd.bulk.CmdBulkFileEvaluator;
import com.nxp.swtools.common.utils.files.UtilsDecryption;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.CompactFormatter;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.net.NetUtils;
import com.nxp.swtools.common.utils.os.OSDetect;
import com.nxp.swtools.common.utils.runtime.ExecutableExtensionProvider;
import com.nxp.swtools.common.utils.runtime.JobsHelper;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.common.utils.zip.ZipUtils;
import com.nxp.swtools.configuration.PEConfiguration;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.configuration.SwToolsProductConfiguration;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.ITemplateInfo;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.framework.ApplicationWorkbenchAdvisor;
import com.nxp.swtools.framework.ApplicationWorkbenchWindowAdvisor;
import com.nxp.swtools.framework.KExCmdLine;
import com.nxp.swtools.framework.Messages;
import com.nxp.swtools.framework.commands.CheckForUpdates;
import com.nxp.swtools.framework.handlers.McuNotSelectedProblemHelper;
import com.nxp.swtools.framework.handlers.UpdateCodeHandler;
import com.nxp.swtools.kex.analytics.DesktopAnalytics;
import com.nxp.swtools.kex.analytics.DesktopAnalyticsHelper;
import com.nxp.swtools.kex.analytics.IAnalyticDataProvider;
import com.nxp.swtools.kex.analytics.IAnalytics;
import com.nxp.swtools.kex.api.IBoardInfo;
import com.nxp.swtools.kex.api.IKitInfo;
import com.nxp.swtools.kex.api.MfactApiFactory;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.kex.selector.McuSelectionFactory;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.analytics.GeneralAnalytics;
import com.nxp.swtools.provider.configuration.ConfigChangeReason;
import com.nxp.swtools.provider.configuration.ErrorLevels;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.change.DefaultConfigChangeContextHelper;
import com.nxp.swtools.provider.configuration.storage.CustomCopyright;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.configuration.storage.ProjectLink;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import com.nxp.swtools.provider.processors.CheckStatus;
import com.nxp.swtools.provider.processors.DataUpdater;
import com.nxp.swtools.provider.processors.KExProcessorsProvider;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.rcp.analytics.RcpAnalyticsFactory;
import com.nxp.swtools.sdkmanifest.loader.ManifestLoaderUtils;
import com.nxp.swtools.sdkproject.ImportProjectResultStatus;
import com.nxp.swtools.sdkproject.ImportToolchainProjectFactory;
import com.nxp.swtools.sdkproject.ToolchainProjectFactory;
import com.nxp.swtools.sdkproject.ToolchainProjectUtils;
import com.nxp.swtools.sdkproject.cmsis.bsp.PdscExample;
import com.nxp.swtools.sdkproject.cmsis.bsp.PdscParser;
import com.nxp.swtools.utils.ConfigurationUtils;
import com.nxp.swtools.utils.configuration.SharedConfigurationStatusSingleton;
import com.nxp.swtools.utils.logging.SevereLogsDetector;
import com.nxp.swtools.utils.preferences.KEPreferences;
import com.nxp.swtools.utils.scripting.api.ScriptUtils;
import com.nxp.swtools.utils.swt.httpserver.HttpServer;
import com.nxp.swtools.utils.tools.Tools;
import com.nxp.swtools.utils.undo.UndoRedoConfig;
import com.nxp.swtools.utils.wizards.importWizard.ImportHelper;
import com.nxp.swtools.utils.yaml.CmdBulkFileYamlConverter;
import com.nxp.swtools.utils.yaml.OutputPathOverridesStorageYamlConverter;
import com.nxp.swtools.validation.engine.IBaseProblem;
import com.nxp.swtools.validation.engine.ValidationEngineFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.osgi.framework.Bundle;

@NonNullByDefault
public class Application
implements IApplication {
    private static final Logger LOGGER = LogManager.getLogger(Application.class);
    private static String selectedTool = "";
    private static String VERIFICATION_FLAG = "-verify";
    private static String DETAILED_VERIFICATION_FLAG = "-verify-detailed";
    private static String POWER_DOWN_MODES_FLAG = "-EnablePowerDownModes";
    public static List<@NonNull String> argsList = new ArrayList<String>();
    private static Integer mExitCode = IApplication.EXIT_OK;
    static final Integer EXIT_MISSING_PARAM = 1;
    static final Integer EXIT_TOOL_ERROR = 2;
    static CmdSection cmdSection = new CmdSection();
    protected static final String MEX_FILE_NAME = "mex_output";
    private static boolean importingAllProjects = false;
    @Nullable
    private static File macMexFileToOpen = null;
    private static final SevereLogsDetector SEVERE_LOGS_DETECTOR = new SevereLogsDetector();
    private static final String EXTENSION_POINT_PLUGIN_ID = "com.nxp.swtools.cli.args";
    private static final String EXTENSION_POINT_ELEMENT = "cli_extension";
    private static final String EXTENSION_POINT_CLASS_ATTRIBUTE = "class";
    private static ScriptUtils utils = new ScriptUtils();

    private static boolean importOneProject(String prjPath, boolean updateCode) {
        LogManager.addHandler((Handler)SEVERE_LOGS_DETECTOR);
        try {
            boolean bl = ImportProjectResultStatus.SUCCEED.equals((Object)Application.importProjectSetTestCase(prjPath, updateCode));
            return bl;
        }
        finally {
            LogManager.removeHandler((Handler)SEVERE_LOGS_DETECTOR);
        }
    }

    private static ImportProjectResultStatus importProjectSetTestCase(String prjPath, boolean updateCode) {
        ImportToolchainProjectFactory.PERFORMANCE_LOGGER.entering(Application.class.getName(), "importProject");
        String prjPath4TestCase = prjPath;
        int pos = prjPath4TestCase.indexOf("boards");
        if (pos > 0) {
            prjPath4TestCase = prjPath4TestCase.substring(pos + 7);
        }
        CompactFormatter.setTestCaseId((String)("importProject:" + prjPath4TestCase));
        try {
            ImportProjectResultStatus importProjectResultStatus = Application.importProject(prjPath, updateCode);
            return importProjectResultStatus;
        }
        finally {
            CompactFormatter.setTestCaseId((String)"");
        }
    }

    /*
     * Unable to fully structure code
     */
    private static ImportProjectResultStatus importProject(String prjPath, boolean updateCode) {
        tgtConfiguration = SharedConfigurationFactory.getSharedConfigurationSingleton();
        prjProvider = tgtConfiguration.getToolchainProjectProvider();
        if (!Application.$assertionsDisabled && prjProvider == null) {
            throw new AssertionError();
        }
        project = null;
        prjProvider.disableProblemUpdates();
        try {
            block41: {
                project = Application.getToolchainProject(prjPath);
                if (project == null) {
                    Application.LOGGER.severe("Toolchain project could not be created: " + prjPath);
                    var12_5 = ImportProjectResultStatus.FAILED;
                    return var12_5;
                }
                mexPath = ImportToolchainProjectFactory.getExistingMexPathForProject((String)prjPath);
                if (mexPath == null) break block41;
                mexFile = new File(mexPath);
                if (!mexFile.exists() || !mexFile.isFile()) ** GOTO lbl76
                try {
                    var7_15 = null;
                    var8_19 = null;
                    try {
                        is = new FileInputStream(mexFile);
                        try {
                            tgtConfiguration.setLocationPath(Path.fromOSString((String)mexPath));
                            SharedConfigurationFactory.loadSharedConfigurationFromXml((ISharedConfiguration)tgtConfiguration, (InputStream)is);
                            ** GOTO lbl76
                        }
                        finally {
                            if (is != null) {
                                is.close();
                            }
                        }
                    }
                    catch (Throwable var8_20) {
                        if (var7_15 == null) {
                            var7_15 = var8_20;
                        } else if (var7_15 != var8_20) {
                            var7_15.addSuppressed(var8_20);
                        }
                        throw var7_15;
                    }
                }
                catch (IOException e) {
                    Application.LOGGER.severe(e.getMessage());
                    var12_6 = ImportProjectResultStatus.FAILED;
                    prjProvider.enableProblemUpdates();
                    return var12_6;
                }
            }
            importConfiguration = SharedConfigurationFactory.createSharedConfiguration();
            numSevereBeforeImport = Application.SEVERE_LOGS_DETECTOR.getNumSevere();
            resultStatus = ImportToolchainProjectFactory.importToolchainProject(null, (ISharedConfiguration)importConfiguration, (IToolchainProjectWithSdk)project, (boolean)KEPreferences.createEmptyCfgIfNoYaml(), (IProgressMonitor)new NullProgressMonitor(), (boolean)Application.importingAllProjects);
            if (!ImportProjectResultStatus.SUCCEED.equals((Object)resultStatus.getStatus())) {
                if (ImportProjectResultStatus.IGNORED.equals((Object)resultStatus.getStatus())) {
                    var12_7 = ImportProjectResultStatus.IGNORED;
                    return var12_7;
                }
                if (Application.importingAllProjects) {
                    Application.LOGGER.warning("Import of toolchain project failed: " + prjPath);
                } else {
                    if (numSevereBeforeImport >= Application.SEVERE_LOGS_DETECTOR.getNumSevere()) {
                        Application.LOGGER.severe("[SDK] Import of toolchain project '" + prjPath + "' failed with error: " + resultStatus.getDescription());
                        var12_8 = ImportProjectResultStatus.FAILED;
                        return var12_8;
                    }
                    var12_9 = ImportProjectResultStatus.FAILED;
                    return var12_9;
                }
            }
            try {
                if (!importConfiguration.isEmpty()) {
                    Tools.disableUnconfiguredTools((ISharedConfiguration)importConfiguration);
                }
                if (updateCode) {
                    mexPath = String.valueOf(prjPath) + File.separator + project.getProjectName() + ".mex";
                    logMsg = new StringBuilder();
                    res = ImportToolchainProjectFactory.saveMexAfterProjectImport((ISharedConfiguration)importConfiguration, (ISharedConfiguration)tgtConfiguration, (String)mexPath, null, (StringBuilder)logMsg);
                    if (logMsg.length() > 0) {
                        Application.LOGGER.info(logMsg.toString());
                    } else {
                        if (res) {
                            Application.LOGGER.info("Toolchain project successfuly imported: " + prjPath);
                        }
                        if (!Application.$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }
                } else {
                    SharedConfigurationFactory.applyNewConfig((ISharedConfiguration)importConfiguration, (ISharedConfiguration)tgtConfiguration, (ConfigChangeReason)ConfigChangeReason.LOAD_CONFIG);
                }
lbl76:
                // 5 sources

                if (tgtConfiguration.getCommonConfig().getSelectedCore() == null) {
                    Application.LOGGER.severe("[SDK] Core not detected from the toolchain project: " + prjPath);
                } else if (updateCode) {
                    UpdateCodeHandler.updateCode(tgtConfiguration, null);
                }
                sdkProject = tgtConfiguration.getToolchainProject();
                if (!Application.$assertionsDisabled && sdkProject == null) {
                    throw new AssertionError();
                }
                sdkProject.logProblemsInSdkComponentDetection();
            }
            catch (Exception e) {
                Application.LOGGER.severe(e.getMessage());
                var12_10 = ImportProjectResultStatus.FAILED;
                return var12_10;
            }
        }
        finally {
            prjProvider.enableProblemUpdates();
        }
        problems = ToolchainProjectUtils.getProblemsInSdkProject((ISharedConfiguration)tgtConfiguration, (IToolchainProjectWithSdk)project);
        ValidationEngineFactory.addAndRemoveProblems((String)"McuConfiguration", null, (Collection)problems);
        res = prjProvider.waitUntilProblemsUpdated();
        if (!Application.$assertionsDisabled && !res) {
            throw new AssertionError();
        }
        ValidationEngineFactory.getValidationService().waitJobFinished(true);
        ValidationEngineFactory.dumpProblems((Logger)Application.LOGGER, (int)2, null, (String)"[SDK]", null);
        ImportToolchainProjectFactory.PERFORMANCE_LOGGER.exiting(Application.class.getName(), "importProject");
        project.close();
        return ImportProjectResultStatus.SUCCEED;
    }

    private static @Nullable IToolchainProjectWithSdk getToolchainProject(String prjPath) {
        java.nio.file.Path path;
        if (SWToolsPlatform.isRunningInEclipseIde()) {
            IProject eclipsePrj = ConfigurationUtils.getEclipseProject((IPath)new Path(prjPath));
            if (eclipsePrj == null) {
                LOGGER.log(Level.SEVERE, "Project is not available in the current workspace: " + prjPath);
                return null;
            }
            return ToolchainProjectFactory.createToolchainProjectForImport((IProject)eclipsePrj);
        }
        try {
            path = Paths.get(prjPath, new String[0]);
        }
        catch (InvalidPathException e) {
            LOGGER.log(Level.SEVERE, "Invalid path: " + prjPath, e);
            return null;
        }
        assert (path != null);
        return ToolchainProjectFactory.createToolchainProjectForImport((java.nio.file.Path)path, (IProgressMonitor)new NullProgressMonitor());
    }

    private static boolean importAllProjects(String workspace) {
        importingAllProjects = true;
        try {
            File[] files = new File(workspace).listFiles();
            if (files != null) {
                CloningStatistics stats = new CloningStatistics();
                PdscParser parser = PdscParser.findPdsc((String)workspace);
                if (parser != null) {
                    Application.importAllCmsisProjects(workspace, parser.getExamples(), stats);
                } else {
                    File[] fileArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        if (file.isDirectory()) {
                            Application.importAllSdkProjects(workspace, file.getName(), stats);
                        }
                        ++n2;
                    }
                }
                String ignoredProjects = stats.numIgnoredProjects > 0 ? String.format(" (%s skipped)", String.valueOf(stats.numIgnoredProjects)) : "";
                String resDetail = stats.numFailures == 0 ? String.valueOf(String.valueOf(stats.numProjects)) + ignoredProjects + " projects SUCCESSFULY imported" : String.valueOf(String.valueOf(stats.numFailures)) + " of " + stats.numProjects + ignoredProjects + " projects FAILED";
                resDetail = "###> Import toolchain projects statistics: " + resDetail;
                LOGGER.info(resDetail);
                System.out.println(resDetail);
                boolean bl = stats.numFailures == 0;
                return bl;
            }
            return false;
        }
        finally {
            importingAllProjects = false;
        }
    }

    private static void importAllCmsisProjects(String workspace, List<PdscExample> examples, CloningStatistics stats) {
        for (PdscExample example : examples) {
            Application.importAllCmsisProjects(workspace, example, stats);
        }
    }

    private static void importAllCmsisProjects(String workspace, PdscExample examples, CloningStatistics stats) {
        File[] projectsPahts = (File[])examples.getProjectPaths().stream().map(e -> new File(workspace, e.toString())).toArray(File[]::new);
        Application.importAllProjects(projectsPahts, stats, UtilsFile.getRootFolder((String)examples.getCategory()));
    }

    private static void importAllSdkProjects(String workspace, String category, CloningStatistics stats) {
        Application.importAllProjects(new File(String.valueOf(workspace) + File.separator + category).listFiles(), stats, category);
    }

    protected static void importAllProjects(File @Nullable [] files, CloningStatistics stats, String category) {
        LogManager.addHandler((Handler)SEVERE_LOGS_DETECTOR);
        CompactFormatter.setExampleCategory((String)category);
        try {
            if (files != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (!(!file.isDirectory() || file.getName().endsWith("kds") || file.getName().endsWith("mcuxpresso") || file.getName().equals("startup") || file.getName().equals("linker") || file.getName().equals("config_files"))) {
                        LOGGER.info("###> Import toolchain project from: " + file.getAbsolutePath());
                        ++stats.numProjects;
                        ImportProjectResultStatus importStatus = Application.importProjectSetTestCase(UtilsText.safeString((String)file.getAbsolutePath()), true);
                        if (ImportProjectResultStatus.IGNORED.equals((Object)importStatus)) {
                            ++stats.numIgnoredProjects;
                        } else if (ImportProjectResultStatus.FAILED.equals((Object)importStatus)) {
                            ++stats.numFailures;
                        } else if (stats.numSevere < SEVERE_LOGS_DETECTOR.getNumSevere()) {
                            ++stats.numFailures;
                            stats.numSevere = SEVERE_LOGS_DETECTOR.getNumSevere();
                        }
                    }
                    ++n2;
                }
            }
        }
        finally {
            LogManager.removeHandler((Handler)SEVERE_LOGS_DETECTOR);
            CompactFormatter.setExampleCategory((String)"");
        }
    }

    public Object start(IApplicationContext context) {
        Application.start(Application.parseArgs(context));
        return mExitCode;
    }

    public static void start(List<String> arguments) {
        Iterator iterator;
        argsList = arguments;
        Application.processArgs();
        Application.setLogger();
        Application.unzipOfflineDataIfNeeded();
        CmdArguments.createCmdOptions();
        KExCmdLine cmdLine = new KExCmdLine(argsList);
        cmdLine.parseCmdLine(CmdArguments.cmdOptions);
        boolean isHeadless = cmdLine.getSections().stream().anyMatch(section -> section.getOptionValues("-HeadlessTool") != null);
        if (isHeadless) {
            MfactApiFactory.setHttpTimeouts((int)14000, (int)120000);
            System.setProperty("com.nxp.swtools.core.console", Boolean.TRUE.toString());
            System.setProperty("com.swtools.test.silentMode", Boolean.TRUE.toString());
            SWToolsPlatform.initializeAllTools();
            Application.initializeAnalytics();
        }
        if ((iterator = cmdLine.getSections().iterator()).hasNext()) {
            CmdSection curSection = (CmdSection)iterator.next();
            if (curSection.hasOption("-updateData")) {
                SWToolsPlatform.getAnalytics().logUserAction("cli", "global", "-updateData");
                MfactApiFactory.setHttpTimeouts((int)14000, (int)120000);
                CmdProgressMonitor cmdProgressMonitor = new CmdProgressMonitor();
                DataUpdater.updateAllData((IProgressMonitor)cmdProgressMonitor);
                cmdProgressMonitor.done();
            }
            if (curSection.hasOption("-version")) {
                SWToolsPlatform.getAnalytics().logUserAction("cli", "global", "-version");
                IProduct product = Platform.getProduct();
                Bundle b = product != null ? product.getDefiningBundle() : null;
                String version = b != null ? b.getVersion().toString() : "unknown";
                System.out.println(MessageFormat.format("Tool version: {0}", version));
            }
        }
        SharedConfigurationStatusSingleton.getInstance();
        if (!isHeadless) {
            Application.startRestApiServer();
            if (!cmdLine.getSections().isEmpty()) {
                cmdSection = (CmdSection)cmdLine.getSections().get(0);
                Display display = PlatformUI.createDisplay();
                assert (display != null);
                Application.registerOpenDocumentListener(display);
                try {
                    int returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new ApplicationWorkbenchAdvisor());
                    if (returnCode == 1) {
                        mExitCode = IApplication.EXIT_RESTART;
                    }
                    return;
                }
                finally {
                    display.dispose();
                }
            }
        }
        ExecutableExtensionProvider extensionProvider = new ExecutableExtensionProvider(EXTENSION_POINT_PLUGIN_ID, EXTENSION_POINT_ELEMENT, EXTENSION_POINT_CLASS_ATTRIBUTE);
        Collection extensions = extensionProvider.getExtensions();
        Application.setExitCode(Application.runCommands(cmdLine.getSections(), extensions, true));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected static Integer runCommands(List<CmdSection> sections, Collection<ICmdApplication> extensions, boolean failOnFirstError) {
        Integer exitCode = IApplication.EXIT_OK;
        for (CmdSection curSection : sections) {
            String configName;
            String outputPathOverridespath;
            Integer res;
            Application.saveArgumentsToExport(curSection);
            if (curSection.hasOption("-EmptyConfig")) {
                SharedConfigurationFactory.applyNewConfig((ISharedConfiguration)SharedConfigurationFactory.createSharedConfiguration(), (ISharedConfiguration)SWToolsPlatform.getSharedConfigurationSingleton(), (ConfigChangeReason)ConfigChangeReason.NEW_CONFIG);
            }
            if (curSection.hasOption("-BatchFile")) {
                String bulkFilePath = curSection.getOptionValue("-BatchFile");
                String bulkFileContent = UtilsFile.readFileToString((String)bulkFilePath, (Charset)StandardCharsets.UTF_8);
                if (bulkFileContent != null) {
                    CmdBulkFile bulkFile = CmdBulkFileYamlConverter.loadModelFromYaml((String)bulkFileContent);
                    if (bulkFile != null) {
                        List bulkSections = CmdBulkFileEvaluator.convertToCmdSection((CmdBulkFile)bulkFile, (String)bulkFilePath);
                        exitCode = Application.runCommands(bulkSections, extensions, failOnFirstError);
                    } else {
                        LOGGER.severe("Failed load batch action file: " + bulkFilePath);
                    }
                } else {
                    LOGGER.severe("Failed read file batch batch actions: " + bulkFilePath);
                }
            }
            if (!Application.getMcuFromCMD(curSection)) {
                Application.loadConfigFromCMD(curSection);
            }
            if (curSection.hasOption("-CreateFromProject") && (res = Application.makeConfigurationFromProject(curSection, "-CreateFromProject", prPath -> Application.importOneProject(prPath, false))) != null) {
                exitCode = res;
                if (!failOnFirstError) break;
                return exitCode;
            }
            if (curSection.hasOption("-ImportProject") && (res = Application.makeConfigurationFromProject(curSection, "-ImportProject", prPath -> prPath.endsWith("*") ? Application.importAllProjects(prPath.substring(0, prPath.length() - 1)) : Application.importOneProject(prPath, true))) != null) {
                exitCode = res;
                if (!failOnFirstError) break;
                return exitCode;
            }
            @NonNull List filePathsToImport = curSection.getOptionValues("-ImportC");
            if (filePathsToImport != null) {
                SWToolsPlatform.getAnalytics().logUserAction("cli", "global", "-ImportC");
                ImportHelper.importCFiles((List)filePathsToImport, (String)curSection.getOptionValue("-HeadlessTool"));
                Application.waitForBgJobs();
            }
            Application.setLinkProjectFromCMD(curSection, false);
            String customCopyrightpath = curSection.getOptionValue("-CustomCopyright");
            if (!customCopyrightpath.isEmpty()) {
                Application.setCustomCopyright(customCopyrightpath);
            }
            if (!(outputPathOverridespath = curSection.getOptionValue("-OutputPathOverrides")).isEmpty()) {
                Application.setOutputPathOverrides(outputPathOverridespath);
            }
            if (!(configName = curSection.getOptionValue("-ConfigName")).isEmpty()) {
                ISharedConfiguration configuration = SWToolsPlatform.getSharedConfigurationSingleton();
                configuration.setConfigurationName(configName);
            }
            for (ICmdApplication internalCmdApplication : extensions) {
                internalCmdApplication.run(curSection);
            }
            if (curSection.getOptionValues("-HeadlessTool") == null) continue;
            boolean result = Application.runCmdLineTool(curSection);
            Application.waitForBgJobs();
            if (!result) {
                exitCode = EXIT_TOOL_ERROR;
            }
            if (failOnFirstError && !result) break;
        }
        return exitCode;
    }

    private static @Nullable Integer makeConfigurationFromProject(CmdSection section, String command, Predicate<String> projectToConfigurationAction) {
        String prjPath = section.getOptionValue(command);
        if (prjPath.isEmpty()) {
            LOGGER.severe("ERROR: Path parameter is empty for " + command);
            return EXIT_MISSING_PARAM;
        }
        SWToolsPlatform.getAnalytics().logUserAction("cli", "global", command);
        String sdkPath = UtilsFile.convertToOSPathFormat((String)section.getOptionValue("-SDKpath"));
        if (!sdkPath.isEmpty()) {
            if (!new File(sdkPath).isDirectory()) {
                LOGGER.severe("ERROR: SDK path is not a directory: " + sdkPath);
                return EXIT_MISSING_PARAM;
            }
            if (!ManifestLoaderUtils.findManifestsInDir((String)sdkPath).isEmpty()) {
                KEPreferences.addSdkPath((String)sdkPath);
            }
        }
        if (projectToConfigurationAction.negate().test(prjPath)) {
            return EXIT_TOOL_ERROR;
        }
        return null;
    }

    static void showProblems(int minLevel, @Nullable Predicate<IBaseProblem> filter, @Nullable String tool) {
        ValidationEngineFactory.getValidationService().waitJobFinished(true);
        ValidationEngineFactory.dumpProblems((Logger)LOGGER, (int)minLevel, filter, null, (String)tool);
    }

    private static void startRestApiServer() {
        HttpServer httpServer = new HttpServer(SWToolsProperties.getRestApiServerPort());
        try {
            httpServer.start();
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Failed to start the HTTP server");
        }
    }

    private static void registerOpenDocumentListener(Display display) {
        if (OSDetect.isMac()) {
            display.addListener(46, event -> {
                File f = new File(event.text);
                if (f.isFile()) {
                    Application.setMexFileToOpen(f);
                }
            });
        }
    }

    private static void waitForBgJobs() {
        ISharedConfiguration sharedConfiguration = SharedConfigurationFactory.getSharedConfigurationSingleton();
        Tools.getTools().forEach(t -> {
            boolean bl = t.waitUntilUpdated(sharedConfiguration);
        });
    }

    public static void unzipOfflineDataIfNeeded() {
        ISupportedDerivativesForSwTools sd = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        File dataDir = new File(sd.getDataDir());
        String productId = KExProcessorsProvider.getProductForProcessorFilter();
        File offlineMarkFile = new File(dataDir, "." + productId + "_extracted");
        if ((UtilsFile.isDirEmpty((File)dataDir) || !offlineMarkFile.exists()) && Application.unzipDefaultData(dataDir)) {
            sd.refreshSupportedDerivatives();
            try {
                Files.createFile(offlineMarkFile.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.severe(e.getMessage());
            }
        }
    }

    private static boolean unzipDefaultData(File dataDir) {
        boolean result = false;
        String reason = "";
        String appPath = PEConfiguration.SystemDirectory;
        File zipFile = new File(appPath, "offline_data.zip");
        if (zipFile.exists()) {
            result = ZipUtils.tryExtractZip((File)zipFile, (File)dataDir, (boolean)false, e -> !"npidata.mf".equals(e.getName()));
            if (!result) {
                LOGGER.severe(() -> MessageFormat.format("Could not copy default offline data to data directory. Trying to unzip:''{0}'' to: ''{1}''. Reason: {2}", zipFile.getAbsolutePath(), dataDir.getAbsolutePath(), reason));
            }
        } else {
            LOGGER.info(() -> MessageFormat.format("Zip file with default offline data does not exist. Trying to unzip:''{0}''", zipFile.getAbsolutePath()));
        }
        return result;
    }

    public static void setExitCode(Integer exitCode) {
        if (!Objects.equals(exitCode, 0)) {
            System.setProperty("eclipse.exitdata", "");
        }
        mExitCode = exitCode;
    }

    public static void initializeAnalytics() {
        DesktopAnalytics analytics = RcpAnalyticsFactory.getAnalyticsInstance();
        String machineIdFileName = String.valueOf(System.getProperty("user.home")) + File.separator + ".nxp" + File.separator + ".machineid";
        File machineFile = new File(machineIdFileName);
        try {
            DesktopAnalyticsHelper.initializeMachineHashFromFile((DesktopAnalytics)analytics, (java.nio.file.Path)machineFile.toPath());
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        analytics.addDataprovider((IAnalyticDataProvider)new GeneralAnalytics(analytics));
        analytics.logSessionStart("", "", "");
        SWToolsPlatform.setAnalytics((IAnalytics)analytics);
        SWToolsPlatform.installHooksForAnalytics();
    }

    public static void showAnalyticsInfoDialog() {
        MessageDialogWithToggle dialog;
        Display display = Display.getDefault();
        if (Objects.nonNull(display) && KEPreferences.isAnalyticsEnabled() && KEPreferences.getShowAnalyticsInformationDialog() && !SWToolsProperties.isPropertyTrue((String)"com.swtools.test.silentMode") && (dialog = MessageDialogWithToggle.openInformation((Shell)ShellProvider.getAnyShellParent((Display)display), (String)Messages.get().ApplicationWorkbenchWindowAdvisor_AnalyticsInfoTitle, (String)String.format(Messages.get().ApplicationWorkbenchWindowAdvisor_AnalyticsInfoMessage, Messages.getEditPreferences()), (String)Messages.get().ApplicationWorkbenchWindowAdvisor_AnalyticsInfoToggle, (boolean)true, null, null)).getToggleState()) {
            KEPreferences.setShowAnalyticsInformationDialog((boolean)false);
        }
    }

    public static void uploadAnalytics() {
        if (!KEPreferences.isOffline() && KEPreferences.isAnalyticsEnabled()) {
            RcpAnalyticsFactory.uploadAnalytics();
        }
    }

    public static void stopAnalytics() {
        if (KEPreferences.isAnalyticsEnabled()) {
            RcpAnalyticsFactory.stopAnalytics();
        }
    }

    private static void setLogger() {
        if (SWToolsProperties.isVerificationOn()) {
            LogManager.setForVerification((boolean)SWToolsProperties.isDetailedVerificationOn());
        } else {
            boolean logExampleCatogory;
            java.util.logging.LogManager logMngr = java.util.logging.LogManager.getLogManager();
            String p = logMngr.getProperty("com.nxp.swtools.show_tool");
            boolean logToolId = p != null && "true".equals(p);
            p = logMngr.getProperty("com.nxp.swtools.show_test_case");
            boolean logTestCaseId = p != null && "true".equals(p);
            p = logMngr.getProperty("com.nxp.swtools.show_example_category");
            boolean bl = logExampleCatogory = p != null && "true".equals(p);
            if (logToolId || logTestCaseId || logExampleCatogory) {
                LogManager.addConsoleHandler((Level)Level.SEVERE, (boolean)logToolId, (boolean)logTestCaseId, (boolean)logExampleCatogory);
                LogManager.disableParentHandlers();
            }
        }
    }

    private static List<@NonNull String> parseArgs(IApplicationContext context) {
        Map args = context.getArguments();
        @NonNull String[] apparguments = (String[])args.get("application.args");
        if (apparguments != null) {
            return new ArrayList<String>(Arrays.asList(apparguments));
        }
        return new ArrayList<String>();
    }

    private static void processArgs() {
        boolean pwrDownModes;
        boolean detailed;
        boolean enabled = argsList.contains(VERIFICATION_FLAG);
        if (enabled) {
            argsList.remove(VERIFICATION_FLAG);
        }
        if (detailed = argsList.contains(DETAILED_VERIFICATION_FLAG)) {
            argsList.remove(DETAILED_VERIFICATION_FLAG);
            enabled = true;
        }
        if (pwrDownModes = argsList.contains(POWER_DOWN_MODES_FLAG)) {
            argsList.remove(POWER_DOWN_MODES_FLAG);
        }
        SWToolsProperties.setVerificationMode((boolean)enabled);
        SWToolsProperties.setDetailedVerificationMode((boolean)detailed);
        SWToolsProperties.enablePowerDownModes((boolean)pwrDownModes);
    }

    public void stop() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        Display display = workbench.getDisplay();
        display.syncExec(() -> {
            if (!display.isDisposed()) {
                workbench.close();
            }
        });
    }

    public static String getSelectedTool() {
        return selectedTool;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void setSelectedPerspective(@Nullable String perspective) {
        @NonNull Collection registeredProducts = SwToolsProductConfiguration.getRegisteredProducts();
        Optional<@NonNull SwToolsProduct> tool = registeredProducts.stream().filter(x -> x.getPerspectiveID().equals(perspective)).findFirst();
        if (tool.isPresent()) {
            Application.setSelectedTool(tool.get());
        } else {
            LOGGER.warning(() -> "There is no tool that has perspective called '" + perspective + "'");
        }
    }

    public static void setSelectedTool(SwToolsProduct tool) {
        String toolName = tool.getProductName();
        LOGGER.finest(() -> "Switching to the tool " + toolName);
        String toolPerspective = tool.getPerspectiveID();
        selectedTool = toolName;
        PerspectivesHelper.switchPerspective((String)toolPerspective);
        if (!SWToolsPlatform.isRunningInEclipseIde()) {
            ApplicationWorkbenchWindowAdvisor.updateAppTitleBar();
        }
    }

    public static void openAllPerspectives() {
        for (SwToolsProduct tool : SwToolsProductConfiguration.getRegisteredProductsSorted()) {
            if (UtilsText.isEmpty((String)tool.getPerspectiveID())) continue;
            try {
                PerspectivesHelper.showPerspective((String)tool.getPerspectiveID());
            }
            catch (WorkbenchException e) {
                LOGGER.log(Level.SEVERE, "open perspective " + tool.getPerspectiveID(), e);
            }
        }
    }

    public static boolean isAnyToolPerspectiveOpened() {
        return SwToolsProductConfiguration.getRegisteredProducts().stream().anyMatch(tool -> PerspectivesHelper.isPerspectiveOpened((String)tool.getPerspectiveID()));
    }

    public static boolean isAnyToolPerspectiveActive() {
        String activeId = PerspectivesHelper.getActivePerspectiveId();
        if (activeId == null) {
            return false;
        }
        return SwToolsProductConfiguration.getRegisteredProductForPerspective((String)activeId) != null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected static boolean runCmdLineTool(CmdSection section) {
        boolean toolFound = false;
        boolean result = true;
        @NonNull List requestedTools = section.getOptionValues("-HeadlessTool");
        @NonNull Collection registeredProducts = SwToolsProductConfiguration.getRegisteredProducts();
        if (requestedTools == null) {
            return result;
        }
        for (String requestedTool : requestedTools) {
            toolFound = false;
            for (SwToolsProduct product : registeredProducts) {
                String productId = product.getProductId();
                if (!productId.equalsIgnoreCase(requestedTool)) continue;
                if (section.hasOption("-Enable")) {
                    Application.enableTool(productId);
                } else {
                    Application.verifyToolEnabled(productId);
                }
                result &= Application.runHeadless(product, section);
                toolFound = true;
                Application.waitForBgJobs();
            }
            if (toolFound) continue;
            Object[] availableTools = registeredProducts.stream().map(SwToolsProduct::getProductId).toArray();
            LOGGER.warning(String.format("Requested tool '%s' does not exist. Available tools: %s", requestedTool, Arrays.toString(availableTools)));
            return false;
        }
        Set keys = section.cmdMap.keySet();
        for (String key : keys) {
            String path;
            if (!result) break;
            if (key.equals("-ShowProblems")) {
                List optionValues = section.getOptionValues("-ShowProblems");
                String tool = null;
                String argLevel = "";
                if (optionValues != null) {
                    if (optionValues.size() == 2) {
                        argLevel = (String)optionValues.get(0);
                        tool = (String)optionValues.get(1);
                    } else if (optionValues.size() == 1) {
                        argLevel = (String)optionValues.get(0);
                    }
                    if (optionValues.size() > 2) {
                        LOGGER.log(Level.WARNING, () -> MessageFormat.format("The provided number of arguments ({0}) to -ShowProblem is invalid, maximum two arguments are expected. All SEVERE problems will be logged.", String.valueOf(optionValues.size())));
                    }
                }
                int minLevel = 2;
                if (!argLevel.isEmpty()) {
                    try {
                        Level logL = Level.parse(argLevel);
                        minLevel = ErrorLevels.loggingLevelToProblemLevel((Level)logL);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
                Application.showProblems(minLevel, null, tool);
            }
            if (key.equals("-ExportMEX")) {
                SWToolsPlatform.getAnalytics().logUserAction("cli", "global", "-ExportMEX");
                path = section.getOptionValue("-ExportMEX");
                if (!UtilsText.isEmpty((String)path)) {
                    result &= Application.exportMEX(path);
                }
            }
            if (!key.equals("-ExportAll")) continue;
            SWToolsPlatform.getAnalytics().logUserAction("cli", "global", "-ExportAll");
            path = section.getOptionValue("-ExportAll");
            if (UtilsText.isEmpty((String)path)) continue;
            result &= Application.exportMEX(path);
        }
        return result;
    }

    private static void verifyToolEnabled(String productId) {
        StorageTool toolStorage = SharedConfigurationFactory.getSharedConfigurationSingleton().getTools().getTool(productId);
        if (toolStorage == null) {
            LOGGER.warning(() -> "Trying to run headless " + productId + " tool that is not present in the current configuration.");
        } else if (!toolStorage.isEnabled()) {
            LOGGER.warning(() -> "Trying to run headless " + productId + " tool that is disabled in the current configuration.");
        }
    }

    private static void enableTool(String productId) {
        StorageTool toolStorage = SharedConfigurationFactory.getSharedConfigurationSingleton().getTools().getTool(productId);
        if (toolStorage != null) {
            StorageTool.setToolEnabled((StorageTool)toolStorage, (boolean)true);
        }
    }

    private static boolean exportMEX(String path) {
        boolean result = true;
        ISharedConfiguration configuration = SWToolsPlatform.getSharedConfigurationSingleton();
        String outputFile = null;
        String configName = configuration.getCommonConfig().getName();
        if (".mex".equals(UtilsFile.getFileExtensionWithDot((String)path))) {
            outputFile = UtilsFile.convertToOSPathFormat((String)path);
        } else if (!UtilsText.isEmpty((String)configName)) {
            assert (configName != null);
            configName = UtilsFile.changeFileExtension((String)configName, (String)".mex");
            outputFile = UtilsFile.makeFullPath((String)path, (String)configName);
        } else {
            configName = UtilsFile.changeFileExtension((String)MEX_FILE_NAME, (String)".mex");
            outputFile = UtilsFile.makeFullPath((String)path, (String)configName);
        }
        File file = new File(outputFile);
        File parentFile = file.getParentFile();
        if (parentFile != null && UtilsFile.checkAndCreateFolder((File)parentFile, (Logger)LOGGER)) {
            try {
                Throwable throwable = null;
                Object var8_10 = null;
                try (FileOutputStream out = new FileOutputStream(outputFile);){
                    SharedConfigurationFactory.saveSharedConfigurationToXml((ISharedConfiguration)configuration, (OutputStream)out);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                LOGGER.warning(e.getMessage());
                result = false;
            }
        } else {
            result = false;
            LOGGER.warning("Can not create folder: " + file.getParentFile());
        }
        return result;
    }

    public static void setMexFileToOpen(@Nullable File mexFile) {
        macMexFileToOpen = mexFile;
    }

    public static boolean loadConfigFromCMD(CmdSection cmdLineArgs) {
        String config = cmdLineArgs.getOptionValue("-Load");
        if (config.isEmpty()) {
            if (macMexFileToOpen != null) {
                config = macMexFileToOpen.getAbsolutePath();
            } else {
                return false;
            }
        }
        Shell shell = null;
        if (!SWToolsProperties.isHeadlessOn()) {
            shell = ShellProvider.getAnyShellParent();
        }
        return ConfigurationUtils.openConfiguration((Shell)shell, (String)config, (ConfigurationUtils.OpenAction)ConfigurationUtils.OpenAction.OPEN_CMD);
    }

    protected static boolean runHeadless(SwToolsProduct tool, CmdSection section) {
        boolean result = true;
        ICmdApplication application = tool.getCmdApp();
        if (application != null) {
            try {
                SWToolsPlatform.getAnalytics().logUserAction("cli", tool.getProductId(), String.join((CharSequence)",", section.getCmdLine().keySet()));
                result = application.run(section);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Problem occured while running tool.", e);
            }
        } else {
            LOGGER.warning("No headless entry point for " + tool.getProductName() + " found, tool cannot run.");
            result = false;
        }
        return result;
    }

    public static boolean getMcuFromCMD(CmdSection cmdLineArgs) {
        boolean success;
        ISharedConfiguration config;
        String mcu = cmdLineArgs.getOptionValue("-MCU");
        String board = cmdLineArgs.getOptionValue("-Board");
        String kit = cmdLineArgs.getOptionValue("-Kit");
        String sdkVersion = cmdLineArgs.getOptionValue("-SDKversion");
        String partNum = cmdLineArgs.getOptionValue("-PartNum");
        String configName = cmdLineArgs.getOptionValue("-ConfigName");
        if ((UtilsText.isEmpty((String)mcu) && UtilsText.isEmpty((String)board) && UtilsText.isEmpty((String)kit)) ^ UtilsText.isEmpty((String)sdkVersion)) {
            LOGGER.severe("Both '-MCU' and '-SDKversion' are required.");
            return false;
        }
        if (UtilsText.isEmpty((String)sdkVersion)) {
            return false;
        }
        ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        ISharedConfiguration sharedConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
        boolean newConfigCreated = sharedConfig.isEmpty() || !UtilsText.isEmpty((String)kit) || !UtilsText.isEmpty((String)board);
        ISharedConfiguration iSharedConfiguration = config = newConfigCreated ? SharedConfigurationFactory.createSharedConfiguration() : sharedConfig;
        if (!KExProcessorsProvider.isOffline()) {
            IKitInfo kitInfo;
            if (UtilsText.nonEmpty((String)mcu)) {
                KExProcessorsProvider.checkOrDownloadProcessor((String)mcu, (String)sdkVersion, (boolean)true);
            } else if (!UtilsText.isEmpty((String)board)) {
                IBoardInfo boardInfo = KExProcessorsProvider.listBoard((String)board);
                if (boardInfo != null) {
                    KExProcessorsProvider.checkOrDownloadProcessor((String)boardInfo.getName(), (String)sdkVersion, (boolean)true);
                }
            } else if (!UtilsText.isEmpty((String)kit) && (kitInfo = KExProcessorsProvider.listKit((String)kit)) != null) {
                KExProcessorsProvider.checkOrDownloadProcessor((String)kitInfo.getName(), (String)sdkVersion, (boolean)true);
            }
        }
        boolean createdFromBoardOrKitTemplate = false;
        if (!UtilsText.isEmpty((String)kit)) {
            ITemplateInfo kitInfo = Application.getKitOptionallyDownload(kit, sdkVersion, derivatives);
            if (kitInfo == null) {
                return false;
            }
            mcu = kitInfo.getMasterToolName();
            ConfigurationUtils.applyMexTemplate((ISharedConfiguration)config, (ITemplateInfo)kitInfo, null, (String)configName, null, null);
            board = Objects.requireNonNull(config.getCommonConfig().getBoard());
            assert (!board.isEmpty());
            if (Application.getBoardOptionallyDownload(board, sdkVersion, derivatives) == null) {
                return false;
            }
            createdFromBoardOrKitTemplate = true;
        } else if (!UtilsText.isEmpty((String)board)) {
            ITemplateInfo boardInfo = Application.getBoardOptionallyDownload(board, sdkVersion, derivatives);
            if (boardInfo == null) {
                return false;
            }
            mcu = boardInfo.getMasterToolName();
            ConfigurationUtils.applyMexTemplate((ISharedConfiguration)config, (ITemplateInfo)boardInfo, null, (String)configName, null, null);
            createdFromBoardOrKitTemplate = true;
        }
        CheckStatus status = KExProcessorsProvider.checkOrDownloadProcessor((String)mcu, (String)sdkVersion, (boolean)true);
        switch (status.getStatus()) {
            case NO_REQUIREMENT: {
                return false;
            }
            case MISSING: {
                LOGGER.severe("Selected MCU and SDK combination does not exist in your data. MCU: " + mcu + ", SDK: " + sdkVersion);
                return false;
            }
        }
        IProcessorMasterToolInfo info = derivatives.getProcessorMasterToolInfo(mcu, sdkVersion);
        assert (info != null);
        boolean bl = success = !UtilsText.isEmpty((String)mcu) && !UtilsText.isEmpty((String)sdkVersion);
        if (success) {
            File presetMex;
            if (!KExProcessorsProvider.PROCESSOR_FILTER.test(info)) {
                LOGGER.severe("Selected MCU and SDK combination is not supported by this product. MCU: " + mcu + ", SDK: " + sdkVersion);
            }
            if (UtilsText.isEmpty((String)partNum)) {
                partNum = !UtilsText.isEmpty((String)board) || !UtilsText.isEmpty((String)kit) ? config.getCommonConfig().getPackage() : info.getDefaultPartNumber();
            }
            if (!UtilsText.isEmpty((String)configName)) {
                config.setConfigurationName(configName);
            }
            IMcuIdentification mcuIdentification = McuSelectionFactory.createMcuSelectionIdentification((String)mcu, (String)partNum, (String)sdkVersion, (String)UtilsText.safeString((String)board), (String)UtilsText.safeString((String)kit), null);
            config.setMcuIdentification(mcuIdentification);
            if (!createdFromBoardOrKitTemplate && newConfigCreated && (presetMex = ConfigurationUtils.getPresetMex((IMcuIdentification)mcuIdentification)) != null && presetMex.exists()) {
                try {
                    Throwable throwable = null;
                    Object var18_21 = null;
                    try (InputStream is = UtilsDecryption.getFileInputStream((File)presetMex);){
                        SharedConfigurationFactory.loadSharedConfigurationFromXml((ISharedConfiguration)config, (InputStream)is);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            SWToolsPlatform.applyCores((ISharedConfiguration)config, (ISupportedDerivativesForSwTools)derivatives);
            if (config.getCommonConfig().getSelectedCore() == null) {
                ProcessorCore core = (ProcessorCore)CollectionsUtils.nullableOptionalGet(config.getCommonConfig().getCores().stream().filter(c -> c.isMasterDefault()).findAny());
                config.getCommonConfig().setSelectedCore(core);
            }
            Tools.disableToolsWithUnsupportedProcessor((ISharedConfiguration)config);
            SharedConfigurationFactory.applyNewConfig((ISharedConfiguration)config, (ISharedConfiguration)sharedConfig, (ConfigChangeReason)(newConfigCreated ? ConfigChangeReason.NEW_CONFIG : ConfigChangeReason.MCU_CHANGE));
        }
        return success;
    }

    private static @Nullable ITemplateInfo getBoardOptionallyDownload(String board, String sdkVersion, ISupportedDerivativesForSwTools derivatives) {
        Optional status = KExProcessorsProvider.checkOrDownloadBoard((String)board, (String)sdkVersion, (Level)Level.SEVERE);
        if (!status.orElse(Boolean.TRUE).booleanValue()) {
            LOGGER.severe(() -> "Selected BOARD and SDK combination does not exist in your data. BOARD: " + board + ", SDK: " + sdkVersion);
            return null;
        }
        ITemplateInfo boardInfo = derivatives.getBoardById(board, sdkVersion);
        if (boardInfo == null) {
            LOGGER.severe(() -> "Internal error - did not get the board instance:" + board);
            return null;
        }
        return boardInfo;
    }

    private static @Nullable ITemplateInfo getKitOptionallyDownload(String kit, String sdkVersion, ISupportedDerivativesForSwTools derivatives) {
        Optional status = KExProcessorsProvider.checkOrDownloadKit((String)kit, (String)sdkVersion, (Level)Level.SEVERE);
        if (!status.orElse(Boolean.TRUE).booleanValue()) {
            LOGGER.severe(() -> "Selected KIT and SDK combination does not exist in your data. KIT: " + kit + ", SDK: " + sdkVersion);
            return null;
        }
        ITemplateInfo kitInfo = derivatives.getKitById(kit, sdkVersion);
        if (kitInfo == null) {
            LOGGER.severe(() -> "Internal error - did not get the kit instance:" + kit);
            return null;
        }
        return kitInfo;
    }

    public static void registerConfigurationListener() {
        ISharedConfiguration config = SharedConfigurationFactory.getSharedConfigurationSingleton();
        UndoRedoConfig.registerConfigListener((ISharedConfiguration)config);
        McuNotSelectedProblemHelper.registerMcuSelectedListener(config);
    }

    private static void setLinkProject(String projectLink, boolean applyToUI) {
        ISharedConfiguration config = SharedConfigurationFactory.getSharedConfigurationSingleton();
        String errMsg = ProjectLink.validatePath((String)projectLink, (String)config.getLocationOnDisk());
        if (errMsg != null) {
            LOGGER.severe(MessageFormat.format("Invalid path \"{0}\" not set as project link toolchain project path: {1}", projectLink, errMsg));
        } else if (config.getPreferences().setProjectLinkPath(projectLink) && applyToUI) {
            config.setDirty(DefaultConfigChangeContextHelper.preferencesChanged((ISharedConfiguration)config, (String)com.nxp.swtools.utils.Messages.get().MexPreferenceHelper_ProjectLinkGroup));
        }
    }

    protected static void setLinkProjectFromCMD(CmdSection cmdLineArgs, boolean applyToUI) {
        if (cmdLineArgs.hasOption("-ProjectLink")) {
            Application.setLinkProject(cmdLineArgs.getOptionValue("-ProjectLink"), applyToUI);
        }
    }

    private static void setCustomCopyright(String customCopyrightPath) {
        String text = UtilsFile.readFileToString((String)customCopyrightPath, null);
        if (text != null) {
            SharedConfigurationFactory.getSharedConfigurationSingleton().getPreferences().setCustomCopyright(new CustomCopyright(text, true));
        } else {
            LOGGER.warning("Unable to load and set custom copyright from " + customCopyrightPath);
        }
    }

    private static void setOutputPathOverrides(String outputPathOverridespath) {
        String yamlContent = UtilsFile.readFileToString((String)outputPathOverridespath, (Charset)StandardCharsets.UTF_8);
        if (yamlContent != null) {
            ArrayList rules = OutputPathOverridesStorageYamlConverter.loadStorageFromYaml((String)yamlContent);
            if (rules != null) {
                SharedConfigurationFactory.getSharedConfigurationSingleton().getPreferences().setOutputPathOverrides(rules.isEmpty() ? null : rules);
            } else {
                LOGGER.warning("Unable to load and set Output Path Overrides rules from " + outputPathOverridespath);
            }
        } else {
            LOGGER.warning("Unable to read content from " + outputPathOverridespath);
        }
    }

    public static void runCheckForNewVersion() {
        if (Rap.isActive() || KExProcessorsProvider.isOffline() || !NetUtils.isNetworkAvailable() || SWToolsProperties.isHeadlessOn()) {
            return;
        }
        if (!KEPreferences.isCheckForNewVersionOnStartup()) {
            return;
        }
        long lastChecked = KEPreferences.getLastCheckForNewVersionTimestamp();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(lastChecked);
        calendar.add(5, 7);
        if (calendar.compareTo(Calendar.getInstance()) <= 0) {
            JobsHelper.runjob((String)"Check for updates", () -> {
                CheckForUpdates.Update status = CheckForUpdates.checkForAppUpdates(false, true);
                if (status == CheckForUpdates.Update.UPDATE) {
                    UIJobHelper.runUIJobSystem(() -> {
                        CheckForUpdates.Update update = CheckForUpdates.checkForAppUpdates(false, true);
                    });
                }
            });
            KEPreferences.setLastCheckForNewVersionTimestamp((long)System.currentTimeMillis());
        }
    }

    private static void saveArgumentsToExport(CmdSection section) {
        List args = (List)section.cmdMap.get("-ExportArgs");
        if (args != null) {
            utils.addArgumentsToExport("-ExportArgs", args);
        }
        if ((args = (List)section.cmdMap.get("-ExportComponentIds")) != null) {
            utils.addArgumentsToExport("-ExportComponentIds", args);
        }
    }

    protected static class CloningStatistics {
        int numProjects = 0;
        int numFailures = 0;
        int numIgnoredProjects = 0;
        int numSevere = 0;

        protected CloningStatistics() {
        }
    }
}

