/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.common.uct.utils;

import com.nxp.swtools.common.uct.controller.AUctController;
import com.nxp.swtools.common.uct.controls.IChildControl;
import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.utils.UctConstants;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.utils.events.IEventListener;
import com.nxp.swtools.utils.events.ToolEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javafx.scene.Node;
import org.eclipse.swt.widgets.FileDialog;

public class UctLayoutUtils {
    private static final Map<IChildControl, IEventListener> registeredListeners = new HashMap<IChildControl, IEventListener>();

    public static void updateNodeState(Node node, ABaseUIComponentSetting setting) {
        node.setVisible(setting.isVisible());
        node.setDisable(setting.isDisabled());
    }

    public static void registerListenerForControl(AUctController controller, final IChildControl control, int eventType) {
        IEventListener settingListener = new IEventListener(){

            public void handle(ToolEvent event) {
                if (event.originator == control) {
                    control.refresh();
                }
            }
        };
        registeredListeners.put(control, settingListener);
        controller.addListener(eventType, settingListener);
    }

    public static void removeListenerForControl(AUctController controller, IChildControl control) {
        IEventListener eventListener = registeredListeners.remove(control);
        if (eventListener != null) {
            controller.removeListener(eventListener);
        }
    }

    public static String concatExtensionToFile(FileDialog fileDialogChooser, String filePath, String defaultExtension) {
        int extensionStartIndex;
        String chosenFilterExtension;
        String fileExtension;
        int filterExtensionIndex = fileDialogChooser.getFilterIndex();
        String[] filterExtensions = fileDialogChooser.getFilterExtensions();
        String chosenExtensionByUser = "";
        if (filterExtensions != null) {
            if (filterExtensionIndex == -1) {
                Optional<String> filteredExtension = Arrays.asList(filterExtensions).stream().filter(e -> defaultExtension.equals(e)).findFirst();
                if (filteredExtension.isPresent()) {
                    chosenExtensionByUser = filteredExtension.get();
                }
            } else {
                chosenExtensionByUser = filterExtensions[filterExtensionIndex];
            }
        }
        if (!(fileExtension = UtilsFile.getFileExtensionWithDot((String)filePath)).equalsIgnoreCase(chosenFilterExtension = UtilsFile.getFileExtensionWithDot((String)chosenExtensionByUser))) {
            fileExtension = "";
        }
        if (UtilsText.isEmpty((String)fileExtension) && !chosenExtensionByUser.equals(UctConstants.ALL_TYPES_EXTENSION) && (extensionStartIndex = chosenFilterExtension.lastIndexOf(".") + 1) != -1 && extensionStartIndex < chosenFilterExtension.length()) {
            chosenFilterExtension = chosenFilterExtension.substring(extensionStartIndex);
            filePath = UtilsFile.addFileExtension((String)filePath, (String)chosenFilterExtension);
        }
        return filePath;
    }
}

