/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.wizard;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.provider.configuration.sources.ISourceFileGenerationStatus;
import com.nxp.swtools.provider.configuration.sources.ISourceFileProviderWrapper;
import com.nxp.swtools.provider.configuration.sources.SourceFileProviderFactory;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.utils.scripting.ScriptResult;
import com.nxp.swtools.utils.wizards.CannotExportWizardPage;
import com.nxp.swtools.utils.wizards.exportWizard.AExportSourcesWizard;
import com.nxp.swtools.utils.wizards.exportWizard.AExportWizard;
import java.util.Collection;
import org.eclipse.jface.wizard.IWizardPage;

public class PeriphsExportSourcesWizard
extends AExportSourcesWizard {
    @Nullable
    private CannotExportWizardPage cannotExportPage;

    public PeriphsExportSourcesWizard() {
        super(UtilsText.safeString((String)Messages.get().PeriphsExportSourcesWizard_Title), "periphs_sources", "Peripherals");
        ScriptResult generatedCode = Controller.getInstance().waitAndGetGeneratedCode();
        if (generatedCode != null && generatedCode.containsAnyError()) {
            String wizardTitle = UtilsText.safeString((String)Messages.get().PeriphsExportSourcesWizard_CannotExportTitle);
            String wizardMessage = UtilsText.safeString((String)Messages.get().PeriphsExportSourcesWizard_CannotExportMessage);
            this.cannotExportPage = new CannotExportWizardPage(wizardTitle, wizardMessage);
        }
    }

    public AExportWizard.GenerationResult generateFiles() {
        return AExportWizard.GenerationResult.fail((String)"This wizard should use generateCoreFiles() method.");
    }

    protected AExportWizard.GenerationResult generateCoreFiles(@NonNull ProcessorCore coreInfo, @NonNull String destination) {
        Controller controller = Controller.getInstance();
        controller.refreshIfChangeInOtherTool();
        controller.waitUntilRegenerated();
        ISourceFileProviderWrapper wrapper = SourceFileProviderFactory.getSourceFileProvidersWrapper((String)"Peripherals");
        if (wrapper != null) {
            ISourceFileProviderWrapper.ISourceGenerateResult wrapperResult = wrapper.generate(coreInfo.getID(), true);
            if (wrapperResult.getStatus() == ISourceFileGenerationStatus.GenerationStatus.FATAL) {
                return AExportWizard.GenerationResult.fail((String)wrapperResult.getMessage());
            }
            return AExportWizard.GenerationResult.success((Collection)wrapperResult.getAllGeneratedFiles());
        }
        assert (false);
        return AExportWizard.GenerationResult.fail((String)"Internal error - no source file provider");
    }

    public void addPages() {
        ScriptResult generatedCode = Controller.getInstance().waitAndGetGeneratedCode();
        if (generatedCode != null && generatedCode.containsAnyError()) {
            this.addPage((IWizardPage)this.cannotExportPage);
        } else {
            super.addPages();
        }
    }
}

