/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view.provider;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.gui.controller.PeriphControllerWrapper;
import com.nxp.swtools.periphs.gui.view.PeripheralsView;
import com.nxp.swtools.periphs.gui.view.provider.IPeripheralsProblemResolveHandler;
import com.nxp.swtools.resourcetables.model.config.IFunctionalGroup;
import com.nxp.swtools.validation.engine.IBaseProblem;
import com.nxp.swtools.validation.engine.IValidationProblem;
import java.text.MessageFormat;

public final class PeripheralInitResolveHandler
implements IPeripheralsProblemResolveHandler {
    @NonNull
    public static final PeripheralInitResolveHandler INSTANCE = new PeripheralInitResolveHandler();
    @NonNull
    protected final IControllerWrapper controllerWrapper = PeriphControllerWrapper.getInstance();

    private PeripheralInitResolveHandler() {
    }

    @Override
    public boolean canHandle(@NonNull IBaseProblem problem) {
        IValidationProblem validationProblem;
        if (problem instanceof IValidationProblem && "Peripheral".equals((validationProblem = (IValidationProblem)problem).getDependency().getResourceType())) {
            return "initialized".equals(validationProblem.getFeature().getName());
        }
        return false;
    }

    public boolean resolveProblem(@NonNull IBaseProblem problem) {
        if (problem instanceof IValidationProblem) {
            IValidationProblem validationProblem = (IValidationProblem)problem;
            String peripheralInstance = validationProblem.getDependency().getResourceId();
            String functionalGroupName = validationProblem.getConfiguration().getConfigurationName();
            IFunctionalGroup functionalGroup = Controller.getInstance().getProfile().getFunctionalGroup(functionalGroupName);
            if (functionalGroup != null) {
                PeripheralsView.configurePeripheral(peripheralInstance, functionalGroup, this, this.controllerWrapper);
                return true;
            }
        }
        return false;
    }

    public @NonNull String getResolveProblemLabel(@NonNull IBaseProblem problem) {
        if (problem instanceof IValidationProblem) {
            IValidationProblem validationProblem = (IValidationProblem)problem;
            String peripheralInstance = validationProblem.getDependency().getResourceId();
            return MessageFormat.format(Messages.get().PeripheralInitResolveHandler_ConfigurePeripheral, peripheralInstance);
        }
        return "";
    }
}

