/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view.componentsettings.internal;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.gui.view.componentsettings.ControlOptions;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.AArrayControlTabular;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.ArrayControlItemMenuContext;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.ArrayControlItemMenuContextVertical;
import com.nxp.swtools.resourcetables.model.config.ArrayConfig;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IRoot;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import com.nxp.swtools.resourcetables.model.config.ScalarConfig;
import com.nxp.swtools.resourcetables.model.data.setting.IBaseModel;
import com.nxp.swtools.utils.tooltip.IToolTipable;
import com.nxp.swtools.utils.tooltip.ToolTipableFormatter;
import com.nxp.swtools.utils.tooltip.ToolTipableMarkdownDescriptionDecorator;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ArrayControlTabularVertical
extends AArrayControlTabular {
    private static final int OFFSET_WITHOUT_INDICES = 2;
    private static final int OFFSET_WITH_INDICES = 3;
    private List<Integer> permanentlyHiddenColumns = new ArrayList<Integer>();

    protected ArrayControlTabularVertical(@NonNull ArrayConfig arrayConfig, @NonNull ControlOptions controlOptions, @NonNull IControllerWrapper controllerWrapper) {
        super(arrayConfig, controlOptions, controllerWrapper);
    }

    @Override
    protected void tableViewerHandling(@NonNull TableViewer tableViewerLoc) {
        Table table = tableViewerLoc.getTable();
        tableViewerLoc.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selectedElement;
                ISelection selection = event.getSelection();
                if (selection instanceof StructuredSelection && (selectedElement = ((StructuredSelection)selection).getFirstElement()) instanceof IChildControl) {
                    IChildControl newSelection = (IChildControl)selectedElement;
                    ArrayControlTabularVertical.this.setSelectedChild(newSelection);
                    ArrayControlTabularVertical.this.updateButtons(ArrayControlTabularVertical.this.getControlUpdateType());
                }
            }
        });
        this.createDecoratorTableViewerColumn(tableViewerLoc);
        if (this.shouldShowIndices()) {
            this.createIndicesTableViewerColumn(tableViewerLoc);
        }
        IRoot root = this.arrayConfig.getChildContext().getRoot();
        ISettingConfig childForHeaderLabels = root.getConfigFactory().createSettingConfig("", "", this.arrayConfig.getModelData().getReferenceType(), this.arrayConfig.getChildContext(), root.getMcu());
        childForHeaderLabels.delayedInitAfterCreation();
        for (IChild childLoc : ArrayControlTabularVertical.getSettingsFlat((IChild)childForHeaderLabels)) {
            IBaseModel baseModel = childLoc.getModelData();
            if (baseModel == null) continue;
            this.createTableViewerColumnVertical(baseModel, tableViewerLoc, this.shouldShowIndices());
        }
        this.arrayConfig.remove(childForHeaderLabels);
        ArrayControlTabularVertical.setTableLayout(table, this.arrayConfig.getId(), true);
        if (SWToolsProperties.isVerificationOn() && this.arrayConfig.getModelData().getUINameExprString() != null) {
            LOGGER.log(Level.WARNING, String.format("[DATA] %1s is used as table title from %2s; table titles are only updated on component (re-)open", "label_expr", this.arrayConfig));
        }
    }

    @Override
    protected @NonNull ArrayControlItemMenuContext getMenuContext(@NonNull TableViewer tableViewerLoc) {
        return new ArrayControlItemMenuContextVertical(this, tableViewerLoc);
    }

    @Override
    public Control createLabelControl(Composite composite) {
        return null;
    }

    @Override
    protected void updateTableViewer(@NonNull TableViewer viewerLoc) {
        IChildControl childToSelect;
        viewerLoc.setInput((Object)this.children);
        if (this.contentContainer != null) {
            this.contentContainer.requestLayout();
        }
        if ((childToSelect = this.getChildToSelect()) != null) {
            viewerLoc.setSelection((ISelection)new StructuredSelection((Object)childToSelect), true);
        }
    }

    protected void createTableViewerColumnVertical(@NonNull IBaseModel baseModel, @NonNull TableViewer tableViewerLoc, boolean isIndices) {
        int rightOffset = isIndices ? 3 : 2;
        final int columnIndex = tableViewerLoc.getTable().getColumnCount() + 1 + this.permanentlyHiddenColumns.size() - rightOffset;
        if (baseModel.isOptionAvailable("UI_NOT_VISIBLE_PERMANENT", this.getChild().getExpressionContext())) {
            this.permanentlyHiddenColumns.add(columnIndex);
            return;
        }
        TableViewerColumn viewerColumn = new TableViewerColumn(this.tableViewer, 0);
        viewerColumn.getColumn().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ArrayControlTabularVertical.this.updateScrollSize();
            }
        });
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String shownText = null;
                IChild currentChild = ArrayControlTabularVertical.this.getChild(element, columnIndex);
                if (currentChild instanceof ScalarConfig) {
                    if (currentChild.isAvailable()) {
                        ScalarConfig currentSettingLoc = (ScalarConfig)currentChild;
                        shownText = AArrayControlTabular.getText(currentSettingLoc);
                    } else {
                        shownText = "N/A";
                    }
                }
                return shownText;
            }

            public Font getFont(Object element) {
                IChild currentChild = ArrayControlTabularVertical.this.getChild(element, columnIndex);
                if (currentChild != null && !currentChild.isAvailable()) {
                    return ArrayControlTabularVertical.this.italicFont;
                }
                return null;
            }

            public Image getImage(Object element) {
                IChild currentChild = ArrayControlTabularVertical.this.getChild(element, columnIndex);
                if (currentChild != null) {
                    Image image = ArrayControlTabularVertical.this.getImageOfLinkedSettingState(currentChild);
                    if (image != null) {
                        return image;
                    }
                    return AArrayControlTabular.getImage(currentChild, ArrayControlTabularVertical.this.getControlUpdateType());
                }
                return null;
            }

            public Color getForeground(Object element) {
                IChild currentChild = ArrayControlTabularVertical.this.getChild(element, columnIndex);
                if (currentChild != null) {
                    if (!currentChild.isEnabled()) {
                        return DISABLED_TEXT_COLOR;
                    }
                    if (currentChild.isOptionSet("UI_SETTING_LINK")) {
                        if (!currentChild.isOptionAvailable("UI_SETTING_LINK")) {
                            return DISABLED_TEXT_COLOR;
                        }
                        return LINK_COLOR;
                    }
                }
                return super.getForeground(element);
            }

            public Color getBackground(Object element) {
                IChild currentChild = ArrayControlTabularVertical.this.getChild(element, columnIndex);
                if (currentChild != null) {
                    return AArrayControlTabular.getBackgroundColor(currentChild);
                }
                return super.getBackground(element);
            }

            public String getToolTipText(Object element) {
                String tooltip = "";
                IChild currentChild = ArrayControlTabularVertical.this.getChild(element, columnIndex);
                if (currentChild != null) {
                    tooltip = currentChild.isAvailable() ? ArrayControlTabularVertical.getToolTip(currentChild) : "N/A";
                }
                return tooltip;
            }
        });
        this.addEditingSupport(tableViewerLoc, viewerColumn, columnIndex);
        TableColumn column = viewerColumn.getColumn();
        String title = baseModel.getUIName(this.arrayConfig.getExpressionContext());
        column.setText(title);
        column.setToolTipText(title);
        column.pack();
        this.setColumnWidth(column, columnIndex + (this.getControlOptions().isArrayIndicesHidden() ? 0 : 1));
    }

    @Override
    protected @Nullable IChildControl editingSupportGetChildControl(@NonNull Object element, int index) {
        if (element instanceof IChildControl) {
            return (IChildControl)element;
        }
        return null;
    }

    @Override
    protected void editingSupportSetValue(@NonNull TableViewer tableViewer, @NonNull Object element, int index, @Nullable Object userInputValue) {
        ScalarConfig currentSettingLoc;
        IChild currentChild = this.getChild(element, index);
        if (currentChild instanceof ScalarConfig && (currentSettingLoc = (ScalarConfig)currentChild).getType() != ScalarConfig.Type.ENUM && (currentSettingLoc.getType() == ScalarConfig.Type.INTEGER || currentSettingLoc.getType() == ScalarConfig.Type.FLOAT || currentSettingLoc.getType() == ScalarConfig.Type.STRING)) {
            this.controllerWrapper.getController().setValue(currentSettingLoc, userInputValue == null ? "" : UtilsText.safeString((String)userInputValue.toString()), (Object)tableViewer);
        }
    }

    @Override
    protected @Nullable Object editingSupportGetValue(@NonNull Object element, int index) {
        String selectedItem = "";
        IChild currentChild = this.getChild(element, index);
        if (currentChild instanceof ScalarConfig && currentChild.isAvailable()) {
            selectedItem = AArrayControlTabular.getText((ScalarConfig)currentChild);
        }
        return selectedItem;
    }

    @Override
    protected boolean editingSupportCanEdit(@NonNull Object element, int index) {
        boolean canEdit = true;
        if (element instanceof IChildControl) {
            List<@NonNull IChild> childList = ArrayControlTabularVertical.getSettingsFlat(((IChildControl)element).getChild());
            IChild currentChild = childList.get(index);
            canEdit = ArrayControlTabularVertical.isCellEnabled(currentChild);
        }
        return canEdit;
    }

    @Override
    protected IChild editingSupportSelectChild(@NonNull Object element, int index) {
        return this.getChild(element, index);
    }

    @Override
    protected void editingSupportPostAction(@NonNull TableViewer viewer, @NonNull TableViewerColumn viewerColumn) {
    }

    protected @Nullable IChild getChild(@Nullable Object element, int column) {
        if (element instanceof IChildControl) {
            List<@NonNull IChild> childList = ArrayControlTabularVertical.getSettingsFlat(((IChildControl)element).getChild());
            if (column >= 0 && column < childList.size()) {
                return childList.get(column);
            }
        }
        return null;
    }

    @Override
    public ISettingConfig getSelection() {
        TableViewer tableViewerLoc = this.tableViewer;
        if (tableViewerLoc != null) {
            ISelection selection = tableViewerLoc.getSelection();
            return super.getChildFromSelection(selection);
        }
        return null;
    }

    protected void createIndicesTableViewerColumn(@NonNull TableViewer viewer) {
        TableViewerColumn indicesViewerColumn = new TableViewerColumn(viewer, 16384, 1);
        TableColumn indicesColumn = indicesViewerColumn.getColumn();
        indicesColumn.setWidth(50);
        this.setColumnWidth(indicesColumn, 0);
        indicesColumn.setAlignment(16384);
        indicesColumn.setText("#");
        indicesViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String indices = "";
                if (element instanceof IChildControl) {
                    indices = ((IChildControl)element).getChild().getUiName();
                }
                return indices;
            }

            public Color getForeground(Object element) {
                if (element instanceof IChildControl && !((IChildControl)element).getChild().isEnabled()) {
                    return DISABLED_TEXT_COLOR;
                }
                return super.getForeground(element);
            }

            public Color getBackground(Object element) {
                if (element instanceof IChildControl) {
                    return AArrayControlTabular.getBackgroundColor(((IChildControl)element).getChild());
                }
                return super.getBackground(element);
            }

            public String getToolTipText(Object element) {
                String tooltip = "";
                if (element instanceof IChildControl) {
                    tooltip = ToolTipableFormatter.getToolTipText((IToolTipable)new ToolTipableMarkdownDescriptionDecorator((IToolTipable)((IChildControl)element).getChild()));
                }
                return tooltip;
            }
        });
    }

    @Override
    protected int computeLimitedHeightOfTable(@NonNull Table table) {
        int itemHeight = table.getItemHeight();
        int headerHeight = table.getHeaderHeight();
        int tableVisibleRows = this.getControlOptions().getTableVisibleRows() + 1;
        return tableVisibleRows * itemHeight + headerHeight;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.permanentlyHiddenColumns.clear();
    }
}

