/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view.componentsettings.internal;

import com.nxp.swtools.common.ui.utils.editors.FileSelectionCellEditor;
import com.nxp.swtools.common.ui.utils.editors.InstantSearchCellEditor;
import com.nxp.swtools.common.ui.utils.swt.FontFactory;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.os.OSDetect;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.derivative.swt.GridDataComponents;
import com.nxp.swtools.derivative.swt.GridLayoutComponents;
import com.nxp.swtools.periphs.controller.UiValueIdHolder;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.gui.view.componentsettings.ChildControlFactory;
import com.nxp.swtools.periphs.gui.view.componentsettings.ControlOptions;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.AArrayControlGroup;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.ArrayControlItemMenu;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.ArrayControlItemMenuContext;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.ArrayControlTabularHorizontal;
import com.nxp.swtools.periphs.gui.view.componentsettings.internal.IArrayControlItemMenuControl;
import com.nxp.swtools.resourcetables.model.config.ArrayConfig;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IChildProvidable;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import com.nxp.swtools.resourcetables.model.config.ScalarConfig;
import com.nxp.swtools.resourcetables.model.config.SetConfig;
import com.nxp.swtools.resourcetables.model.data.setting.DynamicEnumSetting;
import com.nxp.swtools.resourcetables.model.data.setting.SetSetting;
import com.nxp.swtools.resourcetables.model.validation.ValidationHelper;
import com.nxp.swtools.utils.preferences.KEPreferences;
import com.nxp.swtools.utils.progress.ProgressUtils;
import com.nxp.swtools.utils.resources.ToolsColors;
import com.nxp.swtools.utils.resources.ToolsImages;
import com.nxp.swtools.utils.tooltip.IToolTipable;
import com.nxp.swtools.utils.tooltip.ToolTipableFormatter;
import com.nxp.swtools.utils.tooltip.ToolTipableImplementation;
import com.nxp.swtools.utils.tooltip.ToolTipableMarkdownDescriptionDecorator;
import com.nxp.swtools.utils.view.ToolView;
import com.nxp.swtools.validation.utils.ValidationProblemsMenuHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public abstract class AArrayControlTabular
extends AArrayControlGroup {
    private static final int DECORATOR_COLUMN_WIDTH = 20;
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(AArrayControlTabular.class);
    protected static final int INDICES_COLUMN_MIN_WIDTH = 50;
    protected static final int COLUMN_MAX_WIDTH = 180;
    protected static final int ROWS_OFFSET = 1;
    @NonNull
    protected static final String NOT_APPLICABLE = "N/A";
    public static final int INDEX_FOR_RETURNING_THE_ITEMS_SETTING = -1;
    @Nullable
    static final Image ICON_ARRAY_MENU = ToolsImages.getImage((String)"icons/arrayMenu.png");
    @Nullable
    static final Color DISABLED_TEXT_COLOR = ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.disabled_FG");
    @Nullable
    static final Color DISABLED_COLOR = ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.disabled_BG");
    @Nullable
    static final Color LINK_COLOR = ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.link_FG");
    @Nullable
    static final Color ERROR_COLOR = ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.error_BG");
    @Nullable
    static final Color WARNING_COLOR = ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.warning_FG");
    @Nullable
    protected Font boldFont;
    @Nullable
    protected Font italicFont;
    @Nullable
    protected TableViewer tableViewer;
    @Nullable
    protected Composite contentContainer = null;
    @Nullable
    protected ScrolledComposite scrolledComposite;
    @Nullable
    protected Composite tableComposite;

    protected AArrayControlTabular(@NonNull ArrayConfig arrayConfig, @NonNull ControlOptions controlOptions, @NonNull IControllerWrapper controllerWrapper) {
        super(arrayConfig, controlOptions, controllerWrapper);
    }

    public static @NonNull List<@NonNull IChild> getSettingsFlat(@NonNull IChild rootChild) {
        ArrayList<@NonNull IChild> result = CollectionsUtils.emptyList();
        if (rootChild instanceof IChildProvidable) {
            IChildProvidable childProvidable = (IChildProvidable)rootChild;
            if (childProvidable instanceof ArrayConfig) {
                LOGGER.severe("[DATA] Nested arrays are not allowed for displaying array in a table.");
            } else {
                result = new ArrayList<IChild>();
                for (IChild subChild : childProvidable.getChildren()) {
                    result.addAll(AArrayControlTabular.getSettingsFlat(subChild));
                }
            }
        } else if (!(rootChild instanceof ScalarConfig) || ((ScalarConfig)rootChild).getType() != ScalarConfig.Type.VARIABLE) {
            result = CollectionsUtils.asList((Object)rootChild);
        }
        return result;
    }

    public @Nullable IChild getSettingAt(int itemNum, int idx) {
        if (itemNum >= 0 && itemNum < this.children.size()) {
            if (idx == -1) {
                return ((IChildControl)this.children.get(itemNum)).getChild();
            }
            List<@NonNull IChild> itemSettings = AArrayControlTabular.getSettingsFlatVisible(((IChildControl)this.children.get(itemNum)).getChild());
            if (idx >= 0 && idx < itemSettings.size()) {
                return itemSettings.get(idx);
            }
        }
        return null;
    }

    public static @NonNull List<@NonNull IChild> getSettingsFlatVisible(@NonNull IChild rootChild) {
        return (List)AArrayControlTabular.getSettingsFlat(rootChild).stream().filter(x -> x.isAvailable()).filter(x -> x.isEnabled()).filter(x -> !x.isOptionAvailable("UI_CONTROL_HIDDEN")).filter(x -> !x.isOptionAvailable("UI_NOT_VISIBLE_PERMANENT")).collect(CollectorsUtils.toList());
    }

    @Override
    public void setAllSettingsTo(@NonNull ArrayControlItemMenu caller, @NonNull IArrayControlItemMenuControl control) {
        IChild selectedSetting = control.getSelectedSettingHint();
        int idx = -1;
        ArrayList<@NonNull List<@NonNull IChild>> flattenedChildren = new ArrayList<List<IChild>>();
        for (IChildControl childControl : this.getChildren()) {
            List<@NonNull IChild> settingsFlat = AArrayControlTabular.getSettingsFlat(childControl.getChild());
            int idxOfSetting = settingsFlat.indexOf(selectedSetting);
            if (idxOfSetting >= 0) {
                idx = idxOfSetting;
            }
            flattenedChildren.add(settingsFlat);
        }
        if (idx >= 0) {
            ArrayList<@NonNull IChild> settings = new ArrayList<IChild>();
            for (List list : flattenedChildren) {
                IChild setting;
                if (idx >= list.size() || !(setting = (IChild)list.get(idx)).isAvailable() || !setting.isEnabled()) continue;
                settings.add(setting);
            }
            if (selectedSetting != null) {
                ProgressUtils.run(m -> this.controllerWrapper.getController().setAllSettingsTo(UtilsText.safeToString((Object)selectedSetting.getValue()), settings, this.getChild(), (Object)this));
            }
        }
    }

    protected void createDecoratorTableViewerColumn(@NonNull TableViewer viewer) {
        TableViewerColumn indicesViewerColumn = new TableViewerColumn(viewer, 16384, 0);
        TableColumn decoratorColumn = indicesViewerColumn.getColumn();
        decoratorColumn.setWidth(20);
        decoratorColumn.setAlignment(16384);
        decoratorColumn.setText("");
        indicesViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof IChildControl) {
                    return AArrayControlTabular.getImage(((IChildControl)element).getChild(), AArrayControlTabular.this.getControlUpdateType());
                }
                return super.getImage(element);
            }

            public String getToolTipText(Object element) {
                String tooltip = "";
                if (element instanceof IChildControl) {
                    tooltip = ToolTipableFormatter.getToolTipText((IToolTipable)new ToolTipableMarkdownDescriptionDecorator((IToolTipable)((IChildControl)element).getChild()));
                }
                return tooltip;
            }

            public @Nullable String getText(@NonNull Object element) {
                return null;
            }
        });
    }

    static boolean isCellEnabled(@NonNull IChild currentChild) {
        return currentChild.isAvailable() && currentChild.isEnabled();
    }

    protected static @Nullable Color getBackgroundColor(@NonNull IChild currentChild) {
        if (currentChild.getWarning() != null) {
            return WARNING_COLOR;
        }
        if (currentChild.getError() != null) {
            return ERROR_COLOR;
        }
        return null;
    }

    static void setTableLayout(@NonNull Table table, @NonNull String arrayConfigId, boolean isVerticalTable) {
        SWTFactoryProxy.INSTANCE.setTestId((Widget)table, "periphsComponentSettingsTable_" + arrayConfigId);
        table.setLayoutData((Object)new GridDataComponents(4, 4, true, true));
        if (isVerticalTable) {
            table.setHeaderVisible(true);
        }
        table.setLinesVisible(true);
    }

    static @Nullable Image getDecoratedCheckBoxIcon(@NonNull IChild currentChild, boolean isChecked, boolean isEnabled) {
        int problemLevel = -1;
        String iconName = null;
        if (isChecked) {
            iconName = isEnabled ? "icons/icons_for_table_viewers/checkbox_checked_left_transparent_pixel.png" : "icons/icons_for_table_viewers/checkbox_checked_disabled_left_transparent_pixel.png";
        } else {
            String string = iconName = isEnabled ? "icons/icons_for_table_viewers/checkbox_unchecked_left_transparent_pixel.png" : "icons/icons_for_table_viewers/checkbox_unchecked_disabled_left_transparent_pixel.png";
        }
        if (currentChild.getError() != null) {
            problemLevel = 2;
        } else if (currentChild.getWarning() != null) {
            problemLevel = 1;
        } else if (currentChild.getInfo() != null) {
            problemLevel = 0;
        }
        return ToolView.getDecoratedImage((String)iconName, (int)problemLevel);
    }

    protected @Nullable Image getImageOfLinkedSettingState(@NonNull IChild currentChild) {
        Object optionValue;
        if (currentChild.isOptionSet("UI_SETTING_LINK") && currentChild.isOptionAvailable("UI_SETTING_LINK") && (optionValue = currentChild.getOptionValue("UI_SETTING_LINK")) instanceof IChild) {
            IChild linkedChild = (IChild)optionValue;
            return AArrayControlTabular.getImage(linkedChild, this.getControlUpdateType());
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected static @Nullable Image getImage(@NonNull IChild currentChild, IChildControl.UpdateType type) {
        boolean enabled;
        @Nullable Image shownIcon = null;
        boolean bl = enabled = type != IChildControl.UpdateType.FORCE_DISABLE && currentChild.isEnabled();
        if (currentChild instanceof SetConfig.SetPresence) {
            SetConfig.SetPresence setPresence = (SetConfig.SetPresence)currentChild;
            shownIcon = AArrayControlTabular.getDecoratedCheckBoxIcon(currentChild, setPresence.getBoolValue(), enabled);
        } else if (currentChild instanceof ScalarConfig && ((ScalarConfig)currentChild).getType().equals((Object)ScalarConfig.Type.BOOL)) {
            boolean isChecked = currentChild.getValue().equals(Boolean.TRUE) ? Boolean.TRUE.booleanValue() : Boolean.FALSE.booleanValue();
            shownIcon = AArrayControlTabular.getDecoratedCheckBoxIcon(currentChild, isChecked, enabled);
        } else {
            @NonNull List errors = ValidationHelper.getSettingValidationProblems((IChild)currentChild, (int)3);
            errors.addAll(ValidationHelper.getSettingValidationProblems((IChild)currentChild, (int)2));
            @NonNull List warnings = ValidationHelper.getSettingValidationProblems((IChild)currentChild, (int)1);
            ArrayList<@NonNull E> problems = new ArrayList(errors.size() + warnings.size());
            problems.addAll(warnings);
            problems.addAll(errors);
            ArrayList<@NonNull E> mergedProblems = new ArrayList(problems.size());
            ValidationProblemsMenuHelper.mergeProblems(problems, mergedProblems);
            String baseIcon = "icons/icons_for_table_viewers/transparent_21x16.png";
            if (!mergedProblems.isEmpty()) {
                baseIcon = "icons/autoResolveProblem.png";
            }
            if (currentChild.getError() != null || !errors.isEmpty()) {
                shownIcon = ToolView.getDecoratedImage((String)baseIcon, (int)2);
            } else if (currentChild.getWarning() != null || !warnings.isEmpty()) {
                shownIcon = ToolView.getDecoratedImage((String)baseIcon, (int)1);
            } else if (currentChild.getInfo() != null) {
                shownIcon = ToolView.getDecoratedImage((String)baseIcon, (int)0);
            }
        }
        return shownIcon;
    }

    protected static String getToolTip(IChild currentChild) {
        Object optionValue;
        ToolTipableImplementation impl = new ToolTipableImplementation((IToolTipable)currentChild);
        if (currentChild.isOptionSet("UI_SETTING_LINK") && currentChild.isOptionAvailable("UI_SETTING_LINK") && (optionValue = currentChild.getOptionValue("UI_SETTING_LINK")) instanceof IChild) {
            IChild linkedChild = (IChild)optionValue;
            String[] currentStatus = new String[3];
            int currentLevel = -1;
            currentStatus[2] = currentChild.getError();
            if (currentStatus[2] != null) {
                currentLevel = 2;
            } else {
                currentStatus[1] = currentChild.getWarning();
                if (currentStatus[1] != null) {
                    currentLevel = 1;
                } else {
                    currentStatus[0] = currentChild.getInfo();
                    if (currentStatus[0] != null) {
                        currentLevel = 0;
                    }
                }
            }
            String[] linkedStatus = new String[3];
            int linkedLevel = -1;
            linkedStatus[2] = linkedChild.getError();
            if (linkedStatus[2] != null) {
                linkedLevel = 2;
            } else {
                linkedStatus[1] = linkedChild.getWarning();
                if (linkedStatus[1] != null) {
                    linkedLevel = 1;
                } else {
                    linkedStatus[0] = linkedChild.getInfo();
                    if (linkedStatus[0] != null) {
                        linkedLevel = 0;
                    }
                }
            }
            int displayedLevel = Math.max(currentLevel, linkedLevel);
            if (displayedLevel == 2) {
                impl.setError(AArrayControlTabular.combineStatus(currentStatus[2], linkedStatus[2]));
            } else if (displayedLevel == 1) {
                impl.setWarning(AArrayControlTabular.combineStatus(currentStatus[1], linkedStatus[1]));
            } else if (displayedLevel == 0) {
                impl.setInfo(AArrayControlTabular.combineStatus(currentStatus[0], linkedStatus[0]));
            }
        }
        return ToolTipableFormatter.getToolTipText((IToolTipable)new ToolTipableMarkdownDescriptionDecorator((IToolTipable)impl));
    }

    private static @Nullable String combineStatus(@Nullable String firstState, @Nullable String secondState) {
        if (firstState == null && secondState == null) {
            return null;
        }
        if (firstState == null) {
            return secondState;
        }
        if (secondState == null) {
            return firstState;
        }
        return String.valueOf(firstState) + "\n" + secondState;
    }

    protected static Font createFont(@NonNull TableViewer tableViewer, int style) {
        Table tableLoc = tableViewer.getTable();
        Font fontLoc = tableLoc.getFont();
        assert (fontLoc != null);
        Font newFont = FontFactory.changeStyle((Font)fontLoc, (int)style);
        tableLoc.addDisposeListener(d -> newFont.dispose());
        return newFont;
    }

    protected static @Nullable String getText(@NonNull ScalarConfig scalarConfig) {
        switch (scalarConfig.getType()) {
            case INTEGER: 
            case FLOAT: 
            case STRING: {
                return scalarConfig.getStringValue();
            }
            case FILE: {
                return scalarConfig.getFileStateMessage();
            }
            case INFO: {
                return scalarConfig.getValue().toString();
            }
            case ENUM: {
                return scalarConfig.getEnumItemUiName();
            }
        }
        return "";
    }

    protected void setColumnWidth(@NonNull TableColumn column, int index) {
        Table table = Objects.requireNonNull(column.getParent());
        int unitSize = this.computeColumnWidthUnitSize((Composite)table);
        List<@NonNull Double> widths = this.getControlOptions().getTableColumnWidths();
        if (widths != null) {
            double columnWidthInUnits;
            if (index >= widths.size()) {
                index = widths.size() - 1;
            }
            if ((columnWidthInUnits = widths.get(index).doubleValue()) >= 0.0) {
                column.setWidth((int)(columnWidthInUnits * (double)unitSize));
            }
        }
    }

    @Override
    public @NonNull Control createMainControl(@NonNull Composite composite) {
        Composite contentContainerLoc;
        int tableStyle;
        Composite tableCompositeLoc;
        Composite contentComposite;
        int colSpan = 1;
        ControlOptions controlOptionsLoc = this.getControlOptions();
        boolean numberOfRowsLimited = controlOptionsLoc.isTableRowsVisibleLimitSet();
        this.contentContainer = contentComposite = this.createComposite(composite, colSpan);
        this.createLabelWithControls(contentComposite);
        boolean scrolledCompositeRequired = OSDetect.isUnix();
        int scrollStyle = 2304;
        if (numberOfRowsLimited) {
            scrollStyle |= 0x200;
        }
        if (scrolledCompositeRequired) {
            ScrolledComposite scrolledCompositeLoc;
            this.scrolledComposite = scrolledCompositeLoc = new ScrolledComposite(contentComposite, scrollStyle);
            tableCompositeLoc = scrolledCompositeLoc;
            tableStyle = 65540;
        } else {
            tableStyle = 0x10004 | scrollStyle;
            tableCompositeLoc = new Composite(contentComposite, 0);
            GridLayoutComponents layout = new GridLayoutComponents(colSpan, false);
            layout.marginWidth = 0;
            tableCompositeLoc.setLayout((Layout)layout);
        }
        tableCompositeLoc.setLayoutData((Object)new GridDataComponents(4, 4, true, false));
        this.tableComposite = tableCompositeLoc;
        TableViewer tableViewerLoc = new TableViewer(tableCompositeLoc, tableStyle);
        tableViewerLoc.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.italicFont = AArrayControlTabular.createFont(tableViewerLoc, 2);
        this.boldFont = AArrayControlTabular.createFont(tableViewerLoc, 1);
        this.tableViewer = tableViewerLoc;
        SWTFactoryProxy.INSTANCE.enableHtmlTooltipFor((ColumnViewer)tableViewerLoc);
        this.tableViewerHandling(tableViewerLoc);
        this.registerControl(this.getMenuContext(tableViewerLoc));
        Table table = tableViewerLoc.getTable();
        this.addKeyboardListener(table);
        ScrolledComposite scrolledCompositeLoc = this.scrolledComposite;
        if (scrolledCompositeLoc != null) {
            scrolledCompositeLoc.setContent((Control)table);
            scrolledCompositeLoc.setExpandVertical(true);
            scrolledCompositeLoc.setExpandHorizontal(true);
            this.updateScrollSize();
            contentComposite.addListener(11, e -> this.updateScrollSize());
        }
        if ((contentContainerLoc = this.contentContainer) != null) {
            AArrayControlTabular.addScrollListener((Control)table, contentContainerLoc);
        }
        this.createInfoLabel(contentComposite, colSpan);
        this.restoreSelectionFromStorage();
        return contentComposite;
    }

    @Override
    protected void updateSelectionOfExpandGroupContent() {
        this.expandGroupContent = this.children.isEmpty() ? null : this.tableComposite;
    }

    @Override
    public void updateMainContent(@NonNull Control mainControlLoc, @NonNull IChildControl.UpdateType updateType) {
        TableViewer viewerLoc = this.tableViewer;
        if (updateType == IChildControl.UpdateType.PROBLEM_DECORATION) {
            if (viewerLoc != null) {
                Object input = viewerLoc.getInput();
                if (input instanceof List) {
                    viewerLoc.update(((List)input).toArray(), null);
                } else {
                    viewerLoc.refresh();
                }
            }
            return;
        }
        Iterator childrenIterator = this.children.iterator();
        Iterator arrayItemIterator = this.arrayConfig.getChildren().iterator();
        ISettingConfig arrayItem = arrayItemIterator.hasNext() ? (ISettingConfig)arrayItemIterator.next() : null;
        while (childrenIterator.hasNext()) {
            IChildControl childControl = (IChildControl)childrenIterator.next();
            if (!childControl.getChild().equals(arrayItem)) {
                childrenIterator.remove();
                childControl.dispose();
                continue;
            }
            ISettingConfig iSettingConfig = arrayItem = arrayItemIterator.hasNext() ? (ISettingConfig)arrayItemIterator.next() : null;
        }
        for (IChildControl childControl : this.children) {
            childControl.update(updateType);
        }
        Composite tableCompositeLoc = this.tableComposite;
        while (arrayItem != null) {
            IChildControl currentChildControl = ChildControlFactory.create((IChild)arrayItem, new ControlOptions().labelHidden(this.getControlOptions().isArrayIndicesHidden()), this.controllerWrapper);
            if (currentChildControl != null) {
                this.children.add(currentChildControl);
                currentChildControl.update(updateType);
            }
            ISettingConfig iSettingConfig = arrayItem = arrayItemIterator.hasNext() ? (ISettingConfig)arrayItemIterator.next() : null;
        }
        if (tableCompositeLoc != null) {
            boolean isChanged;
            Point size = tableCompositeLoc.getSize();
            boolean bl = isChanged = !size.equals((Object)new Point(0, 0));
            if (KEPreferences.isAnimationsEnabled() && isChanged && (updateType == IChildControl.UpdateType.NORMAL || updateType == IChildControl.UpdateType.NORMAL_CONFIGSET) && (this.children.isEmpty() || this.children.size() == 1 && !tableCompositeLoc.isVisible())) {
                this.setControlVisibleAnimation((Control)tableCompositeLoc, null, !this.children.isEmpty());
            } else {
                this.setControlVisible((Control)tableCompositeLoc, !this.children.isEmpty());
            }
        }
        if (viewerLoc != null) {
            this.updateTableViewer(viewerLoc);
            Table table = viewerLoc.getTable();
            if (this.getControlOptions().isTableRowsVisibleLimitSet() && tableCompositeLoc != null) {
                Point size = table.computeSize(-1, -1);
                Object data = tableCompositeLoc.getLayoutData();
                int wantedMaxHeight = this.computeLimitedHeightOfTable(table);
                if (data != null) {
                    GridDataComponents tableCompositeLayoutData = (GridDataComponents)data;
                    tableCompositeLayoutData.heightHint = Math.min(size.y, wantedMaxHeight);
                }
            }
        }
        IChildControl childToSelect = this.getChildToSelect();
        this.setSelectedChild(childToSelect);
    }

    protected abstract int computeLimitedHeightOfTable(@NonNull Table var1);

    protected abstract void updateTableViewer(@NonNull TableViewer var1);

    protected void updateScrollSize() {
        ScrolledComposite scrolledCompositeLoc = this.scrolledComposite;
        TableViewer tableViewerLoc = this.tableViewer;
        if (scrolledCompositeLoc != null && tableViewerLoc != null) {
            scrolledCompositeLoc.setMinSize(tableViewerLoc.getTable().computeSize(-1, -1));
        }
    }

    protected abstract @NonNull ArrayControlItemMenuContext getMenuContext(@NonNull TableViewer var1);

    protected abstract void tableViewerHandling(@NonNull TableViewer var1);

    @Override
    public void selectLastItem() {
        TableViewer tableViewerLoc = this.tableViewer;
        if (tableViewerLoc != null && !this.getChildren().isEmpty()) {
            IChildControl lastControl = this.getChildren().get(this.getChildren().size() - 1);
            tableViewerLoc.setSelection((ISelection)new StructuredSelection((Object)lastControl));
        }
    }

    public int getItemHeight() {
        if (this.tableViewer != null) {
            return this.tableViewer.getTable().getItemHeight();
        }
        return 0;
    }

    protected abstract IChild editingSupportSelectChild(@NonNull Object var1, int var2);

    protected abstract void editingSupportPostAction(@NonNull TableViewer var1, @NonNull TableViewerColumn var2);

    protected abstract @Nullable IChildControl editingSupportGetChildControl(@NonNull Object var1, int var2);

    protected abstract void editingSupportSetValue(@NonNull TableViewer var1, @NonNull Object var2, int var3, @Nullable Object var4);

    protected abstract @Nullable Object editingSupportGetValue(@NonNull Object var1, int var2);

    protected abstract boolean editingSupportCanEdit(@NonNull Object var1, int var2);

    protected void addEditingSupport(final @NonNull TableViewer viewer, final @NonNull TableViewerColumn viewerColumn, final int index) {
        EditingSupport editingSupport = new EditingSupport((ColumnViewer)viewer){

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            protected @Nullable CellEditor getCellEditor(Object element) {
                TextCellEditor editor = null;
                final IChild currentChild = AArrayControlTabular.this.editingSupportSelectChild(element, index);
                IChildControl childControl = AArrayControlTabular.this.editingSupportGetChildControl(element, index);
                if (childControl != null) {
                    AArrayControlTabular.this.setSelectedChild(childControl);
                }
                if (currentChild instanceof ScalarConfig) {
                    final ScalarConfig currentSettingLoc = (ScalarConfig)currentChild;
                    if (currentSettingLoc.getType().equals((Object)ScalarConfig.Type.BOOL)) {
                        ProgressUtils.run(m -> AArrayControlTabular.this.controllerWrapper.getController().setValue(currentSettingLoc, currentSettingLoc.getValue().equals(Boolean.FALSE) ? UtilsText.safeString((String)Boolean.TRUE.toString()) : UtilsText.safeString((String)Boolean.FALSE.toString()), (Object)viewer));
                    } else if (currentSettingLoc.getType().equals((Object)ScalarConfig.Type.ENUM)) {
                        String valueString;
                        @NonNull List enumItems = AArrayControlTabular.this.controllerWrapper.getController().getEnumItems((ISettingConfig)currentChild);
                        final InstantSearchCellEditor editorCombo = new InstantSearchCellEditor((Composite)viewer.getTable(), 0);
                        for (UiValueIdHolder enumItem : enumItems) {
                            editorCombo.add(enumItem.getUiValue());
                            editorCombo.addItemToolTip(enumItem.getUiValue(), enumItem.getDescription());
                        }
                        Object value = currentChild.getValue();
                        if (value instanceof String && (valueString = (String)value).startsWith("custom:")) {
                            editorCombo.setAllowCustomValue(true);
                        }
                        editorCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            /*
                             * Issues handling annotations - annotations may be inaccurate
                             */
                            public void widgetSelected(@NonNull SelectionEvent e) {
                                String text = editorCombo.getText();
                                @NonNull List items = (this).AArrayControlTabular.this.controllerWrapper.getController().getEnumItems((ISettingConfig)currentChild);
                                SetSetting.CustomItem customItem = currentSettingLoc.getCustomItem();
                                for (UiValueIdHolder item : items) {
                                    if (item.getId().equals("custom") && text.equals("Custom...")) {
                                        if (!editorCombo.isAllowCustomValue()) {
                                            editorCombo.setAllowCustomValue(true);
                                            DynamicEnumSetting.CustomValueSupport customValueSupport = currentSettingLoc.getCustomValueSupport();
                                            if (customValueSupport != null) {
                                                text = customValueSupport.getDefaultValue();
                                            }
                                            editorCombo.setText(text);
                                        }
                                        AArrayControlTabular.this.changeModelValue(currentSettingLoc, SetSetting.CustomItem.getStorableFormat((String)text));
                                        return;
                                    }
                                    if (!item.getUiValue().equals(text) || item.getId().equals("custom")) continue;
                                    editorCombo.setAllowCustomValue(false);
                                    if (customItem != null) {
                                        customItem.setValue(UtilsText.safeString((String)"Custom..."));
                                    }
                                    if (Objects.equals(currentSettingLoc.getValue(), item.getId())) break;
                                    AArrayControlTabular.this.changeModelValue(currentSettingLoc, item.getId());
                                    break;
                                }
                                if (editorCombo.isAllowCustomValue()) {
                                    String storableFormat = SetSetting.CustomItem.getStorableFormat((String)UtilsText.safeString((String)text));
                                    if (!currentSettingLoc.getStringValue().equals(storableFormat)) {
                                        AArrayControlTabular.this.changeModelValue(currentSettingLoc, storableFormat);
                                    }
                                }
                            }
                        });
                        editor = editorCombo;
                    } else if (currentSettingLoc.getType().equals((Object)ScalarConfig.Type.INTEGER) || currentSettingLoc.getType().equals((Object)ScalarConfig.Type.FLOAT) || currentSettingLoc.getType().equals((Object)ScalarConfig.Type.STRING)) {
                        editor = new TextCellEditor((Composite)viewer.getTable());
                    } else if (currentSettingLoc.getType() == ScalarConfig.Type.INFO && currentSettingLoc.isOptionSet("UI_SETTING_LINK")) {
                        Object linkTo = currentChild.getOptionValue("UI_SETTING_LINK");
                        if (linkTo instanceof IChild) {
                            AArrayControlTabular.this.handleLinkToSetting((IChild)linkTo, ((Object)((Object)this)).getClass());
                        }
                    } else if (currentSettingLoc.getType().equals((Object)ScalarConfig.Type.FILE)) {
                        Consumer<@Nullable String> listener = pathToFile -> {
                            String newValue = currentSettingLoc.prepareFileValue(pathToFile);
                            if (!newValue.equals(currentSettingLoc.getValue())) {
                                AArrayControlTabular.this.controllerWrapper.getController().setValue(currentSettingLoc, newValue, ArrayControlTabularHorizontal.class);
                            }
                        };
                        editor = new FileSelectionCellEditor((Composite)viewer.getTable(), Messages.get().FileControl_SelectFile, UtilsText.safeString((String)currentSettingLoc.getFilePath()), listener);
                    }
                } else if (currentChild instanceof SetConfig.SetPresence) {
                    SetConfig.SetPresence setPresence = (SetConfig.SetPresence)currentChild;
                    ProgressUtils.run(m -> AArrayControlTabular.this.controllerWrapper.getController().setSetPresence(setPresence, !setPresence.getBoolValue(), (Object)viewer));
                }
                AArrayControlTabular.this.editingSupportPostAction(viewer, viewerColumn);
                return editor;
            }

            protected boolean canEdit(Object element) {
                return AArrayControlTabular.this.editingSupportCanEdit(element, index);
            }

            protected @Nullable Object getValue(Object element) {
                return AArrayControlTabular.this.editingSupportGetValue(element, index);
            }

            protected void setValue(Object element, Object userInputValue) {
                AArrayControlTabular.this.editingSupportSetValue(viewer, element, index, userInputValue);
            }
        };
        viewerColumn.setEditingSupport(editingSupport);
    }

    protected void selectChildOfColumn(@NonNull TableViewer viewer, @NonNull TableColumn column) {
        List<TableColumn> columnsList = Arrays.asList(viewer.getTable().getColumns());
        int indexOfColumn = columnsList.indexOf(column);
        if (indexOfColumn != -1) {
            IChildControl childToSet = this.getChildren().get(indexOfColumn - 1);
            this.setSelectedChild(childToSet);
        }
    }

    @Override
    protected void setEnabledStateToMainControl(boolean enabled) {
        Control mainControlLoc = this.mainControl;
        if (mainControlLoc != null && !mainControlLoc.isDisposed()) {
            this.setControlEnabled(mainControlLoc, enabled, true);
        }
    }
}

