/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view.componentsettings;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.gui.view.componentsettings.ChildControlBase;
import com.nxp.swtools.resourcetables.model.config.ArrayConfig;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.SetConfig;
import com.nxp.swtools.utils.profiler.Profiler;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ControlOptions {
    @NonNull
    private static final Integer INTEGER_ONE = 1;
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(ControlOptions.class);
    @Nullable
    private IChild child;
    @Nullable
    private ShowContentAs showContentAs;
    @Nullable
    private PrintAs printAs;
    @Nullable
    private Boolean collapseGroup;
    @Nullable
    private Boolean expandGroupHidden;
    @Nullable
    private Boolean arrayFixed;
    @Nullable
    private Boolean arrayReorder;
    @Nullable
    private Boolean arrayIndicesHidden;
    @Nullable
    private Boolean arrayHorizontal;
    @Nullable
    private Boolean labelHidden;
    @Nullable
    private Boolean borderHidden;
    @Nullable
    private Boolean infoCopyButton;
    @Nullable
    private Boolean componentModeHidden;
    @Nullable
    private List<@NonNull Double> tableColumnWidths;
    @Nullable
    private Boolean labelBold;
    @Nullable
    private Boolean lineBreak;
    @Nullable
    private Integer numOfLines;
    @Nullable
    private Integer numOfColumns;
    @Nullable
    private Boolean radioGroupValueLabelHidden;
    @Nullable
    private Boolean radioGroupIndicesHidden;
    @Nullable
    private Boolean radioGroupHorizontal;
    @Nullable
    private Boolean persistOnSelection;
    @Nullable
    private Boolean controlHidden;
    @Nullable
    private String openDocumentationPage;
    private List<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ArrayConfig.Representation> availableRepresentations;
    @Nullable
    private Integer tableVisibleRows = null;

    public ControlOptions() {
    }

    public ControlOptions(@NonNull IChild child) {
        this.child = child;
        this.refresh();
    }

    public void refresh() {
        IChild childLoc = this.child;
        if (childLoc != null) {
            Profiler profiler;
            BigInteger index = profiler.start(ControlOptions.class, (Object)(!(profiler = Profiler.getInstance((Object)"Peripherals")).isEnabled() ? "" : MessageFormat.format("Control options refresh of child with id \"{0}\"", childLoc.getId())));
            Object optionValue = childLoc.getOptionValue("UI_SHOW_CONTENT_AS");
            this.showContentAs = optionValue != null && optionValue instanceof String ? ShowContentAs.parse((String)optionValue) : ShowContentAs.FORM;
            optionValue = childLoc.getOptionValue("UI_SHOW_AS");
            this.printAs = optionValue != null && optionValue instanceof String ? PrintAs.parse((String)optionValue) : PrintAs.PLAIN;
            optionValue = childLoc.getOptionValue("UI_MULTI_LINE");
            if (optionValue instanceof String) {
                try {
                    this.numOfLines = Integer.valueOf(UtilsText.safeToString((Object)optionValue));
                }
                catch (NumberFormatException numberFormatException) {
                    this.numOfLines = INTEGER_ONE;
                    LOGGER.log(Level.SEVERE, "[DATA] Value \"{0}\" cannot be converted to number", optionValue);
                }
            }
            optionValue = childLoc.getOptionValue("UI_MULTI_COLUMN");
            Integer defaultValue = INTEGER_ONE;
            if (childLoc instanceof SetConfig) {
                defaultValue = 2;
            }
            if (optionValue instanceof String) {
                try {
                    Integer numOfColumnsLoc = Integer.valueOf(UtilsText.safeToString((Object)optionValue));
                    if (numOfColumnsLoc.compareTo(INTEGER_ONE) < 0) {
                        numOfColumnsLoc = defaultValue;
                    }
                    this.numOfColumns = numOfColumnsLoc;
                }
                catch (NumberFormatException numberFormatException) {
                    this.numOfColumns = defaultValue;
                    LOGGER.log(Level.SEVERE, "[DATA] Value \"{0}\" cannot be converted to number", optionValue);
                }
            } else {
                this.numOfColumns = defaultValue;
            }
            this.arrayFixed = childLoc.isOptionSet("UI_ARRAY_FIXED") || childLoc instanceof ArrayConfig && ((ArrayConfig)childLoc).getModelData().getSizeExpr() != null;
            this.arrayReorder = childLoc.isOptionSet("UI_ARRAY_REORDER");
            this.arrayIndicesHidden = childLoc.isOptionSet("UI_ARRAY_INDICES_HIDDEN");
            this.arrayHorizontal = childLoc.isOptionSet("UI_ARRAY_LAYOUT_HORIZONTAL");
            this.labelHidden = childLoc.isOptionSet("UI_LABEL_HIDDEN");
            this.borderHidden = childLoc.isOptionSet("UI_BORDER_HIDDEN");
            this.infoCopyButton = childLoc.isOptionSet("UI_INFO_COPY_BUTTON");
            this.componentModeHidden = childLoc.isOptionSet("UI_COMPONENT_MODE_HIDDEN");
            this.labelBold = childLoc.isOptionSet("UI_LABEL_BOLD");
            this.lineBreak = childLoc.isOptionSet("UI_LINE_BREAK");
            this.radioGroupValueLabelHidden = Boolean.FALSE;
            this.radioGroupIndicesHidden = Boolean.TRUE;
            this.radioGroupHorizontal = childLoc.isOptionSet("UI_RADIO_GROUP_HORIZONTAL");
            this.persistOnSelection = childLoc.isOptionSet("PERSIST_ON_SELECTION");
            optionValue = childLoc.getOptionValue("UI_TABLE_COLUMN_WIDTHS");
            if (optionValue instanceof String) {
                this.tableColumnWidths = ControlOptions.parseDoubleArray((String)optionValue);
            }
            this.openDocumentationPage = (optionValue = childLoc.getOptionValue("UI_OPEN_DOCUMENTATION")) instanceof String ? (String)optionValue : null;
            Object arrayTableRowsLimit = childLoc.getOptionValue("UI_ARRAY_TABLE_ROWS_VISIBLE");
            if (arrayTableRowsLimit instanceof String) {
                try {
                    this.tableVisibleRows = Integer.valueOf((String)arrayTableRowsLimit);
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.log(Level.SEVERE, () -> MessageFormat.format("TOOL] Value {0} given for option {1} is not integer in setting {2}", arrayTableRowsLimit, "UI_ARRAY_TABLE_ROWS_VISIBLE", childLoc.getId()));
                }
            }
            if ((optionValue = childLoc.getOptionValue("UI_ARRAY_REPRESENTATIONS")) instanceof String) {
                String[] array = ((String)optionValue).split(",");
                ArrayList<// Could not load outer class - annotation placement on inner may be incorrect
                @NonNull ArrayConfig.Representation> list = new ArrayList<ArrayConfig.Representation>(array.length);
                String[] stringArray = array;
                int n = array.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    ArrayConfig.Representation representation = ArrayConfig.Representation.getById((String)id);
                    if (representation != null) {
                        list.add(representation);
                    }
                    ++n2;
                }
                this.availableRepresentations = list;
            } else if (optionValue instanceof List) {
                List list = (List)optionValue;
                ArrayList<// Could not load outer class - annotation placement on inner may be incorrect
                @NonNull ArrayConfig.Representation> representations = new ArrayList<ArrayConfig.Representation>(list.size());
                for (Object obj : list) {
                    ArrayConfig.Representation representation;
                    if (!(obj instanceof String) || (representation = ArrayConfig.Representation.getById((String)((String)obj))) == null) continue;
                    representations.add(representation);
                }
                this.availableRepresentations = representations;
            }
            this.expandGroupHidden = childLoc.isOptionSet("UI_EXPAND_GROUP_HIDDEN");
            this.collapseGroup = childLoc.isOptionSet("UI_COLLAPSE_GROUP");
            profiler.stop(index, ChildControlBase.class, null);
            this.controlHidden = childLoc.isOptionSet("UI_CONTROL_HIDDEN");
        }
    }

    public boolean isArrayFixed() {
        return Boolean.TRUE.equals(this.arrayFixed);
    }

    public boolean isArrayReorder() {
        return Boolean.TRUE.equals(this.arrayReorder);
    }

    public boolean isArrayIndicesHidden() {
        return Boolean.TRUE.equals(this.arrayIndicesHidden);
    }

    public boolean isArrayHorizontal() {
        return Boolean.TRUE.equals(this.arrayHorizontal);
    }

    public boolean isTableRowsVisibleLimitSet() {
        return this.tableVisibleRows != null;
    }

    public boolean isLabelHidden() {
        return Boolean.TRUE.equals(this.labelHidden);
    }

    public boolean isLabelBold() {
        return Boolean.TRUE.equals(this.labelBold);
    }

    public boolean isLineBreak() {
        return Boolean.TRUE.equals(this.lineBreak);
    }

    public boolean isMultiColumn() {
        Integer numOfColumnsLoc = this.numOfColumns;
        if (numOfColumnsLoc != null) {
            return INTEGER_ONE.compareTo(numOfColumnsLoc) < 0;
        }
        return false;
    }

    public boolean isBorderHidden() {
        return Boolean.TRUE.equals(this.borderHidden);
    }

    public boolean isInfoCopyButtonRequested() {
        return Boolean.TRUE.equals(this.infoCopyButton);
    }

    public boolean isComponentModeHidden() {
        return Boolean.TRUE.equals(this.componentModeHidden);
    }

    public boolean isRadioGroupValueLabelHidden() {
        return Boolean.TRUE.equals(this.radioGroupValueLabelHidden);
    }

    public boolean isRadioGroupIndicesHidden() {
        return Boolean.TRUE.equals(this.radioGroupIndicesHidden);
    }

    public boolean isRadioGroupHorizontal() {
        return Boolean.TRUE.equals(this.radioGroupHorizontal);
    }

    public boolean isSelectionPersistent() {
        return Boolean.TRUE.equals(this.persistOnSelection);
    }

    public boolean shouldLayoutAsForm() {
        return ShowContentAs.FORM.equals((Object)this.showContentAs);
    }

    public boolean shouldLayoutAsTable() {
        return ShowContentAs.TABLE.equals((Object)this.showContentAs);
    }

    public boolean shouldLayoutAsTabs() {
        return ShowContentAs.TABS.equals((Object)this.showContentAs);
    }

    public boolean shouldLayoutAsMasterDetail() {
        return ShowContentAs.MASTER_DETAIL.equals((Object)this.showContentAs);
    }

    public boolean shouldLayoutAsRadioGroup() {
        return ShowContentAs.RADIO_GROUP.equals((Object)this.showContentAs);
    }

    public boolean isExpandGroupHidden() {
        return Boolean.TRUE.equals(this.expandGroupHidden);
    }

    public boolean isGroupCollapsed() {
        return Boolean.TRUE.equals(this.collapseGroup);
    }

    public boolean isControlHidden() {
        return Boolean.TRUE.equals(this.controlHidden);
    }

    public void controlHidden(boolean value) {
        this.controlHidden = value;
    }

    public boolean isDocumentationPageToOpenSpecified() {
        return this.openDocumentationPage != null;
    }

    public @Nullable Boolean getArrayFixed() {
        return this.arrayFixed;
    }

    public @Nullable Boolean getArrayReorder() {
        return this.arrayReorder;
    }

    public @Nullable Boolean getArrayIndicesHidden() {
        return this.arrayIndicesHidden;
    }

    public @Nullable Boolean getArrayHorizontal() {
        return this.arrayHorizontal;
    }

    public @Nullable Boolean getLabelHidden() {
        return this.labelHidden;
    }

    public @Nullable Boolean getBorderHidden() {
        return this.borderHidden;
    }

    public @Nullable Boolean getComponentModeHidden() {
        return this.componentModeHidden;
    }

    public @Nullable ShowContentAs getShowContentAs() {
        return this.showContentAs;
    }

    public @Nullable PrintAs getPrintAs() {
        return this.printAs;
    }

    public @Nullable Boolean getInfoCopyButton() {
        return this.infoCopyButton;
    }

    public @Nullable List<@NonNull Double> getTableColumnWidths() {
        return this.tableColumnWidths;
    }

    public @Nullable Boolean getLabelBold() {
        return this.labelBold;
    }

    public @Nullable Boolean getLineBreak() {
        return this.lineBreak;
    }

    public @Nullable Integer getNumOfLines() {
        return this.numOfLines;
    }

    public @Nullable Integer getNumOfColumns() {
        return this.numOfColumns;
    }

    public @Nullable String getDocumentationPageToOpen() {
        return this.openDocumentationPage;
    }

    public @Nullable List<// Could not load outer class - annotation placement on inner may be incorrect
    ArrayConfig.Representation> getAvailableRepresentations() {
        return this.availableRepresentations;
    }

    public int getTableVisibleRows() {
        return this.tableVisibleRows != null ? this.tableVisibleRows : 0;
    }

    public @NonNull ControlOptions showContentAs(@NonNull ShowContentAs setShowContentAs) {
        this.showContentAs = setShowContentAs;
        return this;
    }

    public @NonNull ControlOptions labelBold(boolean bold) {
        this.labelBold = bold;
        return this;
    }

    public @NonNull ControlOptions lineBreak(boolean breakLine) {
        this.lineBreak = breakLine;
        return this;
    }

    public @NonNull ControlOptions numOfLines(int multi) {
        this.numOfLines = multi;
        return this;
    }

    public @NonNull ControlOptions numOfColumns(int multi) {
        this.numOfColumns = multi;
        return this;
    }

    public @NonNull ControlOptions printAs(@NonNull PrintAs setPrintAs) {
        this.printAs = setPrintAs;
        return this;
    }

    public @NonNull ControlOptions arrayFixed(boolean isArrayFixed) {
        this.arrayFixed = isArrayFixed;
        return this;
    }

    public @NonNull ControlOptions arrayReorder(boolean isArrayReorder) {
        this.arrayReorder = isArrayReorder;
        return this;
    }

    public @NonNull ControlOptions arrayIndicesHidden(boolean isArrayIndicesHidden) {
        this.arrayIndicesHidden = isArrayIndicesHidden;
        return this;
    }

    public @NonNull ControlOptions arrayHorizontal(boolean isArrayHorizontal) {
        this.arrayHorizontal = isArrayHorizontal;
        return this;
    }

    public @NonNull ControlOptions labelHidden(boolean isLabelHidden) {
        this.labelHidden = isLabelHidden;
        return this;
    }

    public @NonNull ControlOptions radioGroupIndicesHidden(boolean isRadioGroupIndicesHidden) {
        this.radioGroupIndicesHidden = isRadioGroupIndicesHidden;
        return this;
    }

    public @NonNull ControlOptions radioGroupValueLabelHidden(boolean isRadioGroupValueLabelHidden) {
        this.radioGroupValueLabelHidden = isRadioGroupValueLabelHidden;
        return this;
    }

    public @NonNull ControlOptions radioGroupHorizontal(boolean isRadioGroupHorizontal) {
        this.radioGroupHorizontal = isRadioGroupHorizontal;
        return this;
    }

    public @NonNull ControlOptions persistOnSelection(boolean selection) {
        this.persistOnSelection = selection;
        return this;
    }

    public @NonNull ControlOptions borderHidden(boolean isBorderHidden) {
        this.borderHidden = isBorderHidden;
        return this;
    }

    public @NonNull ControlOptions tableColumnWidths(@Nullable List<@NonNull Double> setTableColumnWidths) {
        this.tableColumnWidths = setTableColumnWidths;
        return this;
    }

    public @NonNull ControlOptions openDocumentationPage(@Nullable String page) {
        this.openDocumentationPage = page;
        return this;
    }

    public @NonNull ControlOptions availableRepresentations(@Nullable List<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ArrayConfig.Representation> list) {
        this.availableRepresentations = list;
        return this;
    }

    public @NonNull ControlOptions tableVisibleRows(int rows) {
        this.tableVisibleRows = rows;
        return this;
    }

    public @NonNull ControlOptions merge(@NonNull ControlOptions overrideOptions) {
        Field[] fields;
        Field[] fieldArray = fields = this.getClass().getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if ((field.getModifiers() & 0x18) == 0) {
                try {
                    Object value = field.get(overrideOptions);
                    if (value != null) {
                        field.set(this, value);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    LOGGER.warning(MessageFormat.format("[TOOL] Error in merging control options: {0}", e.getMessage()));
                }
            }
            ++n2;
        }
        return this;
    }

    private static @NonNull List<@NonNull Double> parseDoubleArray(@NonNull String values) {
        String[] doubles;
        ArrayList<@NonNull Double> result = new ArrayList<Double>();
        String[] stringArray = doubles = values.split(",");
        int n = doubles.length;
        int n2 = 0;
        while (n2 < n) {
            String doubleNumberString = stringArray[n2];
            try {
                result.add(Double.valueOf(doubleNumberString.trim()));
            }
            catch (NumberFormatException e) {
                result.add(-1.0);
                LOGGER.log(Level.SEVERE, String.format("[DATA] Invalid array of doubles '%1s': %2s. Using value -1 instead", values, e.getMessage()));
                break;
            }
            ++n2;
        }
        return result;
    }

    public static enum PrintAs {
        PLAIN("PLAIN"),
        LINK("LINK");

        @NonNull
        String xmlName;

        private PrintAs(String xmlName) {
            this.xmlName = xmlName;
        }

        public String toString() {
            return this.xmlName;
        }

        public static @Nullable PrintAs parse(@Nullable String settingOption) {
            if (settingOption != null) {
                PrintAs[] printAsArray = PrintAs.values();
                int n = printAsArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PrintAs printAs = printAsArray[n2];
                    if (printAs.toString().equals(settingOption)) {
                        return printAs;
                    }
                    ++n2;
                }
            }
            return null;
        }
    }

    public static enum ShowContentAs {
        FORM("FORM"),
        TABLE("TABLE"),
        TABS("TABS"),
        RADIO_GROUP("RADIO_GROUP"),
        MASTER_DETAIL("MASTER_DETAIL");

        @NonNull
        private String xmlName;

        private ShowContentAs(String xmlName) {
            this.xmlName = xmlName;
        }

        public String toString() {
            return this.xmlName;
        }

        public static @Nullable ShowContentAs parse(@Nullable String settingOption) {
            if (settingOption != null) {
                ShowContentAs[] showContentAsArray = ShowContentAs.values();
                int n = showContentAsArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ShowContentAs showContentAs = showContentAsArray[n2];
                    if (showContentAs.toString().equals(settingOption)) {
                        return showContentAs;
                    }
                    ++n2;
                }
            }
            return null;
        }
    }
}

