/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view.componentsettings;

import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.derivative.swt.GridDataComponents;
import com.nxp.swtools.derivative.swt.GridLayoutComponents;
import com.nxp.swtools.periphs.gui.controller.IControllerWrapper;
import com.nxp.swtools.periphs.gui.view.componentsettings.ChildProvidableControlBase;
import com.nxp.swtools.periphs.gui.view.componentsettings.ControlOptions;
import com.nxp.swtools.periphs.gui.view.componentsettings.QuickSelectionControl;
import com.nxp.swtools.periphs.model.config.ConfigSetConfig;
import com.nxp.swtools.resourcetables.model.config.IChildProvidable;
import com.nxp.swtools.resourcetables.model.config.IPresettable;
import com.nxp.swtools.utils.tooltip.IToolTipable;
import com.nxp.swtools.utils.tooltip.ToolTipableFormatter;
import com.nxp.swtools.utils.tooltip.ToolTipableMarkdownDescriptionDecorator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ConfigSetControl
extends ChildProvidableControlBase {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(ConfigSetControl.class);
    private Composite contentComposite;
    @NonNull
    private QuickSelectionControl quickSelection;
    @Nullable
    private Control label;

    public ConfigSetControl(@NonNull ConfigSetConfig configSetConfig, @NonNull ControlOptions controlOptions, @NonNull IControllerWrapper controllerWrapper) {
        super((IChildProvidable)configSetConfig, controlOptions, controllerWrapper);
        assert (this.getChild().getModelData().hasQuickSelections());
        this.quickSelection = new QuickSelectionControl((IPresettable)configSetConfig, controllerWrapper);
    }

    @Override
    public void create(@NonNull Composite composite, int colSpan) {
        Control mainControlLoc;
        Composite contentCompositeLoc;
        if (SWToolsProperties.isVerificationOn() && this.getChild().getModelData().getUINameExprString() != null) {
            LOGGER.log(Level.WARNING, String.format("[DATA] %1s is used as section title from %2s; section titles are only updated on component (re-)open", "label_expr", this.getChild()));
        }
        if (((ConfigSetConfig)this.child).getAllVisibleSettings().isEmpty()) {
            return;
        }
        this.contentComposite = contentCompositeLoc = new Composite(composite, 0);
        GridLayoutComponents gridLayout = new GridLayoutComponents(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        contentCompositeLoc.setLayout((Layout)gridLayout);
        contentCompositeLoc.setLayoutData((Object)new GridDataComponents(4, 128, true, false, colSpan, 1));
        super.create(contentCompositeLoc, 3);
        Control labelControlLoc = this.labelControl;
        if (labelControlLoc != null) {
            labelControlLoc.setLayoutData((Object)new GridDataComponents(4, 0x1000000, true, false, 3, 1));
        }
        if ((mainControlLoc = this.mainControl) != null) {
            mainControlLoc.setLayoutData((Object)new GridDataComponents(4, 128, true, false, 3, 1));
        }
    }

    public @NonNull ConfigSetConfig getChild() {
        return (ConfigSetConfig)this.child;
    }

    @Override
    public @Nullable Control createLabelControl(@NonNull Composite composite) {
        if (!this.quickSelection.isEmpty()) {
            Composite labelComposite = new Composite(composite, 0);
            GridLayoutComponents layout = new GridLayoutComponents(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            labelComposite.setLayout((Layout)layout);
            Control labelLoc = this.createLabel(labelComposite);
            this.quickSelection.create(labelComposite, labelLoc == null ? 2 : 1);
            return labelComposite;
        }
        return this.createLabel(composite);
    }

    private Control createLabel(@NonNull Composite composite) {
        Control labelLoc = super.createLabelControl(composite);
        if (labelLoc != null) {
            this.setLabelInternalFontStyle(1);
            Label actualLabel = this.labelControlInternal;
            if (actualLabel != null) {
                this.createErrorDecoration((Control)actualLabel, 16512);
            }
            labelLoc.setLayoutData((Object)new GridDataComponents(4, 0x1000000, true, false));
            this.label = labelLoc;
        }
        return labelLoc;
    }

    @Override
    protected void updateLabelContent(@NonNull Control labelCtrl,  @NonNull IChildControl.UpdateType updateType) {
        Control labelLoc = this.label;
        if (labelLoc != null) {
            super.updateLabelContent(labelLoc, updateType);
            String toolTipText = ToolTipableFormatter.getToolTipText((IToolTipable)new ToolTipableMarkdownDescriptionDecorator((IToolTipable)this.child));
            SWTFactoryProxy.INSTANCE.setHtmlTooltip(labelLoc, toolTipText);
        }
    }

    @Override
    public void update( @NonNull IChildControl.UpdateType updateType) {
        if (this.isDisposed()) {
            return;
        }
        super.update(updateType);
        this.quickSelection.update(updateType);
    }

    @Override
    protected void fillTopOfMainControl(@NonNull Composite composite, int numColumns) {
        if (this.controlOptions.isLabelHidden() && !this.quickSelection.isEmpty()) {
            this.quickSelection.create(composite, numColumns);
        }
    }

    @Override
    public void dispose() {
        if (this.contentComposite != null && !this.contentComposite.isDisposed()) {
            this.contentComposite.dispose();
            this.contentComposite = null;
        }
        this.quickSelection.dispose();
        super.dispose();
    }
}

