/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view.componentsettings;

import com.nxp.swtools.common.ui.utils.perspectives.PerspectivesHelper;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionMap;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.gui.view.APeriphsExternalViewHandler;
import com.nxp.swtools.periphs.gui.view.componentsettings.ArrayControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.ChildProvidableControlBase;
import com.nxp.swtools.periphs.gui.view.componentsettings.ComponentSettingView;
import com.nxp.swtools.periphs.gui.view.componentsettings.ComponentSettingViewInput;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.storage.periphs.AStoragePeriphsComponent;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsComponent;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsComponentInstance;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsFuncGroup;
import com.nxp.swtools.resourcetables.model.config.IComponentConfig;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.config.IFunctionalGroup;
import com.nxp.swtools.utils.events.IEventListener;
import com.nxp.swtools.utils.events.ToolEvent;
import com.nxp.swtools.utils.storage.StorageHelper;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.w3c.dom.DOMException;

public class ComponentSettingViewHelper {
    private static final String ADDITIONAL_VIEWS_EXTENSION_ID = "com.nxp.swtools.periphs.gui.perspective.additionalViews";
    private static final String ADDITIONAL_VIEWS_EXTENSION_ATTRIBUTE_HANDLER = "view_handler";
    private static final String EXTENSION_POINT_ID_ATTRIBUTE = "id";
    private static final String SCHEMATIC_VIEW_ID = "com.nxp.swtools.plu.view.DiagramView";
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(ComponentSettingViewHelper.class);
    @NonNull
    private @NonNull CollectionMap<@NonNull String, @NonNull AStoragePeriphsComponent> editors = new CollectionMap(IdentityHashMap.class, CollectionsUtils.IdentitySet.class);
    @NonNull
    private @NonNull CollectionMap<@NonNull String, @NonNull AStoragePeriphsComponent> schematicViews = new CollectionMap(IdentityHashMap.class, CollectionsUtils.IdentitySet.class);
    @NonNull
    public static final String TYPE = "type";
    @NonNull
    public static final String UUID = "uuid";
    @NonNull
    public static final String GLOBAL = "global";
    @NonNull
    public static final String GROUP = "group";
    @NonNull
    public static final String EDITOR = "editor";
    @NonNull
    public static final String EDITORS = "editors";
    private static final String SCHEMATIC = "schematic";
    @NonNull
    public static final String EDITORS_UNDERSCORE = "editors_";
    @NonNull
    public static final String EMPTY_EDITOR_ID = "org.eclipse.ui.internal.emptyEditorTab";
    public static final boolean REMOVE_DISABLED = true;
    public static final boolean REMOVE_ENABLED = false;
    private static final int MAXIMAL_OCCURRENCES_OF_VIEW = 100;
    @NonNull
    StorageHelper storageHelper = new StorageHelper(5);
    @NonNull
    IMcuIdentification mcuIdentification = Controller.getInstance().getMcu().getMcuIdentification();
    @NonNull
    StoragePeriphsFuncGroup functionalGroupReference = Controller.getInstance().getFunctionalGroup().getStorageFuncGroup();
    int functionalGroupReferenceHash = this.functionalGroupReference.hashCode();
    boolean removeState = false;
    private Map<@NonNull String, Set<@NonNull Integer>> permittedOccurences = new HashMap<String, Set<Integer>>();
    String mexPath = null;

    public static @NonNull ComponentSettingViewHelper getInstance() {
        try {
            return (ComponentSettingViewHelper)SWTFactoryProxy.INSTANCE.getSingletonInstance(ComponentSettingViewHelper.class);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Cannot obtain instance of a component editor helper", e);
        }
    }

    public void switchRemoveState() {
        this.removeState = !this.removeState;
    }

    public void setRemoveState(boolean newRemoveState) {
        this.removeState = newRemoveState;
    }

    public ComponentSettingViewHelper() {
        this.storageHelper.saveString(EDITORS_UNDERSCORE, "");
        Controller.getInstance().addListener(1, new IEventListener(){

            public void handle(@NonNull ToolEvent event) {
                String currentPerspectiveId = PerspectivesHelper.getActivePerspectiveId();
                if (currentPerspectiveId == null) {
                    return;
                }
                if (!currentPerspectiveId.equals("com.nxp.swtools.periphs.gui.perspective")) {
                    return;
                }
                IViewPart view = ComponentSettingViewHelper.getViewPart();
                if (view == null) {
                    return;
                }
                final IViewSite viewSite = view.getViewSite();
                if (viewSite == null) {
                    return;
                }
                String mexPathNew = ComponentSettingViewHelper.getMexFilePath();
                boolean configurationSwitched = false;
                if (!Objects.equals(ComponentSettingViewHelper.this.mexPath, mexPathNew)) {
                    configurationSwitched = true;
                }
                ComponentSettingViewHelper.this.mexPath = mexPathNew;
                IMcuIdentification mcuIdentificationNew = Controller.getInstance().getMcu().getMcuIdentification();
                Display display = Display.getCurrent();
                if (!$assertionsDisabled && display == null) {
                    throw new AssertionError();
                }
                if (!ComponentSettingViewHelper.this.mcuIdentification.equals(mcuIdentificationNew)) {
                    ComponentSettingViewHelper.this.mcuIdentification = mcuIdentificationNew;
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).ComponentSettingViewHelper.this.functionalGroupReference = Controller.getInstance().getFunctionalGroup().getStorageFuncGroup();
                            (this).ComponentSettingViewHelper.this.functionalGroupReferenceHash = (this).ComponentSettingViewHelper.this.functionalGroupReference.hashCode();
                            ComponentSettingViewHelper.this.restoreConfigurationEditors(viewSite);
                        }
                    });
                } else if (configurationSwitched) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ComponentSettingViewHelper.this.restoreConfigurationEditors(viewSite);
                        }
                    });
                } else {
                    StoragePeriphsFuncGroup functionalGroupNew = Controller.getInstance().getFunctionalGroup().getStorageFuncGroup();
                    if (!ComponentSettingViewHelper.this.functionalGroupReference.getUUID().equals(functionalGroupNew.getUUID())) {
                        ComponentSettingViewHelper.this.functionalGroupReference = functionalGroupNew;
                        ComponentSettingViewHelper.this.functionalGroupReferenceHash = ComponentSettingViewHelper.this.functionalGroupReference.hashCode();
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                (this).ComponentSettingViewHelper.this.removeState = true;
                                ComponentSettingViewHelper.this.closeOpenedEditors();
                                ComponentSettingViewHelper.this.showOpenedEditors(viewSite);
                                ComponentSettingViewHelper.this.showOpenedSchematicViews(viewSite);
                                (this).ComponentSettingViewHelper.this.removeState = false;
                            }
                        });
                    } else if (ComponentSettingViewHelper.this.functionalGroupReferenceHash != ComponentSettingViewHelper.this.functionalGroupReference.hashCode()) {
                        ComponentSettingViewHelper.this.saveEditors();
                    }
                }
            }
        });
    }

    public static @Nullable IViewPart getViewPart() {
        IWorkbenchPage activePage = Objects.requireNonNull(PlatformUI.getWorkbench().getActiveWorkbenchWindow()).getActivePage();
        if (activePage != null) {
            IViewReference[] viewReferences;
            IViewReference[] iViewReferenceArray = viewReferences = activePage.getViewReferences();
            int n = viewReferences.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference reference = iViewReferenceArray[n2];
                IViewPart view = reference.getView(false);
                if (view != null) {
                    return view;
                }
                ++n2;
            }
        }
        return null;
    }

    public void clearEditors() {
        this.editors.clear();
    }

    public void clearSchematicViews() {
        this.schematicViews.clear();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void removeEditor(@NonNull ComponentSettingViewInput input, @NonNull String funcGroupUuid) {
        if (this.removeState) {
            return;
        }
        // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull CollectionsUtils.IdentitySet originalSet = (CollectionsUtils.IdentitySet)this.editors.get((Object)funcGroupUuid);
        // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull CollectionsUtils.IdentitySet funcGroupEditors = originalSet == null ? new CollectionsUtils.IdentitySet() : new CollectionsUtils.IdentitySet((Collection)originalSet);
        if (input.isGlobalConfig()) {
            for (Map.Entry entry : this.editors.flatEntrySet()) {
                AStoragePeriphsComponent component = (AStoragePeriphsComponent)entry.getValue();
                if (!(component instanceof StoragePeriphsComponent) || !component.getName().equals(input.getComponentType())) continue;
                funcGroupUuid = UtilsText.safeString((String)((String)entry.getKey()));
                funcGroupEditors.add((Object)component);
            }
        }
        if (funcGroupEditors.isEmpty()) {
            return;
        }
        @Nullable AStoragePeriphsComponent editorToBeRemoved = (AStoragePeriphsComponent)CollectionsUtils.nullableOptionalGet(funcGroupEditors.stream().filter(x -> {
            if (input.isGlobalConfig()) {
                if (x instanceof StoragePeriphsComponent) {
                    return x.getName().equals(input.getComponentType());
                }
            } else if (x instanceof StoragePeriphsComponentInstance) {
                IComponentInstanceConfig componentSetting = Controller.getInstance().getComponentInstance(input.getComponentType(), input.getComponent());
                if (componentSetting == null) {
                    componentSetting = Controller.getInstance().getComponentInstance(input.getUUID());
                }
                if (componentSetting != null) {
                    return x.getUUID().equals(componentSetting.getUUID());
                }
            }
            return false;
        }).findAny());
        if (editorToBeRemoved == null) {
            return;
        }
        if (this.editors.removeItem((Object)funcGroupUuid, (Object)editorToBeRemoved)) {
            this.saveEditors();
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void removeSchematicView(@NonNull String uuid, @NonNull String funcGroupUuid) {
        CollectionsUtils.IdentitySet funcGroupEditors;
        if (this.removeState) {
            return;
        }
        // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull CollectionsUtils.IdentitySet originalSet = (CollectionsUtils.IdentitySet)this.schematicViews.get((Object)funcGroupUuid);
        CollectionsUtils.IdentitySet identitySet = funcGroupEditors = originalSet == null ? new CollectionsUtils.IdentitySet() : new CollectionsUtils.IdentitySet((Collection)originalSet);
        if (funcGroupEditors.isEmpty()) {
            return;
        }
        @Nullable AStoragePeriphsComponent editorToBeRemoved = (AStoragePeriphsComponent)CollectionsUtils.nullableOptionalGet(funcGroupEditors.stream().filter(x -> {
            IComponentInstanceConfig componentSetting;
            if (x instanceof StoragePeriphsComponentInstance && (componentSetting = Controller.getInstance().getComponentInstance(uuid)) != null) {
                return x.getUUID().equals(componentSetting.getUUID());
            }
            return false;
        }).findAny());
        if (editorToBeRemoved == null) {
            return;
        }
        if (this.schematicViews.removeItem((Object)funcGroupUuid, (Object)editorToBeRemoved)) {
            this.saveEditors();
        }
    }

    public boolean addEditor(@NonNull StoragePeriphsFuncGroup funcGroup, @NonNull AStoragePeriphsComponent component) {
        AStoragePeriphsComponent comp;
        if (component instanceof StoragePeriphsComponent && this.editors.containsValue((Object)(comp = component))) {
            return false;
        }
        Object found = CollectionsUtils.findAny((Collection)this.editors.flatEntrySet(), entry -> funcGroup.getUUID().equals(entry.getKey()) && component.equalsUUID(entry.getValue()));
        if (found == null) {
            this.editors.add((Object)funcGroup.getUUID(), (Object)component);
        }
        return this.saveEditors();
    }

    public boolean addSchematic(@NonNull StoragePeriphsFuncGroup funcGroup, @NonNull AStoragePeriphsComponent component) {
        AStoragePeriphsComponent comp;
        if (component instanceof StoragePeriphsComponent && this.schematicViews.containsValue((Object)(comp = component))) {
            return false;
        }
        Object found = CollectionsUtils.findAny((Collection)this.schematicViews.flatEntrySet(), entry -> funcGroup.getUUID().equals(entry.getKey()) && component.equalsUUID(entry.getValue()));
        if (found == null) {
            this.schematicViews.add((Object)funcGroup.getUUID(), (Object)component);
        }
        return this.saveEditors();
    }

    private static String getMexFilePath() {
        @Nullable IPath locationPath = SharedConfigurationFactory.getSharedConfigurationSingleton().getLocationPath();
        String projectLocation = locationPath == null ? "" : locationPath.toOSString();
        return projectLocation;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void showOpenedEditors(@NonNull IViewSite viewSite) {
        Iterator<@NonNull @NonNull T> iterator = this.editors.flatEntrySet().stream().filter(e -> {
            StoragePeriphsFuncGroup storageFuncGroupLoc;
            Controller controller = Controller.getInstance();
            String fgUuid = (String)e.getKey();
            return (fgUuid.equals((storageFuncGroupLoc = controller.getFunctionalGroup().getStorageFuncGroup()).getUUID()) || e.getValue() instanceof StoragePeriphsComponent) && storageFuncGroupLoc.getInstances().contains(e.getValue());
        }).iterator();
        while (iterator.hasNext()) {
            @NonNull @NonNull Map.Entry entry = (Map.Entry)iterator.next();
            AStoragePeriphsComponent config = (AStoragePeriphsComponent)entry.getValue();
            boolean global = false;
            if (config instanceof StoragePeriphsComponentInstance) {
                String uuid = ((StoragePeriphsComponentInstance)config).getUUID();
                ComponentSettingView.open(viewSite, uuid, false);
                continue;
            }
            if (!(config instanceof StoragePeriphsComponent)) continue;
            String name = ((StoragePeriphsComponent)config).getName();
            String type = ((StoragePeriphsComponent)config).getName();
            global = true;
            ComponentSettingView.open(viewSite, type, name, global, false);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void showOpenedSchematicViews(@NonNull IViewSite viewSite) {
        @NonNull IConfigurationElement[] configurationElementsFor = Platform.getExtensionRegistry().getConfigurationElementsFor(ADDITIONAL_VIEWS_EXTENSION_ID);
        if (configurationElementsFor.length == 0) {
            return;
        }
        IConfigurationElement schematicViewHandler = null;
        int i = 0;
        while (i < configurationElementsFor.length) {
            if (configurationElementsFor[0].getAttribute(EXTENSION_POINT_ID_ATTRIBUTE).startsWith(SCHEMATIC_VIEW_ID)) {
                schematicViewHandler = configurationElementsFor[i];
            }
            ++i;
        }
        if (schematicViewHandler == null) {
            return;
        }
        Iterator<@NonNull @NonNull T> iterator = this.schematicViews.flatEntrySet().stream().filter(e -> {
            StoragePeriphsFuncGroup storageFuncGroupLoc;
            Controller controller = Controller.getInstance();
            @NonNull String fgUuid = (String)e.getKey();
            return (fgUuid.equals((storageFuncGroupLoc = controller.getFunctionalGroup().getStorageFuncGroup()).getUUID()) || e.getValue() instanceof StoragePeriphsComponent) && storageFuncGroupLoc.getInstances().contains(e.getValue());
        }).iterator();
        while (iterator.hasNext()) {
            @NonNull @NonNull Map.Entry entry = (Map.Entry)iterator.next();
            AStoragePeriphsComponent config = (AStoragePeriphsComponent)entry.getValue();
            if (!(config instanceof StoragePeriphsComponentInstance)) continue;
            String uuid = ((StoragePeriphsComponentInstance)config).getUUID();
            try {
                APeriphsExternalViewHandler handler = (APeriphsExternalViewHandler)schematicViewHandler.createExecutableExtension(ADDITIONAL_VIEWS_EXTENSION_ATTRIBUTE_HANDLER);
                handler.openViewFor(viewSite, uuid);
            }
            catch (CoreException e2) {
                LOGGER.log(Level.SEVERE, "[TOOL] Failed to create handler: {0}", e2.getLocalizedMessage());
            }
        }
    }

    public boolean restoreEditors() {
        String mementoStrContent;
        boolean result;
        block8: {
            String mexFilePath;
            block7: {
                result = false;
                mexFilePath = ComponentSettingViewHelper.getMexFilePath();
                if (!UtilsText.isEmpty((String)mexFilePath)) break block7;
                LOGGER.log(Level.FINE, "[TOOL] Empty MEX file path, not restoring editors");
                return false;
            }
            mementoStrContent = this.storageHelper.loadString(EDITORS_UNDERSCORE + mexFilePath, "");
            if (!"".equals(mementoStrContent)) break block8;
            LOGGER.log(Level.FINE, "[TOOL] No editors saved for MEX file, not restoring editors");
            return false;
        }
        try {
            XMLMemento xmlMemento = XMLMemento.createReadRoot((Reader)new StringReader(mementoStrContent));
            IMemento[] iMementoArray = xmlMemento.getChildren();
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento memento = iMementoArray[n2];
                boolean restored = this.restoreEditorsHandleComponentSettingsView(memento);
                if (!restored) {
                    restored = this.restoreEditorsHandleSchematicView(memento);
                }
                if (!restored) {
                    LOGGER.log(Level.WARNING, "[TOOL] Memento was not parsed by any handler: {0}", memento);
                }
                ++n2;
            }
            result = true;
        }
        catch (WorkbenchException e) {
            LOGGER.severe(MessageFormat.format("[TOOL] XMLMemento exception occured. Detail: {0}", e.getMessage()));
        }
        return result;
    }

    private boolean restoreEditorsHandleComponentSettingsView(IMemento memento) {
        StoragePeriphsComponent configToSave;
        if (!memento.getType().equals(EDITOR)) {
            return false;
        }
        String funcGroupUuid = UtilsText.safeString((String)memento.getString(GROUP));
        IFunctionalGroup functionalGroup = Controller.getInstance().getProfile().getFunctionalGroupWithUUID(funcGroupUuid);
        if (functionalGroup == null) {
            LOGGER.info("[TOOL] Trying to restore editors: Functional group with given ID was not found in current profile");
            return false;
        }
        String type = UtilsText.safeString((String)memento.getString(TYPE));
        String name = UtilsText.safeString((String)memento.getString(UUID));
        Boolean globalBoolean = memento.getBoolean(GLOBAL);
        if (globalBoolean == null) {
            LOGGER.warning("[TOOL] Global is not set in XML memento");
            return false;
        }
        boolean global = globalBoolean;
        if (global) {
            IComponentConfig configuredComponent = Controller.getInstance().getConfiguredComponent(type);
            if (configuredComponent == null) {
                LOGGER.info("[TOOL] Trying to restore component setting view of component config that is not present in current functional group");
                return false;
            }
            configToSave = configuredComponent.getStorageComponent();
        } else {
            IComponentInstanceConfig instance = functionalGroup.getInstanceByUUID(name);
            if (instance == null) {
                LOGGER.info("[TOOL] Trying to restore component setting view of component instance config that is not present in current functional group");
                return false;
            }
            configToSave = instance.getStorageComponent();
        }
        return this.addEditor(functionalGroup.getStorageFuncGroup(), (AStoragePeriphsComponent)configToSave);
    }

    private boolean restoreEditorsHandleSchematicView(IMemento memento) {
        if (!memento.getType().equals(SCHEMATIC)) {
            return false;
        }
        String funcGroupUuid = UtilsText.safeString((String)memento.getString(GROUP));
        IFunctionalGroup functionalGroup = Controller.getInstance().getProfile().getFunctionalGroupWithUUID(funcGroupUuid);
        if (functionalGroup == null) {
            LOGGER.info("[TOOL] Trying to restore editors: Functional group with given ID was not found in current profile");
            return false;
        }
        String name = UtilsText.safeString((String)memento.getString(UUID));
        IComponentInstanceConfig instance = functionalGroup.getInstanceByUUID(name);
        if (instance == null) {
            LOGGER.info("[TOOL] Trying to restore component setting view of component instance config that is not present in current functional group");
            return false;
        }
        return this.addSchematic(functionalGroup.getStorageFuncGroup(), (AStoragePeriphsComponent)instance.getStorageComponent());
    }

    public boolean saveEditors() {
        boolean result = false;
        StringWriter writer = new StringWriter();
        try {
            XMLMemento xmlMemento = XMLMemento.createWriteRoot((String)EDITORS);
            for (Map.Entry editorSettings : this.editors.flatEntrySet()) {
                ComponentSettingViewHelper.saveEditorsHandleComponentSettingsView(xmlMemento, editorSettings);
            }
            for (Map.Entry editorSettings : this.schematicViews.flatEntrySet()) {
                ComponentSettingViewHelper.saveEditorsHandleSchematicView(xmlMemento, editorSettings);
            }
            xmlMemento.save((Writer)writer);
            this.storageHelper.saveString(EDITORS_UNDERSCORE + ComponentSettingViewHelper.getMexFilePath(), UtilsText.safeString((String)writer.toString()));
            result = true;
        }
        catch (IOException e) {
            LOGGER.info(MessageFormat.format("[TOOL] File exception occured. Detail: {0}", e.getMessage()));
        }
        return result;
    }

    private static boolean saveEditorsHandleComponentSettingsView(XMLMemento xmlMemento, Map.Entry<@NonNull String, @NonNull AStoragePeriphsComponent> editorSettings) {
        String global;
        IMemento node;
        String funcGroupUuid;
        block5: {
            funcGroupUuid = editorSettings.getKey();
            AStoragePeriphsComponent component = editorSettings.getValue();
            try {
                node = xmlMemento.createChild(EDITOR);
                node.putString(UUID, component.getUUID());
                if (component instanceof StoragePeriphsComponentInstance) {
                    node.putString(TYPE, ((StoragePeriphsComponentInstance)component).getType());
                    global = String.valueOf(false);
                    break block5;
                }
                if (component instanceof StoragePeriphsComponent) {
                    node.putString(TYPE, ((StoragePeriphsComponent)component).getName());
                    global = String.valueOf(true);
                    break block5;
                }
                LOGGER.log(Level.SEVERE, "[TOOL] Editor given for save is not instance or component config editor: {0}", component);
                return false;
            }
            catch (DOMException e) {
                LOGGER.log(Level.SEVERE, "Exception occurred during creating new XML element in memento: {0}", e.getLocalizedMessage());
                return false;
            }
        }
        node.putString(GLOBAL, global);
        node.putString(GROUP, funcGroupUuid);
        return true;
    }

    private static boolean saveEditorsHandleSchematicView(XMLMemento xmlMemento, Map.Entry<@NonNull String, @NonNull AStoragePeriphsComponent> editorSettings) {
        String funcGroupUuid = editorSettings.getKey();
        AStoragePeriphsComponent component = editorSettings.getValue();
        try {
            IMemento node = xmlMemento.createChild(SCHEMATIC);
            node.putString(UUID, component.getUUID());
            node.putString(GROUP, funcGroupUuid);
            return true;
        }
        catch (DOMException e) {
            LOGGER.log(Level.SEVERE, "Exception occurred during creating new XML element in memento: {0}", e.getLocalizedMessage());
            return false;
        }
    }

    public void closeOpenedEditors() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage activePage = Objects.requireNonNull(workbench.getActiveWorkbenchWindow()).getActivePage();
        if (activePage == null) {
            return;
        }
        IViewReference[] viewReferences = activePage.getViewReferences();
        int index = 0;
        while (index < viewReferences.length) {
            IViewReference viewRef = viewReferences[index];
            String id = viewRef.getId();
            if (id.equals("com.nxp.swtools.periphs.gui.view.componentsettings")) {
                activePage.hideView(viewRef);
            }
            ++index;
        }
    }

    public void closeOpenedSchematicViews() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage activePage = Objects.requireNonNull(workbench.getActiveWorkbenchWindow()).getActivePage();
        if (activePage == null) {
            return;
        }
        IViewReference[] viewReferences = activePage.getViewReferences();
        int index = 0;
        while (index < viewReferences.length) {
            IViewReference viewRef = viewReferences[index];
            String id = viewRef.getId();
            if (id.equals(SCHEMATIC_VIEW_ID)) {
                activePage.hideView(viewRef);
            }
            ++index;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void removeEntriesOfGroup(@NonNull StoragePeriphsFuncGroup group) {
        @NonNull Collection editorsOfGroup = this.editors.get((Object)group.getUUID());
        if (editorsOfGroup != null) {
            editorsOfGroup.clear();
            this.editors.remove((Object)group.getUUID());
            this.schematicViews.remove((Object)group.getUUID());
        }
    }

    public void reopenInvalidViews() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchPage activePage = Objects.requireNonNull(workbench.getActiveWorkbenchWindow()).getActivePage();
        if (activePage == null) {
            return;
        }
        IViewReference[] viewReferences = activePage.getViewReferences();
        int index = 0;
        while (index < viewReferences.length) {
            ComponentSettingViewInput componentInput;
            ComponentSettingView view;
            String primaryID = viewReferences[index].getId();
            String secondaryID = UtilsText.safeString((String)viewReferences[index].getSecondaryId());
            if (primaryID.equals("com.nxp.swtools.periphs.gui.view.componentsettings") && (view = (ComponentSettingView)viewReferences[index].getView(false)) != null && (componentInput = view.componentInput) != null && !secondaryID.startsWith(ComponentSettingViewHelper.createSecondaryId(componentInput))) {
                activePage.hideView((IViewPart)view);
                ComponentSettingView.open(activePage, componentInput.getComponentType(), componentInput.getComponent(), componentInput.isGlobalConfig(), false, null);
            }
            ++index;
        }
    }

    public static @NonNull String createSecondaryId(@NonNull ComponentSettingViewInput componentInput) {
        String uuid = componentInput.getUUID();
        String identification = UtilsText.isEmpty((String)uuid) ? String.valueOf(componentInput.getComponentType()) + "/" + componentInput.getComponent() : uuid;
        return identification;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull Set<@NonNull Integer> getPermittedOccurrences(@NonNull String identificationBase) {
        @NonNull Set viewOccurences = this.permittedOccurences.computeIfAbsent(identificationBase, id -> {
            HashSet<@NonNull Integer> hashSet = new HashSet<Integer>();
            hashSet.add(0);
            return hashSet;
        });
        assert (viewOccurences != null);
        return viewOccurences;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void addPermittedOccurrence(@NonNull String identificationBase) {
        @NonNull Set viewOccurences = this.permittedOccurences.computeIfAbsent(identificationBase, id -> {
            HashSet<@NonNull Integer> hashSet = new HashSet<Integer>();
            hashSet.add(0);
            return hashSet;
        });
        assert (viewOccurences != null);
        int i = 1;
        while (i < 100) {
            Integer occurrence = i;
            if (!viewOccurences.contains(occurrence)) {
                viewOccurences.add(occurrence);
                break;
            }
            ++i;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void removePermittedOccurrence(@NonNull String identificationBase, @NonNull Integer occurrence) {
        @NonNull Set viewOccurrences = this.permittedOccurences.computeIfAbsent(identificationBase, id -> new HashSet());
        assert (viewOccurrences != null);
        viewOccurrences.remove(occurrence);
        if (viewOccurrences.isEmpty()) {
            viewOccurrences.add(0);
        }
    }

    public void restoreConfigurationEditors(@NonNull IViewSite viewSite) {
        this.removeState = true;
        this.closeOpenedEditors();
        this.clearEditors();
        this.removeState = false;
        this.restoreEditors();
        this.showOpenedEditors(viewSite);
        this.showOpenedSchematicViews(viewSite);
    }

    public static boolean selectChildrenOnPath(@NonNull IChildControl child, @NonNull String childId, @NonNull IChildControl.UpdateType updateType) {
        String rest;
        String myPart;
        List<@NonNull IChildControl> children = null;
        int separatorIndex = childId.indexOf(".");
        if (separatorIndex != -1) {
            myPart = childId.substring(0, separatorIndex);
            rest = childId.substring(separatorIndex + 1);
        } else {
            myPart = childId;
            rest = childId;
        }
        if (child.getChild().getName().equals(rest)) {
            return true;
        }
        if (child instanceof ChildProvidableControlBase) {
            IChildControl nextChild;
            ChildProvidableControlBase childProvidableControlBase = (ChildProvidableControlBase)child;
            children = childProvidableControlBase.getChildren();
            if (child instanceof ArrayControl) {
                children = ((ArrayControl)child).getChildren();
            }
            if ((nextChild = (IChildControl)CollectionsUtils.nullableOptionalGet(children.stream().filter(x -> x.getChild().getName().equals(myPart)).findAny())) != null) {
                childProvidableControlBase.selectChildTab(nextChild);
                childProvidableControlBase.setSelectedChild(nextChild);
                childProvidableControlBase.update(updateType);
                return ComponentSettingViewHelper.selectChildrenOnPath(nextChild, rest, updateType);
            }
        }
        return false;
    }

    public static void selectChildrenOnPath(@NonNull IChildControl child, @NonNull String childId, @Nullable ChildProvidableControlBase parent, @NonNull IChildControl.UpdateType updateType) {
        List<IChildControl> children = null;
        if (child instanceof ChildProvidableControlBase) {
            ChildProvidableControlBase childProvidableControlBase = (ChildProvidableControlBase)child;
            children = childProvidableControlBase.getChildren();
            if (childId.contains(child.getChild().getId()) && parent != null) {
                if (parent instanceof ArrayControl) {
                    ArrayControl arrayControl = (ArrayControl)parent;
                    children = arrayControl.getChildren();
                }
                parent.selectChildTab(child);
                parent.setSelectedChild(child);
                parent.update(updateType);
            }
            for (IChildControl childControl : children) {
                if (!childId.contains(childControl.getChild().getId())) continue;
                ComponentSettingViewHelper.selectChildrenOnPath(childControl, childId, childProvidableControlBase, updateType);
            }
        } else if (childId.equals(child.getChild().getId()) && parent != null) {
            parent.selectChildTab(child);
            parent.setSelectedChild(child);
            parent.update(updateType);
        }
    }
}

