/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view.componentsettings;

import com.nxp.swtools.common.ui.utils.GcUtils;
import com.nxp.swtools.common.ui.utils.swt.ControlDecorationUtils;
import com.nxp.swtools.common.ui.utils.swt.FontFactory;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.ui.utils.swt.ScrolledCompositeHelper;
import com.nxp.swtools.common.ui.utils.swt.widgets.InstantSearchList;
import com.nxp.swtools.common.ui.utils.swt.widgets.ToggleButton;
import com.nxp.swtools.common.ui.utils.views.GenericSelectionProvider;
import com.nxp.swtools.common.ui.utils.views.PartListener2Adapter;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.ExpressionException;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.core.service.scriptapi.db.IRegParentPeripheralAPI;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import com.nxp.swtools.derivative.swt.GridDataComponents;
import com.nxp.swtools.derivative.swt.GridLayoutComponents;
import com.nxp.swtools.periphs.controller.APeriphController;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.periphs.gui.controller.PeriphControllerWrapper;
import com.nxp.swtools.periphs.gui.view.DocumentationView;
import com.nxp.swtools.periphs.gui.view.componentsettings.ArrayControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.ChildControlFactory;
import com.nxp.swtools.periphs.gui.view.componentsettings.ChildProvidableControlBase;
import com.nxp.swtools.periphs.gui.view.componentsettings.ComponentSettingViewHelper;
import com.nxp.swtools.periphs.gui.view.componentsettings.ComponentSettingViewInput;
import com.nxp.swtools.periphs.gui.view.componentsettings.ConfigSetControl;
import com.nxp.swtools.periphs.gui.view.componentsettings.EditorViewBase;
import com.nxp.swtools.periphs.gui.view.componentsettings.GlobalComponentSettingView;
import com.nxp.swtools.periphs.gui.view.componentsettings.IChildControl;
import com.nxp.swtools.periphs.gui.wrappers.ComponentInstanceWrapper;
import com.nxp.swtools.periphs.model.data.Categories;
import com.nxp.swtools.provider.configuration.storage.periphs.AStoragePeriphsComponent;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsComponentInstance;
import com.nxp.swtools.resourcetables.model.config.ArrayConfig;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IChildProvidable;
import com.nxp.swtools.resourcetables.model.config.IComponentConfig;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.config.IConfigSetConfig;
import com.nxp.swtools.resourcetables.model.config.IFunctionalGroup;
import com.nxp.swtools.resourcetables.model.config.RegistersModelSingleton;
import com.nxp.swtools.resourcetables.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.resourcetables.model.data.MasterPeripheral;
import com.nxp.swtools.resourcetables.model.validation.ValidationHelper;
import com.nxp.swtools.utils.events.IEventListener;
import com.nxp.swtools.utils.events.ToolEvent;
import com.nxp.swtools.utils.preferences.KEPreferences;
import com.nxp.swtools.utils.profiler.Profiler;
import com.nxp.swtools.utils.progress.ProgressUtils;
import com.nxp.swtools.utils.resources.ToolsColors;
import com.nxp.swtools.utils.resources.ToolsImages;
import com.nxp.swtools.utils.support.markdown.MarkDownSupport;
import com.nxp.swtools.utils.text.TextBoxHelper;
import com.nxp.swtools.utils.tooltip.IToolTipable;
import com.nxp.swtools.utils.tooltip.ToolTipableFormatter;
import com.nxp.swtools.utils.tooltip.ToolTipableImplementation;
import com.nxp.swtools.utils.tooltip.ToolTipableMarkdownDescriptionDecorator;
import com.nxp.swtools.utils.view.ToolView;
import com.nxp.swtools.validation.engine.IValidationProblem;
import com.nxp.swtools.validation.engine.IValidationProblemListener;
import com.nxp.swtools.validation.engine.ValidationEngineFactory;
import com.nxp.swtools.validation.engine.ValidationProblemListenerAdapter;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;

public class ComponentSettingView
extends EditorViewBase {
    @NonNull
    static final Logger LOGGER = LogManager.getLogger(ComponentSettingView.class);
    @NonNull
    public static final String SECONDARY_ID_NAME_TYPE_SEPARATOR = "/";
    @NonNull
    public static final String SECONDARY_ID_IDENTIFICATION_OCCURENCE_SEPARATOR = "|";
    @NonNull
    public static final String SECONDARY_ID_GROUP_TYPE = "type";
    @NonNull
    public static final String SECONDARY_ID_GROUP_NAME = "name";
    @NonNull
    public static final String SECONDARY_ID_GROUP_UUID = "uuid";
    @NonNull
    public static final String SECONDARY_ID_GROUP_OCCURRENCE = "occurrence";
    @NonNull
    public static final Pattern SECONDARY_ID_GROUPS_PATTERN = Pattern.compile("(((?<type>.*?)/(?<name>.*?))|(?<uuid>.*?))\\|(?<occurrence>.*)");
    public static final int TITLE_ROW_COLS = 4;
    public static final int COMPONENT_COLS = 2;
    public static final int CONFIG_SET_COLS = 3;
    public static final int SET_COLS = 2;
    public static final int NUM_OF_CONFIGSET_LABEL_COLUMNS = 2;
    private static final int MODE_PERIPHERAL_COLUMNS = 10;
    private static final int PERIPHERAL_COLUMN_SPAN = 4;
    private static final int MODE_COLUMN_SPAN = 6;
    @NonNull
    public static final String ID = "com.nxp.swtools.periphs.gui.view.componentsettings";
    @NonNull
    public static final String ERROR_DECORATION_KEY = "error_decoration";
    private static final int MIN_WIDTH_EMS = SwToolsProduct.isUctProduct() ? 100 : 70;
    protected ScrolledComposite scrolledComposite;
    final Controller controller = Controller.getInstance();
    ComponentSettingViewInput componentInput;
    @Nullable
    private IChildControl componentSettingControl = null;
    @NonNull
    final @NonNull Collection<@NonNull IEventListener> registeredListeners = new ArrayList<IEventListener>();
    @NonNull
    final @NonNull Map<@NonNull IConfigSetConfig, ConfigSetControl> configSetControls = new HashMap<IConfigSetConfig, ConfigSetControl>();
    @Nullable
    private InstantSearchList comboBoxMode;
    @Nullable
    private Listener resizeListener;
    @Nullable
    private Label labelName;
    @Nullable
    private Text textBoxName;
    @Nullable
    private Label labelMode;
    @Nullable
    private Label labelPeripheral;
    @Nullable
    private InstantSearchList comboBoxPeripheral;
    @Nullable
    private Label labelCustomName;
    @Nullable
    private Button buttonCustomName;
    boolean nameIsValid = true;
    protected GenericSelectionProvider viewSelectionProvider = new GenericSelectionProvider();
    @NonNull
    EditorViewBase.ActionRequired requiredAction = EditorViewBase.ActionRequired.NO_ACTION;
    @NonNull
    private ValidationProblemListenerAdapter validationsListener = new ValidationProblemListenerAdapter(){

        public void validationProblemsChanged(@NonNull Collection<@NonNull IValidationProblem> problems) {
            RegistersModelSingleton registerModelSingleton;
            if (ComponentSettingView.this.contentComposite != null && !ComponentSettingView.this.contentComposite.isDisposed()) {
                ComponentSettingView.this.refreshIfVisible(IChildControl.UpdateType.PROBLEM_DECORATION);
            }
            if ((registerModelSingleton = RegistersModelSingleton.getInstance()).isRegenerationNeeded()) {
                registerModelSingleton.refreshRegistersFromAssigns(ComponentSettingView.this.controller.getFunctionalGroup());
                ComponentSettingView.this.controller.refreshRegistersView();
            }
        }
    };

    public void init(IViewSite site) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        String secondaryId = site.getSecondaryId();
        if (secondaryId == null) {
            return;
        }
        site.setSelectionProvider((ISelectionProvider)this.viewSelectionProvider);
        Matcher matcher = SECONDARY_ID_GROUPS_PATTERN.matcher(secondaryId);
        int occurrence = -1;
        String uuid = "";
        String name = "";
        String type = "";
        if (matcher.matches()) {
            uuid = UtilsText.safeString((String)matcher.group(SECONDARY_ID_GROUP_UUID));
            type = UtilsText.safeString((String)matcher.group(SECONDARY_ID_GROUP_TYPE));
            name = UtilsText.safeString((String)matcher.group(SECONDARY_ID_GROUP_NAME));
            occurrence = Integer.parseInt(UtilsText.safeString((String)matcher.group(SECONDARY_ID_GROUP_OCCURRENCE)));
        }
        final int occurrenceFinal = occurrence;
        ComponentSettingViewInput input = new ComponentSettingViewInput(type, name, false);
        input.setUUID(uuid);
        this.componentInput = input;
        final IChild inputSetting = this.getComponent();
        if (inputSetting instanceof IComponentInstanceConfig) {
            IComponentInstanceConfig instance = (IComponentInstanceConfig)inputSetting;
            this.componentInput.setUUID(instance.getUUID());
            if (instance.getComponent().isRegistersInitialization()) {
                site.getPage().showView("com.nxp.swtools.framework.RegistersView");
            }
        }
        this.getSiteSafe().getPage().addPartListener(new IPartListener(){

            public void partOpened(IWorkbenchPart part) {
                if (part.equals((Object)ComponentSettingView.this)) {
                    IComponentConfig component = ComponentSettingView.this.controller.getConfiguredComponent(ComponentSettingView.this.getComponentType());
                    String uuid = ComponentSettingView.this.componentInput.getUUID();
                    IComponentInstanceConfig componentInstance = UtilsText.isEmpty((String)uuid) ? ComponentSettingView.this.controller.getComponentInstance(ComponentSettingView.this.getComponentType(), ComponentSettingView.this.getComponentName()) : ComponentSettingView.this.controller.getComponentInstance(uuid);
                    StoragePeriphsComponentInstance configToSave = null;
                    if (componentInstance != null) {
                        configToSave = componentInstance.getStorageComponent();
                        ComponentSettingView.this.viewSelectionProvider.setSelection((ISelection)new StructuredSelection((Object)new ComponentInstanceWrapper(componentInstance, ComponentSettingView.this.controllerWrapper)));
                    } else if (component != null) {
                        configToSave = component.getStorageComponent();
                    } else {
                        return;
                    }
                    ComponentSettingView.this.setPartName(inputSetting == null ? null : inputSetting.getUiName());
                    ComponentSettingViewHelper.getInstance().addEditor(Controller.getInstance().getFunctionalGroup().getStorageFuncGroup(), (AStoragePeriphsComponent)configToSave);
                }
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
                if (part.equals((Object)ComponentSettingView.this)) {
                    ComponentSettingViewInput inputOfClosedEditor = ComponentSettingView.this.componentInput;
                    if (inputOfClosedEditor != null) {
                        ComponentSettingViewHelper.getInstance().removeEditor(inputOfClosedEditor, Controller.getInstance().getFunctionalGroup().getStorageFuncGroup().getUUID());
                        ComponentSettingViewHelper.getInstance().removePermittedOccurrence(ComponentSettingViewHelper.createSecondaryId(inputOfClosedEditor), occurrenceFinal);
                    }
                    ComponentSettingView.this.getSiteSafe().getPage().removePartListener((IPartListener)this);
                }
            }

            public void partBroughtToTop(IWorkbenchPart part) {
                this.handleViewFocusedEvent(part);
            }

            private void handleViewFocusedEvent(IWorkbenchPart part) {
                IComponentInstanceConfig instance;
                if (part.equals((Object)ComponentSettingView.this) && inputSetting instanceof IComponentInstanceConfig && (instance = (IComponentInstanceConfig)inputSetting).getComponent().isRegistersInitialization()) {
                    RegistersModelSingleton.getInstance().setSelectedComponent(instance);
                    ComponentSettingView.this.controller.refreshRegistersView();
                }
            }

            public void partActivated(IWorkbenchPart part) {
                this.handleViewFocusedEvent(part);
            }
        });
    }

    @Override
    public void dispose() {
        ValidationEngineFactory.removeListener((IValidationProblemListener)this.validationsListener);
        for (IEventListener listener : this.registeredListeners) {
            this.controller.removeListener(listener);
        }
        super.dispose();
    }

    protected @NonNull Composite getDefaultCompositeSpecificImplementation(Composite basic) {
        return new ScrolledComposite(basic, 768);
    }

    public void createPartControl(Composite parent) {
        ScrolledComposite scrolledCompositeLoc;
        if (this.componentInput == null) {
            return;
        }
        this.scrolledComposite = scrolledCompositeLoc = (ScrolledComposite)this.createDefaultComposite(parent);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)scrolledCompositeLoc, "periphsComponentSettingViewContent");
        this.contentComposite = new Composite((Composite)scrolledCompositeLoc, 0);
        GridLayoutComponents layout = new GridLayoutComponents(2, false);
        layout.marginWidth = 8;
        layout.horizontalSpacing = 8;
        this.contentComposite.setLayout((Layout)layout);
        scrolledCompositeLoc.setContent((Control)this.contentComposite);
        scrolledCompositeLoc.setExpandHorizontal(true);
        scrolledCompositeLoc.setExpandVertical(true);
        this.addPartHandlers();
        parent.getDisplay().asyncExec(() -> {
            if (this.state == EditorViewBase.State.UNINITIALIZED) {
                this.state = EditorViewBase.State.READY_TO_CREATE;
                IWorkbenchPage page = this.getSiteSafe().getPage();
                IWorkbenchPart part = this.getSiteSafe().getPart();
                if (page == null || part == null) {
                    LOGGER.fine("[TOOL] GUI: page or part is set to null");
                    return;
                }
                if (page.isPartVisible(part)) {
                    this.recreate();
                    this.contentComposite.forceFocus();
                    this.state = EditorViewBase.State.CREATED_VISIBLE;
                }
            }
        });
        this.registerEventListener();
        ValidationEngineFactory.addListener((IValidationProblemListener)this.validationsListener);
        this.updateErrorIndicators();
    }

    protected void addPartHandlers() {
        this.getSiteSafe().getPage().addPartListener((IPartListener2)new PartListener2Adapter(){

            public void partVisible(IWorkbenchPartReference partRef) {
                if (ComponentSettingView.this.getViewSiteNonNull().getPart() != partRef.getPart(false)) {
                    return;
                }
                if (ComponentSettingView.this.state == EditorViewBase.State.CREATED_HIDDEN) {
                    ComponentSettingView.this.state = EditorViewBase.State.CREATED_VISIBLE;
                    if (ComponentSettingView.this.requiredAction == EditorViewBase.ActionRequired.RECREATE) {
                        ComponentSettingView.this.recreate();
                    } else if (ComponentSettingView.this.requiredAction == EditorViewBase.ActionRequired.REFRESH) {
                        ComponentSettingView.this.refreshSettings(IChildControl.UpdateType.NORMAL);
                    }
                    ComponentSettingView.this.requiredAction = EditorViewBase.ActionRequired.NO_ACTION;
                } else if (ComponentSettingView.this.state == EditorViewBase.State.READY_TO_CREATE) {
                    ComponentSettingView.this.state = EditorViewBase.State.CREATED_VISIBLE;
                    ComponentSettingView.this.recreate();
                    ComponentSettingView.this.requiredAction = EditorViewBase.ActionRequired.NO_ACTION;
                }
            }

            public void partHidden(IWorkbenchPartReference partRef) {
                if (ComponentSettingView.this.getViewSiteNonNull().getPart() == partRef.getPart(false) && ComponentSettingView.this.state == EditorViewBase.State.CREATED_VISIBLE) {
                    ComponentSettingView.this.state = EditorViewBase.State.CREATED_HIDDEN;
                    ComponentSettingView.this.requiredAction = EditorViewBase.ActionRequired.NO_ACTION;
                }
            }

            public void partClosed(IWorkbenchPartReference partRef) {
                if (ComponentSettingView.this.getViewSiteNonNull().getPart() == partRef.getPart(false)) {
                    ComponentSettingView.this.getSiteSafe().getPage().removePartListener((IPartListener2)this);
                    ComponentSettingView.this.state = EditorViewBase.State.UNINITIALIZED;
                    ComponentSettingView.this.requiredAction = EditorViewBase.ActionRequired.NO_ACTION;
                }
            }
        });
    }

    protected @NonNull IViewSite getViewSiteNonNull() {
        IViewSite site = this.getViewSite();
        assert (site != null);
        return site;
    }

    private void registerEventListener() {
        IEventListener changesListener = new IEventListener(){

            public void handle(ToolEvent event) {
                Display display;
                ComponentSettingViewInput componentInputReference;
                boolean shouldCloseView = false;
                boolean shouldRemoveViewFromOpened = false;
                String componentType = ComponentSettingView.this.getComponentType();
                IComponentInstanceConfig componentSetting = Controller.getInstance().getComponentInstance(ComponentSettingView.this.componentInput.getUUID());
                if (ComponentSettingView.this.componentInput.isGlobalConfig()) {
                    shouldRemoveViewFromOpened = shouldCloseView = ComponentSettingView.this.controller.getProfile().getConfiguredComponents().values().stream().noneMatch(config -> config.getName().equals(componentType));
                } else {
                    String uuid = componentSetting != null ? componentSetting.getUUID() : "";
                    shouldCloseView = ComponentSettingView.this.controller.getFunctionalGroup().getInstances().values().stream().noneMatch(instance -> instance.getUUID().equals(uuid));
                    shouldRemoveViewFromOpened = ComponentSettingView.this.controller.getProfile().getAllInstances().stream().noneMatch(instance -> instance.getUUID().equals(uuid));
                }
                if (shouldRemoveViewFromOpened && (componentInputReference = ComponentSettingView.this.componentInput) != null) {
                    ComponentSettingViewHelper.getInstance().removeEditor(componentInputReference, ComponentSettingView.this.controller.getFunctionalGroup().getStorageFuncGroup().getUUID());
                }
                if (shouldCloseView && (display = Display.getCurrent()) != null && !ComponentSettingView.this.scrolledComposite.isDisposed()) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            IWorkbenchPage page;
                            IWorkbenchWindow workbenchWindow = ComponentSettingView.this.getViewSiteNonNull().getWorkbenchWindow();
                            if (workbenchWindow != null && (page = workbenchWindow.getActivePage()) != null) {
                                page.hideView((IViewPart)ComponentSettingView.this);
                            }
                        }
                    });
                }
                if (event.originator != ComponentSettingView.this) {
                    if (ComponentSettingView.this.state == EditorViewBase.State.CREATED_VISIBLE) {
                        display = Display.getCurrent();
                        if (display != null) {
                            display.asyncExec(() -> ComponentSettingView.this.recreate());
                        }
                    } else if (ComponentSettingView.this.state == EditorViewBase.State.CREATED_HIDDEN) {
                        ComponentSettingView.this.requiredAction = EditorViewBase.ActionRequired.RECREATE;
                    }
                }
                ComponentSettingView.this.updateErrorIndicators();
                ComponentSettingView.this.updateTooltips();
            }
        };
        this.controller.addListener(1, changesListener);
        this.registeredListeners.add(changesListener);
        IEventListener settingListener = new IEventListener(){

            public void handle(ToolEvent event) {
                ComponentSettingView.this.refreshIfVisible(IChildControl.UpdateType.NORMAL_CONFIGSET);
            }
        };
        this.controller.addListener(2, settingListener);
        this.registeredListeners.add(settingListener);
        IEventListener initializationListener = new IEventListener(){

            public void handle(ToolEvent event) {
                ComponentSettingView.this.refreshIfVisible(IChildControl.UpdateType.INITIALIZATION);
            }
        };
        this.controller.addListener(4, initializationListener);
        this.registeredListeners.add(initializationListener);
    }

    protected void refreshIfVisible(@NonNull IChildControl.UpdateType updateType) {
        if (this.state == EditorViewBase.State.CREATED_HIDDEN) {
            if (this.requiredAction != EditorViewBase.ActionRequired.RECREATE) {
                this.requiredAction = EditorViewBase.ActionRequired.REFRESH;
            }
            this.updateErrorIndicators();
        } else {
            this.refreshSettings(updateType);
        }
    }

    protected void updateErrorIndicators() {
        IChild component = this.getComponent();
        Image image = null;
        if (component != null) {
            int dependenciesLevel = ValidationHelper.getHighestSeverityComponentValidationProblemLevel((IChild)component);
            int settingsLevel = -1;
            if (component.getInfo() != null) {
                settingsLevel = 0;
            }
            if (component.getWarning() != null) {
                settingsLevel = 1;
            }
            if (component.getError() != null) {
                settingsLevel = 2;
            }
            int problemLevel = dependenciesLevel > settingsLevel ? dependenciesLevel : settingsLevel;
            image = this.componentInput.isGlobalConfig() ? ToolView.getDecoratedImage((String)"views/component_global.png", (int)problemLevel) : ToolView.getDecoratedImage((String)"views/component_local.png", (int)problemLevel);
        }
        this.setTitleImage(image);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void updateErrorDecorators() {
        IComponentInstanceConfig compInstance = this.controller.getComponentInstance(this.componentInput.getUUID());
        if (compInstance != null) {
            Control[] editors = new Control[]{this.textBoxName, this.comboBoxMode, this.comboBoxPeripheral};
            Supplier[] supplierArray = new Supplier[3];
            supplierArray[0] = () -> compInstance.getNotUniqueNameError();
            supplierArray[2] = () -> ComponentSettingView.getPeripheralError(compInstance);
            Supplier[] suppliers = supplierArray;
            assert (editors.length == suppliers.length);
            int i = 0;
            while (i < editors.length) {
                Control editor = editors[i];
                @Nullable Supplier supplier = suppliers[i];
                if (editor != null && supplier != null) {
                    ControlDecorationUtils.updateControlDecoration((Control)editor, (Supplier)supplier);
                }
                ++i;
            }
        }
    }

    void createTitleRow(@NonNull Composite parent) {
        boolean isDocumentationPresent = false;
        ConfigurationComponentTypeId configCompTypeId = null;
        String titleString = "";
        String categoryId = "";
        IComponentInstanceConfig componentInstanceConfig = this.controller.getComponentInstance(this.componentInput.getUUID());
        IComponentConfig componentConfig = this.controller.getConfiguredComponent(this.getComponentType());
        int titleGridDataAdvancedColumns = 1;
        Composite titleRow = new Composite(parent, 0);
        titleRow.setLayoutData((Object)new GridDataComponents(4, 0x1000000, true, false, 2, 1));
        titleRow.setBackgroundMode(2);
        GridLayoutComponents titleRowLayout = new GridLayoutComponents(4, false);
        titleRowLayout.marginHeight = 0;
        titleRowLayout.marginWidth = 0;
        titleRow.setLayout((Layout)titleRowLayout);
        Composite titleComposite = new Composite(titleRow, 0);
        titleComposite.setLayoutData((Object)new GridDataComponents());
        RowLayout titleCompositeLayout = new RowLayout();
        titleCompositeLayout.marginHeight = 0;
        titleCompositeLayout.marginWidth = 0;
        titleComposite.setLayout((Layout)titleCompositeLayout);
        Label title = new Label(titleComposite, 64);
        IContext context = null;
        if (this.componentInput.isGlobalConfig() && componentConfig != null) {
            titleString = componentConfig.getComponent().getResolvedDescription(componentConfig.getExpressionContext());
            if (titleString == null) {
                titleString = componentConfig.getComponent().getLabel(componentConfig.getExpressionContext());
            }
            context = componentConfig.getExpressionContext();
            categoryId = componentConfig.getComponent().getCategory();
            configCompTypeId = componentConfig.getConfigCompTypeId();
            isDocumentationPresent = configCompTypeId.isDocumentationPresent();
        }
        if (!this.componentInput.isGlobalConfig() && componentInstanceConfig != null) {
            titleString = componentInstanceConfig.getComponent().getResolvedDescription(componentInstanceConfig.getExpressionContext());
            if (titleString == null) {
                titleString = componentInstanceConfig.getComponent().getLabel(componentInstanceConfig.getExpressionContext());
            }
            context = componentInstanceConfig.getExpressionContext();
            categoryId = componentInstanceConfig.getComponent().getCategory();
            configCompTypeId = componentInstanceConfig.getConfigCompTypeId();
            isDocumentationPresent = componentInstanceConfig.getConfigCompTypeId().isDocumentationPresent();
        }
        String categoryString = "";
        if (!UtilsText.isEmpty((String)categoryId) && context != null) {
            String categoryIdFinal = UtilsText.safeString((String)categoryId);
            IContext contextFinal = context;
            Categories categories = this.controllerWrapper.getController().getCategories();
            if (categories != null) {
                categoryString = categories.getCategoryLabel(categoryIdFinal, contextFinal);
            }
        }
        title.setLayoutData((Object)new RowData());
        title.setText(titleString);
        FontFactory.scaleFontSize((Control)title, (double)1.5);
        FontFactory.changeStyle((Control)title, (int)1);
        Point titleSize = title.computeSize(-1, -1);
        if (!UtilsText.isEmpty((String)categoryString)) {
            Composite categoryComposite = new Composite(titleComposite, 0);
            GridLayoutComponents categoryLayout = new GridLayoutComponents();
            categoryLayout.marginHeight = 0;
            categoryLayout.marginWidth = 0;
            categoryComposite.setLayout((Layout)categoryLayout);
            Label category = new Label(categoryComposite, 0);
            category.setLayoutData((Object)new GridDataComponents(16384, 1024, false, false));
            category.setText("[" + categoryString + "]");
            SWTFactoryProxy.INSTANCE.setTestId((Widget)category, "periphsCategoryLabel");
            FontFactory.changeStyle((Control)category, (int)2);
            Point categorySize = category.computeSize(-1, -1);
            categoryLayout.marginTop = titleSize.y - categorySize.y;
            categoryComposite.setLayoutData((Object)new RowData(categorySize.x, titleSize.y));
        }
        if (isDocumentationPresent && configCompTypeId != null) {
            ComponentSettingView.createLinkToDocumentation(titleRow, configCompTypeId);
        } else {
            ++titleGridDataAdvancedColumns;
        }
        if (!this.componentInput.isGlobalConfig() && componentInstanceConfig != null) {
            this.createLockButton(titleRow, componentInstanceConfig);
            this.createEnableButton(titleRow, componentInstanceConfig);
        } else {
            ++titleGridDataAdvancedColumns;
        }
        titleComposite.setLayoutData((Object)new GridDataComponents(16384, 4, true, false, titleGridDataAdvancedColumns, 1));
    }

    void createContent() {
        IChild inputSetting = this.getComponent();
        this.setPartName(inputSetting == null ? null : inputSetting.getUiName());
        Composite contentCompositeLoc = this.contentComposite;
        if (contentCompositeLoc != null) {
            this.createTitleRow(contentCompositeLoc);
            if (this.componentInput.isGlobalConfig()) {
                this.createGlobalPart(contentCompositeLoc);
            } else {
                this.createInstancePart(contentCompositeLoc);
            }
        }
        this.updateErrorIndicators();
        this.updateErrorDecorators();
        this.updateTooltips();
        this.scrolledComposite.setMinWidth(GcUtils.getEmWidth((Control)this.scrolledComposite, (boolean)true) * MIN_WIDTH_EMS);
        this.scrolledComposite.setMinHeight(this.contentComposite.computeSize((int)this.scrolledComposite.getClientArea().width, (int)-1).y);
        this.resizeListener = new Listener(){

            public void handleEvent(Event event) {
                if (!ComponentSettingView.this.getSiteSafe().getPage().isPartVisible((IWorkbenchPart)ComponentSettingView.this)) {
                    return;
                }
                ComponentSettingView.this.scrolledComposite.setMinHeight(ComponentSettingView.this.contentComposite.computeSize((int)ComponentSettingView.this.scrolledComposite.getClientArea().width, (int)-1).y);
            }
        };
        this.contentComposite.addListener(11, this.resizeListener);
    }

    @Deprecated
    private void createGlobalPart(@NonNull Composite parent) {
        IComponentConfig componentConfig = this.controller.getConfiguredComponent(this.getComponentType());
        if (componentConfig != null) {
            IConfigSetConfig configSetConfig;
            Label label = new Label(parent, 0);
            label.setLayoutData((Object)new GridDataComponents(16384, 0x1000000, true, false, 2, 1));
            FontFactory.changeStyle((Control)label, (int)1);
            label.setText(MessageFormat.format(UtilsText.safeString((String)Messages.get().ComponentEditor_GlobalConfigurationOf), componentConfig.getUiName()));
            if (!UtilsText.isEmpty((String)componentConfig.getDescription())) {
                label = new Label(parent, 258);
                label.setLayoutData((Object)new GridDataComponents(4, 0x1000000, true, false, 2, 1));
                label = new Label(parent, 64);
                label.setLayoutData((Object)new GridDataComponents(4, 128, true, false, 2, 1));
                label.setText(UtilsText.safeString((String)componentConfig.getDescription()));
            }
            if ((configSetConfig = componentConfig.getGlobalConfigSet()) != null) {
                this.updateConfigSetsContent(CollectionsUtils.asList((Object)configSetConfig), parent);
            } else {
                label = new Label(parent, 0);
                label.setText(Messages.get().ComponentSettingView_ComponentHasNoGlobalConfigSet);
                FontFactory.changeStyle((Control)label, (int)1);
                FontFactory.scaleFontSize((Control)label, (double)1.5);
            }
        }
    }

    private void createInstancePart(@NonNull Composite parent) {
        IComponentInstanceConfig componentSetting = this.controller.getComponentInstance(this.componentInput.getUUID());
        if (componentSetting != null) {
            boolean showPeripheralControl;
            String comment = componentSetting.getComment();
            if (!comment.isEmpty()) {
                Label label;
                this.labelName = label = new Label(parent, 0);
                label.setLayoutData((Object)new GridDataComponents(16384, 0x1000000, false, false, 1, 1));
                label.setText(Messages.get().ComponentSettingView_CommentLabel);
                this.labelName = label = new Label(parent, 0);
                label.setLayoutData((Object)new GridDataComponents(16384, 0x1000000, false, false, 1, 1));
                label.setText(UtilsText.safeString((String)UtilsText.cutOffAfter((String)comment, (int)10)));
            }
            this.createNamePart(parent, componentSetting);
            MasterPeripheral masterPeripheral = componentSetting.getMode().getMasterPeripheral();
            boolean showModeControl = !componentSetting.isOptionSet("UI_COMPONENT_MODE_HIDDEN");
            boolean bl = showPeripheralControl = masterPeripheral != null;
            if (showModeControl && showPeripheralControl) {
                this.createModeAndPeripheralLine(parent, componentSetting, Objects.requireNonNull(masterPeripheral));
            } else {
                if (showModeControl) {
                    this.createModeControl(componentSetting, parent);
                }
                if (masterPeripheral != null) {
                    this.createPeripheralControl(componentSetting, masterPeripheral, parent);
                }
            }
            String componentType = this.getComponentType();
            if (this.controller.hasGlobalConfigSet(componentType)) {
                this.createLinkToGlobalConfig(componentType);
            }
            this.createControlsOfInstance(parent, componentSetting);
            this.updateControls(IChildControl.UpdateType.NORMAL);
        }
    }

    private @NonNull String getComponentType() {
        IComponentInstanceConfig instance;
        String componentType = this.componentInput.getComponentType();
        if (UtilsText.isEmpty((String)componentType) && (instance = this.controllerWrapper.getController().getComponentInstance(this.componentInput.getUUID())) != null) {
            componentType = instance.getType();
        }
        return componentType;
    }

    private String getComponentName() {
        IComponentInstanceConfig instance;
        String componentName = this.componentInput.getComponent();
        if (UtilsText.isEmpty((String)componentName) && (instance = this.controllerWrapper.getController().getComponentInstance(this.componentInput.getUUID())) != null) {
            componentName = instance.getName();
        }
        return componentName;
    }

    private void createControlsOfInstance(@NonNull Composite parent, @NonNull IComponentInstanceConfig instance) {
        IChildControl componentSettingControlLoc = this.componentSettingControl;
        if (componentSettingControlLoc == null || !componentSettingControlLoc.getChild().equals(instance) || componentSettingControlLoc.isDisposed()) {
            if (componentSettingControlLoc != null) {
                componentSettingControlLoc.dispose();
            }
            this.componentSettingControl = componentSettingControlLoc = ChildControlFactory.create((IChild)instance, this.controllerWrapper, null);
            if (componentSettingControlLoc != null) {
                componentSettingControlLoc.setParentControl(null);
                componentSettingControlLoc.getControlOptions().labelHidden(true);
                componentSettingControlLoc.getControlOptions().borderHidden(true);
            }
        }
        if (componentSettingControlLoc != null) {
            componentSettingControlLoc.create(parent, 2);
        }
    }

    private void createModeAndPeripheralLine(@NonNull Composite parent, @NonNull IComponentInstanceConfig instance, @NonNull MasterPeripheral masterPeripheral) {
        Composite modePeripheralComposite = new Composite(parent, 0);
        GridLayoutComponents layout = new GridLayoutComponents(10, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        modePeripheralComposite.setLayout((Layout)layout);
        modePeripheralComposite.setLayoutData((Object)new GridDataComponents(4, 4, true, false, 2, 1));
        Composite modeComposite = new Composite(modePeripheralComposite, 0);
        GridLayoutComponents modeCompositeLayout = new GridLayoutComponents(2, false);
        modeCompositeLayout.marginWidth = 0;
        modeCompositeLayout.marginHeight = 0;
        modeComposite.setLayout((Layout)modeCompositeLayout);
        modeComposite.setLayoutData((Object)new GridDataComponents(4, 4, true, false, 6, 1));
        this.createModeControl(instance, modeComposite);
        Composite peripheralComposite = new Composite(modePeripheralComposite, 0);
        GridLayoutComponents peripheralCompositeLayout = new GridLayoutComponents(2, false);
        peripheralCompositeLayout.marginWidth = 0;
        peripheralCompositeLayout.marginHeight = 0;
        peripheralComposite.setLayout((Layout)peripheralCompositeLayout);
        peripheralComposite.setLayoutData((Object)new GridDataComponents(4, 4, true, false, 4, 1));
        this.createPeripheralControl(instance, masterPeripheral, peripheralComposite);
    }

    private void createNamePart(@NonNull Composite parent, final @NonNull IComponentInstanceConfig instance) {
        Label label;
        Composite nameComposite = new Composite(parent, 0);
        GridLayoutComponents layout = new GridLayoutComponents(4, false);
        layout.marginWidth = 0;
        nameComposite.setLayout((Layout)layout);
        nameComposite.setLayoutData((Object)new GridDataComponents(4, 0x1000000, true, false, 2, 1));
        this.labelName = label = new Label(nameComposite, 0);
        label.setLayoutData((Object)new GridDataComponents(16384, 0x1000000, false, false));
        label.setText(Messages.get().ComponentEditor_Name);
        IChild component = this.getComponent();
        Text text = new Text(nameComposite, 2048);
        if (instance.isCustomNameEnabled()) {
            text.setTextLimit(31);
        } else {
            text.setEnabled(false);
        }
        this.textBoxName = text;
        text.setText(component != null ? component.getUiName() : "");
        TextBoxHelper.attachModifyListeners((Text)text, newName -> this.controller.runTransaction(() -> {
            if (this.controller.renameComponentInstance(instance, newName, (Object)this, true)) {
                this.componentInput.setComponent((String)newName);
                this.setPartName((String)newName);
                this.updateControls(IChildControl.UpdateType.NORMAL);
            }
        }));
        TextBoxHelper.attachModifyErrorListener(() -> instance.getUiName(), (Text)text, newName -> {
            boolean isSameText = instance.getUiName().equalsIgnoreCase((String)newName);
            boolean isNameUsable = this.controller.isNameUsable(newName);
            String errorText = null;
            if (!isNameUsable) {
                errorText = Messages.get().ComponentEditor_NameNotUniqueError;
            }
            if (isSameText) {
                errorText = instance.getNotUniqueNameError();
            }
            String error = errorText;
            this.nameIsValid = errorText == null;
            ControlDecorationUtils.updateControlDecoration((Control)text, () -> error);
            this.updateTooltips();
            if (errorText != null) {
                return TextBoxHelper.Status.INVALID;
            }
            return TextBoxHelper.Status.OK;
        });
        if (instance.getNotUniqueNameError() != null) {
            this.nameIsValid = false;
            text.setBackground(ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.error_BG"));
            text.setForeground(ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.error_FG"));
        }
        ControlDecorationUtils.createErrorDecoration((Control)text, (int)0, (Image)ToolsImages.getStatusDecoratorImg((int)2));
        SWTFactoryProxy.INSTANCE.setTestId((Widget)text, "periphsCompNameEditor");
        text.setLayoutData((Object)new GridDataComponents(4, 0x1000000, true, false));
        label = new Label(nameComposite, 0);
        label.setText(Messages.get().ComponentSettingView_CustomName);
        ToolTipableImplementation tooltipCustomName = new ToolTipableImplementation();
        tooltipCustomName.setUiName(Messages.get().ComponentSettingView_CustomName);
        tooltipCustomName.setDescription(Messages.get().ComponentSettingView_CustomNameDescription);
        String toolTipText = ToolTipableFormatter.getToolTipText((IToolTipable)new ToolTipableMarkdownDescriptionDecorator((IToolTipable)tooltipCustomName));
        SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)label, toolTipText);
        label.setLayoutData((Object)new GridDataComponents(16384, 0x1000000, false, false));
        this.labelCustomName = label;
        final Button button = new Button(nameComposite, 32);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)button, "periphsCompNameCustomCheckbox");
        button.setLayoutData((Object)new GridDataComponents(16384, 0x1000000, false, false));
        button.setSelection(instance.isCustomNameEnabled());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComponentSettingView.this.controller.setInstanceToCustomNameMode(instance, button.getSelection(), ComponentSettingView.class);
            }
        });
        SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)button, toolTipText);
        this.buttonCustomName = button;
    }

    private void createPeripheralControl(@NonNull IComponentInstanceConfig instance, @NonNull MasterPeripheral masterPeripheral, @NonNull Composite composite) {
        InstantSearchList combo;
        Label label;
        this.labelPeripheral = label = new Label(composite, 0);
        label.setLayoutData((Object)new GridDataComponents(16384, 0x1000000, false, false));
        label.setText(Messages.get().ComponentEditor_Peripheral);
        this.comboBoxPeripheral = combo = new InstantSearchList(composite, 2048);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)combo, "periphsCompPeriphCombo");
        GridDataComponents layoutData = new GridDataComponents(4, 4, true, false);
        combo.setLayoutData((Object)layoutData);
        IFunctionalGroup functionalGroup = instance.getChildContext().getFunctionalGroup();
        if (functionalGroup == null) {
            LOGGER.log(Level.SEVERE, "Instance {0} is not part of any functional group. Functional group is required here.", instance.getName());
            return;
        }
        @NonNull String[] items = (String[])masterPeripheral.getPeripherals().stream().map(x -> functionalGroup.getAvailablePeripherals(x)).flatMap(x -> x.stream()).toArray(String[]::new);
        combo.setItems(items);
        IRegistersDatabaseAPI registersDb = this.controllerWrapper.getController().getMcu().getRegistersDb();
        if (registersDb != null) {
            String[] stringArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String fullName;
                String item = stringArray[n2];
                StringBuilder builder = new StringBuilder(item);
                IRegParentPeripheralAPI peripheral = registersDb.getPeripheral(item);
                if (peripheral != null && (fullName = peripheral.getFullName()) != null) {
                    builder.append(" ").append("-").append(" ").append(fullName);
                }
                combo.addItemToolTip(item, builder.length() == 0 ? null : builder.toString());
                ++n2;
            }
        }
        ControlDecorationUtils.createErrorDecoration((Control)combo, (int)16512, (Image)ToolsImages.getStatusDecoratorImg((int)2));
        String selectedPeripheral = instance.getPeripheral();
        if (selectedPeripheral != null) {
            combo.setSelection(selectedPeripheral);
        }
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IWorkbenchPartSite partSite = ComponentSettingView.this.getSite();
                if (!$assertionsDisabled && partSite == null) {
                    throw new AssertionError();
                }
                if (!partSite.getPage().isPartVisible((IWorkbenchPart)ComponentSettingView.this)) {
                    return;
                }
                String peripheralToSet = UtilsText.safeString((String)((InstantSearchList)e.widget).getText());
                ProgressUtils.run(m -> {
                    String uuid = ComponentSettingView.this.componentInput.getUUID();
                    ComponentSettingView.this.controller.setPeripheral(uuid, peripheralToSet, (Object)ComponentSettingView.this);
                });
                ComponentSettingView.this.recreate();
            }
        });
        Color background = combo.getDisplay().getSystemColor(25);
        if (instance.getMasterPeripheralError() != null) {
            background = ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.error_BG");
        }
        combo.setBackground(background);
    }

    private void createModeControl(@NonNull IComponentInstanceConfig instance, @NonNull Composite composite) {
        InstantSearchList modeComboLoc;
        Label label;
        this.labelMode = label = new Label(composite, 0);
        label.setLayoutData((Object)new GridDataComponents(16384, 0x1000000, false, false));
        label.setText(Messages.get().ComponentEditor_Mode);
        this.comboBoxMode = modeComboLoc = new InstantSearchList(composite, 2048);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)modeComboLoc, "periphsCompModeCombo");
        modeComboLoc.setLayoutData((Object)new GridDataComponents(4, 4, true, false));
        modeComboLoc.setItems(this.getAvailableModeLabels(instance));
        modeComboLoc.select(instance.getMode().getUIName(instance.getExpressionContext()));
        modeComboLoc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IWorkbenchPartSite site = ComponentSettingView.this.getSite();
                if (!$assertionsDisabled && site == null) {
                    throw new AssertionError();
                }
                if (!site.getPage().isPartVisible((IWorkbenchPart)ComponentSettingView.this)) {
                    return;
                }
                String modeSelection = UtilsText.safeString((String)((InstantSearchList)e.widget).getText());
                String uuid = ComponentSettingView.this.componentInput.getUUID();
                ProgressUtils.run(m -> ComponentSettingView.this.controller.changeMode(uuid, modeSelection, (Object)ComponentSettingView.this));
                ComponentSettingView.this.recreate();
            }
        });
    }

    public @NonNull String[] getAvailableModeLabels(IComponentInstanceConfig instance) {
        return (String[])instance.getComponent().getScenarios().stream().filter(y -> y.isAvailable(instance.getExpressionContext())).filter(y -> {
            MasterPeripheral masterPeripheral = y.getMasterPeripheral();
            if (masterPeripheral == null) {
                return true;
            }
            for (String periph : masterPeripheral.getPeripherals()) {
                if (this.controller.getMcu().getPeripherals(periph).isEmpty()) continue;
                return true;
            }
            return false;
        }).map(y -> y.getUIName(instance.getExpressionContext())).toArray(String[]::new);
    }

    private static @Nullable String getPeripheralError(@NonNull IComponentInstanceConfig config) {
        return config.getMasterPeripheralError();
    }

    private void createLinkToGlobalConfig(final @NonNull String componentType) {
        Label label = new Label(this.contentComposite, 258);
        label.setLayoutData((Object)new GridDataComponents(4, 0x1000000, true, false, 2, 1));
        label = new Label(this.contentComposite, 0);
        label.setLayoutData((Object)new GridDataComponents(16384, 128, false, false, 2, 1));
        label = new Label(this.contentComposite, 0);
        label.setLayoutData((Object)new GridDataComponents(16384, 128, false, false, 1, 1));
        label.setText(Messages.get().ComponentEditor_ComponentGlobalSettings);
        FontFactory.changeStyle((Control)label, (int)1);
        Link link = new Link(this.contentComposite, 0);
        link.setLayoutData((Object)new GridDataComponents(16384, 0x1000000, false, false, 1, 1));
        link.setText("<A>" + componentType + "</A>");
        SWTFactoryProxy.INSTANCE.setTestId((Widget)link, "periphsCompGlobalConfigSetLink");
        link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GlobalComponentSettingView.open(ComponentSettingView.this.getSiteSafe().getPage(), componentType, null);
            }
        });
    }

    private static void createLinkToDocumentation(@NonNull Composite parent, final @NonNull ConfigurationComponentTypeId confCompTypeId) {
        Button btn = new Button(parent, 0);
        Image img = ToolsImages.getImage((String)"views/documentation.png");
        if (img == null) {
            assert (false) : "image not found: views/documentation.png";
        } else {
            btn.setImage(img);
        }
        SWTFactoryProxy.INSTANCE.setTestId((Widget)btn, "periphsComponentSettingViewDocumentation");
        SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)btn, UtilsText.safeString((String)Messages.get().ComponentSettingView_Documentation));
        btn.setLayoutData((Object)new GridDataComponents(16384, 0x1000000, false, false));
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IViewSite viewSite;
                IViewPart viewPart = ComponentSettingViewHelper.getViewPart();
                if (viewPart != null && (viewSite = viewPart.getViewSite()) != null) {
                    DocumentationView.open(viewSite, confCompTypeId.getTypeId(), true);
                }
            }
        });
    }

    private void createEnableButton(@NonNull Composite parent, final @NonNull IComponentInstanceConfig componentInstanceConfig) {
        Runnable action = new Runnable(){

            @Override
            public void run() {
                ProgressUtils.run(m -> ComponentSettingView.this.controller.setComponentInstancesEnabled((Collection)CollectionsUtils.asList((Object)componentInstanceConfig), !componentInstanceConfig.isEnabled(), (Object)this));
                ComponentSettingView.this.recreate();
            }
        };
        ToggleButton toggleButton = new ToggleButton(parent, componentInstanceConfig.isEnabled(), "periphsEnableInstanceButton_" + this.getComponentName(), action);
        SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)toggleButton, Messages.get().ComponentSettingView_EnableDisableComponentInstance);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)toggleButton, "periphsEnableInstanceButton_" + this.getComponentName());
        toggleButton.setLayoutData((Object)new GridDataComponents(16384, 0x1000000, false, false));
        ToolView.disableGlobalControlOfEnabledFlag((Widget)toggleButton);
    }

    private void createLockButton(@NonNull Composite parent, final @NonNull IComponentInstanceConfig componentInstanceConfig) {
        final Runnable action = new Runnable(){

            @Override
            public void run() {
                ProgressUtils.run(m -> ComponentSettingView.this.controller.setEditingLockOfInstance(componentInstanceConfig, !componentInstanceConfig.isEditingLocked()));
            }
        };
        Button button = new Button(parent, 2);
        button.setImage(ToolsImages.getImage((String)(componentInstanceConfig.isEditingLocked() ? "icons/locked.png" : "icons/unlocked.png")));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(@NonNull SelectionEvent e) {
                action.run();
            }
        });
        SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)button, componentInstanceConfig.isEditingLocked() ? Messages.get().ComponentSettingView_UnlockEditingOfComponentInstance : Messages.get().ComponentSettingView_LockEditingOfComponentInstance);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)button, "periphsLockEditingButton");
        button.setLayoutData((Object)new GridDataComponents(16384, 0x1000000, false, false));
    }

    private void updateConfigSetsContent(@NonNull List<IConfigSetConfig> configSets, @NonNull Composite composite) {
        this.configSetControls.keySet().retainAll(configSets);
        for (IConfigSetConfig configSet : configSets) {
            ConfigSetControl configSetControl = this.configSetControls.get(configSet);
            if (configSetControl == null) {
                configSetControl = (ConfigSetControl)ChildControlFactory.create((IChild)configSet, PeriphControllerWrapper.getInstance(), null);
            }
            if (configSetControl == null) {
                LOGGER.log(Level.SEVERE, "[TOOL] Attempt to create control failed for config set: {0}", configSet);
                continue;
            }
            configSetControl.create(composite, 3);
            configSetControl.update(IChildControl.UpdateType.NORMAL);
            this.configSetControls.put(configSet, configSetControl);
        }
    }

    void recreate() {
        block10: {
            if (this.contentComposite.isDisposed()) {
                return;
            }
            this.contentComposite.setRedraw(false);
            try {
                try {
                    if (this.resizeListener != null) {
                        this.contentComposite.removeListener(11, this.resizeListener);
                    }
                    if (this.componentSettingControl != null) {
                        this.componentSettingControl.dispose();
                    }
                    for (ConfigSetControl configSetControl : this.configSetControls.values()) {
                        configSetControl.dispose();
                    }
                    Control[] controlArray = this.contentComposite.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control ctrl = controlArray[n2];
                        ctrl.dispose();
                        ++n2;
                    }
                    this.createContent();
                }
                catch (ExpressionException e) {
                    e.log();
                    this.contentComposite.setRedraw(true);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                this.contentComposite.setRedraw(true);
                throw throwable;
            }
            this.contentComposite.setRedraw(true);
        }
        this.contentComposite.layout();
    }

    public static boolean open(@NonNull IViewSite viewSite, @NonNull String componentType, @NonNull String componentName, boolean global, boolean activate) {
        IWorkbenchPage iWorkbenchPage = viewSite.getPage();
        if (iWorkbenchPage != null) {
            return ComponentSettingView.open(iWorkbenchPage, componentType, componentName, global, activate, null);
        }
        return false;
    }

    public static boolean open(@NonNull IViewSite viewSite, @NonNull String uuid, boolean activate) {
        IWorkbenchPage iWorkbenchPage = viewSite.getPage();
        if (iWorkbenchPage != null) {
            return ComponentSettingView.open(iWorkbenchPage, uuid, activate, null);
        }
        return false;
    }

    public static boolean open(@Nullable IWorkbenchPage workbenchPage, @NonNull String componentType, @NonNull String componentName, boolean global, boolean activate, @Nullable IChild problematicChild) {
        if (workbenchPage != null) {
            ComponentSettingViewHelper.getInstance().reopenInvalidViews();
            try {
                if (global) {
                    componentName = "";
                }
                ComponentSettingViewInput input = new ComponentSettingViewInput(componentType, componentName, false);
                String identificationBase = ComponentSettingViewHelper.createSecondaryId(input);
                ComponentSettingView.openView(workbenchPage, identificationBase, activate, problematicChild);
                return true;
            }
            catch (PartInitException partInitException) {
                return false;
            }
        }
        return false;
    }

    private static void openView(@NonNull IWorkbenchPage workbenchPage, @NonNull String identificationBase, boolean activate, @Nullable IChild problematicChild) throws PartInitException {
        Integer lastOpenOccurrence = -1;
        Set<@NonNull Integer> permittedOccurrences = ComponentSettingViewHelper.getInstance().getPermittedOccurrences(identificationBase);
        for (Integer i : permittedOccurrences) {
            String identification = String.valueOf(identificationBase) + SECONDARY_ID_IDENTIFICATION_OCCURENCE_SEPARATOR + i.toString();
            boolean viewPresent = Arrays.asList(workbenchPage.getViewReferences()).stream().filter(x -> ID.equals(x.getId())).anyMatch(x -> identification.equals(x.getSecondaryId()));
            if (!viewPresent) {
                IViewPart view = workbenchPage.showView(ID, identification, activate ? 1 : 2);
                if (problematicChild != null && view != null) {
                    ComponentSettingView.focusOnChild(view, problematicChild);
                }
                return;
            }
            lastOpenOccurrence = i;
        }
        if (lastOpenOccurrence != -1) {
            IViewPart view = workbenchPage.showView(ID, String.valueOf(identificationBase) + SECONDARY_ID_IDENTIFICATION_OCCURENCE_SEPARATOR + lastOpenOccurrence.toString(), activate ? 1 : 2);
            if (problematicChild != null && view != null) {
                ComponentSettingView.focusOnChild(view, problematicChild);
            }
        }
    }

    public static boolean open(@Nullable IWorkbenchPage workbenchPage, @NonNull String uuid, boolean activate, @Nullable IChild problematicChild) {
        if (workbenchPage != null) {
            ComponentSettingViewHelper.getInstance().reopenInvalidViews();
            try {
                ComponentSettingViewInput input = new ComponentSettingViewInput("", "", false);
                input.setUUID(uuid);
                ComponentSettingView.openView(workbenchPage, ComponentSettingViewHelper.createSecondaryId(input), activate, problematicChild);
                return true;
            }
            catch (PartInitException partInitException) {
                return false;
            }
        }
        return false;
    }

    public static void focusOnChild(@NonNull IViewPart view, @NonNull IChild child) {
        if (view instanceof ComponentSettingView) {
            ComponentSettingView settingView = (ComponentSettingView)view;
            if (!settingView.isViewFocused()) {
                Objects.requireNonNull(settingView.getToolMainControl()).setFocus();
            }
            settingView.contentComposite.getDisplay().asyncExec(() -> {
                IComponentInstanceConfig compInstance = componentSettingView.controller.getComponentInstance(componentSettingView.componentInput.getUUID());
                if (compInstance != null) {
                    ScrolledComposite scrolledComposite;
                    Composite composite;
                    String childId = child.getId();
                    String compInstanceName = compInstance.getName();
                    IChildControl instanceControl = componentSettingView.componentSettingControl;
                    if (instanceControl != null && (composite = instanceControl.getContent()) != null && (scrolledComposite = ScrolledCompositeHelper.findScrolledComposite((Control)composite)) != null) {
                        if (SwToolsProduct.isUctProduct()) {
                            ComponentSettingViewHelper.selectChildrenOnPath(instanceControl, child.getId(), null, compInstance.isEditingLocked() ? IChildControl.UpdateType.FORCE_DISABLE : IChildControl.UpdateType.NORMAL);
                        } else {
                            ComponentSettingViewHelper.selectChildrenOnPath(instanceControl, child.getId(), compInstance.isEditingLocked() ? IChildControl.UpdateType.FORCE_DISABLE : IChildControl.UpdateType.NORMAL);
                        }
                        if (childId.equals(compInstanceName)) {
                            ScrolledCompositeHelper.scrollByNumberOfLines((Composite)composite, (int)1, (int)(-scrolledComposite.getOrigin().y));
                        } else {
                            String childTestID = "periphsSettCtrl_" + childId;
                            Control control = ScrolledCompositeHelper.getControlWithTestId((Composite)composite, (String)childTestID);
                            if (control != null) {
                                if (KEPreferences.isAnimationsEnabled()) {
                                    ScrolledCompositeHelper.animateScrollToControlWithId((Composite)composite, (String)childTestID);
                                } else {
                                    ScrolledCompositeHelper.scrollToControlWithId((Composite)composite, (String)childTestID);
                                }
                                control.setFocus();
                            } else {
                                Integer offset = ComponentSettingView.getOffsetToArrayRow(instanceControl, childId);
                                if (offset != null) {
                                    composite.getDisplay().asyncExec(() -> ScrolledCompositeHelper.scrollByNumberOfLines((Composite)composite, (int)1, (int)offset));
                                }
                            }
                        }
                    }
                }
            });
        }
    }

    private static Integer getOffsetToArrayRow(@NonNull IChildControl childControl, @NonNull String childId) {
        Integer offset = null;
        String currentChildID = childControl.getChild().getId();
        if (childId.equals(currentChildID)) {
            return ComponentSettingView.getArrayRowNumber(childControl.getChild());
        }
        if (childControl instanceof ChildProvidableControlBase) {
            ChildProvidableControlBase childProvidableControlBase = (ChildProvidableControlBase)childControl;
            List<@NonNull IChildControl> children = childProvidableControlBase.getChildren();
            for (IChildControl child : children) {
                offset = ComponentSettingView.getOffsetToArrayRow(child, childId);
                if (offset == null) continue;
                if (childControl instanceof ArrayControl) {
                    ArrayControl arrayControl = (ArrayControl)childControl;
                    return arrayControl.getOffsetToRow(offset);
                }
                return offset;
            }
        }
        return offset;
    }

    private static Integer getArrayRowNumber(IChild child) {
        if (child != null) {
            IChildProvidable parent = child.getChildContext().getParent();
            if (parent != null && parent instanceof ArrayConfig) {
                return new Integer(parent.getChildren().indexOf(child));
            }
            return ComponentSettingView.getArrayRowNumber((IChild)parent);
        }
        return null;
    }

    protected void refreshStatus() {
        this.refreshStatusBar();
    }

    void refreshSettings(@NonNull IChildControl.UpdateType updateType) {
        this.updateErrorIndicators();
        this.updateControls(updateType);
        this.updateErrorDecorators();
        this.updateTooltips();
        if (updateType != IChildControl.UpdateType.PROBLEM_DECORATION) {
            IComponentInstanceConfig componentSetting = this.controller.getComponentInstance(this.getComponentType(), this.getComponentName());
            InstantSearchList combo = this.comboBoxMode;
            if (componentSetting != null && combo != null && !combo.isDisposed()) {
                combo.setItems(this.getAvailableModeLabels(componentSetting));
                combo.select(componentSetting.getMode().getUIName(componentSetting.getExpressionContext()));
            }
            this.scrolledComposite.setMinHeight(this.contentComposite.computeSize((int)this.scrolledComposite.getClientArea().width, (int)-1).y);
        }
    }

    void updateControls(@NonNull IChildControl.UpdateType updateType) {
        this.contentComposite.setRedraw(false);
        Profiler profiler = Profiler.getInstance((Object)"Peripherals");
        BigInteger index = profiler.start(ComponentSettingView.class, (Object)(!profiler.isEnabled() ? "" : "Component settings view update of " + this.getComponentName()));
        IChild component = this.getComponent();
        if (component != null) {
            updateType = ((IComponentInstanceConfig)component).isEditingLocked() ? IChildControl.UpdateType.FORCE_DISABLE : updateType;
        }
        IChildControl.UpdateType finalUpdateType = updateType;
        try {
            if (this.componentSettingControl != null) {
                this.componentSettingControl.update(finalUpdateType);
            }
            this.configSetControls.values().forEach(x -> x.update(finalUpdateType));
            if (finalUpdateType != IChildControl.UpdateType.PROBLEM_DECORATION) {
                Control[] controls;
                boolean enabled = component != null && component.isEnabled() && !((IComponentInstanceConfig)component).isEditingLocked();
                Control[] controlArray = controls = new Control[]{this.comboBoxMode, this.comboBoxPeripheral, this.buttonCustomName, this.labelName, this.labelMode, this.labelPeripheral, this.labelCustomName};
                int n = controls.length;
                int n2 = 0;
                while (n2 < n) {
                    Control control = controlArray[n2];
                    if (control != null && !control.isDisposed()) {
                        control.setEnabled(enabled);
                    }
                    ++n2;
                }
                Text textBoxNameLoc = this.textBoxName;
                if (textBoxNameLoc != null && component != null) {
                    boolean customNameEnabled = ((IComponentInstanceConfig)component).isCustomNameEnabled();
                    textBoxNameLoc.setEnabled(customNameEnabled && enabled);
                }
                this.updateTooltips();
            }
        }
        finally {
            this.contentComposite.setRedraw(true);
            profiler.stop(index, ComponentSettingView.class, null);
        }
    }

    void updateTooltips() {
        InstantSearchList combobox;
        ToolTipableImplementation tooltipName = new ToolTipableImplementation();
        ToolTipableImplementation tooltipMode = new ToolTipableImplementation();
        ToolTipableImplementation tooltipPeripheral = new ToolTipableImplementation();
        IComponentInstanceConfig componentSetting = this.controller.getComponentInstance(this.componentInput.getUUID());
        if (componentSetting == null) {
            return;
        }
        Text textbox = this.textBoxName;
        if (textbox != null) {
            if (!textbox.isDisposed()) {
                String nameValue = UtilsText.safeString((String)textbox.getText());
                String error = this.getNameErrorMessageTooltip(componentSetting, nameValue);
                tooltipName.setError(error);
                tooltipName.setValueName(nameValue);
            }
            tooltipName.setUiName(Messages.get().ComponentEditor_Name);
            tooltipName.setDescription(Messages.get().ComponentEditor_NameDescription);
        }
        if ((combobox = this.comboBoxMode) != null) {
            if (!combobox.isDisposed()) {
                String markDownToHtml = MarkDownSupport.markDownToHtml((String)(String.valueOf(combobox.getText()) + " " + "\u2013" + " " + componentSetting.getMode().getDescription()), null);
                tooltipMode.setValueName(markDownToHtml);
            }
            tooltipMode.setUiName(Messages.get().ComponentEditor_Mode);
            tooltipMode.setDescription(Messages.get().ComponentEditor_ModeDescription);
        }
        if ((combobox = this.comboBoxPeripheral) != null && !combobox.isDisposed()) {
            String peripheral = combobox.getText();
            if (!combobox.isDisposed()) {
                IRegParentPeripheralAPI peripheralDb;
                tooltipPeripheral.setValueName(peripheral);
                IRegistersDatabaseAPI registersDb = this.controllerWrapper.getController().getMcu().getRegistersDb();
                if (registersDb != null && (peripheralDb = registersDb.getPeripheral(peripheral)) != null) {
                    tooltipPeripheral.setValueDescription(peripheralDb.getFullName());
                }
            }
            tooltipPeripheral.setUiName(Messages.get().ComponentEditor_Peripheral);
            tooltipPeripheral.setDescription(Messages.get().ComponentEditor_PeripheralDescription);
            tooltipPeripheral.setError(ComponentSettingView.getPeripheralError(componentSetting));
        }
        ToolTipableImplementation[] tooltips = new ToolTipableImplementation[]{tooltipName, tooltipMode, tooltipPeripheral};
        Label[] labels = new Label[]{this.labelName, this.labelMode, this.labelPeripheral};
        Control[] editors = new Control[]{this.textBoxName, this.comboBoxMode, this.comboBoxPeripheral};
        int index = 0;
        while (index < tooltips.length) {
            Control nonNullEditor;
            ToolTipableImplementation tooltip = tooltips[index];
            Label label = labels[index];
            Control editor = editors[index];
            String toolTipText = ToolTipableFormatter.getToolTipText((IToolTipable)new ToolTipableMarkdownDescriptionDecorator((IToolTipable)tooltip));
            Label nonNullLabel = label;
            if (nonNullLabel != null && !nonNullLabel.isDisposed()) {
                SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)nonNullLabel, toolTipText);
            }
            if ((nonNullEditor = editor) != null && !nonNullEditor.isDisposed()) {
                SWTFactoryProxy.INSTANCE.setHtmlTooltip(nonNullEditor, toolTipText);
            }
            ++index;
        }
    }

    private @Nullable String getNameErrorMessageTooltip(@NonNull IComponentInstanceConfig instance, @NonNull String newName) {
        boolean nameIsIdentifier = APeriphController.isNameValid((String)newName);
        String error = null;
        if (!this.nameIsValid) {
            error = nameIsIdentifier ? instance.getNameConflictErrorInternal(instance, newName) : Messages.get().ComponentEditor_NameNotIdentifierError;
        } else {
            String notUniqueNameError = instance.getNotUniqueNameError();
            if (notUniqueNameError != null) {
                error = notUniqueNameError;
            }
        }
        return error;
    }

    private @Nullable IChild getComponent() {
        ComponentSettingViewInput componentInputLoc = this.componentInput;
        if (componentInputLoc != null) {
            if (componentInputLoc.isGlobalConfig()) {
                return this.controller.getConfiguredComponent(componentInputLoc.getComponentType());
            }
            if (!componentInputLoc.getUUID().isEmpty()) {
                return this.controller.getComponentInstance(componentInputLoc.getUUID());
            }
            return this.controller.getComponentInstance(componentInputLoc.getComponentType(), componentInputLoc.getComponent());
        }
        return null;
    }
}

