/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.view;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.periphs.model.templates.component.ComponentTemplateProperties;
import com.nxp.swtools.resourcetables.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.resourcetables.model.data.Description;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class AddComponentDialogEntry {
    @NonNull
    private ConfigurationComponentTypeId component;
    @Nullable
    private ComponentTemplateProperties templateProperties = null;
    @Nullable
    private AddComponentDialogEntry parent = null;
    @NonNull
    private List<AddComponentDialogEntry> templateEntries = Collections.emptyList();

    public AddComponentDialogEntry(@NonNull ConfigurationComponentTypeId component) {
        this.component = component;
    }

    public AddComponentDialogEntry(@NonNull AddComponentDialogEntry parent, @NonNull ComponentTemplateProperties templateProperties) {
        this(parent.getComponent());
        this.templateProperties = templateProperties;
        this.parent = parent;
    }

    public @NonNull ConfigurationComponentTypeId getComponent() {
        return this.component;
    }

    public @Nullable ComponentTemplateProperties getTemplateProperties() {
        return this.templateProperties;
    }

    private @NonNull ComponentTemplateProperties getTemplatePropertiesNonNull() {
        assert (this.templateProperties != null) : "Template is null. Add check before calling this function";
        return this.templateProperties;
    }

    public boolean isTemplateEntry() {
        return this.templateProperties != null;
    }

    public boolean isComponentHidden() {
        return this.getComponent().getConfigurationComponent().isHidden();
    }

    public boolean hasTemplates() {
        return !this.templateEntries.isEmpty();
    }

    public @Nullable AddComponentDialogEntry getParent() {
        return this.parent;
    }

    public @NonNull List<AddComponentDialogEntry> getTemplateEntries() {
        return CollectionsUtils.unmodifiableList(this.templateEntries);
    }

    public void setTemplateEntries(@NonNull List<AddComponentDialogEntry> entries) {
        this.templateEntries = new ArrayList<AddComponentDialogEntry>(entries);
    }

    public boolean addTemplateEntry(@NonNull AddComponentDialogEntry entry) {
        if (!(this.templateEntries instanceof ArrayList)) {
            this.templateEntries = new ArrayList<AddComponentDialogEntry>();
        }
        return this.templateEntries.add(entry);
    }

    public @NonNull String getName(@NonNull IContext context) {
        if (this.isTemplateEntry()) {
            return this.getTemplatePropertiesNonNull().getName();
        }
        return this.getComponent().getConfigurationComponent().getLabel(context);
    }

    public @Nullable String getDescription(@NonNull IContext context) {
        if (this.isTemplateEntry()) {
            return this.getTemplatePropertiesNonNull().getDescription();
        }
        Description description = this.getComponent().getConfigurationComponent().getDescription();
        if (description == null) {
            return null;
        }
        return description.getDescription(context);
    }

    public int hashCode() {
        return Objects.hash(this.component, this.templateProperties, this.parent);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AddComponentDialogEntry other = (AddComponentDialogEntry)obj;
        if (!Objects.equals(this.component, other.component)) {
            return false;
        }
        if (!Objects.equals(this.templateProperties, other.templateProperties)) {
            return false;
        }
        return Objects.equals(this.parent, other.parent);
    }
}

