/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.toolbar;

import com.nxp.swtools.common.ui.utils.dialogs.ShellProvider;
import com.nxp.swtools.common.ui.utils.swt.ControlDecorationUtils;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.ui.utils.swt.widgets.InstantSearchList;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.periphs.gui.view.componentsettings.ComponentSettingViewHelper;
import com.nxp.swtools.periphs.model.config.FunctionalGroup;
import com.nxp.swtools.periphs.model.config.PeriphsProfile;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsFuncGroup;
import com.nxp.swtools.resourcetables.model.config.ChildContext;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.config.IFunctionalGroup;
import com.nxp.swtools.resourcetables.model.config.IRoot;
import com.nxp.swtools.resourcetables.model.mcu.ICommonMcu;
import com.nxp.swtools.utils.dialog.FnGroupPrefix;
import com.nxp.swtools.utils.dialog.IChangeListener;
import com.nxp.swtools.utils.dialog.IFunctionPrefix;
import com.nxp.swtools.utils.dialog.IFunctionalGroupUpdateListener;
import com.nxp.swtools.utils.dialog.ISelectedFunctionProvider;
import com.nxp.swtools.utils.dialog.ISpecificContent;
import com.nxp.swtools.utils.dialog.ToolFunctionModification;
import com.nxp.swtools.utils.events.IEventListener;
import com.nxp.swtools.utils.events.ToolEvent;
import com.nxp.swtools.utils.resources.ToolsColors;
import com.nxp.swtools.utils.resources.ToolsImages;
import com.nxp.swtools.utils.toolbar.AFunctionManager;
import com.nxp.swtools.utils.tools.IToolFunction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class PeriphsToolBarManager
extends AFunctionManager {
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(PeriphsToolBarManager.class);

    public PeriphsToolBarManager() {
        Controller.getInstance().addListener(3, new IEventListener(){

            public void handle(@NonNull ToolEvent event) {
                PeriphsToolBarManager.this.updateFunctionBar();
            }
        });
    }

    public @NonNull List<? extends @NonNull IToolFunction> getFunctions() {
        return Controller.getInstance().getProfile().getFunctionalGroups();
    }

    public @NonNull IToolFunction getWorkingFunction() {
        return Controller.getInstance().getFunctionalGroup();
    }

    public boolean removeFunction(@NonNull IToolFunction function) {
        if (function instanceof IFunctionalGroup) {
            IFunctionalGroup group = (IFunctionalGroup)function;
            boolean allowed = MessageDialog.openQuestion((Shell)PeriphsToolBarManager.getShell(), (String)Messages.get().PeriphsToolBarManager_RemoveGroupDialog_Title, (String)MessageFormat.format(UtilsText.safeString((String)Messages.get().PeriphsToolBarManager_RemoveGroupDialog_Message), group.getName()));
            if (allowed) {
                ComponentSettingViewHelper.getInstance().removeEntriesOfGroup(group.getStorageFuncGroup());
                return Controller.getInstance().removeFunctionalGroup(group, (Object)this);
            }
        }
        return false;
    }

    private static @NonNull Shell getShell() {
        Display display = Display.getCurrent();
        assert (display != null);
        return ShellProvider.getAnyShellParent((Display)display);
    }

    public void setWorkingFunction(@NonNull IToolFunction function) {
        Controller.getInstance().setFunctionalGroup((IFunctionalGroup)function, (Object)this);
    }

    public void update(List<@NonNull ToolFunctionModification> toolFunctions) {
        Controller controller = Controller.getInstance();
        PeriphsProfile profile = controller.getProfile();
        profile.clearFunctionalGroups();
        toolFunctions.forEach(arg_0 -> PeriphsToolBarManager.lambda$0((IRoot)profile, controller, arg_0));
        if (!profile.getFunctionalGroups().contains(controller.getFunctionalGroup())) {
            controller.setFunctionalGroup((IFunctionalGroup)profile.getFunctionalGroups().get(0), (Object)this);
        }
        controller.handleSettingChange(1, (Object)this, UtilsText.safeString((String)com.nxp.swtools.periphs.controller.Messages.get().Controller_Action_ApplyFunctionProperties));
    }

    public @NonNull IToolFunction copyFunction(@NonNull ToolFunctionModification functionToCopy) {
        IFunctionalGroup group = (IFunctionalGroup)functionToCopy.getOriginalFunction();
        ChildContext profileContext = Controller.getInstance().getProfile().getChildContext();
        return new FunctionalGroup(profileContext, new StoragePeriphsFuncGroup(group.getStorageFuncGroup()), group.getMcu());
    }

    public boolean allowMultipleCallFromInit() {
        return false;
    }

    public IFunctionalGroupUpdateListener createSpecificProperties(@NonNull Composite parent, @NonNull ISelectedFunctionProvider selectedFunctionProvider, @NonNull List<@NonNull ToolFunctionModification> functionsSupplier, @NonNull IChangeListener changeListener) {
        ToolFunctionModification function = selectedFunctionProvider.getSelectedFunction();
        if (function != null) {
            FnGroupPrefix fnGroupPrefix = new FnGroupPrefix(parent, selectedFunctionProvider, changeListener, Messages.get().PeriphsFunctionalGroupDialog_IdPrefixTooltip, PeriphsToolBarManager::getToolSpecific);
            InstantSearchList coreCombo = this.fillCombo(selectedFunctionProvider, parent, changeListener);
            return this.getUpdateListener(fnGroupPrefix, coreCombo, changeListener);
        }
        LOGGER.warning("[TOOL] No functional group selected.");
        return null;
    }

    static void selectCoreName(@NonNull ICommonMcu mcu, @NonNull SpecificContent specificContent, @NonNull InstantSearchList coreCombo) {
        String selectedCoreName = "";
        for (ProcessorCore core : mcu.getCores()) {
            if (specificContent.selectedCore.equals("")) {
                specificContent.selectedCore = core.getID();
            }
            if (!specificContent.selectedCore.equals(core.getID())) continue;
            selectedCoreName = core.getName();
        }
        coreCombo.select(selectedCoreName);
    }

    private static void setComboProperties(@NonNull InstantSearchList combo) {
        combo.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        SWTFactoryProxy.INSTANCE.setTestId((Widget)combo, "periphsPropertiesCoreCombo");
        SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)combo, Messages.get().PeriphsFunctionalGroupDialog_CoreTooltip);
    }

    private static void setLabelLayout(@NonNull Label label, @NonNull String text, @NonNull String toolTip) {
        label.setText(text);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)label, toolTip);
    }

    static @NonNull SpecificContent getToolSpecific(@NonNull ToolFunctionModification function) {
        SpecificContent specificContent = (SpecificContent)function.getToolSpecific();
        if (specificContent == null) {
            IFunctionalGroup functionalGroup = (IFunctionalGroup)function.getOriginalFunction();
            specificContent = new SpecificContent();
            specificContent.selectedCore = functionalGroup.getCore();
            specificContent.idPrefix = functionalGroup.getIdPrefix();
            function.setToolSpecific((ISpecificContent)specificContent);
        }
        return specificContent;
    }

    public void setCalledFromDefaultInit(@NonNull IToolFunction function, boolean called) {
        if (!(function instanceof FunctionalGroup)) {
            return;
        }
        Controller.getInstance().setCalledFromDefaultInit((IFunctionalGroup)function, called, (Object)this);
    }

    public boolean isToolSpecificPropertiesValid(@NonNull ToolFunctionModification function, @NonNull List<@NonNull ToolFunctionModification> functions) {
        ISpecificContent toolSpecific = function.getToolSpecific();
        if (toolSpecific instanceof IFunctionPrefix) {
            return FnGroupPrefix.isPrefixValid((IFunctionPrefix)((IFunctionPrefix)toolSpecific));
        }
        return true;
    }

    public String getReservedFunctionName() {
        return "BOARD_InitBootPeripherals";
    }

    public @NonNull IToolFunction createNewFunction(@NonNull String functionName) {
        Controller controller = Controller.getInstance();
        if (controller.isMcuSupported()) {
            FunctionalGroup group = new FunctionalGroup(controller.getProfile().getChildContext(), (ICommonMcu)controller.getMcu());
            group.setName(functionName);
            group.setDescription("");
            group.setCalledFromDefaultInit(false);
            if (!group.setCoreFrom(SharedConfigurationFactory.getSharedConfigurationSingleton().getCommonConfig())) {
                group.setMasterCoreAsUsed();
            }
            if (controller.getProfile().isFunctionalGroupSynchronizationEnabled()) {
                PeriphsToolBarManager.addInstancesInFunctionalGroup((IFunctionalGroup)group);
            }
            return group;
        }
        IFunctionalGroup group = controller.getFunctionalGroup();
        if (controller.getProfile().isFunctionalGroupSynchronizationEnabled()) {
            PeriphsToolBarManager.addInstancesInFunctionalGroup(group);
        }
        return group;
    }

    public int getMaxToolFunctions() {
        return Controller.getInstance().getMaximumNumberOfFunctionalGroups();
    }

    public @NonNull String getDefaultFunctionName() {
        return "PeriphsFunc_";
    }

    static @Nullable ICommonMcu getMcu(@NonNull ToolFunctionModification function) {
        ICommonMcu mcu = null;
        IToolFunction toolFunction = function.getOriginalFunction();
        if (toolFunction instanceof IFunctionalGroup) {
            IFunctionalGroup functionalGroup = (IFunctionalGroup)toolFunction;
            mcu = functionalGroup.getMcu();
        }
        return mcu;
    }

    @NonNull IFunctionalGroupUpdateListener getUpdateListener(final @NonNull FnGroupPrefix fnGroupPrefix, final @Nullable InstantSearchList coreCombo, final @NonNull IChangeListener changeListener) {
        IFunctionalGroupUpdateListener updateListener = new IFunctionalGroupUpdateListener(){

            public void updateFunctionalGroup(@NonNull ToolFunctionModification updatedFunction) {
                SpecificContent specificContentLoc = PeriphsToolBarManager.getToolSpecific(updatedFunction);
                fnGroupPrefix.updateTextAndSelection(updatedFunction);
                ICommonMcu mcuLoc = PeriphsToolBarManager.getMcu(updatedFunction);
                if (mcuLoc != null) {
                    if (mcuLoc.isMulticore() && coreCombo != null) {
                        PeriphsToolBarManager.selectCoreName(mcuLoc, specificContentLoc, coreCombo);
                        ProcessorCore selectedCoreOfProject = SharedConfigurationFactory.getSharedConfigurationSingleton().getCommonConfig().getSelectedCore();
                        ArrayList<@NonNull String> wrongCores = new ArrayList<String>(mcuLoc.getCores().size());
                        for (ProcessorCore core : mcuLoc.getCores()) {
                            if (selectedCoreOfProject == null || core.getID().equals(selectedCoreOfProject.getID())) continue;
                            wrongCores.add(core.getName());
                        }
                        Image warningImg = ToolsImages.getStatusDecoratorImg((int)1);
                        coreCombo.setStatusItemProvider(it -> wrongCores.contains(it) ? warningImg : null);
                        PeriphsToolBarManager.this.updateErrorDecorationOfCoreCombo(updatedFunction, coreCombo);
                    }
                    changeListener.propertiesChange();
                }
            }
        };
        return updateListener;
    }

    @Nullable InstantSearchList fillCombo(final @NonNull ISelectedFunctionProvider functionProvider, @NonNull Composite parent, final @NonNull IChangeListener changeListener) {
        ICommonMcu mcu;
        InstantSearchList combo = null;
        ToolFunctionModification function = functionProvider.getSelectedFunction();
        if (function != null && (mcu = PeriphsToolBarManager.getMcu(function)) != null && mcu.isMulticore()) {
            Label label = new Label(parent, 0);
            combo = new InstantSearchList(parent, 2048);
            PeriphsToolBarManager.setLabelLayout(label, UtilsText.safeString((String)Messages.get().PeriphsFunctionalGroupDialog_Core), UtilsText.safeString((String)Messages.get().PeriphsFunctionalGroupDialog_CoreTooltip));
            PeriphsToolBarManager.setComboProperties(combo);
            ControlDecorationUtils.createErrorDecoration((Control)combo, (int)16512);
            ControlDecorationUtils.setImage((Control)combo, (Image)ToolsImages.getStatusDecoratorImg((int)1));
            for (ProcessorCore core : mcu.getCores()) {
                combo.add(core.getName());
            }
            final InstantSearchList comboLoc = combo;
            combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ToolFunctionModification currentFunction = functionProvider.getSelectedFunction();
                    if (currentFunction != null) {
                        String comboSelectionText = UtilsText.safeString((String)comboLoc.getText());
                        ProcessorCore coreFromSelection = (ProcessorCore)CollectionsUtils.findFirst((Collection)mcu.getCores(), x -> x.getName().equals(comboSelectionText));
                        PeriphsToolBarManager.getToolSpecific((ToolFunctionModification)currentFunction).selectedCore = coreFromSelection != null ? coreFromSelection.getID() : "";
                        comboLoc.setForeground(null);
                        comboLoc.setData("state", (Object)"ok");
                        ControlDecorationUtils.hide((Control)comboLoc);
                        PeriphsToolBarManager.this.updateErrorDecorationOfCoreCombo(currentFunction, comboLoc);
                        changeListener.propertiesChange();
                    }
                }
            });
        }
        return combo;
    }

    void updateErrorDecorationOfCoreCombo(@NonNull ToolFunctionModification function, @NonNull InstantSearchList combo) {
        ProcessorCore selectedCoreOfProject = SharedConfigurationFactory.getSharedConfigurationSingleton().getCommonConfig().getSelectedCore();
        String selectedCoreName = UtilsText.safeString((String)combo.getText());
        ICommonMcu mcu = PeriphsToolBarManager.getMcu(function);
        SpecificContent toolContent = PeriphsToolBarManager.getToolSpecific(function);
        if (selectedCoreOfProject == null) {
            return;
        }
        if (mcu == null) {
            return;
        }
        ProcessorCore coreFromSelection = mcu.getCore(toolContent.selectedCore);
        if (coreFromSelection == null) {
            return;
        }
        if (!selectedCoreName.equals(selectedCoreOfProject.getName())) {
            String message = MessageFormat.format(UtilsText.safeString((String)com.nxp.swtools.periphs.model.Messages.get().FunctionalGroup_DifferentSelectedCore), coreFromSelection.getName(), selectedCoreOfProject.getName());
            combo.setForeground(ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.warning_FG"));
            combo.setData("state", (Object)"warning");
            ControlDecorationUtils.setDescription((Control)combo, (String)message);
            ControlDecorationUtils.show((Control)combo);
        } else {
            combo.setForeground(combo.getDisplay().getSystemColor(24));
            combo.setData("state", (Object)"ok");
            ControlDecorationUtils.setDescription((Control)combo, (String)"");
            ControlDecorationUtils.hide((Control)combo);
        }
    }

    public @Nullable StorageTool getStorageTool() {
        return SWToolsPlatform.getSharedConfigurationSingleton().getTools().getPeripherals();
    }

    private static void addInstancesInFunctionalGroup(IFunctionalGroup group) {
        PeriphsProfile profile = Controller.getInstance().getProfile();
        List instances = profile.getAllInstances();
        for (IComponentInstanceConfig compInstance : instances) {
            if (group.getInstance(compInstance.getName()) != null) continue;
            profile.createComponentInstanceCopy(compInstance, group);
        }
    }

    private static /* synthetic */ void lambda$0(IRoot iRoot, Controller controller, ToolFunctionModification x) {
        IFunctionalGroup group = (IFunctionalGroup)x.getOriginalFunction();
        SpecificContent specific = PeriphsToolBarManager.getToolSpecific(x);
        group.setName(x.getName());
        group.setDescription(x.getDescription());
        group.setCalledFromDefaultInit(x.isCalledFromDefaultInit());
        group.setCore(specific.selectedCore);
        group.setIdPrefix(specific.idPrefix);
        iRoot.addFunctionalGroup(group);
        controller.addAutoAddingInstances(group);
    }

    static class SpecificContent
    implements ISpecificContent,
    IFunctionPrefix {
        @NonNull
        String selectedCore = "";
        @NonNull
        String idPrefix = "";

        public SpecificContent() {
        }

        public SpecificContent(@NonNull SpecificContent copyFrom) {
            this.selectedCore = copyFrom.selectedCore;
            this.idPrefix = copyFrom.idPrefix;
        }

        public @NonNull ISpecificContent createCopy() {
            return new SpecificContent(this);
        }

        public @NonNull String getPrefix() {
            return this.idPrefix;
        }

        public void setPrefix(@NonNull String prefix) {
            this.idPrefix = prefix;
        }

        public boolean isPrefixUserDefined() {
            return true;
        }

        public void setPrefixUserDefined(boolean userDefined) {
        }
    }
}

