/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.handler;

import com.nxp.swtools.common.ui.utils.dialogs.ShellProvider;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.gui.view.componentsettings.CollapsibleSettingsStorageHelper;
import com.nxp.swtools.periphs.gui.view.componentsettings.ProvidableSettingsSelectionStorageHelper;
import com.nxp.swtools.periphs.model.config.PeriphsProfile;
import com.nxp.swtools.resourcetables.model.config.IFunctionalGroup;
import com.nxp.swtools.utils.command.ProcessorResetDialog;
import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;

public class ResetToProcessorDefaultHandler
extends AbstractHandler {
    public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
        Controller controller = Controller.getInstance();
        IFunctionalGroup functionalGroup = controller.getFunctionalGroup();
        ProcessorResetDialog dialog = new ProcessorResetDialog(ShellProvider.getAnyShellParent(), functionalGroup.getName(), controller.hasProcessorMex());
        int result = dialog.open();
        if (result == 0) {
            if (dialog.getResetMethod() == ProcessorResetDialog.ResetMethod.MEX_VALUES) {
                ResetToProcessorDefaultHandler.resetToProcessorDefaultsSynchronized(functionalGroup.getName(), true);
                controller.resetToProcessorMexDefaults(functionalGroup);
            } else {
                ResetToProcessorDefaultHandler.resetToProcessorDefaultsSynchronized(functionalGroup.getName(), false);
                controller.resetToProcessorDefault(functionalGroup);
            }
            CollapsibleSettingsStorageHelper.getInstance().removeSettingStateEntries(functionalGroup.getId());
            ProvidableSettingsSelectionStorageHelper.getInstance().removeSettingStateEntries(functionalGroup.getId());
        }
        return null;
    }

    private static void resetToProcessorDefaultsSynchronized(String functionalGroupName, boolean mexDefaults) {
        Controller controller = Controller.getInstance();
        PeriphsProfile profile = controller.getProfile();
        if (profile.isFunctionalGroupSynchronizationEnabled()) {
            ArrayList fcGroups = new ArrayList(profile.getFunctionalGroups());
            for (IFunctionalGroup group : fcGroups) {
                if (group.getName().equals(functionalGroupName)) continue;
                if (mexDefaults) {
                    controller.resetToProcessorMexDefaults(group);
                    continue;
                }
                controller.resetToProcessorDefault(group);
            }
        }
    }
}

