/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui.dialogs.initializationorder;

import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.ui.utils.swt.widgets.InstantSearchList;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.controller.InitializationPrioritiesHelper;
import com.nxp.swtools.periphs.gui.Messages;
import com.nxp.swtools.periphs.gui.dialogs.initializationorder.InitializationOrderDialogProperties;
import com.nxp.swtools.periphs.gui.dialogs.initializationorder.InitializationOrderGroup;
import com.nxp.swtools.periphs.gui.dialogs.initializationorder.InitializationOrderInstance;
import com.nxp.swtools.periphs.gui.dialogs.initializationorder.InitializationOrderProvider;
import com.nxp.swtools.periphs.model.config.PeriphsProfile;
import com.nxp.swtools.periphs.model.data.InitializationPriorities;
import com.nxp.swtools.periphs.model.data.InitializationPrioritiesGroup;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.config.IFunctionalGroup;
import com.nxp.swtools.resourcetables.model.data.Description;
import com.nxp.swtools.utils.resources.ToolsImages;
import com.nxp.swtools.utils.tools.IToolFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class InitializationOrderDialog
extends Dialog {
    static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger(InitializationOrderDialog.class);
    private final transient InitializationOrderDialogProperties properties;
    @Nullable
    private TreeViewer treeViewer;
    @Nullable
    private transient IFunctionalGroup currentFunctionalGroup = null;
    private transient Map<IFunctionalGroup, LinkedList<IComponentInstanceConfig>> instancesOfGroups = new HashMap<IFunctionalGroup, LinkedList<IComponentInstanceConfig>>();
    @Nullable
    private Button buttonUp;
    @Nullable
    private Button buttonDown;

    protected InitializationOrderDialog(InitializationOrderDialogProperties properties) {
        super(properties.getShell());
        this.properties = properties;
    }

    private InitializationOrderDialogProperties getProperties() {
        return this.properties;
    }

    protected @NonNull Control createDialogArea(@NonNull Composite parent) {
        TreeViewer viewer;
        Composite dialogComposite = (Composite)super.createDialogArea(parent);
        dialogComposite.setLayout((Layout)new GridLayout());
        dialogComposite.getShell().setText(Messages.get().InitializationOrderDialog_DialogHeaderText);
        Label groupLabel = new Label(dialogComposite, 0);
        groupLabel.setText(Messages.get().InitializationOrderDialog_FunctionalGroupLabel);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(true, false).applyTo((Control)groupLabel);
        InstantSearchList combo = new InstantSearchList(dialogComposite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)combo);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)combo, "periphsReorderDialogCombo");
        List groups = this.getProperties().getRoot().getFunctionalGroups();
        groups.forEach(g -> {
            LinkedList linkedList = this.instancesOfGroups.put((IFunctionalGroup)g, new LinkedList(g.getInstances().values()));
        });
        @NonNull String[] functionalGroupNames = (String[])groups.stream().map(IToolFunction::getName).toArray(String[]::new);
        combo.setItems(functionalGroupNames);
        Label viewerLabel = new Label(dialogComposite, 0);
        viewerLabel.setText(Messages.get().InitializationOrderDialog_InitializationOrderLabel);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(true, false).applyTo((Control)viewerLabel);
        Composite viewerComposite = new Composite(dialogComposite, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)viewerComposite);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        viewerComposite.setLayout((Layout)layout);
        this.treeViewer = viewer = new TreeViewer(viewerComposite, 2052);
        Tree tree = viewer.getTree();
        GridDataFactory.fillDefaults().grab(true, true).span(1, 2).applyTo((Control)tree);
        SWTFactoryProxy.INSTANCE.enableHtmlTooltipFor((ColumnViewer)viewer);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)tree, "periphsReorderDialogTree");
        viewer.setContentProvider((IContentProvider)new InitializationOrderProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public @Nullable String getText(Object element) {
                if (element instanceof InitializationOrderGroup) {
                    return ((InitializationOrderGroup)element).getName();
                }
                if (element instanceof InitializationOrderInstance) {
                    InitializationOrderInstance instanceWrapper = (InitializationOrderInstance)element;
                    IComponentInstanceConfig instance = instanceWrapper.getInstance();
                    String componentId = instance.getComponent().getId().toUpperCase(Locale.US);
                    return String.valueOf(instance.getName()) + "[" + componentId + "]";
                }
                return null;
            }

            public @Nullable Font getFont(Object element) {
                return super.getFont(element);
            }

            public @Nullable Color getForeground(Object element) {
                return super.getForeground(element);
            }

            public @Nullable Image getImage(Object element) {
                return super.getImage(element);
            }

            public @Nullable String getToolTipText(@NonNull Object element) {
                if (element instanceof InitializationOrderGroup) {
                    return ((InitializationOrderGroup)element).getDescription();
                }
                if (element instanceof InitializationOrderInstance) {
                    InitializationOrderInstance instanceWrapper = (InitializationOrderInstance)element;
                    IComponentInstanceConfig instance = instanceWrapper.getInstance();
                    StringBuilder builder = new StringBuilder();
                    builder.append(instance.getComment());
                    Description descriptionObject = instance.getComponent().getDescription();
                    if (descriptionObject != null) {
                        if (builder.length() != 0) {
                            builder.append("\r\n");
                        }
                        builder.append("[").append(descriptionObject.getDescription(instance.getExpressionContext())).append("]");
                    }
                    return builder.length() != 0 ? builder.toString() : null;
                }
                return null;
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(@Nullable SelectionChangedEvent event) {
                InitializationOrderDialog.this.updateOrderingButtonsEnabledState();
            }
        });
        viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof InitializationOrderInstance) {
                    return true;
                }
                if (element instanceof InitializationOrderGroup) {
                    return !((InitializationOrderGroup)element).getInstances().isEmpty();
                }
                return false;
            }
        });
        this.createOrderingButtonUp(viewerComposite);
        this.createOrderingButtonDown(viewerComposite);
        this.addComboSelectionListener(combo);
        combo.setSelection(this.getProperties().getControllerWrapper().getController().getFunctionalGroup().getName());
        return dialogComposite;
    }

    void createOrderingButtonUp(Composite composite) {
        Button buttonUpLoc;
        this.buttonUp = buttonUpLoc = new Button(composite, 8);
        buttonUpLoc.setImage(ToolsImages.getImage((String)"icons/up.png"));
        SWTFactoryProxy.INSTANCE.setTestId((Widget)buttonUpLoc, "periphsReorderDialogButtonUp");
        GridDataFactory.fillDefaults().grab(false, true).span(1, 1).applyTo((Control)buttonUpLoc);
        buttonUpLoc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeViewer treeViewerLoc = InitializationOrderDialog.this.getTreeViewer();
                if (treeViewerLoc == null) {
                    return;
                }
                InitializationOrderInstance instance = InitializationOrderDialog.this.getCurrentlySelectedInstance();
                if (instance != null) {
                    instance.getGroup().moveBefore(instance);
                }
                treeViewerLoc.refresh();
                InitializationOrderDialog.this.updateOrderingButtonsEnabledState();
            }
        });
    }

    void createOrderingButtonDown(Composite composite) {
        Button buttonDownLoc;
        this.buttonDown = buttonDownLoc = new Button(composite, 8);
        buttonDownLoc.setImage(ToolsImages.getImage((String)"icons/down.png"));
        SWTFactoryProxy.INSTANCE.setTestId((Widget)buttonDownLoc, "periphsReorderDialogButtonDown");
        GridDataFactory.fillDefaults().grab(false, true).span(1, 1).applyTo((Control)buttonDownLoc);
        buttonDownLoc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeViewer treeViewerLoc = InitializationOrderDialog.this.getTreeViewer();
                if (treeViewerLoc == null) {
                    return;
                }
                InitializationOrderInstance instance = InitializationOrderDialog.this.getCurrentlySelectedInstance();
                if (instance != null) {
                    instance.getGroup().moveAfter(instance);
                }
                treeViewerLoc.refresh();
                InitializationOrderDialog.this.updateOrderingButtonsEnabledState();
            }
        });
    }

    @Nullable InitializationOrderInstance getCurrentlySelectedInstance() {
        TreeViewer treeViewerLoc = this.getTreeViewer();
        if (treeViewerLoc == null) {
            return null;
        }
        ITreeSelection selection = treeViewerLoc.getStructuredSelection();
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof InitializationOrderInstance) {
            return (InitializationOrderInstance)firstElement;
        }
        return null;
    }

    private void updateButtonDownEnabledState() {
        Button button = this.buttonDown;
        if (button == null) {
            return;
        }
        InitializationOrderInstance instance = this.getCurrentlySelectedInstance();
        if (instance != null) {
            button.setEnabled(instance.getGroup().canMoveAfter(instance));
        } else {
            button.setEnabled(false);
        }
    }

    private void updateButtonUpEnabledState() {
        Button button = this.buttonUp;
        if (button == null) {
            return;
        }
        InitializationOrderInstance instance = this.getCurrentlySelectedInstance();
        if (instance != null) {
            button.setEnabled(instance.getGroup().canMoveBefore(instance));
        } else {
            button.setEnabled(false);
        }
    }

    void updateOrderingButtonsEnabledState() {
        this.updateButtonDownEnabledState();
        this.updateButtonUpEnabledState();
    }

    void storeInstances(IFunctionalGroup functionalGroup, LinkedList<IComponentInstanceConfig> instances) {
        this.instancesOfGroups.put(functionalGroup, instances);
    }

    LinkedList<IComponentInstanceConfig> loadInstances(IFunctionalGroup functionalGroup) {
        LinkedList list = this.instancesOfGroups.computeIfAbsent(functionalGroup, x -> new LinkedList());
        assert (list != null);
        return list;
    }

    public void addComboSelectionListener(InstantSearchList combo) {
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            public void widgetSelected(@NonNull SelectionEvent e) {
                IFunctionalGroup functionalGroup;
                String functionalGroupName = UtilsText.safeString((String)e.text);
                IFunctionalGroup currentFunctionalGroupLoc = InitializationOrderDialog.this.getCurrentlySelectedFunctionalGroup();
                TreeViewer treeViewerLoc = InitializationOrderDialog.this.getTreeViewer();
                if (treeViewerLoc == null) {
                    return;
                }
                if (currentFunctionalGroupLoc != null) {
                    InitializationOrderDialog.this.storeInstances(currentFunctionalGroupLoc, InitializationOrderDialog.this.getOrderedInstances(treeViewerLoc));
                }
                if ((functionalGroup = InitializationOrderDialog.this.getFunctionalGroup(functionalGroupName)) == null) {
                    return;
                }
                InitializationOrderDialog.this.setCurrentFunctionalGroup(functionalGroup);
                InitializationPriorities initializationPriorities = ((PeriphsProfile)functionalGroup.getChildContext().getRoot()).getMcu().getInitializationPriorities();
                if (initializationPriorities == null) {
                    return;
                }
                LinkedList<@NonNull IComponentInstanceConfig> instances = new LinkedList<IComponentInstanceConfig>(functionalGroup.getInstances().values());
                InitializationOrderDialog.this.storeInstances(functionalGroup, instances);
                ArrayList<InitializationOrderGroup> groups = new ArrayList<InitializationOrderGroup>();
                InitializationOrderGroup defaultGroup = null;
                String defaultGroupName = initializationPriorities.getDefaultGroupName();
                for (InitializationPrioritiesGroup priorityGroup : initializationPriorities.getSortedGroups()) {
                    InitializationOrderGroup group = new InitializationOrderGroup(priorityGroup);
                    groups.add(group);
                    if (priorityGroup.getId().equals(defaultGroupName)) {
                        defaultGroup = group;
                    }
                    ArrayList<InitializationOrderInstance> instancesInGroup = new ArrayList<InitializationOrderInstance>();
                    @NonNull List instancesOfGroup = InitializationPrioritiesHelper.getComponentsOfGroup(instances, (InitializationPrioritiesGroup)priorityGroup);
                    for (IComponentInstanceConfig instance : instancesOfGroup) {
                        instancesInGroup.add(new InitializationOrderInstance(instance, group));
                    }
                    instances.removeAll(instancesOfGroup);
                    group.setInstances(instancesInGroup);
                }
                if (defaultGroup != null) {
                    List<InitializationOrderInstance> mentionedInstances = defaultGroup.getInstances();
                    LinkedList<InitializationOrderInstance> newList = new LinkedList<InitializationOrderInstance>(mentionedInstances);
                    for (IComponentInstanceConfig instance : instances) {
                        if (instance.isNoInit()) continue;
                        newList.add(new InitializationOrderInstance(instance, defaultGroup));
                    }
                    defaultGroup.setInstances(newList);
                    if (!newList.isEmpty() && !groups.contains(defaultGroup)) {
                        groups.add(defaultGroup);
                    }
                }
                treeViewerLoc.setInput(groups);
                treeViewerLoc.refresh();
                treeViewerLoc.setExpandedElements(groups.toArray());
                InitializationOrderDialog.this.updateOrderingButtonsEnabledState();
            }
        });
    }

    protected boolean isResizable() {
        return true;
    }

    protected void createButtonsForButtonBar(@NonNull Composite parent) {
        this.createButton(parent, 1, Messages.get().InitializationOrderDialog_CancelButton, true);
        this.createButton(parent, 0, Messages.get().InitializationOrderDialog_SaveOrderButton, true);
    }

    protected void okPressed() {
        TreeViewer treeViewerLoc = this.getTreeViewer();
        if (treeViewerLoc == null) {
            LOGGER.log(Level.SEVERE, "[TOOL] TreeViewer was not yet created and OK button was pressed");
            super.okPressed();
            return;
        }
        IFunctionalGroup currentFunctionalGroupLoc = this.getCurrentlySelectedFunctionalGroup();
        if (currentFunctionalGroupLoc == null) {
            super.okPressed();
            return;
        }
        this.storeInstances(currentFunctionalGroupLoc, this.getOrderedInstances(treeViewerLoc));
        this.saveOrderingToProfile();
        this.getProperties().getControllerWrapper().getController().handleSettingChange(1, InitializationOrderDialog.class, Messages.get().InitializationOrderDialog_DirtyMessage, true, (IChild)this.getProperties().getRoot(), true);
        super.okPressed();
    }

    protected Point getInitialSize() {
        return new Point(400, 400);
    }

    protected boolean saveOrderingToProfile() {
        PeriphsProfile root = this.getProperties().getRoot();
        for (IFunctionalGroup group : root.getFunctionalGroups()) {
            ArrayList firstOnly = new ArrayList();
            ArrayList secondOnly = new ArrayList();
            LinkedList<IComponentInstanceConfig> orderedInstances = this.loadInstances(group);
            LinkedList instances = new LinkedList(group.getInstances().values());
            instances.stream().filter(x -> x.isNoInit()).forEach(x -> {
                boolean bl = orderedInstances.add((IComponentInstanceConfig)x);
            });
            if (!CollectionsUtils.difference(instances, orderedInstances, firstOnly, secondOnly)) {
                LOGGER.log(Level.SEVERE, "[TOOL] Instances of the functional group {0} and the ordered list specified by user are not the same collection with different order", group.getName());
                return false;
            }
            HashMap<String, Integer> orderMap = new HashMap<String, Integer>();
            int i = 0;
            while (i < orderedInstances.size()) {
                IComponentInstanceConfig instance = orderedInstances.get(i);
                orderMap.put(instance.getName(), i);
                ++i;
            }
            group.setInstancesOrder(orderMap);
        }
        return true;
    }

    protected LinkedList<IComponentInstanceConfig> getOrderedInstances(TreeViewer viewer) {
        Object input = viewer.getInput();
        if (!(input instanceof List)) {
            return new LinkedList<IComponentInstanceConfig>();
        }
        List groups = (List)input;
        return new LinkedList<IComponentInstanceConfig>((Collection)groups.stream().flatMap(g -> g.getInstances().stream()).map(InitializationOrderInstance::getInstance).collect(CollectorsUtils.toList()));
    }

    protected @Nullable IFunctionalGroup getFunctionalGroup(String name) {
        return this.getProperties().getRoot().getFunctionalGroup(name);
    }

    void setCurrentFunctionalGroup(IFunctionalGroup functionalGroup) {
        this.currentFunctionalGroup = functionalGroup;
    }

    @Nullable TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    @Nullable IFunctionalGroup getCurrentlySelectedFunctionalGroup() {
        return this.currentFunctionalGroup;
    }

    public static void open(InitializationOrderDialogProperties properties) {
        InitializationOrderDialog dialog = new InitializationOrderDialog(properties);
        dialog.setBlockOnOpen(true);
        dialog.open();
    }
}

