/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui;

import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.utils.Messages;
import com.nxp.swtools.utils.preferences.KEPreferences;
import com.nxp.swtools.utils.tooltip.IToolTipable;
import com.nxp.swtools.utils.tooltip.ToolTipableFormatter;
import java.util.Objects;

public class PeripheralsToolTippableFormatter
extends ToolTipableFormatter {
    public static String getToolTipText(IToolTipable tooltipable) {
        StringBuilder result = new StringBuilder();
        result.append(PeripheralsToolTippableFormatter.createIdentification(tooltipable));
        String status = PeripheralsToolTippableFormatter.createStatus((IToolTipable)tooltipable, null, (int)-1);
        String value = PeripheralsToolTippableFormatter.createValue(tooltipable);
        if (!UtilsText.isEmpty((String)status) || !UtilsText.isEmpty((String)value)) {
            result.append("<br/>");
            result.append(status);
            result.append(value);
        }
        return PeripheralsToolTippableFormatter.trimExcessBreakLine((String)UtilsText.safeToString((Object)result));
    }

    protected static String createIdentification(IToolTipable tooltipable) {
        String idPart;
        StringBuilder result = new StringBuilder();
        String name = tooltipable.getUiName();
        if (!UtilsText.isEmpty((String)name)) {
            result.append(UtilsText.htmlB((String)name));
        }
        if (PeripheralsToolTippableFormatter.shouldShowInternalIds() && !UtilsText.isEmpty((String)(idPart = PeripheralsToolTippableFormatter.createTypeAndId((IToolTipable)tooltipable)))) {
            result.append(" ").append("[");
            result.append(idPart);
            result.append("]");
        }
        String description = tooltipable.getDescription();
        if (result.length() > 0 && (description == null || description.isEmpty())) {
            result.append("<br/>");
        }
        if (description != null && !description.isEmpty()) {
            if (!description.startsWith("<br/>") && !description.startsWith("<p>")) {
                result.append("<br/>");
            }
            result.append(description).append("<br/>");
        }
        return UtilsText.safeToString((Object)result);
    }

    protected static final boolean shouldShowInternalIds() {
        return KEPreferences.shouldInternalIdsBeShown() || SWToolsProperties.isVerificationOn();
    }

    protected static String createValue(IToolTipable tooltipable) {
        boolean showValue = false;
        boolean showValueDescription = false;
        if (PeripheralsToolTippableFormatter.shouldShowInternalIds()) {
            if (!UtilsText.isEmpty((String)tooltipable.getValueName())) {
                showValue = true;
            }
            if (!UtilsText.isEmpty((String)tooltipable.getValueDescription()) && !Objects.equals(tooltipable.getValueName(), tooltipable.getValueDescription())) {
                showValueDescription = true;
            }
        } else if (!UtilsText.isEmpty((String)tooltipable.getValueDescription())) {
            showValueDescription = true;
        }
        return PeripheralsToolTippableFormatter.createValueInternal(tooltipable, showValue, showValueDescription);
    }

    protected static String createValueInternal(IToolTipable tooltipable, boolean showValue, boolean showValueDescription) {
        StringBuilder result = new StringBuilder();
        if (showValue || showValueDescription) {
            result.append(UtilsText.htmlB((String)Messages.get().ToolTipableFormater_Value)).append("<br/>");
        }
        if (showValue) {
            result.append(tooltipable.getValueName());
        }
        if (showValue && showValueDescription) {
            result.append(" ").append("\u2013").append(" ");
        }
        if (showValueDescription) {
            result.append(tooltipable.getValueDescription());
        }
        if (result.length() > 0) {
            result.append("<br/>");
        }
        return UtilsText.safeToString((Object)result);
    }
}

