/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.gui;

import com.nxp.swtools.codemanager.ICodeGenerator;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsTool;
import com.nxp.swtools.utils.snippets.SnippetNode;
import com.nxp.swtools.utils.tools.ITool;
import java.util.List;

public class PeripheralsTool
implements ITool {
    public String getToolId() {
        return "Peripherals";
    }

    public boolean isProcessorSupported(ISharedConfiguration configuration) {
        return Controller.getInstance().isMcuSupported(configuration.getCommonConfig());
    }

    public boolean isUpdated(ISharedConfiguration configuration) {
        return !Controller.getInstance().isCodeDirty();
    }

    public boolean waitUntilUpdated(ISharedConfiguration configuration) {
        Controller controller = Controller.getInstance();
        controller.refreshIfChangeInOtherTool();
        if (configuration.getPreferences().isCodePreviewEnabled()) {
            return controller.waitUntilRegenerated();
        }
        return true;
    }

    public StorageTool createStorageTool(ISharedConfiguration sharedConfig) {
        assert (sharedConfig.getTools().getPeripherals() == null);
        StoragePeriphsTool result = new StoragePeriphsTool();
        return result;
    }

    public boolean isFunctionalGroupSupported() {
        return true;
    }

    public @Nullable ICodeGenerator getCodeGenerator() {
        return Controller.getInstance();
    }

    public List<SnippetNode> getSnippets() {
        return Controller.getInstance().getSnippets();
    }
}

