/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.internal.ui;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IProcessInfo;
import org.eclipse.cdt.core.IProcessList;
import org.eclipse.cdt.launch.internal.ui.LaunchImages;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;

public class ProcessPrompter
implements IStatusHandler {
    public Object handleStatus(IStatus status, Object source) throws CoreException {
        IProcessInfo info;
        Shell shell = LaunchUIPlugin.getShell();
        if (shell == null) {
            Status error = new Status(4, LaunchUIPlugin.getUniqueIdentifier(), 150, LaunchMessages.CoreFileLaunchDelegate_No_Shell_available_in_Launch, null);
            throw new CoreException((IStatus)error);
        }
        LabelProvider provider = new LabelProvider(){

            public String getText(Object element) {
                IProcessInfo info = (IProcessInfo)element;
                Path path = new Path(info.getName());
                return String.valueOf(path.lastSegment()) + " - " + info.getPid();
            }

            public Image getImage(Object element) {
                return LaunchImages.get(LaunchImages.IMG_OBJS_EXEC);
            }
        };
        LabelProvider qprovider = new LabelProvider(){

            public String getText(Object element) {
                IProcessInfo info = (IProcessInfo)element;
                return info.getName();
            }

            public Image getImage(Object element) {
                return LaunchImages.get(LaunchImages.IMG_OBJS_EXEC);
            }
        };
        TwoPaneElementSelector dialog = new TwoPaneElementSelector(shell, (ILabelProvider)provider, (ILabelProvider)qprovider);
        dialog.setTitle(LaunchMessages.LocalAttachLaunchDelegate_Select_Process);
        dialog.setMessage(LaunchMessages.LocalAttachLaunchDelegate_Select_Process_to_attach_debugger_to);
        IProcessList plist = null;
        try {
            plist = CCorePlugin.getDefault().getProcessList();
        }
        catch (CoreException e) {
            LaunchUIPlugin.errorDialog(LaunchMessages.LocalAttachLaunchDelegate_CDT_Launch_Error, e.getStatus());
        }
        if (plist == null) {
            MessageDialog.openError((Shell)shell, (String)LaunchMessages.LocalAttachLaunchDelegate_CDT_Launch_Error, (String)LaunchMessages.LocalAttachLaunchDelegate_Platform_cannot_list_processes);
            return null;
        }
        dialog.setElements((Object[])plist.getProcessList());
        if (dialog.open() == 0 && (info = (IProcessInfo)dialog.getFirstResult()) != null) {
            return info.getPid();
        }
        return null;
    }
}

