/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkproject.parsers;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.XmlDomProvider;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.version.VersionUtils;
import com.nxp.swtools.common.utils.xml.UtilsXmlDom;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.sdkcomponents.CmsisComponentId;
import com.nxp.swtools.expert.processordb.sdkcomponents.SdkComponentsTable;
import com.nxp.swtools.expert.processordb.sdkcomponents.SupportedSdkComponent;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.sdkproject.SdkComponentInProject;
import com.nxp.swtools.sdkproject.parsers.GenericPrjAdapterWithParser;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

abstract class GenericPrjAdapterWithCmsisParser
extends GenericPrjAdapterWithParser {
    GenericPrjAdapterWithCmsisParser(@NonNull File prjFile, @NonNull File prjDir, @NonNull IToolchainProjectWithSdk existingProcessorDetector) {
        super(prjFile, prjDir, existingProcessorDetector);
    }

    private @Nullable SdkComponentInProject createSdkComponentInPrj(@NonNull CmsisComponentId cmsisCompId) {
        IProcessorMasterToolInfo processorInfo = this.getProcessorInfo();
        if (processorInfo == null) {
            return null;
        }
        SdkComponentsTable supportedComps = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools().getSdkComponentsTable(processorInfo);
        if (supportedComps == null) {
            return null;
        }
        List suComps = supportedComps.findByCmsisId(cmsisCompId).collect(Collectors.toList());
        SupportedSdkComponent suppComp = null;
        Version cmsCompVersion = cmsisCompId.getVersion();
        for (SupportedSdkComponent sCom : suComps) {
            Version sVersion = sCom.getVersion();
            if (VersionUtils.perfect((Version)sVersion, (Version)cmsCompVersion)) {
                suppComp = sCom;
                break;
            }
            if (!VersionUtils.compatible((Version)cmsCompVersion, (Version)sVersion)) continue;
            suppComp = sCom;
        }
        if (suComps.size() > 0 && suppComp == null) {
            LOGGER.severe(String.format("[SDK/DATA] CMSIS component '%s' from the project not found in given version in SDK component xml: %s", cmsisCompId.toString(), CollectionsUtils.formatList(suComps, (String)"; ", c -> String.valueOf(c.toString()) + ":" + c.getVersionStr())));
        }
        if (suppComp != null) {
            return new SdkComponentInProject(suppComp.getId(), cmsisCompId.getVersionStr());
        }
        if ("NXP".equals(cmsisCompId.getCVendor()) && "SDK Drivers".equals(cmsisCompId.getCGroup())) {
            LOGGER.warning("[SDK] CMSIS component from project not found: " + cmsisCompId.toString());
        }
        return null;
    }

    @Nullable SdkComponentInProject createSdkComponentInPrjFromCmsisAttrs(@NonNull Element compElem) {
        block3: {
            try {
                if (compElem.hasAttribute("Cclass") && compElem.hasAttribute("Cgroup") && compElem.hasAttribute("Cversion")) break block3;
                return null;
            }
            catch (UtilsXmlDom.InvalidXmlFormatException e) {
                LOGGER.log(Level.SEVERE, "Invalid CMSIS component reference", e);
                return null;
            }
        }
        CmsisComponentId cmsisId = new CmsisComponentId(compElem, null);
        return this.createSdkComponentInPrj(cmsisId);
    }

    abstract boolean parse(@NonNull Element var1, @NonNull Collection<@NonNull SdkComponentInProject> var2, @NonNull Set<@NonNull Path> var3, @NonNull List<@NonNull Path> var4, @NonNull IProgressMonitor var5);

    @Override
    public boolean parse(@NonNull Collection<@NonNull SdkComponentInProject> componentsInPrjFile, @NonNull Set<@NonNull Path> prjSources, @NonNull List<@NonNull Path> inclPaths, @NonNull IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return false;
        }
        Document doc = XmlDomProvider.getAsW3CDom((String)this.prjFile.getAbsolutePath(), null);
        if (doc == null) {
            LOGGER.severe("Failed to read XML file: " + this.prjFile.getAbsolutePath());
            return false;
        }
        Element root = doc.getDocumentElement();
        assert (root != null);
        monitor.worked(20);
        return this.parse(root, componentsInPrjFile, prjSources, inclPaths, monitor);
    }
}

