/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkproject;

import com.nxp.swtools.common.ui.utils.services.Rap;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.sdkcomponents.SdkComponentsTable;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.dependencies.DependencyQueryAnnotation;
import com.nxp.swtools.provider.configuration.dependencies.DependencyQueryResult;
import com.nxp.swtools.provider.configuration.dependencies.DependencyResourceAnotation;
import com.nxp.swtools.provider.configuration.dependencies.IDependencyQuery;
import com.nxp.swtools.provider.configuration.dependencies.IDependencyQueryResult;
import com.nxp.swtools.provider.configuration.storage.IDependenciesConfiguration;
import com.nxp.swtools.provider.configuration.storage.INamedTool;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.configuration.storage.projectgenerator.StorageProjectConfig;
import com.nxp.swtools.provider.configuration.storage.sdkproject.StorageToolchainProjectTool;
import com.nxp.swtools.provider.toolchainproject.ISdkComponentInProject;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;

@DependencyQueryAnnotation(resources={@DependencyResourceAnotation(resourceType="SWComponent", features={"exists", "enabled", "version", "revision"})})
public class ToolchainProjectQuery
implements IDependencyQuery {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(ToolchainProjectQuery.class);

    private static @Nullable SdkComponentsTable getSdkComponentsTable(@NonNull ISharedConfiguration configuration) {
        ICommonConfig commonConfig;
        ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        IProcessorMasterToolInfo prcsorInfo = derivatives.getProcessorMasterToolInfo((commonConfig = configuration.getCommonConfig()).getMcu(), commonConfig.getSdkVersion());
        return prcsorInfo == null ? null : derivatives.getSdkComponentsTable(prcsorInfo);
    }

    public @NonNull Collection<@NonNull IDependencyQueryResult> query(@NonNull ISharedConfiguration configuration, @NonNull String resourceType, @NonNull String resourceId, @NonNull String featureName) {
        Object resultValue;
        SdkComponentsTable supportedSdkComps;
        ArrayList<@NonNull IDependencyQueryResult> result = new ArrayList<IDependencyQueryResult>();
        if (!resourceType.equals("SWComponent")) {
            LOGGER.severe("Unsupported resource-type: " + resourceType);
            return result;
        }
        IToolchainProjectWithSdk toolchainProject = configuration.getToolchainProject();
        ISdkComponentInProject resComp = toolchainProject != null ? toolchainProject.getSdkComponent(resourceId) : null;
        String msgForesultNullValueErrorMsg = null;
        if (featureName.equals("exists")) {
            resultValue = resComp != null ? Boolean.TRUE : ((supportedSdkComps = ToolchainProjectQuery.getSdkComponentsTable(configuration)) == null ? Boolean.FALSE : Boolean.valueOf(supportedSdkComps.findById(resourceId).findAny().isPresent()));
        } else if (featureName.equals("version")) {
            if (resComp != null) {
                resultValue = resComp.getVersion();
            } else {
                resultValue = null;
                supportedSdkComps = ToolchainProjectQuery.getSdkComponentsTable(configuration);
                if (supportedSdkComps == null) {
                    msgForesultNullValueErrorMsg = "SDK_components.xml not found for the processor: " + configuration.getCommonConfig().getMcu();
                } else if (!supportedSdkComps.findById(resourceId).findAny().isPresent()) {
                    msgForesultNullValueErrorMsg = "Tool asks version of unsupported SDK component(such component not found in SDK_components.xml)";
                }
            }
        } else if (featureName.equals("revision")) {
            if (resComp != null) {
                resultValue = resComp.getRevision();
            } else {
                resultValue = null;
                supportedSdkComps = ToolchainProjectQuery.getSdkComponentsTable(configuration);
                if (supportedSdkComps == null) {
                    msgForesultNullValueErrorMsg = "SDK_components.xml not found for the processor: " + configuration.getCommonConfig().getMcu();
                } else if (!supportedSdkComps.findById(resourceId).findAny().isPresent()) {
                    msgForesultNullValueErrorMsg = "Tool asks version of unsupported SDK component(such component not found in SDK_components.xml)";
                }
            }
        } else if (featureName.equals("enabled")) {
            if (Rap.isActive()) {
                resultValue = null;
            } else if (resComp != null) {
                resultValue = Boolean.TRUE;
            } else {
                if (toolchainProject == null) {
                    LOGGER.warning("Null toolchain project for the configuration");
                    return result;
                }
                if (!toolchainProject.wasProjectDetected()) {
                    resultValue = null;
                } else {
                    resultValue = Boolean.FALSE;
                    supportedSdkComps = ToolchainProjectQuery.getSdkComponentsTable(configuration);
                    if (supportedSdkComps == null) {
                        LOGGER.severe("SDK_components.xml not found for the processor: " + configuration.getCommonConfig().getMcu());
                    } else if (!supportedSdkComps.findById(resourceId).findAny().isPresent()) {
                        LOGGER.severe("Tool requires unsupported SDK component: " + resourceId + " (such component not found in SDK_components.xml)");
                    }
                }
            }
        } else {
            return result;
        }
        ProcessorCore selCore = configuration.getCommonConfig().getSelectedCore();
        StorageProjectConfig cfg = new StorageProjectConfig(selCore != null ? selCore.getID() : "");
        result.add((IDependencyQueryResult)new DependencyQueryResult(resultValue, (INamedTool)StorageToolchainProjectTool.STORAGE_TOOLCHAIN_PROJECT_TOOL, (IDependenciesConfiguration)cfg, msgForesultNullValueErrorMsg));
        return result;
    }
}

