/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.page1;

import com.freescale.s32ds.cross.core.model.context.GeneralContext;
import com.freescale.s32ds.cross.core.model.data.ConfigurationData;
import com.freescale.s32ds.cross.core.model.data.FamilyData;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.jface.viewers.ITreeContentProvider;

public class FilteredContentProvider
implements ITreeContentProvider {
    private final GeneralContext context;
    private final Predicate<ProcessorData> filterFunction;

    public FilteredContentProvider(GeneralContext context) {
        this(context, e -> true);
    }

    public FilteredContentProvider(GeneralContext context, Predicate<ProcessorData> filterFunction) {
        this.filterFunction = filterFunction;
        this.context = context;
    }

    public boolean hasChildren(Object element) {
        return element instanceof FamilyData;
    }

    public Object getParent(Object element) {
        if (element instanceof ProcessorData) {
            return ((ProcessorData)element).getFamily();
        }
        if (element instanceof FamilyData) {
            return this.context.getModel().getFamilies();
        }
        return null;
    }

    public Object[] getElements(Object inputElement) {
        List families = this.context.getModel().getFamilies();
        return families.toArray(new FamilyData[families.size()]);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof FamilyData) {
            return ((FamilyData)parentElement).getProcessors().stream().filter(this.filterFunction).sorted(Comparator.comparing(ConfigurationData::getName)).toArray();
        }
        return new ProcessorData[0];
    }
}

