/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tools.templates.ui.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tools.templates.ui.internal.Tag;
import org.eclipse.tools.templates.ui.internal.Template;
import org.osgi.framework.FrameworkUtil;

public class TemplateExtension {
    private Map<String, Template> templates;
    private Map<String, Tag> tags;

    private void init() {
        IConfigurationElement element;
        if (this.templates != null) {
            return;
        }
        this.templates = new HashMap<String, Template>();
        this.tags = new HashMap<String, Tag>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(FrameworkUtil.getBundle(this.getClass()).getSymbolicName(), "templates");
        Tag allTag = new Tag("all", "All");
        this.tags.put(allTag.getId(), allTag);
        IConfigurationElement[] iConfigurationElementArray = point.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            element = iConfigurationElementArray[n2];
            if (element.getName().equals("tag")) {
                Tag tag = new Tag(element);
                this.tags.put(tag.getId(), tag);
            }
            ++n2;
        }
        iConfigurationElementArray = point.getConfigurationElements();
        n = iConfigurationElementArray.length;
        n2 = 0;
        while (n2 < n) {
            element = iConfigurationElementArray[n2];
            if (element.getName().equals("template")) {
                Template template = new Template(this, element);
                this.templates.put(template.getId(), template);
                template.addTag(allTag);
            }
            ++n2;
        }
        iConfigurationElementArray = point.getConfigurationElements();
        n = iConfigurationElementArray.length;
        n2 = 0;
        while (n2 < n) {
            String templateId;
            Template template;
            element = iConfigurationElementArray[n2];
            if (element.getName().equals("templateExtension") && (template = this.templates.get(templateId = element.getAttribute("templateId"))) != null) {
                IConfigurationElement[] iConfigurationElementArray2 = element.getChildren("tagReference");
                int n3 = iConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement tagRef = iConfigurationElementArray2[n4];
                    String tagId = tagRef.getAttribute("id");
                    Tag tag = this.tags.get(tagId);
                    if (tag != null) {
                        template.addTag(tag);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public Collection<Template> getTemplates() {
        this.init();
        return this.templates.values();
    }

    public Tag getTag(String id) {
        this.init();
        return this.tags.get(id);
    }
}

