/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.orbit.c.defines.evaluate;

import com.nxp.s32ds.ext.orbit.c.defines.CDefine;
import com.nxp.s32ds.ext.orbit.c.defines.evaluate.CDefineEvaluateException;
import com.nxp.s32ds.ext.orbit.internal.c.Messages;
import com.nxp.s32ds.ext.orbit.javascript.JavaScriptEngine;
import java.util.List;
import java.util.function.Function;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.eclipse.osgi.util.NLS;

public class CDefineEvaluator {
    private final JavaScriptEngine javaScriptEngine = new JavaScriptEngine();

    public boolean isActivated() {
        return this.getJavaScriptEngine().getScriptEngine() != null;
    }

    public String buildConstantsScript(List<CDefine> defines) {
        StringBuilder constantsScriptBuilder = new StringBuilder();
        for (CDefine define : defines) {
            String name = define.getName();
            String value = define.getValue();
            constantsScriptBuilder.append(name).append("=").append(value).append(";\n");
        }
        return constantsScriptBuilder.toString();
    }

    public JavaScriptEngine getJavaScriptEngine() {
        return this.javaScriptEngine;
    }

    public int evalInteger(String script) throws CDefineEvaluateException {
        return this.eval(script, o -> {
            int intValue;
            Double result;
            if (o instanceof Integer) {
                return (Integer)o;
            }
            if (o instanceof Double && !(result = (Double)o).isNaN() && !result.isInfinite() && result.equals(Double.valueOf(Integer.toString(intValue = result.intValue())))) {
                return intValue;
            }
            return null;
        });
    }

    public double evalDouble(String script) throws CDefineEvaluateException {
        return this.eval(script, o -> {
            Double result;
            if (o instanceof Integer) {
                return ((Integer)o).doubleValue();
            }
            if (o instanceof Double && !(result = (Double)o).isNaN() && !result.isInfinite()) {
                return result;
            }
            return null;
        });
    }

    private <T extends Number> T eval(String script, Function<Object, T> func) throws CDefineEvaluateException {
        ScriptEngine scriptEngine = this.javaScriptEngine.getScriptEngine();
        try {
            Object eval = scriptEngine.eval(script);
            Number result = (Number)func.apply(eval);
            if (result != null) {
                return (T)result;
            }
            throw new CDefineEvaluateException(NLS.bind((String)Messages.eval_constants_evaluation_failed_invalid_result_0, (Object)eval), script);
        }
        catch (ScriptException e) {
            String message = e.getMessage();
            Throwable cause = e.getCause();
            if (cause != null) {
                message = cause.getMessage();
            }
            throw new CDefineEvaluateException(NLS.bind((String)Messages.eval_constants_evaluation_failed_0, (Object)CDefineEvaluator.replaceNewLines(message)), script, e);
        }
    }

    private static String replaceNewLines(String string) {
        if (string == null) {
            return string;
        }
        return string.replace("\n", " ").replace("\r", "").trim();
    }
}

