/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.flash.internal.ui.dialogs;

import com.nxp.s32ds.debug.ide.core.DebuggerUtils;
import com.nxp.s32ds.debug.ide.s32debugger.flash.core.S32DebuggerFlashProgrammerCoreActivator;
import com.nxp.s32ds.debug.ide.s32debugger.flash.internal.ui.S32DebuggerFlashProgrammerUIActivator;
import com.nxp.s32ds.debug.ide.s32debugger.flash.internal.ui.dialogs.S32DebuggerFlashElementDialogMessages;
import com.nxp.s32ds.debug.ide.s32debugger.flash.validation.FlashElementConfiguration;
import com.nxp.s32ds.debug.ide.s32debugger.flash.validation.S32DebuggerFlashElementConfigurationValidator;
import com.nxp.s32ds.debug.ide.ui.SWTUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;

public class S32DebuggerFlashElementDialog
extends TitleAreaDialog {
    private static final int WIDTH_TEXT_BASE_ADDRESS = 110;
    private static final String ELF_EXTENSION = "elf";
    private static final String[] EXTENSIONS_FOR_SEARCHING = new String[]{"elf", "bin"};
    private final List<String> binaryPaths = new ArrayList<String>();
    private final FlashElementConfiguration elementForEdit;
    private final FlashElementConfiguration savedStateElement;
    private Button butOK;
    private Text txtProjectName;
    private Text txtBinaryPath;
    private Button btnUseBaseAddress;
    private Text txtBaseAddress;
    private ICProject currentProject;

    public S32DebuggerFlashElementDialog(Shell parentShell, FlashElementConfiguration editableElement) {
        super(parentShell);
        if (editableElement != null) {
            this.elementForEdit = editableElement;
            this.currentProject = !this.elementForEdit.getProjectName().equals("<undefined>") ? CoreModel.getDefault().getCModel().getCProject(this.elementForEdit.getProjectName()) : null;
            this.savedStateElement = FlashElementConfiguration.newInstance((FlashElementConfiguration)this.elementForEdit);
            ICProject elementProject = CoreModel.getDefault().getCModel().getCProject(this.savedStateElement.getProjectName());
            this.savedStateElement.setBinaryPath(DebuggerUtils.getAbsoluteBinaryPathByProjectName((String)elementProject.getProject().getName(), (String)this.savedStateElement.getBinaryPath()));
        } else {
            this.elementForEdit = new FlashElementConfiguration();
            this.elementForEdit.setBinaryType(ELF_EXTENSION);
            this.savedStateElement = null;
            this.currentProject = null;
        }
    }

    public void addAlreadyCreatedElements(Collection<FlashElementConfiguration> flashElements) {
        for (FlashElementConfiguration element : flashElements) {
            ICProject elementProject = CoreModel.getDefault().getCModel().getCProject(element.getProjectName());
            if (elementProject == null) continue;
            this.binaryPaths.add(DebuggerUtils.getAbsoluteBinaryPathByProjectName((String)elementProject.getProject().getName(), (String)element.getBinaryPath()));
        }
    }

    public Control createDialogArea(Composite parent) {
        Composite innerComposite = SWTUtils.createGridCellCompositeWithVerticalAndHorizontalMargin((Composite)parent, (int)1, (int)3, (int)2, (int)5);
        SWTUtils.createLabelWithHorizontalSpan((Composite)innerComposite, (String)S32DebuggerFlashElementDialogMessages.S32DebuggerFlashElementDialog_project_label, (int)3);
        this.txtProjectName = SWTUtils.createWideText((Composite)innerComposite, (int)2052, (boolean)true, (int)2);
        this.txtProjectName.setEditable(false);
        Button browseProject = SWTUtils.createButton((Composite)innerComposite, (String)S32DebuggerFlashElementDialogMessages.S32DebuggerFlashElementDialog_browse_button, (int)8);
        browseProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerFlashElementDialog.this.handleProjectButtonSelected();
            }
        });
        SWTUtils.createLabelWithHorizontalSpan((Composite)innerComposite, (String)S32DebuggerFlashElementDialogMessages.S32DebuggerFlashElementDialog_application_label, (int)3);
        this.txtBinaryPath = SWTUtils.createWideText((Composite)innerComposite, (int)2052, (boolean)true, (int)3);
        this.txtBinaryPath.setEditable(false);
        Button variables = SWTUtils.createButton((Composite)innerComposite, (String)S32DebuggerFlashElementDialogMessages.S32DebuggerFlashElementDialog_variables_button, (int)8);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 0x1000008;
        variables.setLayoutData((Object)data);
        variables.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerFlashElementDialog.this.variablesButtonSelected();
            }
        });
        Button searchProject = SWTUtils.createButton((Composite)innerComposite, (String)S32DebuggerFlashElementDialogMessages.S32DebuggerFlashElementDialog_search_project_button, (int)8);
        searchProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerFlashElementDialog.this.handleSearchButtonSelected();
            }
        });
        data.grabExcessHorizontalSpace = false;
        searchProject.setLayoutData((Object)data);
        Button browseBinary = SWTUtils.createButton((Composite)innerComposite, (String)S32DebuggerFlashElementDialogMessages.S32DebuggerFlashElementDialog_browse_button, (int)8);
        browseBinary.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerFlashElementDialog.this.handleBrowseFileSystemButton();
            }
        });
        Composite baseAddressComposite = SWTUtils.createGridCellCompositeWithVerticalAndHorizontalMargin((Composite)innerComposite, (int)1, (int)2, (int)1, (int)1);
        this.btnUseBaseAddress = SWTUtils.createButtonWithHorizontalSpan((Composite)baseAddressComposite, (String)S32DebuggerFlashElementDialogMessages.S32DebuggerFlashElementDialog_base_address_label, (int)32, (int)1);
        this.btnUseBaseAddress.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerFlashElementDialog.this.txtBaseAddress.setEnabled(((Button)e.getSource()).getSelection());
                S32DebuggerFlashElementDialog.this.validate();
            }
        });
        this.txtBaseAddress = SWTUtils.createTextWithWidthHint((Composite)baseAddressComposite, (int)2052, (int)110, (int)1);
        this.txtBaseAddress.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                S32DebuggerFlashElementDialog.this.validate();
            }
        });
        if (this.savedStateElement == null) {
            this.getShell().setText(S32DebuggerFlashElementDialogMessages.S32DebuggerFlashElementDialog_add_binary);
        } else {
            this.getShell().setText(S32DebuggerFlashElementDialogMessages.S32DebuggerFlashElementDialog_edit_binary);
        }
        this.txtProjectName.setText(this.elementForEdit.getProjectName());
        this.txtBinaryPath.setText(this.elementForEdit.getBinaryPath());
        if (this.elementForEdit.isUseBaseAddress()) {
            this.txtBaseAddress.setText(this.elementForEdit.getBaseAddress());
            if (ELF_EXTENSION.equals(this.elementForEdit.getBinaryType())) {
                this.btnUseBaseAddress.setEnabled(true);
            } else {
                this.btnUseBaseAddress.setEnabled(false);
            }
            this.btnUseBaseAddress.setSelection(true);
        } else {
            this.txtBaseAddress.setEnabled(false);
            this.btnUseBaseAddress.setSelection(false);
        }
        this.setHelpAvailable(false);
        parent.setFocus();
        return innerComposite;
    }

    private void handleBrowseFileSystemButton() {
        String result;
        FileDialog dialog = new FileDialog(this.getShell(), 0);
        dialog.setText(S32DebuggerFlashElementDialogMessages.S32DebuggerFlashElementDialog_title);
        String str = this.txtBinaryPath.getText().trim();
        int lastSeparatorIndex = str.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(str.substring(0, lastSeparatorIndex));
        }
        if ((result = dialog.open()) != null) {
            str = new Path(result).toString();
            this.txtBinaryPath.setText(str);
            this.currentProject = null;
            this.setProjectUIStringsForBinarySelected(str);
        }
    }

    private void setProjectUIStringsForBinarySelected(String binaryFile) {
        this.txtBinaryPath.setText(binaryFile);
        if (this.currentProject == null) {
            try {
                ICProject[] projects;
                ICProject[] iCProjectArray = projects = CoreModel.getDefault().getCModel().getCProjects();
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    ICProject project = iCProjectArray[n2];
                    String location = project.getProject().getLocation().toString();
                    if (binaryFile.startsWith(location)) {
                        this.currentProject = project;
                        break;
                    }
                    ++n2;
                }
            }
            catch (CModelException ex) {
                this.showErrorDialog(ex.getMessage());
            }
        }
        if (this.currentProject == null) {
            this.txtProjectName.setText("<undefined>");
        } else {
            this.txtProjectName.setText(this.currentProject.getProject().getName());
        }
        this.setBaseAddressUIState(binaryFile);
        this.validate();
    }

    private void setBaseAddressUIState(String binaryFile) {
        if (binaryFile.isEmpty() || binaryFile.endsWith(ELF_EXTENSION)) {
            this.btnUseBaseAddress.setEnabled(true);
            if (!this.btnUseBaseAddress.getSelection() && this.txtBaseAddress.getText().isEmpty()) {
                this.btnUseBaseAddress.setSelection(false);
                this.txtBaseAddress.setEnabled(false);
            }
        } else {
            this.btnUseBaseAddress.setEnabled(false);
            this.btnUseBaseAddress.setSelection(true);
            this.txtBaseAddress.setEnabled(true);
        }
    }

    private void validate() {
        IStatus validationStatus;
        FlashElementConfiguration addedElement = new FlashElementConfiguration();
        addedElement.setProjectName(this.txtProjectName.getText().trim());
        String binaryPath = this.txtBinaryPath.getText().trim();
        if (this.currentProject != null) {
            addedElement.setBinaryPath(DebuggerUtils.getAbsoluteBinaryPathByProjectName((String)this.currentProject.getProject().getName(), (String)this.txtBinaryPath.getText().trim()));
        } else {
            addedElement.setBinaryPath(binaryPath);
        }
        if (binaryPath.endsWith(ELF_EXTENSION)) {
            addedElement.setBinaryType(ELF_EXTENSION);
        } else {
            addedElement.setBinaryType("other");
        }
        if (this.btnUseBaseAddress.getSelection()) {
            addedElement.setUseBaseAddress(true);
            addedElement.setBaseAddress(this.txtBaseAddress.getText().trim());
        }
        if ((validationStatus = S32DebuggerFlashElementConfigurationValidator.validate((FlashElementConfiguration)addedElement, (FlashElementConfiguration)this.savedStateElement, this.binaryPaths)).getSeverity() == 4) {
            this.setMessage(null);
            this.setErrorMessage(validationStatus.getMessage());
            if (this.butOK != null) {
                this.butOK.setEnabled(false);
            }
        } else {
            this.setErrorMessage(null);
            if (!validationStatus.isOK()) {
                this.setMessage(validationStatus.getMessage(), validationStatus.getSeverity());
            } else {
                this.setMessage(null);
            }
            if (this.butOK != null) {
                this.butOK.setEnabled(!addedElement.equals((Object)this.savedStateElement));
            }
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control butBar = super.createButtonBar(parent);
        this.butOK = this.getButton(0);
        this.validate();
        return butBar;
    }

    private void handleProjectButtonSelected() {
        ICProject cProject = this.chooseCProject();
        if (cProject == null) {
            return;
        }
        String newProjectName = cProject.getElementName();
        if (!this.txtProjectName.getText().equals(newProjectName)) {
            this.currentProject = cProject;
            this.txtProjectName.setText(newProjectName);
        }
        try {
            String binary = DebuggerUtils.getProjectBinary((ICProject)cProject);
            this.txtBinaryPath.setText(binary);
            this.setBaseAddressUIState(binary);
        }
        catch (CModelException ex) {
            this.showErrorDialog(ex.getMessage());
        }
        this.validate();
    }

    private void showErrorDialog(String message) {
        ErrorDialog.openError((Shell)this.getShell(), (String)S32DebuggerFlashElementDialogMessages.S32DebuggerFlashElementDialog_cannot_perform_operation, (String)S32DebuggerFlashElementDialogMessages.S32DebuggerFlashElementDialog_internal_c_error, (IStatus)new Status(4, S32DebuggerFlashProgrammerUIActivator.getInstance().getBundleId(), message));
    }

    private ICProject chooseCProject() {
        try {
            ICProject cProject;
            Object[] projects = CoreModel.getDefault().getCModel().getCProjects();
            CElementLabelProvider labelProvider = new CElementLabelProvider();
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
            dialog.setTitle(S32DebuggerFlashElementDialogMessages.S32DebuggerFlashElementDialog_project_dialog_project_selection);
            dialog.setMessage(S32DebuggerFlashElementDialogMessages.S32DebuggerFlashElementDialog_project_dialog_project_to_constrain);
            dialog.setElements(projects);
            String projectName = this.txtProjectName.getText().trim();
            if (!projectName.isEmpty() && (cProject = CoreModel.getDefault().getCModel().getCProject(projectName)) != null) {
                dialog.setInitialSelections(new Object[]{cProject});
            }
            if (dialog.open() == 0) {
                return (ICProject)dialog.getFirstResult();
            }
        }
        catch (CModelException e) {
            this.showErrorDialog(e.getMessage());
        }
        return null;
    }

    protected void handleSearchButtonSelected() {
        if (this.currentProject == null || !this.currentProject.exists()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)S32DebuggerFlashElementDialogMessages.S32DebuggerFlashElementDialog_search_dialog_project_required_error, (String)S32DebuggerFlashElementDialogMessages.S32DebuggerFlashElementDialog_search_dialog_enter_project);
            return;
        }
        CElementLabelProvider programLabelProvider = new CElementLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IPath) {
                    IPath path = (IPath)element;
                    return path.lastSegment();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                return DebugUITools.getImage((String)"IMG_ACT_RUN");
            }
        };
        CElementLabelProvider qualifierLabelProvider = new CElementLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IPath) {
                    IPath path = (IPath)element;
                    return path.toString();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                return CDTSharedImages.getImage((String)"icons/obj16/exec_dbg_obj.gif");
            }
        };
        try {
            TwoPaneElementSelector dialog = new TwoPaneElementSelector(this.getShell(), (ILabelProvider)programLabelProvider, (ILabelProvider)qualifierLabelProvider);
            ExtFilesFinder binaryFinder = new ExtFilesFinder(EXTENSIONS_FOR_SEARCHING);
            IPath location = this.currentProject.getProject().getLocation();
            Files.walkFileTree(Paths.get(location.toString(), new String[0]), binaryFinder);
            Collection<IPath> foundBinaries = binaryFinder.getFoundFiles();
            HashSet<IPath> projectRelativeBinaries = new HashSet<IPath>();
            for (IPath path : foundBinaries) {
                IPath makeRelativeTo = path.makeRelativeTo(location);
                projectRelativeBinaries.add(makeRelativeTo);
            }
            dialog.setElements(projectRelativeBinaries.toArray());
            dialog.setMessage(S32DebuggerFlashElementDialogMessages.S32DebuggerFlashElementDialog_search_dialog_choose_application);
            dialog.setTitle(S32DebuggerFlashElementDialogMessages.S32DebuggerFlashElementDialog_search_dialog_application_selection);
            dialog.setUpperListLabel(S32DebuggerFlashElementDialogMessages.S32DebuggerFlashElementDialog_search_dialog_application_binaries_colon);
            dialog.setLowerListLabel(S32DebuggerFlashElementDialogMessages.S32DebuggerFlashElementDialog_search_dialog_application_qualifier_colon);
            dialog.setMultipleSelection(false);
            if (dialog.open() == 0) {
                IPath binary = (IPath)dialog.getFirstResult();
                this.setProjectUIStringsForBinarySelected(binary.toString());
            }
        }
        catch (IOException ex) {
            this.showErrorDialog(ex.getMessage());
        }
    }

    protected void okPressed() {
        this.elementForEdit.setProjectName(this.txtProjectName.getText().trim());
        String binaryPath = this.txtBinaryPath.getText().trim();
        this.elementForEdit.setBinaryPath(binaryPath);
        if (this.btnUseBaseAddress.getSelection()) {
            this.elementForEdit.setUseBaseAddress(true);
            this.elementForEdit.setBaseAddress(this.txtBaseAddress.getText().trim());
        } else {
            this.elementForEdit.setUseBaseAddress(false);
            this.elementForEdit.setBaseAddress("");
        }
        if (binaryPath.endsWith(ELF_EXTENSION)) {
            this.elementForEdit.setBinaryType(ELF_EXTENSION);
        } else {
            this.elementForEdit.setBinaryType("other");
        }
        super.okPressed();
    }

    public FlashElementConfiguration getFlashElementData() {
        return this.elementForEdit;
    }

    private void variablesButtonSelected() {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        if (dialog.open() == 0) {
            String variable = new Path(DebuggerUtils.substitute((String)dialog.getVariableExpression())).toString();
            this.txtBinaryPath.setText(variable);
            this.currentProject = null;
            this.setProjectUIStringsForBinarySelected(variable);
        }
    }

    private static class ExtFilesFinder
    extends SimpleFileVisitor<java.nio.file.Path> {
        private final Collection<IPath> foundFiles = new HashSet<IPath>();
        private final String[] fileExtensions;

        public ExtFilesFinder(String[] extensions) {
            this.fileExtensions = extensions;
        }

        @Override
        public FileVisitResult visitFile(java.nio.file.Path file, BasicFileAttributes attr) {
            IPath eclipsePath = Path.fromOSString((String)file.toString());
            String fileExt = eclipsePath.getFileExtension();
            String[] stringArray = this.fileExtensions;
            int n = this.fileExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                if (extension.equalsIgnoreCase(fileExt)) {
                    this.foundFiles.add(eclipsePath);
                    break;
                }
                ++n2;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(java.nio.file.Path file, IOException exc) {
            S32DebuggerFlashProgrammerCoreActivator.getDefault().logError(exc.getMessage());
            return FileVisitResult.CONTINUE;
        }

        public Collection<IPath> getFoundFiles() {
            return this.foundFiles;
        }
    }
}

