/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.validation.ui;

import com.freescale.s32ds.cross.core.ProjectContextSettings;
import com.nxp.s32ds.cle.cdt.ui.internal.CdtUiActivator;
import com.nxp.s32ds.cle.cdt.validation.internal.ui.Messages;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FamilyDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.FamilyDescriptors;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class HardwareSettingsProjectFixDialog
extends TitleAreaDialog {
    private static final String DIALOG_FAMILY_TEXT = "Family:";
    private static final String DIALOG_DEVICE_TEXT = "Device:";
    private static final String DIALOG_CORE_TEXT = "Core:";
    private static final String C_NATURE = "c";
    private static final String CC_NATURE = "c++";
    private CCombo cmbFamily;
    private CCombo cmbDevice;
    private CCombo cmbCore;
    private Button butOK;
    private IProject project;
    private String familyId;
    private String deviceId;
    private String deviceCoreId;
    private String coreId;

    public HardwareSettingsProjectFixDialog(Shell parentShell, IProject project) {
        super(parentShell);
        this.project = project;
    }

    public void create() {
        super.create();
        this.setTitle(Messages.HardwareSettingsProjectSetterDialog_entire_title_message);
    }

    public Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)parentComposite);
        Composite innerComposite = new Composite(parentComposite, 2048);
        GridData horizontalFill = new GridData(4, 2, true, false);
        innerComposite.setLayoutData((Object)horizontalFill);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.horizontalSpacing = 5;
        innerComposite.setLayout((Layout)gridLayout);
        this.createFamilyBlock(innerComposite);
        this.cmbFamily.setLayoutData((Object)horizontalFill);
        this.createDeviceBlock(innerComposite);
        this.cmbDevice.setLayoutData((Object)horizontalFill);
        this.createCoreBlock(innerComposite);
        this.cmbCore.setLayoutData((Object)horizontalFill);
        this.getShell().setText(Messages.HardwareSettingsProjectSetterDialog_title_message);
        this.setHelpAvailable(false);
        return innerComposite;
    }

    private void createFamilyBlock(Composite parent) {
        Label lblFamily = new Label(parent, 16384);
        lblFamily.setText(DIALOG_FAMILY_TEXT);
        this.cmbFamily = new CCombo(parent, 18440);
        TreeSet<String> families = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String str1, String str2) {
                return str1.compareToIgnoreCase(str2);
            }
        });
        List familyDescriptors = FamilyDescriptors.getFamilyDescriptors();
        for (FamilyDescriptor family : familyDescriptors) {
            families.add(family.getName());
        }
        this.cmbFamily.setItems(families.toArray(new String[families.size()]));
        this.cmbFamily.setVisibleItemCount(10);
        this.cmbFamily.addListener(13, event -> {
            String familyName = this.cmbFamily.getText();
            if (!familyName.isEmpty()) {
                this.familyId = "";
                for (FamilyDescriptor family : familyDescriptors) {
                    if (!familyName.equals(family.getName())) continue;
                    this.familyId = family.getId();
                    break;
                }
                List devices = FamilyDescriptors.getDeviceDescriptors((String)this.familyId);
                TreeSet<String> devicesNames = new TreeSet<String>();
                for (DeviceDescriptor device : devices) {
                    devicesNames.add(device.getId());
                }
                this.cmbDevice.removeAll();
                this.cmbDevice.setItems(devicesNames.toArray(new String[devicesNames.size()]));
                this.cmbDevice.setEnabled(true);
                this.cmbCore.removeAll();
                this.cmbCore.setEnabled(false);
            } else {
                this.cmbDevice.setEnabled(false);
                this.cmbCore.setEnabled(false);
            }
            this.validate();
        });
    }

    private void createDeviceBlock(Composite parent) {
        Label lblDevice = new Label(parent, 16384);
        lblDevice.setText(DIALOG_DEVICE_TEXT);
        this.cmbDevice = new CCombo(parent, 18440);
        this.cmbDevice.setEnabled(false);
        this.cmbDevice.addListener(13, event -> {
            String deviceName = this.cmbDevice.getText();
            if (!deviceName.isEmpty()) {
                this.deviceId = "";
                List devices = FamilyDescriptors.getDeviceDescriptors((String)this.familyId);
                for (DeviceDescriptor device : devices) {
                    if (!deviceName.equals(device.getName())) continue;
                    this.deviceId = device.getId();
                    break;
                }
                List deviceCores = DeviceDescriptors.getDeviceCoreDescriptors((String)this.deviceId);
                TreeSet<String> deviceCoresNames = new TreeSet<String>();
                for (DeviceCoreDescriptor deviceCore : deviceCores) {
                    deviceCoresNames.add(deviceCore.getName());
                }
                this.cmbCore.removeAll();
                this.cmbCore.setItems(deviceCoresNames.toArray(new String[deviceCoresNames.size()]));
                this.cmbCore.setEnabled(true);
            } else {
                this.cmbCore.setEnabled(false);
            }
            this.validate();
        });
    }

    private void createCoreBlock(Composite parent) {
        Label lblCore = new Label(parent, 16384);
        lblCore.setText(DIALOG_CORE_TEXT);
        this.cmbCore = new CCombo(parent, 18440);
        this.cmbCore.setEnabled(false);
        this.cmbCore.addListener(13, event -> {
            if (!this.cmbCore.getText().isEmpty()) {
                this.coreId = "";
                this.deviceCoreId = "";
                String deviceCoreName = this.cmbCore.getText();
                List deviceCores = DeviceDescriptors.getDeviceCoreDescriptors((String)this.deviceId);
                for (DeviceCoreDescriptor deviceCore : deviceCores) {
                    if (!deviceCoreName.equals(deviceCore.getName())) continue;
                    this.deviceCoreId = deviceCore.getId();
                    this.coreId = deviceCore.getCoreId();
                    break;
                }
                this.validate();
            }
        });
    }

    private boolean validateField(CCombo toValidate, String errorMsg) {
        boolean isEmpty = toValidate.getText().isEmpty();
        if (isEmpty) {
            this.butOK.setEnabled(false);
            this.setErrorMessage(errorMsg);
        }
        return !isEmpty;
    }

    private void validate() {
        if (this.butOK != null && this.validateField(this.cmbFamily, Messages.HardwareSettingsProjectSetterDialog_select_family_error_message) && this.validateField(this.cmbDevice, Messages.HardwareSettingsProjectSetterDialog_select_device_error_message) && this.validateField(this.cmbCore, Messages.HardwareSettingsProjectSetterDialog_select_core_error_message)) {
            this.setErrorMessage(null);
            this.butOK.setEnabled(true);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control butBar = super.createButtonBar(parent);
        this.butOK = this.getButton(0);
        this.validate();
        return butBar;
    }

    protected void okPressed() {
        ProjectContextSettings projectContextSettings = new ProjectContextSettings(this.project);
        String langId = "";
        try {
            if (this.project.hasNature("org.eclipse.cdt.core.cnature")) {
                langId = C_NATURE;
            }
            if (this.project.hasNature("org.eclipse.cdt.core.ccnature")) {
                langId = CC_NATURE;
            }
        }
        catch (CoreException ex) {
            CdtUiActivator.getInstance().logError("An exception was thrown in the project nature verification process", ex);
        }
        String platformId = projectContextSettings.getAttributeByKey("com.nxp.s32ds.cle.runtime.component.registry.archetype.platform.id");
        projectContextSettings.storeProjectContext(this.familyId, this.deviceId, this.coreId, this.deviceCoreId, null, "", langId, platformId);
        super.okPressed();
    }
}

