/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.tad.common.preferences;

import com.nxp.s32ds.tad.common.TadCommonActivator;
import com.nxp.s32ds.tad.common.messages.Messages;
import com.nxp.s32ds.tad.common.preferences.IPreferencesConstants;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TadPreferences
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String EMPTY_STRING = "";
    protected Group loggingGroup;
    protected RadioGroupFieldEditor radioFieldLogLocation;
    protected DirectoryFieldEditor browseFieldLogLocation;

    public TadPreferences() {
        super(0);
    }

    public TadPreferences(int style) {
        super(style);
    }

    public void init(IWorkbench arg0) {
        this.setPreferenceStore(TadCommonActivator.getDefault().getPreferenceStore());
        this.setTitle(Messages.PreferencesPage_Title);
        this.setDescription(Messages.PreferencesPage_Description);
    }

    protected void initialize() {
        super.initialize();
        if (this.radioFieldLogLocation != null) {
            this.propertyChange(new PropertyChangeEvent((Object)this.radioFieldLogLocation, "field_editor_value", null, (Object)this.getPreferenceStore().getString(this.radioFieldLogLocation.getPreferenceName())));
        }
    }

    protected void createFieldEditors() {
    }

    protected void createLoggingFieldEditors() {
        this.loggingGroup = new Group(this.getFieldEditorParent(), 32);
        GridData layoutData = new GridData(4, 4, true, false);
        layoutData.horizontalSpan = 2;
        this.loggingGroup.setLayoutData((Object)layoutData);
        this.loggingGroup.setText(Messages.Log_GroupLabel);
        this.radioFieldLogLocation = new RadioGroupFieldEditor(String.valueOf(this.getPreferencesPrefix()) + "rtosLoggingLocation", IPreferencesConstants.L_RTOS_LOGGING_LOCATION, IPreferencesConstants.LV_RTOS_LOGGING_LOCATION.length, IPreferencesConstants.LV_RTOS_LOGGING_LOCATION, (Composite)this.loggingGroup);
        this.browseFieldLogLocation = new DirectoryFieldEditor(String.valueOf(this.getPreferencesPrefix()) + "rtosLoggingLocationCustomPath", IPreferencesConstants.L_RTOS_LOGGING_LOCATION_CUSTOM_PATH, (Composite)this.loggingGroup){

            private boolean isCustomLoggingLocation() {
                return "rtosLoggingCustom".equals(TadPreferences.this.radioFieldLogLocation.getSelectionValue());
            }

            public boolean isValid() {
                return !this.isCustomLoggingLocation() || super.isValid();
            }

            protected void refreshValidState() {
                if (!this.isCustomLoggingLocation()) {
                    this.clearErrorMessage();
                    TadPreferences.this.setValid(true);
                } else {
                    super.refreshValidState();
                    TadPreferences.this.setValid(this.isValid() && TadPreferences.this.isValid());
                }
            }
        };
        this.browseFieldLogLocation.setEmptyStringAllowed(false);
        this.browseFieldLogLocation.getTextControl((Composite)this.loggingGroup).addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                TadPreferences.this.browseFieldLogLocation.getTextControl((Composite)TadPreferences.this.loggingGroup).notifyListeners(16, null);
            }
        });
        this.addField((FieldEditor)this.radioFieldLogLocation);
        this.addField((FieldEditor)this.browseFieldLogLocation);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.radioFieldLogLocation != null && this.radioFieldLogLocation.equals(event.getSource()) && "field_editor_value".equals(event.getProperty())) {
            this.browseFieldLogLocation.setEnabled("rtosLoggingCustom".equals(event.getNewValue()), (Composite)this.loggingGroup);
            this.browseFieldLogLocation.getTextControl((Composite)this.loggingGroup).notifyListeners(16, null);
        }
        super.propertyChange(event);
    }

    protected String getPreferencesPrefix() {
        return EMPTY_STRING;
    }

    protected void performDefaults() {
        super.performDefaults();
        if (this.radioFieldLogLocation != null) {
            this.propertyChange(new PropertyChangeEvent((Object)this.radioFieldLogLocation, "field_editor_value", null, (Object)"rtosLoggingWorkspace"));
        }
    }
}

