/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.tad.common.logger;

import com.nxp.s32ds.tad.common.logger.LogType;
import com.nxp.s32ds.tad.common.logger.Logger;
import com.nxp.s32ds.tad.common.model.Time;

public class Log {
    private final String text;
    private final String time;
    private String className;
    private final LogType type;
    private StackTraceElement[] stackTrace;

    public Log(LogType type, String text) {
        this.text = text;
        this.type = type;
        this.time = Time.MILLISECONDS.toString();
        this.stackTrace = Thread.currentThread().getStackTrace();
        int i = 0;
        while (i < this.stackTrace.length) {
            if (this.stackTrace[i].getClassName().equals(Logger.class.getName()) && i + 1 < this.stackTrace.length) {
                String fileName = this.stackTrace[i + 1].getFileName();
                if (fileName == null) break;
                this.className = fileName.replace(".java", "");
                break;
            }
            ++i;
        }
    }

    public Log(Exception e, String message) {
        this(LogType.EXCEPTION, String.format("%s %s", e.getClass().getSimpleName(), message));
        this.stackTrace = e.getStackTrace();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.valueOf(this.time) + " ");
        builder.append(String.valueOf(this.type.toString()) + ": ");
        if (this.className != null) {
            builder.append("[" + this.className + "] ");
        }
        builder.append(this.text);
        if (this.type == LogType.EXCEPTION) {
            StackTraceElement[] stackTraceElementArray = this.stackTrace;
            int n = this.stackTrace.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement line = stackTraceElementArray[n2];
                builder.append(String.valueOf(System.getProperty("line.separator")) + "\t" + line);
                ++n2;
            }
        }
        return builder.toString();
    }

    public LogType getType() {
        return this.type;
    }
}

