/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.validation;

import com.nxp.swtools.provider.configuration.dependencies.IDependency;
import com.nxp.swtools.provider.configuration.storage.StorageDependency;
import com.nxp.swtools.resourcetables.model.Messages;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IChildProvidable;
import com.nxp.swtools.resourcetables.model.config.IComponentConfig;
import com.nxp.swtools.resourcetables.model.config.IFunctionalGroup;
import com.nxp.swtools.validation.engine.IValidationProblem;
import com.nxp.swtools.validation.engine.ProblemUtils;
import com.nxp.swtools.validation.engine.ValidationProblemsUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;

public final class ValidationHelper {
    private ValidationHelper() {
    }

    public static Map<String, List<IValidationProblem>> collectValidationProblemsOnPeripheralsTool() {
        List<String> respondsTo = Arrays.asList("Peripheral", "SWComponent");
        Predicate<IValidationProblem> predicate = p -> respondsTo.contains(p.getDependency().getResourceType());
        Function<IValidationProblem, String> keyTransformer = p -> p.getDependency().getResourceId();
        return ValidationProblemsUtils.getValidationProblemsMap(predicate, keyTransformer);
    }

    public static Map<String, List<IValidationProblem>> collectComponentValidationProblemsOnPeripheralsTool() {
        Predicate<IValidationProblem> predicate = p -> !((StorageDependency)p.getDependency()).getOriginatorId().isEmpty();
        Function<IValidationProblem, String> keyTransformer = p -> ((StorageDependency)p.getDependency()).getOriginatorId();
        return ValidationProblemsUtils.getValidationProblemsMap(predicate, keyTransformer);
    }

    public static List<IValidationProblem> getComponentValidationProblems(IChild component, int problemLevel) {
        return ValidationHelper.getValidationProblems(component, problemLevel, ValidationHelper.getComponentEqualityPredicate());
    }

    public static List<IValidationProblem> getDriverValidationProblems(IChild node, int problemLevel) {
        return ValidationHelper.getValidationProblems(node, problemLevel, ValidationHelper.getComponentIdEqualityPredicate());
    }

    public static int getHighestSeverityComponentValidationProblemLevel(IChild component) {
        return ValidationHelper.getHighestSeverityValidationProblemLevel(component, ValidationHelper.getComponentEqualityPredicate());
    }

    private static BiPredicate<IChild, IValidationProblem> getComponentEqualityPredicate() {
        return (node, problem) -> {
            if (problem.getDependency() instanceof StorageDependency) {
                StorageDependency storageDependency = (StorageDependency)problem.getDependency();
                boolean idEquals = Objects.equals(StorageDependency.extractComponentId((String)storageDependency.getOriginatorId()), StorageDependency.extractComponentId((String)node.getOriginatorId()));
                String dependencySource = storageDependency.getSource();
                String dependencyFunctionalGroupName = dependencySource.substring(dependencySource.indexOf(":") + 1);
                IFunctionalGroup nodeFunctionalGroup = node.getChildContext().getFunctionalGroup();
                String nodeFunctionalGroupName = nodeFunctionalGroup != null ? nodeFunctionalGroup.getName() : "";
                boolean groupEquals = Objects.equals(nodeFunctionalGroupName, dependencyFunctionalGroupName);
                return idEquals && groupEquals;
            }
            return false;
        };
    }

    private static BiPredicate<IChild, IValidationProblem> getComponentIdEqualityPredicate() {
        return (node, problem) -> {
            if (problem.getDependency() instanceof StorageDependency) {
                IComponentConfig componentConfig = ((IChildProvidable)node).getChildContext().getComponentConfig();
                if (componentConfig == null) {
                    return false;
                }
                StorageDependency storageDependency = (StorageDependency)problem.getDependency();
                return Objects.equals(storageDependency.getOriginatorId(), String.valueOf(componentConfig.getId()) + "." + componentConfig.getId());
            }
            return false;
        };
    }

    private static BiPredicate<IChild, IValidationProblem> getSettingEqualityPredicate() {
        return (node, problem) -> {
            if (problem.getDependency() instanceof StorageDependency) {
                StorageDependency storageDependency = (StorageDependency)problem.getDependency();
                boolean idEquals = Objects.equals(storageDependency.getOriginatorId(), node.getOriginatorId());
                String dependencySource = storageDependency.getSource();
                String dependencyFunctionalGroupName = dependencySource.substring(dependencySource.indexOf(":") + 1);
                IFunctionalGroup nodeFunctionalGroup = node.getChildContext().getFunctionalGroup();
                String nodeFunctionalGroupName = nodeFunctionalGroup != null ? nodeFunctionalGroup.getName() : "";
                boolean groupEquals = Objects.equals(nodeFunctionalGroupName, dependencyFunctionalGroupName);
                return idEquals && groupEquals;
            }
            return false;
        };
    }

    private static BiPredicate<IChild, IValidationProblem> getSettingInTreePredicate() {
        return (node, problem) -> {
            if (problem.getDependency() instanceof StorageDependency) {
                StorageDependency storageDependency = (StorageDependency)problem.getDependency();
                boolean containsBeginingOfId = storageDependency.getOriginatorId().startsWith(node.getOriginatorId());
                String dependencySource = storageDependency.getSource();
                String dependencyFunctionalGroupName = dependencySource.substring(dependencySource.indexOf(":") + 1);
                IFunctionalGroup nodeFunctionalGroup = node.getChildContext().getFunctionalGroup();
                String nodeFunctionalGroupName = nodeFunctionalGroup != null ? nodeFunctionalGroup.getName() : "";
                boolean groupEquals = Objects.equals(nodeFunctionalGroupName, dependencyFunctionalGroupName);
                return containsBeginingOfId && groupEquals;
            }
            return false;
        };
    }

    public static List<IValidationProblem> getSettingValidationProblems(IChild setting, int problemLevel) {
        return ValidationHelper.getValidationProblems(setting, problemLevel, ValidationHelper.getSettingEqualityPredicate());
    }

    public static List<IValidationProblem> getSettingValidationProblemsInTree(IChild setting, int problemLevel) {
        return ValidationHelper.getValidationProblems(setting, problemLevel, ValidationHelper.getSettingInTreePredicate());
    }

    public static int getHighestSeveritySettingValidationProblemLevel(IChild setting) {
        return ValidationHelper.getHighestSeverityValidationProblemLevel(setting, ValidationHelper.getSettingEqualityPredicate());
    }

    public static int getHighestSeveritySettingValidationProblemLevelInTree(IChild setting) {
        return ValidationHelper.getHighestSeverityValidationProblemLevel(setting, ValidationHelper.getSettingInTreePredicate());
    }

    private static List<IValidationProblem> getValidationProblems(IChild node, int problemLevel, BiPredicate<IChild, IValidationProblem> biPredicate) {
        ArrayList<IValidationProblem> result = new ArrayList<IValidationProblem>();
        if (problemLevel >= 0) {
            Map<String, List<IValidationProblem>> problems = ValidationHelper.collectComponentValidationProblemsOnPeripheralsTool();
            for (Map.Entry<String, List<IValidationProblem>> entry : problems.entrySet()) {
                List<IValidationProblem> entryValue = entry.getValue();
                for (IValidationProblem problem : entryValue) {
                    if (!biPredicate.test(node, problem) || problem.getProblemLevel() != problemLevel) continue;
                    result.add(problem);
                }
            }
        }
        return result;
    }

    private static int getHighestSeverityValidationProblemLevel(IChild node, BiPredicate<IChild, IValidationProblem> biPredicate) {
        Map<String, List<IValidationProblem>> problems = ValidationHelper.collectComponentValidationProblemsOnPeripheralsTool();
        int highestLevel = -1;
        for (Map.Entry<String, List<IValidationProblem>> entry : problems.entrySet()) {
            boolean allProblemsPassedTest = true;
            List<IValidationProblem> entryValue = entry.getValue();
            for (IValidationProblem value : entryValue) {
                if (biPredicate.test(node, value)) continue;
                allProblemsPassedTest = false;
            }
            if (!allProblemsPassedTest) continue;
            List<IValidationProblem> problemsOfComponent = entryValue;
            int problemLevel = ProblemUtils.getHighestSeverityLevel(problemsOfComponent.stream());
            if (problemLevel >= 3) {
                return problemLevel;
            }
            if (problemLevel <= highestLevel) continue;
            highestLevel = problemLevel;
        }
        return highestLevel;
    }

    public static String getDependenciesMessageInTree(IChild node, int level) {
        StringJoiner joiner = new StringJoiner("\r\n");
        List<IValidationProblem> problemsInTree = ValidationHelper.getSettingValidationProblemsInTree(node, level);
        ArrayList<String> alreadyReportedDescriptions = new ArrayList<String>();
        for (IValidationProblem problem : problemsInTree) {
            IDependency dependency = problem.getDependency();
            String problemDescription = dependency.getDescription();
            if (alreadyReportedDescriptions.contains(problemDescription)) continue;
            alreadyReportedDescriptions.add(problemDescription);
            String prefix = Messages.get().ValidationHelper_PrefixUnknown;
            if (dependency instanceof StorageDependency) {
                String path;
                StorageDependency storageDependency = (StorageDependency)dependency;
                String originatorId = storageDependency.getOriginatorId();
                String nodeId = node.makeOriginatorId(node.getChildContext());
                String relativeId = originatorId.replaceAll(String.valueOf(nodeId) + "\\.", "");
                String pathSeparator = " / ";
                prefix = path = relativeId.replaceAll("\\.", pathSeparator);
            }
            joiner.add(String.valueOf(prefix) + ": " + problemDescription);
        }
        return joiner.toString();
    }
}

