/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.mcu;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.core.service.scriptapi.db.IRegParentPeripheralAPI;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.resourcetables.model.data.McuResourceTables;
import com.nxp.swtools.resourcetables.model.mcu.ICommonMcu;
import com.nxp.swtools.utils.processors.McuUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class ACommonMcu
implements ICommonMcu {
    private static final Logger LOGGER = LogManager.getLogger(ACommonMcu.class);
    private final Collection<ProcessorCore> cores;
    private final IProcessorMasterToolInfo masterToolInfo;
    private final IMcuIdentification mcuIdentification;
    @Nullable
    private final McuResourceTables mcuResourceTables;
    @Nullable
    private final IRegistersDatabaseAPI registersDb;
    public static final String PERIPHERAL_TYPE_MATCH_ALL = "*";

    protected ACommonMcu(@Nullable IRegistersDatabaseAPI registersDb, @Nullable McuResourceTables mcuResourceTables, IMcuIdentification mcuIdentification, IProcessorMasterToolInfo masterToolInfo, Collection<ProcessorCore> cores) {
        this.cores = cores;
        this.masterToolInfo = masterToolInfo;
        this.mcuIdentification = mcuIdentification;
        this.mcuResourceTables = mcuResourceTables;
        this.registersDb = registersDb;
    }

    public @Nullable String getBoard() {
        return this.mcuIdentification.getBoard();
    }

    public @Nullable String getMexVariant() {
        return this.mcuIdentification.getMexVariant();
    }

    @Override
    public @Nullable ProcessorCore getCore(String coreId) {
        for (ProcessorCore core : this.cores) {
            if (!core.getID().equals(coreId)) continue;
            return core;
        }
        return null;
    }

    @Override
    public Collection<ProcessorCore> getCores() {
        return this.cores;
    }

    public JSONObject getCoresList() {
        JSONObject res = new JSONObject();
        for (ProcessorCore onecore : this.cores) {
            JSONObject core = new JSONObject();
            try {
                core.put("name", (Object)onecore.getName());
                core.put("id", (Object)onecore.getID());
                core.put("description", (Object)onecore.getDescription());
                core.put("enabled", onecore.isMasterDefault());
                res.put(onecore.getID(), (Object)core);
            }
            catch (JSONException e) {
                assert (false) : e.getMessage();
            }
        }
        return res;
    }

    @Override
    public @Nullable String getCoreUiName(String coreId) {
        ProcessorCore core = this.getCore(coreId);
        if (core != null) {
            return core.getName();
        }
        return null;
    }

    public String getDataVersion() {
        return this.masterToolInfo.getVersion();
    }

    public String getFamily() {
        return this.masterToolInfo.getFamily();
    }

    public @Nullable String getKit() {
        return this.mcuIdentification.getKit();
    }

    @Override
    public IMcuIdentification getMcuIdentification() {
        return this.mcuIdentification;
    }

    @Override
    public @Nullable McuResourceTables getMcuResourceTables() {
        return this.mcuResourceTables;
    }

    public String getPackage() {
        return this.mcuIdentification.getPackage();
    }

    public String getPartNumber() {
        return this.mcuIdentification.getMcu();
    }

    @Override
    public @Nullable String getPeripheralType(String peripheralInstance) {
        if (this.registersDb != null) {
            IRegParentPeripheralAPI api = this.registersDb.getPeripheral(peripheralInstance);
            if (api == null) {
                return null;
            }
            return api.getAlias("type");
        }
        return null;
    }

    @Override
    public List<String> getPeripherals() {
        if (this.registersDb != null) {
            return (List)Arrays.asList(this.registersDb.getPeripherals()).stream().map(x -> x.getName()).collect(CollectorsUtils.toList());
        }
        return new ArrayList<String>();
    }

    @Override
    public List<String> getPeripherals(String peripheral) {
        ArrayList<String> periphInstances = new ArrayList<String>();
        boolean skipCheck = peripheral.equals(PERIPHERAL_TYPE_MATCH_ALL);
        if (this.registersDb != null) {
            IRegParentPeripheralAPI[] apis;
            IRegParentPeripheralAPI[] iRegParentPeripheralAPIArray = apis = this.registersDb.getPeripherals();
            int n = apis.length;
            int n2 = 0;
            while (n2 < n) {
                IRegParentPeripheralAPI peripheralApi = iRegParentPeripheralAPIArray[n2];
                if (skipCheck || Objects.equals(peripheralApi.getAlias("type"), peripheral)) {
                    periphInstances.add(peripheralApi.getName());
                }
                ++n2;
            }
        }
        return periphInstances;
    }

    @Override
    public @Nullable IRegistersDatabaseAPI getRegistersDb() {
        return this.registersDb;
    }

    public String getSdkVersion() {
        return this.mcuIdentification.getSdkVersion();
    }

    public String getSeries() {
        return this.masterToolInfo.getSeries();
    }

    @Override
    public boolean isMulticore() {
        return this.getCores().size() > 1;
    }

    @Override
    public String getMasterCore() {
        String masterCoreId = McuUtils.getMasterCoreId(this.cores);
        if (masterCoreId != null) {
            return masterCoreId;
        }
        if (this.cores.isEmpty()) {
            LOGGER.severe(MessageFormat.format("[DATA] No core could be found on this MCU ({0})", this.getPackage()));
            return "";
        }
        return ((ProcessorCore)CollectionsUtils.first(this.cores)).getID();
    }

    public static String addCoreNameIfMulticore(ICommonMcu mcu, String core, String name) {
        if (mcu.getCores().size() > 1) {
            name = String.valueOf(name) + "@" + mcu.getCoreUiName(core);
        }
        return name;
    }
}

