/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.data.setting;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.FormatOptions;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.resourcetables.model.data.ComponentLoadingStatus;
import com.nxp.swtools.resourcetables.model.data.Constraint;
import com.nxp.swtools.resourcetables.model.data.Dependency;
import com.nxp.swtools.resourcetables.model.data.DependencyResponse;
import com.nxp.swtools.resourcetables.model.data.Description;
import com.nxp.swtools.resourcetables.model.data.IActiveContextRefResolver;
import com.nxp.swtools.resourcetables.model.data.IConfigurationComponent;
import com.nxp.swtools.resourcetables.model.data.OptionsExpr;
import com.nxp.swtools.resourcetables.model.data.Validation;
import com.nxp.swtools.resourcetables.model.data.setting.ABaseModel;
import com.nxp.swtools.resourcetables.model.data.setting.ACollectionSetting;
import com.nxp.swtools.resourcetables.model.data.setting.DynamicEnumSetting;
import com.nxp.swtools.resourcetables.model.data.setting.ISetting;
import com.nxp.swtools.resourcetables.model.data.setting.IntegerSetting;
import com.nxp.swtools.resourcetables.model.data.setting.ReferenceSetting;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.core.Commit;

public abstract class ASetting
extends ABaseModel
implements ISetting {
    private static final Logger LOGGER = LogManager.getLogger(ASetting.class);
    @Nullable
    private Expression publicCond;
    @Element(type=Validation.class, name="validation", required=false)
    @Nullable
    private @Element(type=Validation.class, name="validation", required=false) @Nullable Validation validation;

    @Override
    @Attribute(name="public", required=false)
    public @Attribute(name="public", required=false) @Nullable String getPublicCondition() {
        return this.publicCond != null ? this.publicCond.formatOutput(FormatOptions.DEFAULT) : null;
    }

    @Attribute(name="public", required=false)
    protected void setPublicCondition(String newCond) {
        if (!newCond.isEmpty()) {
            try {
                this.publicCond = Expression.create((String)newCond);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Public condition of setting \"" + this.getId() + "\" caused exception: " + e.getLocalizedMessage());
            }
        }
    }

    protected ASetting(String id, @Nullable String uiName, @Nullable String uiNameExpr, @Nullable Description description, @Nullable String availableCond, @Nullable String enableCond, @Nullable String publicCond, @Nullable String options, @Nullable OptionsExpr optionsExpression) {
        super(id, uiName, uiNameExpr, description, availableCond, enableCond, options, optionsExpression);
        if (publicCond != null) {
            this.setPublicCondition(publicCond);
        }
        this.validation = null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.publicCond);
        result = 31 * result + Objects.hashCode(this.validation);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        assert (obj != null);
        ASetting other = (ASetting)obj;
        if (!Objects.equals(this.publicCond, other.publicCond)) {
            return false;
        }
        return Objects.equals(this.validation, other.validation);
    }

    @Deprecated
    protected ASetting() {
        this("", null, null, null, null, null, null, null, null);
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + ", " + "validation" + "=" + (this.validation != null ? this.validation : "") + ", " + "public" + "=" + UtilsText.safeString((String)this.getPublicCondition());
    }

    protected @Nullable Validation mergeValidations(@Nullable Validation v1, @Nullable Validation v2) {
        if (v1 == null) {
            return v2;
        }
        if (v2 == null) {
            return v1;
        }
        Validation mergedValidation = new Validation();
        List<Constraint> constraintsFirst = v1.getConstraints();
        List<Constraint> constraintsSecond = v2.getConstraints();
        ArrayList<Constraint> constraints = new ArrayList<Constraint>(constraintsFirst.size() + constraintsSecond.size());
        constraints.addAll(constraintsFirst);
        constraints.addAll(constraintsSecond);
        mergedValidation.setConstraints(constraints);
        List<Dependency> dependenciesFirst = v1.getDependencies();
        List<Dependency> dependenciesSecond = v2.getDependencies();
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>(dependenciesFirst.size() + dependenciesSecond.size());
        dependencies.addAll(dependenciesFirst);
        dependencies.addAll(dependenciesSecond);
        mergedValidation.setDependencies(dependencies);
        List<DependencyResponse> dependencyResponsesFirst = v1.getDependencyResponses();
        List<DependencyResponse> dependencyResponsesSecond = v2.getDependencyResponses();
        ArrayList<DependencyResponse> dependencyResponses = new ArrayList<DependencyResponse>(dependencyResponsesFirst.size() + dependencyResponsesSecond.size());
        dependencyResponses.addAll(dependencyResponsesFirst);
        dependencyResponses.addAll(dependencyResponsesSecond);
        mergedValidation.setDependencyResponses(dependencyResponses);
        return mergedValidation;
    }

    @Override
    public boolean isPublic(IContext context) {
        return this.publicCond != null ? this.publicCond.resolve(context).getBoolean() : false;
    }

    @Override
    public @Nullable Validation getValidation() {
        return this.validation;
    }

    public void setValidation(@Nullable Validation validation) {
        this.validation = validation;
    }

    @Override
    @Commit
    public void commit() {
        super.commit();
        this.verify();
    }

    public void verify() {
        if (!SWToolsProperties.isVerificationOn()) {
            return;
        }
        Validation validationLoc = this.getValidation();
        if (this.isOptionSet("UI_BORDER_HIDDEN") && this.isOptionSet("UI_LABEL_HIDDEN") && validationLoc != null) {
            if (!validationLoc.getConstraints().isEmpty()) {
                LOGGER.log(Level.WARNING, () -> MessageFormat.format("[DATA] [{0}] [{1}] Setting with id \"{2}\" has defined options \"{3}\" and \"{4}\" and cannot contain any constraints", this.getClass().getSimpleName().toUpperCase(Locale.US), ComponentLoadingStatus.getInstanceForCurrentThread().getCurrentlyLoadingComponent(), this.getId(), "UI_BORDER_HIDDEN", "UI_LABEL_HIDDEN"));
            }
            if (!validationLoc.getDependencies().isEmpty()) {
                LOGGER.log(Level.SEVERE, () -> MessageFormat.format("[DATA] [{0}] [{1}] Setting with id \"{2}\" has defined options \"{3}\" and \"{4}\" and cannot contain any dependencies", this.getClass().getSimpleName().toUpperCase(Locale.US), ComponentLoadingStatus.getInstanceForCurrentThread().getCurrentlyLoadingComponent(), this.getId(), "UI_BORDER_HIDDEN", "UI_LABEL_HIDDEN"));
            }
        }
        if (this.isOptionSet("FEATURE_COMPONENT_ADD") && !this.getClass().equals(DynamicEnumSetting.class)) {
            LOGGER.log(Level.SEVERE, () -> MessageFormat.format("[DATA] [{0}] [{1}] Setting with id \"{2}\" does not support option \"{3}\"", this.getClass().getSimpleName().toUpperCase(Locale.US), ComponentLoadingStatus.getInstanceForCurrentThread().getCurrentlyLoadingComponent(), this.getId(), "FEATURE_COMPONENT_ADD"));
        }
        if (this.isOptionSet("FEATURE_PERIPHERAL_SELECT") && (this instanceof IntegerSetting || this instanceof ACollectionSetting)) {
            LOGGER.log(Level.SEVERE, () -> MessageFormat.format("[DATA] [{0}] [{1}] Setting with id \"{2}\" does not support option \"{3}\"", this.getClass().getSimpleName().toUpperCase(Locale.US), ComponentLoadingStatus.getInstanceForCurrentThread().getCurrentlyLoadingComponent(), this.getId(), "FEATURE_PERIPHERAL_SELECT"));
        }
        if (validationLoc == null) {
            return;
        }
        for (Constraint constraint : validationLoc.getConstraints()) {
            if (!constraint.isDescriptionEmpty()) continue;
            LOGGER.log(Level.SEVERE, () -> MessageFormat.format("[DATA] [{0}] [{1}] Constraint in setting with ID \"{2}\" has no description", this.getClass().getSimpleName().toUpperCase(Locale.US), ComponentLoadingStatus.getInstanceForCurrentThread().getCurrentlyLoadingComponent(), this.getId()));
        }
        for (Dependency dependency : validationLoc.getDependencies()) {
            if (!dependency.isDescriptionEmpty()) continue;
            LOGGER.log(Level.SEVERE, () -> MessageFormat.format("[DATA] [{0}] [{1}] Dependency in setting with ID \"{2}\" has no description", this.getClass().getSimpleName().toUpperCase(Locale.US), ComponentLoadingStatus.getInstanceForCurrentThread().getCurrentlyLoadingComponent(), this.getId()));
        }
    }

    protected @Nullable ASetting resolveBaseType(IActiveContextRefResolver sdkRefResolver, @Nullable IConfigurationComponent comp, String setID, String baseTypeId) {
        ReferenceSetting referenceBaseType = this.computeReferenceInstance(baseTypeId);
        if (referenceBaseType != null) {
            LinkedHashMap<String, ISetting> baseSettings = new LinkedHashMap<String, ISetting>();
            baseSettings.put(referenceBaseType.getId(), referenceBaseType);
            sdkRefResolver.resolve(this, baseSettings, comp, setID);
            ISetting refSetting = baseSettings.get(referenceBaseType.getId());
            if (this.getTypeName().equals(refSetting.getTypeName()) && refSetting instanceof ASetting) {
                ASetting baseTypeSetting = (ASetting)refSetting;
                String finalCondition = ASetting.andConditions(this.getAvailableExprString(), baseTypeSetting.getAvailableExprString());
                if (finalCondition != null) {
                    this.setAvailableExprString(finalCondition);
                }
                if ((finalCondition = ASetting.andConditions(this.getEnableExprString(), baseTypeSetting.getEnableExprString())) != null) {
                    this.setEnableExprString(finalCondition);
                }
                if ((finalCondition = ASetting.andConditions(this.getPublicCondition(), baseTypeSetting.getPublicCondition())) != null) {
                    this.setPublicCondition(finalCondition);
                }
                this.setOptionsMap(this.createOptionsMap(baseTypeSetting.getOptionsMap(), this.getOptionsMap()));
                this.setValidation(this.mergeValidations(this.getValidation(), baseTypeSetting.getValidation()));
                return baseTypeSetting;
            }
            LOGGER.severe(MessageFormat.format("[DATA] A setting with ID {0} contains an unresolvable base type with ID {1} to a setting in component with ID {2} and config-set with ID {3}", this.getId(), referenceBaseType.getId(), comp != null ? comp.getId() : null, setID));
        }
        return null;
    }
}

