/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.data;

import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.resourcetables.model.data.ResourceTable;
import com.nxp.swtools.resourcetables.model.data.ResourceTableInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResourceTablesProvider {
    private static final Logger LOGGER = LogManager.getLogger(ResourceTablesProvider.class);
    private static final String RESOURCE_TABLE_EXTENSION = "xml";
    public static final String RESOURCE_TABLE_COMPONENT_EXTENSION = "resource";

    private ResourceTablesProvider() {
    }

    public static Collection<ResourceTableInfo> getResourceTables(String rootDir) {
        List fileNames = UtilsFile.findFilesByExtension((String)UtilsFile.newFile((String)File.separator, (String[])new String[]{rootDir}).getAbsolutePath(), (String)RESOURCE_TABLE_EXTENSION);
        ArrayList<ResourceTableInfo> infos = new ArrayList<ResourceTableInfo>();
        for (String fileName : fileNames) {
            File f = new File(fileName);
            ResourceTable loadedTable = ResourceTable.loadResourceFromFile(f);
            if (loadedTable == null) continue;
            try {
                infos.add(new ResourceTableInfo(loadedTable, f.getAbsolutePath()));
            }
            catch (SecurityException e) {
                LOGGER.log(Level.SEVERE, String.format("[TOOL] internal error: %1s", e.getMessage()));
            }
        }
        return new ArrayList<ResourceTableInfo>(infos);
    }

    public static Collection<ResourceTableInfo> getResourceTablesOfComponent(String rootDir) {
        ArrayList<ResourceTableInfo> infos = new ArrayList<ResourceTableInfo>();
        List fileNames = UtilsFile.findFilesByExtension((String)UtilsFile.newFile((String)File.separator, (String[])new String[]{rootDir}).getAbsolutePath(), (String)RESOURCE_TABLE_COMPONENT_EXTENSION);
        for (String fileName : fileNames) {
            File f = new File(fileName);
            ResourceTable loadedTable = ResourceTable.loadResourceFromFile(f);
            if (loadedTable == null) continue;
            try {
                infos.add(new ResourceTableInfo(loadedTable, f.getAbsolutePath()));
            }
            catch (SecurityException e) {
                LOGGER.log(Level.SEVERE, String.format("[TOOL] internal error: %1s", e.getMessage()));
            }
        }
        return new ArrayList<ResourceTableInfo>(infos);
    }
}

