/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.data;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.resourcetables.model.data.IActiveContextRefContainer;
import com.nxp.swtools.resourcetables.model.data.IActiveContextRefResolver;
import com.nxp.swtools.resourcetables.model.data.IConfigurationComponent;
import com.nxp.swtools.resourcetables.model.data.ReferenceResolverHelper;
import com.nxp.swtools.resourcetables.model.data.ResourceTable;
import com.nxp.swtools.resourcetables.model.data.setting.ACollectionSetting;
import com.nxp.swtools.resourcetables.model.data.setting.ArraySetting;
import com.nxp.swtools.resourcetables.model.data.setting.IID;
import com.nxp.swtools.resourcetables.model.data.setting.ISetting;
import com.nxp.swtools.resourcetables.model.data.setting.ReferenceSetting;
import java.text.MessageFormat;
import java.util.Map;
import java.util.logging.Logger;

public class AvailableResourceTablesRefResolver
implements IActiveContextRefResolver {
    private static final Logger LOGGER = LogManager.getLogger(AvailableResourceTablesRefResolver.class);
    protected IActiveContextRefContainer activeResourceTables;
    @Nullable
    protected ResourceTable currentResourceTable;

    public AvailableResourceTablesRefResolver(IActiveContextRefContainer activeResourceTables) {
        this.activeResourceTables = activeResourceTables;
    }

    @Override
    public void resolve() {
        for (ResourceTable t : this.activeResourceTables.getResourceTables()) {
            t.resolve(this);
        }
    }

    @Override
    public void resolve(IID caller, Map<String, ISetting> where, @Nullable IConfigurationComponent comp, String setID) {
        ResourceTable owner = this.currentResourceTable;
        if (owner == null) {
            throw new IllegalStateException("Incorrect method usage - use {@link #resolve(ResourceTable, LinkedHashMap)}");
        }
        for (ISetting sett : where.values()) {
            if (sett instanceof ACollectionSetting) {
                ACollectionSetting coll = (ACollectionSetting)sett;
                this.resolve(caller, coll.getSettings(), comp, setID);
                continue;
            }
            if (!(sett instanceof ArraySetting)) continue;
            ArraySetting arr = (ArraySetting)sett;
            arr.resolve(this, comp, setID);
        }
        for (ISetting sett : where.values()) {
            if (!(sett instanceof ReferenceSetting)) continue;
            ReferenceSetting rs = (ReferenceSetting)sett;
            this.resolveReferenceSetting(caller, where, setID, rs);
        }
    }

    private void resolveReferenceSetting(IID caller, Map<String, ISetting> where, String setID, ReferenceSetting rs) {
        ResourceTable owner = this.currentResourceTable;
        if (owner == null) {
            throw new IllegalStateException("Incorrect method usage - use {@link #resolve(ResourceTable, Map)}");
        }
        if (!setID.isEmpty()) {
            LOGGER.severe(MessageFormat.format("[DATA] An instance of {0} with ID \"{1}\" contains an unresolvable reference with ID \"{2}\" to a setting in an identified component and config-set with ID \"{3}\"", caller.getClass().getSimpleName(), caller.getId(), rs.getId(), setID));
            return;
        }
        ISetting targetSett = owner.find(new String[]{rs.getReferenceID()});
        if (targetSett == null) {
            LOGGER.severe(MessageFormat.format("[DATA] An instance of {0} with ID \"{1}\" contains an unresolvable reference with ID \"{2}\"", caller.getClass().getSimpleName(), caller.getId(), rs.getId()));
            return;
        }
        ISetting fromReference = targetSett.fromReference(rs);
        where.put(fromReference.getId(), fromReference);
        this.resolveCurrentResourceTable(caller, where);
    }

    public void resolve(ResourceTable caller, Map<String, ISetting> where) {
        this.currentResourceTable = caller;
        this.resolveCurrentResourceTable(caller, where);
        this.currentResourceTable = null;
    }

    private void resolveCurrentResourceTable(IID caller, Map<String, ISetting> where) {
        for (ISetting sett : where.values()) {
            if (sett instanceof ACollectionSetting) {
                ACollectionSetting coll = (ACollectionSetting)sett;
                this.resolveCurrentResourceTable(caller, coll.getSettings());
                continue;
            }
            if (!(sett instanceof ArraySetting)) continue;
            ArraySetting arr = (ArraySetting)sett;
            arr.resolve(this, null, "");
        }
        for (ISetting sett : where.values()) {
            if (!(sett instanceof ReferenceSetting)) continue;
            ReferenceSetting rs = (ReferenceSetting)sett;
            String setID = ReferenceResolverHelper.getRefConfigSet(rs, "");
            this.resolveReferenceSetting(caller, where, setID, rs);
        }
    }

    @Override
    public void setCaller(@NonNull Object caller) {
    }
}

