/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.expression.IFunction;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.resourcetables.model.config.IChild;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.core.Commit;

public class AMigrationDescriptionBase {
    private static final Logger LOGGER = LogManager.getLogger(AMigrationDescriptionBase.class);
    @Attribute(name="description", required=false)
    @Nullable
    private @Attribute(name="description", required=false) @Nullable String description;
    @Attribute(name="description_expr", required=false)
    @Nullable
    private @Attribute(name="description_expr", required=false) @Nullable String descriptionExpressionString;
    @Nullable
    private Expression descriptionExpression;
    @Attribute(name="description_severity", required=false)
    @Nullable
    private @Attribute(name="description_severity", required=false) @Nullable String descriptionSeverity;
    @Attribute(name="description_show_mode", required=false)
    @Nullable
    private @Attribute(name="description_show_mode", required=false) @Nullable String showDescriptionMode;

    public @Nullable String getDescriptionString() {
        return this.description;
    }

    public @Nullable String getDescriptionExpressionString() {
        return this.descriptionExpressionString;
    }

    public @Nullable String getDescription(IContext context, @Nullable IChild targetSetting, @Nullable IChild sourceSetting) {
        if (this.descriptionExpression != null) {
            IValue value = this.descriptionExpression.resolve(context);
            if (value.getType().equals((Object)IValue.Type.FUNCTION)) {
                if (targetSetting == null || sourceSetting == null) {
                    LOGGER.log(Level.FINE, "Source setting or target setting is null. Returning null as description");
                    return null;
                }
                IFunction lambdaFunction = value.getFunctionReference();
                IValue result = lambdaFunction.invokeOn(context, new Object[]{targetSetting, sourceSetting});
                return result.getString();
            }
            return value.getString();
        }
        return this.description;
    }

    public @Nullable String getDescriptionSeverity() {
        return this.descriptionSeverity;
    }

    public @Nullable String getShowDescriptionMode() {
        return this.showDescriptionMode;
    }

    @Commit
    public void commit() {
        String descriptionExpressionStringLoc = this.descriptionExpressionString;
        if (descriptionExpressionStringLoc != null && !descriptionExpressionStringLoc.isEmpty()) {
            this.setDescriptionExpression(descriptionExpressionStringLoc);
        }
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public void setDescriptionExpressionString(@Nullable String descriptionExpressionString) {
        this.descriptionExpressionString = descriptionExpressionString;
        if (descriptionExpressionString != null) {
            this.setDescriptionExpression(descriptionExpressionString);
        }
    }

    private void setDescriptionExpression(String expressionString) {
        this.descriptionExpression = Expression.tryCreate((String)expressionString);
    }

    public void setDescriptionSeverity(@Nullable String severity) {
        this.descriptionSeverity = severity;
    }

    public void setShowDescriptionMode(@Nullable String mode) {
        this.showDescriptionMode = mode;
    }

    public int hashCode() {
        return Objects.hash(this.description, this.descriptionExpressionString, this.descriptionSeverity, this.showDescriptionMode);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AMigrationDescriptionBase other = (AMigrationDescriptionBase)obj;
        if (!Objects.equals(this.description, other.description)) {
            return false;
        }
        if (!Objects.equals(this.descriptionExpressionString, other.descriptionExpressionString)) {
            return false;
        }
        if (!Objects.equals(this.descriptionSeverity, other.descriptionSeverity)) {
            return false;
        }
        return Objects.equals(this.showDescriptionMode, other.showDescriptionMode);
    }
}

