/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.config;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.provider.configuration.storage.periphs.AStoragePeriphsSetting;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Persister;

@Root(name="copy_wrapper", strict=false)
public class SettingConfigCopyWrapper {
    protected static final Logger LOGGER = LogManager.getLogger(SettingConfigCopyWrapper.class);
    private static final Persister PERSISTER = new Persister();
    @Element(name="setting", required=true)
    @Nullable
    private @Element(name="setting", required=true) @Nullable AStoragePeriphsSetting settingStorage;
    @Attribute(name="setting_id", required=false)
    private String settingId = "";
    @Attribute(name="setting_type", required=false)
    private String settingType = "";
    @Attribute(name="component_type", required=false)
    private String componentType = "";

    @Deprecated
    public SettingConfigCopyWrapper() {
    }

    public SettingConfigCopyWrapper(ISettingConfig settingConfig) {
        this.settingStorage = settingConfig.getStorageSetting();
        this.settingType = settingConfig.getModelData().getTypeName();
        this.settingId = settingConfig.getModelData().getId();
        this.componentType = settingConfig.getConfigurationComponentType();
    }

    public @Nullable AStoragePeriphsSetting getSettingStorage() {
        return this.settingStorage;
    }

    public String getSettingType() {
        return this.settingType;
    }

    public String getSettingId() {
        return this.settingId;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public @Nullable String serialize() {
        StringWriter writer = new StringWriter();
        try {
            PERSISTER.write((Object)this, (Writer)writer);
            return writer.toString();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Problem occurred during serializing copy wrapper into XML string: {0}", e.getLocalizedMessage());
            return null;
        }
    }

    public static @Nullable SettingConfigCopyWrapper deserialize(Reader reader) {
        try {
            SettingConfigCopyWrapper read = (SettingConfigCopyWrapper)PERSISTER.read(SettingConfigCopyWrapper.class, reader);
            return read;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Problem occurred during deserializing copy wrapper from XML string: {0}", e.getLocalizedMessage());
            return null;
        }
    }

    public static boolean containsCopyWrapper(String input) {
        return input.startsWith("<copy_wrapper");
    }
}

