/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.config;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.ExpressionException;
import com.nxp.swtools.common.utils.expression.IFunction;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.number.BigRationalRange;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.common.utils.runtime.JobsHelper;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.ComparatorHelpers;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.provider.configuration.storage.periphs.AStoragePeriphsSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsScalarSetting;
import com.nxp.swtools.resourcetables.model.Messages;
import com.nxp.swtools.resourcetables.model.config.ASettingConfig;
import com.nxp.swtools.resourcetables.model.config.AssignConfig;
import com.nxp.swtools.resourcetables.model.config.CacheHelper;
import com.nxp.swtools.resourcetables.model.config.ChildContext;
import com.nxp.swtools.resourcetables.model.config.DependencyResponseConfig;
import com.nxp.swtools.resourcetables.model.config.DumpFormatOptions;
import com.nxp.swtools.resourcetables.model.config.DumpHelper;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IChildProvidable;
import com.nxp.swtools.resourcetables.model.config.IComponentConfig;
import com.nxp.swtools.resourcetables.model.config.IConfigSetConfig;
import com.nxp.swtools.resourcetables.model.config.IRoot;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import com.nxp.swtools.resourcetables.model.config.PeripheralExpressionException;
import com.nxp.swtools.resourcetables.model.config.QuickSelectionHelper;
import com.nxp.swtools.resourcetables.model.config.RegistersModelSingleton;
import com.nxp.swtools.resourcetables.model.config.ScalarUtils;
import com.nxp.swtools.resourcetables.model.data.Assign;
import com.nxp.swtools.resourcetables.model.data.DependencyResponse;
import com.nxp.swtools.resourcetables.model.data.Description;
import com.nxp.swtools.resourcetables.model.data.IQuickSelection;
import com.nxp.swtools.resourcetables.model.data.IQuickSetting;
import com.nxp.swtools.resourcetables.model.data.SortTarget;
import com.nxp.swtools.resourcetables.model.data.Validation;
import com.nxp.swtools.resourcetables.model.data.setting.ABaseModel;
import com.nxp.swtools.resourcetables.model.data.setting.AValueSetting;
import com.nxp.swtools.resourcetables.model.data.setting.BoolSetting;
import com.nxp.swtools.resourcetables.model.data.setting.ButtonSetting;
import com.nxp.swtools.resourcetables.model.data.setting.DynamicEnumSetting;
import com.nxp.swtools.resourcetables.model.data.setting.EnumSetting;
import com.nxp.swtools.resourcetables.model.data.setting.FileSetting;
import com.nxp.swtools.resourcetables.model.data.setting.FloatSetting;
import com.nxp.swtools.resourcetables.model.data.setting.ISetting;
import com.nxp.swtools.resourcetables.model.data.setting.InfoSetting;
import com.nxp.swtools.resourcetables.model.data.setting.IntegerSetting;
import com.nxp.swtools.resourcetables.model.data.setting.SetSetting;
import com.nxp.swtools.resourcetables.model.data.setting.StringSetting;
import com.nxp.swtools.resourcetables.model.data.setting.VariableSetting;
import com.nxp.swtools.resourcetables.model.mcu.ICommonMcu;
import com.nxp.swtools.utils.profiler.Profiler;
import java.io.File;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class ScalarConfig
extends ASettingConfig {
    private static final String RESTRICTION_BINARY = Messages.get().ScalarConfig_RestrictionBinary;
    private static final String RESTRICTION_OCTAL = Messages.get().ScalarConfig_RestrictionOctal;
    private static final String RESTRICTION_DECIMAL = Messages.get().ScalarConfig_RestrictionDecimal;
    private static final String RESTRICTION_HEXADECIMAL = Messages.get().ScalarConfig_RestrictionHexadecimal;
    private static final String VALUE_NOT_INITIALIZED = "Not initialized";
    private static final int TEXT_CUTOFF_LINES = 10;
    private static final Pattern NEW_LINE_ESCAPED_PATTERN = Pattern.compile("\\\\n");
    private static final Pattern TABS_ESCAPED_PATTERN = Pattern.compile("\\\\t");
    private String value;
    private final Type type = this.detectType();
    @Nullable
    private SetSetting.CustomItem customItem = null;

    public ScalarConfig(ScalarConfig original) {
        super(original.id, original.name, original.setting, (AStoragePeriphsSetting)new StoragePeriphsScalarSetting(), original.getChildContext().getParentContext(), original.mcu);
        DynamicEnumSetting.CustomValueSupport customValueSupport;
        if (this.setting instanceof DynamicEnumSetting && (customValueSupport = ((DynamicEnumSetting)this.setting).getCustomValueSupport()) != null) {
            this.customItem = new SetSetting.CustomItem("custom", "Custom...", null, customValueSupport.getDefaultValue(), new Description("Custom value", null), null, null);
        }
        this.value = original.value;
        ((StoragePeriphsScalarSetting)this.storageSetting).setValue(this.value);
        if (this.type == Type.BOOL || this.type == Type.ENUM || this.type == Type.INTEGER || this.type == Type.STRING || this.type == Type.VARIABLE) {
            RegistersModelSingleton.getInstance().getAssignCreationLatch().decrease();
            JobsHelper.runjob((String)UtilsText.safeString((String)Messages.get().ScalarConfig_JobTitle_CreateAssigns), this::createAssignConfig);
        }
    }

    protected ScalarConfig(String id, String name, ISetting setting, ChildContext parentContext, ICommonMcu mcu) {
        super(id, name, setting, (AStoragePeriphsSetting)new StoragePeriphsScalarSetting(), parentContext, mcu);
        DynamicEnumSetting.CustomValueSupport customValueSupport;
        if (setting instanceof DynamicEnumSetting && (customValueSupport = ((DynamicEnumSetting)setting).getCustomValueSupport()) != null) {
            this.customItem = new SetSetting.CustomItem("custom", "Custom...", null, customValueSupport.getDefaultValue(), new Description("Custom value", null), null, null);
        }
        this.value = this.type == Type.VARIABLE || this.type == Type.INFO || this.type == Type.BUTTON || this.type == Type.FILE ? this.getDefaultValue() : VALUE_NOT_INITIALIZED;
        ((StoragePeriphsScalarSetting)this.storageSetting).setValue(this.value);
        if (this.type == Type.BOOL || this.type == Type.ENUM || this.type == Type.INTEGER || this.type == Type.STRING || this.type == Type.VARIABLE || this.type == Type.INFO || this.type == Type.FLOAT) {
            RegistersModelSingleton.getInstance().getAssignCreationLatch().decrease();
            JobsHelper.runjob((String)UtilsText.safeString((String)Messages.get().ScalarConfig_JobTitle_CreateAssigns), this::createAssignConfig);
        }
    }

    private void createAssignConfig() {
        if (this.setting instanceof ABaseModel) {
            ABaseModel baseSetting = (ABaseModel)((Object)this.setting);
            baseSetting.getAssigns().forEach(e -> this.addAssign(new AssignConfig((Assign)e, this)));
        }
        RegistersModelSingleton.getInstance().getAssignCreationLatch().increase();
    }

    @Override
    public void applyOther(ISettingConfig config) {
        this.applyOtherInternal(config, false);
    }

    @Override
    public void applySynchronizedSetting(ISettingConfig config) {
        this.applyOtherInternal(config, true);
    }

    private void applyOtherInternal(ISettingConfig config, boolean checkSynchronization) {
        if (!(config instanceof ScalarConfig)) {
            throw new IllegalArgumentException(String.format("Unexpected setting type with id %1s - expected %2s", config.getId(), ScalarConfig.class.getName()));
        }
        ScalarConfig scalar = (ScalarConfig)config;
        if (!checkSynchronization) {
            this.setValue(scalar.getStringValue(), false);
        } else if (scalar.isSynchronizationEnabled()) {
            this.setValue(scalar.getStringValue(), false);
        }
    }

    @Override
    public void applyQuickSelection(@Nullable IQuickSelection quickSelection, IChild relativeTo) {
        IQuickSetting setToUse;
        String valToUse;
        SetSetting.CustomItem customItemLoc = this.customItem;
        if (this.type == Type.ENUM && customItemLoc != null) {
            customItemLoc.reset();
        }
        if (!this.applyQuickSelectionFromResource(quickSelection, relativeTo) && (valToUse = (setToUse = QuickSelectionHelper.getQuickSelection(quickSelection, this, relativeTo)) != null ? setToUse.getValue() : null) != null) {
            if (this.setting instanceof VariableSetting || this.setting instanceof InfoSetting || this.setting instanceof FileSetting) {
                IComponentConfig componentConfig = this.getChildContext().getComponentConfig();
                String componentId = componentConfig != null ? componentConfig.getId() : "unknown";
                LOGGER.log(Level.SEVERE, MessageFormat.format("[DATA] [{0}] Trying to apply item defaults or quick selection on setting with id \"{1}\" that is of type \"{2}\" which is not supported", componentId, this.getId(), this.setting.getClass().getSimpleName()));
            } else {
                this.setValue(valToUse, false);
            }
        }
    }

    public String getDefaultValue() {
        if (this.isOptionSet("DEFAULT_VALUE") && this.isOptionAvailable("DEFAULT_VALUE")) {
            Object defaultValue = this.getOptionValue("DEFAULT_VALUE");
            String stringValue = String.valueOf(defaultValue);
            return stringValue;
        }
        switch (this.type) {
            case INTEGER: 
            case FLOAT: {
                return this.getDefaultValueFromRange();
            }
            case ENUM: {
                SetSetting.Item item = null;
                try {
                    List<SetSetting.Item> items = this.getEnumItems();
                    item = (SetSetting.Item)CollectionsUtils.nullableOptionalGet(items.stream().filter(x -> x.isAvailable(this.expressionContext) && x.isEnabled(this.expressionContext)).findFirst());
                }
                catch (ExpressionException ex) {
                    ex.log();
                }
                catch (Exception ex) {
                    LOGGER.log(Level.INFO, MessageFormat.format("[TOOL] Could not obtain default value of a \"{0}\" because of exception: {1}", this.setting, ex.getLocalizedMessage()));
                }
                if (item == null) {
                    return "";
                }
                if (item instanceof SetSetting.CustomItem) {
                    return SetSetting.CustomItem.getStorableFormat(item.getValue());
                }
                return item.getId();
            }
            case BOOL: {
                return UtilsText.safeString((String)Boolean.FALSE.toString());
            }
            case BUTTON: {
                return ((ButtonSetting)this.setting).getValueExpression();
            }
            case INFO: {
                return ((InfoSetting)this.setting).getValueExpression();
            }
            case VARIABLE: {
                return ((VariableSetting)this.setting).getValueExpression();
            }
            case FILE: {
                return "";
            }
        }
        return "";
    }

    private String getDefaultValueFromRange() {
        String result = "0";
        BigRationalRange range = null;
        try {
            if (!ScalarUtils.isInRange((ASettingConfig)this, result)) {
                range = ScalarUtils.getConstraintsRange(this);
                if (range != null) {
                    BigRational min = (BigRational)range.getMin();
                    BigRational max = (BigRational)range.getMax();
                    if (min != null) {
                        result = min.toExactDecimalString();
                    } else if (max != null) {
                        result = max.toExactDecimalString();
                    } else {
                        LOGGER.severe("[DATA] 0 is out of range even if there is no explicit restriction of min or max value");
                    }
                } else {
                    LOGGER.severe("[DATA] 0 is out of range even if there is no explicit restriction of min or max value");
                }
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, MessageFormat.format("[DATA] Error obtaining default value from range for the setting: {0}", this.getId()), ex);
        }
        return result;
    }

    private Object parseValue(String valueToConvert) {
        switch (this.type) {
            case INTEGER: {
                BigInteger parsedValue = ScalarUtils.parseInteger(valueToConvert, ((IntegerSetting)this.getModelData()).getType());
                IntegerSetting integerSetting = (IntegerSetting)this.getModelData();
                if (integerSetting.getType() == IntegerSetting.IntegerType.uint64_t) {
                    return parsedValue;
                }
                return parsedValue.longValue();
            }
            case BOOL: {
                return Boolean.valueOf(valueToConvert);
            }
            case BUTTON: {
                if (SwToolsProduct.isUctProduct()) {
                    return valueToConvert;
                }
            }
            case INFO: 
            case VARIABLE: {
                try {
                    return Expression.create((String)valueToConvert).resolve(this.getExpressionContext()).getValue();
                }
                catch (ExpressionException ex) {
                    ex.log();
                    return 0L;
                }
                catch (Exception ex) {
                    String description = "Error resolving current value of info/variable setting: " + UtilsText.safeString((String)ex.getLocalizedMessage());
                    PeripheralExpressionException exception = new PeripheralExpressionException(description, ex, ScalarConfig.class);
                    exception.addContext(this.getExpressionContext());
                    exception.log();
                    throw new CacheHelper.DoNotCacheValue(0L);
                }
            }
            case FLOAT: {
                return BigRational.parse((String)valueToConvert);
            }
            case ENUM: {
                DynamicEnumSetting dynamicEnumSetting;
                DynamicEnumSetting.CustomValueSupport customValueSupport;
                if (this.setting instanceof DynamicEnumSetting && (customValueSupport = (dynamicEnumSetting = (DynamicEnumSetting)this.setting).getCustomValueSupport()) != null && valueToConvert.startsWith("custom:")) {
                    this.validateCustomValue(valueToConvert, customValueSupport);
                }
                return valueToConvert;
            }
        }
        return valueToConvert;
    }

    public void validateCustomValue(String valueToValidate, DynamicEnumSetting.CustomValueSupport customValueSupport) throws IllegalArgumentException {
        String valueOfCustomItem = UtilsText.safeString((String)valueToValidate.substring("custom:".length()));
        Expression validationExpression = customValueSupport.getValidationExpression();
        if (validationExpression != null) {
            IFunction functionReference;
            IValue resolvedExpression = validationExpression.resolve(this.getExpressionContext());
            try {
                functionReference = resolvedExpression.getFunctionReference();
            }
            catch (ExpressionException e) {
                LOGGER.log(Level.SEVERE, "[DATA] Lambda function is required in validation expression of custom value");
                throw e;
            }
            try {
                boolean result = functionReference.invokeOn(this.getExpressionContext(), new Object[]{valueOfCustomItem}).getBoolean();
                if (!result) {
                    ScalarConfig.throwCustomItemValidationExpression(valueOfCustomItem);
                }
            }
            catch (ExpressionException expressionException) {
                ScalarConfig.throwCustomItemValidationExpression(valueOfCustomItem);
            }
        }
    }

    private static void throwCustomItemValidationExpression(String value) {
        throw new SetSetting.CustomItem.CustomItemValidationException(MessageFormat.format("Value: {0} did not pass validation", value));
    }

    public boolean isParseable(String valueToParse) {
        try {
            if (this.type != Type.INFO && this.type != Type.VARIABLE) {
                this.parseValue(valueToParse);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected ScalarConfig(String id, ISetting setting, ChildContext parentContext, StoragePeriphsScalarSetting storageSetting, ICommonMcu mcu) {
        super(id, storageSetting.getName(), setting, (AStoragePeriphsSetting)storageSetting, parentContext, mcu);
        DynamicEnumSetting dynamicEnumSetting;
        DynamicEnumSetting.CustomValueSupport customValueSupport;
        String temporaryValue = storageSetting.getValue();
        if (setting instanceof DynamicEnumSetting && (customValueSupport = (dynamicEnumSetting = (DynamicEnumSetting)setting).getCustomValueSupport()) != null) {
            SetSetting.CustomItem customItemLoc = new SetSetting.CustomItem("custom", "Custom...", null, customValueSupport.getDefaultValue(), new Description("Custom value", null), null, null);
            if (temporaryValue.startsWith("custom:")) {
                customItemLoc.setValue(SetSetting.CustomItem.parseValueFromStorableString(temporaryValue));
            }
            this.customItem = customItemLoc;
        }
        if (!(setting instanceof FileSetting)) {
            temporaryValue = temporaryValue.replaceAll("\\\\n", "\n");
        }
        this.value = temporaryValue;
        if (this.type == Type.BOOL || this.type == Type.ENUM || this.type == Type.INTEGER || this.type == Type.STRING || this.type == Type.VARIABLE) {
            RegistersModelSingleton.getInstance().getAssignCreationLatch().decrease();
            JobsHelper.runjob((String)UtilsText.safeString((String)Messages.get().ScalarConfig_JobTitle_CreateAssigns), this::createAssignConfig);
        }
    }

    @Override
    public void initValue() {
        if (this.value == VALUE_NOT_INITIALIZED) {
            this.setDefaultValue();
        }
    }

    @Override
    public void setDefaultValue() {
        this.setValue(this.getDefaultValue(), false);
    }

    public @Nullable SetSetting.CustomItem getCustomItem() {
        return this.customItem;
    }

    private Type detectType() {
        if (this.setting instanceof IntegerSetting) {
            return Type.INTEGER;
        }
        if (this.setting instanceof EnumSetting || this.setting instanceof DynamicEnumSetting) {
            return Type.ENUM;
        }
        if (this.setting instanceof BoolSetting) {
            return Type.BOOL;
        }
        if (this.setting instanceof ButtonSetting) {
            return Type.BUTTON;
        }
        if (this.setting instanceof FloatSetting) {
            return Type.FLOAT;
        }
        if (this.setting instanceof StringSetting) {
            return Type.STRING;
        }
        if (this.setting instanceof InfoSetting) {
            return Type.INFO;
        }
        if (this.setting instanceof VariableSetting) {
            return Type.VARIABLE;
        }
        if (this.setting instanceof FileSetting) {
            return Type.FILE;
        }
        return Type.UNKNOWN;
    }

    public boolean setValue(String value) {
        return this.setValue(value, true);
    }

    public boolean setValue(String value, boolean check) {
        if (check) {
            if (this.type == Type.VARIABLE || this.type == Type.INFO) {
                LOGGER.log(Level.SEVERE, "[DATA] Setting value to a variable/info setting with ID \"{0}\"", this.id);
            }
            try {
                this.parseValue(value);
            }
            catch (Exception ex) {
                LOGGER.warning(MessageFormat.format("[DATA] Error in validity check of new value: \"{0}\" for setting: \"{1}\". Error message: {2}", value, this.getId(), ex.getMessage()));
                return false;
            }
        }
        this.value = value.replaceAll("\\r\\n|\\n", "\n");
        IRoot profile = this.getPeriphsProfile();
        if (profile != null) {
            profile.clearCacheForValueChange(this);
        }
        ((StoragePeriphsScalarSetting)this.storageSetting).setValue(this.value.replaceAll("\n", "\\\\n"));
        SetSetting.CustomItem customItemLoc = this.customItem;
        if (customItemLoc != null && value.startsWith("custom:")) {
            customItemLoc.setValue(SetSetting.CustomItem.parseValueFromStorableString(value));
        }
        return true;
    }

    @Override
    public Object getValue() {
        return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*value", () -> {
            String unavailableValueExpression;
            if (this.value == VALUE_NOT_INITIALIZED) {
                this.initValue();
            }
            if (!(this.isAvailable() || this.getType() != Type.INFO && this.getType() != Type.VARIABLE || (unavailableValueExpression = ((AValueSetting)this.setting).getUnavailableValueExpression()) == null)) {
                return this.parseValue(unavailableValueExpression);
            }
            try {
                return this.parseValue(this.value);
            }
            catch (SetSetting.CustomItem.CustomItemValidationException customItemValidationException) {
                LOGGER.log(Level.SEVERE, "[DATA] Invalid custom value was found in model. Value was changed to default value.");
                SetSetting.CustomItem customItemLoc = this.customItem;
                if (customItemLoc != null) {
                    customItemLoc.setUINameString("Custom...");
                }
                this.resetToDefaultValue();
                return this.parseValue(this.value);
            }
            catch (CacheHelper.DoNotCacheValue e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, MessageFormat.format("[TOOL] Unknown exception was caught during getValue function, setting default value instead: {0}", e.getLocalizedMessage()));
                this.resetToDefaultValue();
                return this.parseValue(this.value);
            }
        });
    }

    private void resetToDefaultValue() {
        this.setValue(this.getDefaultValue());
        IRoot profile = this.getPeriphsProfile();
        if (profile != null) {
            profile.clearCacheForValueChange(this);
        }
    }

    public String getStringValue() {
        if (this.value == VALUE_NOT_INITIALIZED) {
            this.initValue();
        }
        return this.value;
    }

    public String getFileLinkValue() {
        if (this.value == VALUE_NOT_INITIALIZED) {
            this.initValue();
        }
        if (this.type == Type.FILE && !this.isOptionSet("PERSIST_ON_SELECTION")) {
            return FileSetting.getContentPart(this.value);
        }
        return "";
    }

    public @NonNull String getValueName() {
        Object realValue = this.getValue();
        if (this.type == Type.FLOAT) {
            return ((BigRational)realValue).formatWithSignificantPlaces(((FloatSetting)this.getModelData()).getType().getSignificantDigits());
        }
        String text = UtilsText.safeToString((Object)realValue);
        if (this.getType() == Type.INFO && this.isOptionSet("UI_INFO_COPY_BUTTON") || this.getType() == Type.STRING && this.isOptionSet("UI_MULTI_LINE")) {
            return UtilsText.htmlCode((String)UtilsText.cutOffAfter((String)text, (int)10));
        }
        return text;
    }

    public @Nullable String getSettingValue() {
        SetSetting.Item item;
        String settingValue = this.getValueName();
        if (this.getType() == Type.ENUM && (item = this.getSelectedEnumItem()) != null) {
            settingValue = item.getValue();
        }
        return settingValue;
    }

    public @Nullable Expression getOnClickExpression() {
        if (this.setting instanceof ButtonSetting) {
            return ((ButtonSetting)this.setting).createOnClickExpression();
        }
        return null;
    }

    private @Nullable SetSetting.Item getSelectedEnumItem() {
        String valueLoc = this.value;
        if (valueLoc.startsWith("custom:")) {
            valueLoc = "custom";
        }
        String valueForLambda = valueLoc;
        if (this.getType() == Type.ENUM) {
            return (SetSetting.Item)CollectionsUtils.nullableOptionalGet(this.getEnumItems().stream().filter(x -> x.getId().equals(valueForLambda)).findFirst());
        }
        return null;
    }

    public @Nullable String getEnumItemUiName() {
        SetSetting.Item item;
        if (this.getType() == Type.ENUM && (item = this.getSelectedEnumItem()) != null) {
            return item.getUIName(this.expressionContext);
        }
        return null;
    }

    @Override
    public @NonNull String getTypeName() {
        return UtilsText.safeString((String)this.type.name().toLowerCase(Locale.US));
    }

    public @Nullable String getValueDescription() {
        SetSetting.Item item;
        if (this.getType() == Type.ENUM && (item = this.getSelectedEnumItem()) != null) {
            String itemDescription;
            Description description = item.getDescription();
            if (description != null && !UtilsText.isEmpty((String)(itemDescription = UtilsText.safeString((String)description.getDescription(this.expressionContext))))) {
                String prefix = "";
                if (itemDescription.startsWith("\n")) {
                    prefix = "\n";
                }
                return String.valueOf(prefix) + item.getUIName(this.expressionContext) + "\r\n" + itemDescription;
            }
            return item.getUIName(this.expressionContext);
        }
        String text = this.getValue().toString();
        if (this.getType() == Type.INFO && this.isOptionSet("UI_INFO_COPY_BUTTON") || this.getType() == Type.STRING && this.isOptionSet("UI_MULTI_LINE")) {
            return UtilsText.htmlCode((String)UtilsText.cutOffAfter((String)text, (int)10));
        }
        return text;
    }

    @Override
    public @Nullable String getDescription() {
        StringBuilder builder = new StringBuilder(UtilsText.safeString((String)super.getDescription()));
        if (this.getType() == Type.INTEGER) {
            IntegerSetting integerSetting = (IntegerSetting)this.setting;
            StringJoiner joiner = new StringJoiner(", ");
            if (integerSetting.isHexInputAllowed()) {
                joiner.add(RESTRICTION_HEXADECIMAL);
            }
            if (integerSetting.isDecInputAllowed()) {
                joiner.add(RESTRICTION_DECIMAL);
            }
            if (integerSetting.isOctInputAllowed()) {
                joiner.add(RESTRICTION_OCTAL);
            }
            if (integerSetting.isBinInputAllowed()) {
                joiner.add(RESTRICTION_BINARY);
            }
            if (joiner.length() == 0) {
                joiner.add(String.valueOf(RESTRICTION_HEXADECIMAL) + ", " + RESTRICTION_DECIMAL + ", " + RESTRICTION_OCTAL + ", " + RESTRICTION_BINARY);
            }
            builder.append("\n");
            builder.append(MessageFormat.format(Messages.get().ScalarConfig_SupportedFormats, joiner.toString()));
        }
        return builder.length() != 0 ? builder.toString() : null;
    }

    @Override
    public AStoragePeriphsSetting getStorageSetting() {
        return this.storageSetting;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public boolean isStorable() {
        return this.type != Type.INFO && this.type != Type.VARIABLE;
    }

    @Override
    public boolean isVisible() {
        return this.type != Type.VARIABLE;
    }

    @Override
    public @Nullable String getValueError() {
        return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*value*error", () -> {
            String filePath;
            if (!this.isParseable(this.value)) {
                return Messages.get().ScalarConfig_ValueCannotBeParsed;
            }
            if (this.type == Type.ENUM) {
                DynamicEnumSetting dynamicEnumSetting;
                String temporaryId = this.value;
                if (this.setting instanceof DynamicEnumSetting && (dynamicEnumSetting = (DynamicEnumSetting)this.setting).getCustomValueSupport() != null && this.value.startsWith("custom:")) {
                    temporaryId = "custom";
                }
                String itemId = temporaryId;
                SetSetting.Item item = (SetSetting.Item)CollectionsUtils.nullableOptionalGet(this.getEnumItems().stream().filter(x -> x.getId().equals(itemId)).findFirst());
                if (item == null || !item.isAvailable(this.expressionContext)) {
                    return Messages.get().ScalarConfig_ValueIsNotAvailable;
                }
            } else if (this.type == Type.INTEGER) {
                if (!ScalarUtils.isInRange((ASettingConfig)this, this.value)) {
                    return ScalarUtils.getRangeError(this);
                }
            } else if (this.type == Type.FLOAT) {
                if (!ScalarUtils.isInRange((ASettingConfig)this, this.value)) {
                    return ScalarUtils.getRangeError(this);
                }
            } else if (this.type == Type.STRING) {
                StringSetting stringSetting = (StringSetting)this.setting;
                Expression validationExpression = stringSetting.getValidationExpression();
                if (validationExpression != null) {
                    try {
                        IFunction functionReference;
                        try {
                            functionReference = validationExpression.resolve(this.getExpressionContext()).getFunctionReference();
                        }
                        catch (ExpressionException e) {
                            LOGGER.severe("[DATA] Lambda function is required in validation expression");
                            throw e;
                        }
                        Object result = functionReference.invokeOn(this.getExpressionContext(), new Object[]{this.value}).getValue();
                        if (result instanceof Boolean && !((Boolean)result).booleanValue()) {
                            return Messages.get().ScalarConfig_ValueCannotBeParsed;
                        }
                    }
                    catch (Exception exception) {
                        return Messages.get().ScalarConfig_ValueCannotBeParsed;
                    }
                }
            } else if (this.type == Type.FILE && (filePath = this.getFilePath()) != null) {
                return this.getFileError(filePath);
            }
            return null;
        });
    }

    public @Nullable String getFilePath() {
        if (this.isOptionSet("PERSIST_ON_SELECTION")) {
            return null;
        }
        return FileSetting.getContentPart(this.value);
    }

    public String getFileStateMessage() {
        String content = FileSetting.getContentPart(this.value);
        if (this.isOptionSet("PERSIST_ON_SELECTION")) {
            if (content.isEmpty()) {
                return Messages.get().FileSetting_NotSpecified;
            }
            return Messages.get().FileSetting_Selected;
        }
        String fileError = this.getFileError(content);
        if (fileError != null) {
            return fileError;
        }
        return content;
    }

    public @Nullable String getFileError(String path) {
        if (path.isEmpty()) {
            return null;
        }
        File file = new File(path);
        if (!(this.hasDirectoryType() || file.exists() && file.isFile())) {
            return MessageFormat.format(Messages.get().ScalarConfig_FileDoesNotExists, file.getAbsolutePath());
        }
        if (!(!this.hasDirectoryType() || file.exists() && file.isDirectory())) {
            return MessageFormat.format(Messages.get().ScalarConfig_DirectoryDoesNotExists, file.getAbsolutePath());
        }
        return null;
    }

    public String prepareFileValue(@Nullable String filePath) {
        switch (((FileSetting)this.setting).getType()) {
            case binary: 
            case image: {
                throw new IllegalStateException("Binary files are not yet supported");
            }
            case directory: {
                if (filePath != null) {
                    return "LINK=" + UtilsText.safeString((String)filePath);
                }
                return (String)this.getValue();
            }
        }
        if (this.isOptionSet("PERSIST_ON_SELECTION")) {
            String fileContent = "";
            if (filePath != null) {
                fileContent = UtilsText.safeString((String)UtilsFile.readFileToString((String)filePath, null, (String)"\\\\n"));
            }
            return "CONTENT=" + fileContent;
        }
        if (filePath != null) {
            return "LINK=" + UtilsText.safeString((String)filePath);
        }
        return (String)this.getValue();
    }

    public boolean isCustomValueValid(String customValue) {
        Expression validationExpression;
        DynamicEnumSetting.CustomValueSupport customValueSupport = this.getCustomValueSupport();
        if (customValueSupport != null && (validationExpression = customValueSupport.getValidationExpression()) != null) {
            try {
                IFunction functionReference;
                try {
                    functionReference = validationExpression.resolve(this.getExpressionContext()).getFunctionReference();
                }
                catch (ExpressionException e) {
                    String description = "[DATA] Lambda function is required in validation expression of custom value";
                    LOGGER.severe(description);
                    throw e;
                }
                return functionReference.invokeOn(this.getExpressionContext(), new Object[]{customValue}).getBoolean();
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public @Nullable DynamicEnumSetting.CustomValueSupport getCustomValueSupport() {
        if (this.setting instanceof DynamicEnumSetting) {
            return ((DynamicEnumSetting)this.setting).getCustomValueSupport();
        }
        return null;
    }

    public boolean isFeatureComponentAddDefined() {
        if (this.setting instanceof DynamicEnumSetting) {
            return this.setting.isOptionSet("FEATURE_COMPONENT_ADD");
        }
        return false;
    }

    public @Nullable List<String> getFeatureComponentAddValues() {
        Object optionValue;
        if (this.isFeatureComponentAddDefined() && (optionValue = this.setting.getOptionValue("FEATURE_COMPONENT_ADD", this.expressionContext)) instanceof String) {
            String components = (String)optionValue;
            String[] rawValues = components.split(",");
            return (List)Arrays.stream(rawValues).map(String::trim).collect(CollectorsUtils.toList());
        }
        return null;
    }

    public @Nullable Expression getStringValidationExpr() {
        if (this.setting instanceof StringSetting) {
            return ((StringSetting)this.setting).getValidationExpression();
        }
        if (this.setting instanceof IntegerSetting) {
            String prefix = "(input) -> (";
            String suffix = ")";
            StringJoiner joiner = new StringJoiner(" || ", prefix, suffix);
            IntegerSetting integerSetting = (IntegerSetting)this.setting;
            if (integerSetting.isHexInputAllowed()) {
                joiner.add("input.regexMatch(`0x[0-9a-fA-F]+`)");
            }
            if (integerSetting.isDecInputAllowed()) {
                joiner.add("input.regexMatch(`0|-?[1-9][0-9]*`)");
            }
            if (integerSetting.isBinInputAllowed()) {
                joiner.add("input.regexMatch(`0b[0-1]+`)");
            }
            if (integerSetting.isOctInputAllowed()) {
                joiner.add("input.regexMatch(`0[0-7]+`)");
            }
            if (joiner.length() == prefix.length() + suffix.length()) {
                joiner.add("true");
            }
            return Expression.tryCreate((String)joiner.toString());
        }
        return null;
    }

    public List<SetSetting.Item> getEnumItems() {
        ArrayList result;
        block11: {
            SortTarget sortTarget;
            if (this.setting instanceof EnumSetting) {
                result = ((EnumSetting)this.setting).getItems();
            } else if (this.setting instanceof DynamicEnumSetting) {
                result = CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*items", () -> {
                    DynamicEnumSetting dynamicEnumSetting = (DynamicEnumSetting)this.setting;
                    Expression itemsExpr = dynamicEnumSetting.getItemsExpr();
                    ArrayList<SetSetting.CustomItem> enumItems = new ArrayList<SetSetting.CustomItem>();
                    if (itemsExpr != null) {
                        Profiler profiler;
                        BigInteger index = profiler.start(ScalarConfig.class, (Object)(!(profiler = Profiler.getInstance((Object)"Peripherals")).isEnabled() ? "" : "Dynamic enum createItems for " + this.getId()));
                        IValue resolvedValue = itemsExpr.resolve(this.getExpressionContext());
                        Object data = resolvedValue.getValue();
                        List inputItems = CollectionsUtils.emptyList();
                        if (data instanceof IChildProvidable) {
                            inputItems = ((IChildProvidable)data).getChildren();
                        } else if (data instanceof List) {
                            inputItems = (List)data;
                        }
                        inputItems.forEach(item -> {
                            if (item instanceof SetSetting.Item) {
                                enumItems.add((SetSetting.CustomItem)((SetSetting.Item)item));
                            } else if (item instanceof IChild) {
                                IChild child = (IChild)item;
                                String descriptionString = child.getDescription();
                                Description itemDescription = descriptionString == null ? null : new Description(descriptionString, null);
                                enumItems.add((SetSetting.CustomItem)new SetSetting.Item(child.getId(), child.getName(), null, child.getId(), itemDescription, null, null));
                            } else {
                                String stringItem = UtilsText.safeString((String)(item == null ? null : item.toString()));
                                enumItems.add((SetSetting.CustomItem)new SetSetting.Item(stringItem, stringItem, null, stringItem, new Description(stringItem, null), null, null));
                            }
                        });
                        profiler.stop(index, ScalarConfig.class, null);
                    }
                    if (SWToolsProperties.isVerificationOn() && this.isOptionSet("FEATURE_PERIPHERAL_SELECT")) {
                        IConfigSetConfig configSet = this.getChildContext().getConfigSetConfig();
                        if (configSet != null && "#global".equals(configSet.getName())) {
                            LOGGER.severe(String.format("[DATA] Dynamic enum: %s - The feature %s cannot be used in global config set", this.getId(), "FEATURE_PERIPHERAL_SELECT"));
                        }
                        List<String> mcuPeripherals = this.mcu.getPeripherals();
                        enumItems.forEach(ei -> {
                            if (!mcuPeripherals.contains(ei.getId()) && ei.isAvailable(this.getExpressionContext())) {
                                LOGGER.severe(String.format("[DATA] Dynamic enum: %s - The peripheral with ID %s is not available on the %s MCU", this.getId(), ei.getId(), this.mcu.getPackage()));
                            }
                        });
                    }
                    if (this.customItem != null) {
                        enumItems.add(this.customItem);
                    }
                    return enumItems;
                });
            } else {
                throw new IllegalStateException("Cannot get enum items from setting of type " + (Object)((Object)this.getType()));
            }
            Object optionValue = this.getOptionValue("UI_SORT_CONTENT_AS");
            if (!(optionValue instanceof String) || (sortTarget = this.getSortTargetValue()) == SortTarget.UNKNOWN) break block11;
            result = new ArrayList(result);
            switch ((String)optionValue) {
                case "ASC_NATURAL": {
                    Collections.sort(result, (o1, o2) -> ComparatorHelpers.compareAscendingNatural((String)o1.getTargetValue(sortTarget, this.getExpressionContext()), (String)o2.getTargetValue(sortTarget, this.getExpressionContext())));
                    break;
                }
                default: {
                    LOGGER.severe(String.format("[DATA] Unknown %1s option value: %2s of setting: %3s", "UI_SORT_CONTENT_AS", optionValue, this.setting.getId()));
                }
            }
        }
        return result;
    }

    @Override
    public void updateStorageAvailability() {
    }

    @Override
    public void deInitialize() {
        this.value = VALUE_NOT_INITIALIZED;
        IRoot profile = this.getPeriphsProfile();
        if (profile != null) {
            profile.clearCacheForValueChange(this);
        }
        ((StoragePeriphsScalarSetting)this.storageSetting).setValue(this.value);
    }

    public static String replaceMarksWithMeanings(String input) {
        String output = input;
        output = NEW_LINE_ESCAPED_PATTERN.matcher(output).replaceAll(UtilsText.platformEOL);
        output = TABS_ESCAPED_PATTERN.matcher(output).replaceAll("\t");
        return output;
    }

    private static @Nullable IRoot getPeriphsProfile(ScalarConfig instance) {
        return instance.childContext.getRoot();
    }

    private @Nullable IRoot getPeriphsProfile() {
        return ScalarConfig.getPeriphsProfile(this);
    }

    @Override
    public List<DependencyResponseConfig> getDependencyResponses() {
        Validation validation = this.setting.getValidation();
        if (validation == null) {
            return Collections.emptyList();
        }
        return (List)validation.getDependencyResponses().stream().map(r -> new DependencyResponseConfig(this, (DependencyResponse)r)).collect(CollectorsUtils.toList());
    }

    public boolean hasDirectoryType() {
        if (this.type.equals((Object)Type.FILE)) {
            return FileSetting.FileType.directory.equals((Object)((FileSetting)this.getModelData()).getType());
        }
        return false;
    }

    @Override
    public void synchronizeValue(@Nullable IChild config) {
        if (this.type == Type.VARIABLE || this.type == Type.INFO || this.type == Type.BUTTON) {
            return;
        }
        super.synchronizeValue(config);
    }

    @Override
    public boolean isSynchronizationEnabled() {
        if (this.type == Type.VARIABLE || this.type == Type.INFO || this.type == Type.BUTTON) {
            return false;
        }
        return super.isSynchronizationEnabled();
    }

    @Override
    public boolean hasDifferentValueWhenNotAvailable() {
        boolean isSettingInfoOrVariable;
        boolean bl = isSettingInfoOrVariable = this.type == Type.INFO || this.type == Type.VARIABLE;
        if (isSettingInfoOrVariable && this.setting instanceof AValueSetting) {
            return ((AValueSetting)this.setting).getUnavailableValueExpression() != null;
        }
        return false;
    }

    @Override
    public boolean providesSnippet() {
        return this.getType() == Type.INFO && this.isOptionAvailable("UI_INFO_COPY_BUTTON") && !this.isOptionAvailable("SNIPPET_DISABLED");
    }

    @Override
    public StringBuilder dump(StringBuilder builder, DumpFormatOptions options) {
        return DumpHelper.dump(builder, options, this);
    }

    public static enum Type {
        INTEGER,
        FLOAT,
        BOOL,
        ENUM,
        STRING,
        INFO,
        VARIABLE,
        FILE,
        BUTTON,
        UNKNOWN;

    }
}

