/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.config;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.resourcetables.model.config.EmptyRoot;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IChildProvidable;
import com.nxp.swtools.resourcetables.model.config.IComponentConfig;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.config.IConfigSetConfig;
import com.nxp.swtools.resourcetables.model.config.IFunctionalGroup;
import com.nxp.swtools.resourcetables.model.config.IRoot;
import java.text.MessageFormat;
import java.util.logging.Logger;

public class ChildContext
implements Cloneable {
    private static final Logger LOGGER = LogManager.getLogger(ChildContext.class);
    @Nullable
    private IComponentConfig componentConfig;
    @Nullable
    private IConfigSetConfig configSetConfig;
    private IChild current;
    @Nullable
    private IChildProvidable parent;
    private IRoot root;
    @Nullable
    private IComponentInstanceConfig componentInstanceConfig;
    @Nullable
    private IFunctionalGroup group;

    public ChildContext(IRoot root) {
        this.current = root;
        this.root = root;
    }

    public @Nullable IComponentConfig getComponentConfig() {
        return this.componentConfig;
    }

    public void setComponentConfig(@Nullable IComponentConfig componentConfig) {
        this.componentConfig = componentConfig;
    }

    public @Nullable IComponentInstanceConfig getComponentInstanceConfig() {
        return this.componentInstanceConfig;
    }

    public void setComponentInstanceConfig(@Nullable IComponentInstanceConfig componentInstanceConfig) {
        this.componentInstanceConfig = componentInstanceConfig;
    }

    public @Nullable IConfigSetConfig getConfigSetConfig() {
        return this.configSetConfig;
    }

    public void setConfigSetConfig(@Nullable IConfigSetConfig configSetConfig) {
        this.configSetConfig = configSetConfig;
    }

    public IChild getCurrent() {
        return this.current;
    }

    public void setCurrent(IChild current) {
        this.current = current;
    }

    public @Nullable IFunctionalGroup getFunctionalGroup() {
        return this.group;
    }

    public void setGroup(@Nullable IFunctionalGroup group) {
        this.group = group;
    }

    public @Nullable IChildProvidable getParent() {
        return this.parent;
    }

    public void setParent(@Nullable IChildProvidable parent) {
        this.parent = parent;
    }

    public IRoot getRoot() {
        return this.root;
    }

    @Deprecated
    public IRoot getProfile() {
        return this.getRoot();
    }

    public void setRoot(IRoot root) {
        this.root = root;
    }

    public ChildContext createForChild(IChild child) {
        ChildContext childContext = this.clone();
        if (!(childContext.getCurrent() instanceof IChildProvidable)) {
            LOGGER.severe(() -> MessageFormat.format("[DATA] Setting with id \"{0}\" is trying to create a context for it''s child with id \"{1}\", but it is not supposed to have children.", this.getCurrent().getId(), child.getId()));
        }
        childContext.setParent((IChildProvidable)this.getCurrent());
        childContext.setCurrent(child);
        return childContext;
    }

    public ChildContext getParentContext() {
        IChildProvidable parentLoc = this.getParent();
        if (parentLoc == null) {
            LOGGER.severe("[TOOL] The current ChildContext instance have a null parent");
            return this;
        }
        return parentLoc.getChildContext();
    }

    protected ChildContext clone() {
        ChildContext clone = new ChildContext(this.root);
        clone.componentConfig = this.componentConfig;
        clone.componentInstanceConfig = this.componentInstanceConfig;
        clone.configSetConfig = this.configSetConfig;
        clone.current = this.current;
        clone.group = this.group;
        clone.parent = this.parent;
        return clone;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + "\r\n" + " $this = " + this.getCurrent().getId() + "\r\n" + " $instance = " + (this.componentInstanceConfig != null ? this.componentInstanceConfig.getId() : "") + "\r\n" + " $group = " + (this.group != null ? this.group.getId() : "") + "]";
    }

    public void dispose() {
        this.componentConfig = null;
        this.componentInstanceConfig = null;
        this.configSetConfig = null;
        this.group = null;
        this.parent = null;
        this.root = EmptyRoot.getEmptyRoot();
    }
}

