/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.config;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.ExpressionException;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.expression.IFunction;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.common.utils.text.ComparatorHelpers;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.provider.configuration.storage.periphs.AStoragePeriphsSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.AStoragePeriphsStructuredSetting;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsArraySetting;
import com.nxp.swtools.resourcetables.model.Messages;
import com.nxp.swtools.resourcetables.model.config.ASettingConfig;
import com.nxp.swtools.resourcetables.model.config.AStructuredSettingConfig;
import com.nxp.swtools.resourcetables.model.config.CacheHelper;
import com.nxp.swtools.resourcetables.model.config.ChildContext;
import com.nxp.swtools.resourcetables.model.config.ConfigCopyFactory;
import com.nxp.swtools.resourcetables.model.config.DumpFormatOptions;
import com.nxp.swtools.resourcetables.model.config.DumpHelper;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IPresettable;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import com.nxp.swtools.resourcetables.model.config.PeripheralExpressionException;
import com.nxp.swtools.resourcetables.model.config.QuickSelectionHelper;
import com.nxp.swtools.resourcetables.model.config.ScalarConfig;
import com.nxp.swtools.resourcetables.model.config.ScalarUtils;
import com.nxp.swtools.resourcetables.model.data.IQuickSelection;
import com.nxp.swtools.resourcetables.model.data.IQuickSetting;
import com.nxp.swtools.resourcetables.model.data.QuickSelection;
import com.nxp.swtools.resourcetables.model.data.QuickSetting;
import com.nxp.swtools.resourcetables.model.data.SettingUtils;
import com.nxp.swtools.resourcetables.model.data.SortTarget;
import com.nxp.swtools.resourcetables.model.data.setting.ArraySetting;
import com.nxp.swtools.resourcetables.model.data.setting.ISetting;
import com.nxp.swtools.resourcetables.model.data.setting.ItemDefaults;
import com.nxp.swtools.resourcetables.model.mcu.ICommonMcu;
import com.nxp.swtools.utils.profiler.Profiler;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;

public class ArrayConfig
extends AStructuredSettingConfig {
    private static final String LAMBDA_FOR_KEY_EXPR = "Lambda function is required for key_expr";
    private final List<ISettingConfig> settings = new ArrayList<ISettingConfig>();
    private ISetting instanceSetting;
    private Representation representation = Representation.VERTICAL_FORM;

    public ArrayConfig(ArrayConfig original) {
        super(original.id, original.name, original.setting, (AStoragePeriphsStructuredSetting)new StoragePeriphsArraySetting(), original.getChildContext().clone(), original.mcu);
        this.instanceSetting = ((ArraySetting)original.setting).getReferenceType();
        for (ISettingConfig originalChild : original.getChildren()) {
            ISettingConfig newChild = ConfigCopyFactory.getCopyOf(originalChild);
            if (newChild == null) {
                LOGGER.log(Level.SEVERE, "[TOOL] Cannot make copy of child from original. Using original child instead of its copy");
                newChild = originalChild;
            }
            this.addSetting(newChild);
        }
    }

    protected ArrayConfig(String id, String name, ISetting setting, ChildContext parentContext, ICommonMcu mcu) {
        super(id, name, setting, (AStoragePeriphsStructuredSetting)new StoragePeriphsArraySetting(), parentContext, mcu);
        this.instanceSetting = ((ArraySetting)setting).getReferenceType();
        this.representation = this.computeDefaultRepresentation();
    }

    /*
     * Exception decompiling
     */
    private Representation computeDefaultRepresentation() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[7] lbl57 : CaseStatement: default:\u000a, @NONE, blocks:[7] lbl57 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ISetting getInstanceSetting() {
        return this.instanceSetting;
    }

    @Override
    public void applyOther(ISettingConfig config) {
        this.applyOtherInternal(config, false);
    }

    @Override
    public void applyQuickSelection(@Nullable IQuickSelection quickSelection, IChild relativeTo) {
        this.settings.clear();
        this.getChildContext().getRoot().clearCacheForValueChange(this);
        this.getChildContext().getRoot().clearCacheForChildrenChange(this);
        ((StoragePeriphsArraySetting)this.storageSetting).getSettings().clear();
        this.updateStorageAvailability();
        if (!this.applyQuickSelectionFromResource(quickSelection, relativeTo)) {
            Profiler profiler;
            String quickSelectionId = QuickSelectionHelper.getQuickSelectionId(this, relativeTo);
            String idWithSeparator = quickSelectionId.isEmpty() ? "" : String.valueOf(quickSelectionId) + ".";
            ArrayList<String> configQuickSelIds = new ArrayList<String>();
            if (quickSelection != null) {
                for (IQuickSetting sett : quickSelection.getSettings()) {
                    if (!sett.getId().startsWith(idWithSeparator)) continue;
                    configQuickSelIds.add(sett.getId());
                }
            }
            int length = 0;
            for (String cfgQsId : configQuickSelIds) {
                String sndPart = cfgQsId.substring(idWithSeparator.length(), cfgQsId.length());
                int idxOfDot = sndPart.indexOf(".");
                String numberPart = idxOfDot >= 0 ? sndPart.substring(0, idxOfDot) : sndPart;
                try {
                    int number = Integer.parseInt(numberPart);
                    length = Math.max(length, number + 1);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            BigInteger createIndex = profiler.start(ArrayConfig.class, (Object)(!(profiler = Profiler.getInstance((Object)"Peripherals")).isEnabled() ? "" : "Apply quick selection - create items - on array " + this.getId()));
            int i = 0;
            while (i < length) {
                ISettingConfig settingConfig = this.addNewItem();
                settingConfig.applyQuickSelection(quickSelection, relativeTo);
                ++i;
            }
            profiler.stop(createIndex, ArrayConfig.class, null);
        }
    }

    protected ArrayConfig(String id, ISetting setting, ChildContext parentContext, StoragePeriphsArraySetting storageSetting, ICommonMcu mcu) {
        super(id, storageSetting.getName(), setting, (AStoragePeriphsStructuredSetting)storageSetting, parentContext, mcu);
        this.instanceSetting = ((ArraySetting)setting).getReferenceType();
        for (AStoragePeriphsSetting storageChildSetting : storageSetting.getSettings()) {
            String childName = UtilsText.safeString((String)Integer.toString(this.settings.size()));
            String childId = SettingUtils.buildId(id, childName);
            if (storageChildSetting.getName().isEmpty()) {
                storageChildSetting.setName(childName);
            }
            ISettingConfig settingConfig = this.childContext.getRoot().getConfigFactory().createSettingConfig(childId, this.instanceSetting, this.childContext, storageChildSetting, mcu);
            settingConfig.setUiNameSupplier(() -> this.determineUiName(settingConfig));
            this.addSetting(settingConfig);
        }
        this.representation = this.computeDefaultRepresentation();
    }

    @Override
    public ArrayConfig getValue() {
        return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*value", () -> this);
    }

    public @Nullable ISettingConfig getValue(int idx) {
        if (idx < 0 || idx >= this.settings.size()) {
            return null;
        }
        return this.settings.get(idx);
    }

    @Override
    public @Nullable IChild getChild(String childName) {
        try {
            Integer intId = Integer.valueOf(childName);
            return this.getValue(intId);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public List<ISettingConfig> getChildren() {
        return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*children", () -> CollectionsUtils.unmodifiableList(this.settings));
    }

    public boolean addSetting(ISettingConfig settingConfig) {
        boolean added = this.settings.add(settingConfig);
        if (added) {
            this.getChildContext().getRoot().clearCacheForChildrenChange(this);
        }
        return added;
    }

    public void addSetting(ISettingConfig settingConfig, int index) {
        this.settings.add(index, settingConfig);
        this.getChildContext().getRoot().clearCacheForChildrenChange(this);
    }

    public ISettingConfig addNewItem() {
        String childName = UtilsText.safeString((String)Integer.toString(this.settings.size()));
        String childId = SettingUtils.buildId(this.id, childName);
        ISettingConfig settingConfig = this.childContext.getRoot().getConfigFactory().createSettingConfig(childId, childName, this.instanceSetting, this.childContext, this.mcu);
        if (settingConfig instanceof IPresettable) {
            IPresettable presetable = (IPresettable)((Object)settingConfig);
            IQuickSelection defaultQS = QuickSelectionHelper.getDefaultQuickSelection(presetable);
            presetable.setQuickSelection(defaultQS);
        }
        settingConfig.delayedInitAfterCreation();
        settingConfig.setUiNameSupplier(() -> this.determineUiName(settingConfig));
        this.addSetting(settingConfig);
        this.applyItemDefaults(settingConfig);
        settingConfig.populateRelatedSettingsList(null);
        if (settingConfig.isStorable()) {
            ((StoragePeriphsArraySetting)this.storageSetting).getSettings().add(settingConfig.getStorageSetting());
        }
        return settingConfig;
    }

    public void applyItemDefaults(ISettingConfig settingConfig) {
        ArraySetting arraySetting = this.getModelData();
        ItemDefaults itemDefaults = arraySetting.getItemDefaults();
        if (itemDefaults != null) {
            String quickSelectionId = SettingUtils.buildId(settingConfig.getName(), "item_defaults_to_quick_selection");
            try {
                if (settingConfig instanceof AStructuredSettingConfig) {
                    AStructuredSettingConfig config = (AStructuredSettingConfig)settingConfig;
                    Set<Map.Entry<String, ItemDefaults.SetDefault>> setDefaultsEntrySet = itemDefaults.getDefaults().entrySet();
                    QuickSelection setQuickSelection = new QuickSelection(quickSelectionId, null, null, null, null);
                    for (Map.Entry<String, ItemDefaults.SetDefault> entry : setDefaultsEntrySet) {
                        Expression valueExpr = entry.getValue().getValueExpr();
                        String key = entry.getKey();
                        IChild child = config.getChildById(key);
                        QuickSetting quickSet = this.getQuickSetting(settingConfig, key, valueExpr);
                        if (quickSet == null) continue;
                        if (child instanceof ISettingConfig) {
                            QuickSelection quickSelection = new QuickSelection(quickSelectionId, null, null, null, null);
                            quickSelection.addSetting(quickSet);
                            ((ISettingConfig)child).applyQuickSelection(quickSelection, this);
                            continue;
                        }
                        setQuickSelection.addSetting(quickSet);
                    }
                    if (!setQuickSelection.getSettings().isEmpty()) {
                        settingConfig.applyQuickSelection(setQuickSelection, this);
                    }
                } else {
                    Map<String, ItemDefaults.SetDefault> defaults = itemDefaults.getDefaults();
                    if (!defaults.isEmpty()) {
                        Map.Entry entry = (Map.Entry)defaults.entrySet().stream().findFirst().get();
                        Expression valueExpr = ((ItemDefaults.SetDefault)entry.getValue()).getValueExpr();
                        QuickSetting quickSet = this.getQuickSetting(settingConfig, (String)entry.getKey(), valueExpr);
                        if (quickSet != null) {
                            QuickSelection quickSelection = new QuickSelection(quickSelectionId, null, null, null, null);
                            quickSelection.addSetting(quickSet);
                            settingConfig.applyQuickSelection(quickSelection, this);
                        }
                    }
                }
            }
            catch (ExpressionException e) {
                e.log();
            }
        }
        settingConfig.initValue();
    }

    private @Nullable QuickSetting getQuickSetting(ISettingConfig settingConfig, String key, @Nullable Expression valueExpr) throws ExpressionException {
        if (valueExpr != null) {
            String relativeId = QuickSelectionHelper.getQuickSelectionId(settingConfig, this);
            if (!UtilsText.isEmpty((String)key)) {
                relativeId = SettingUtils.buildId(relativeId, key);
            }
            IValue lambdaValue = valueExpr.resolve(this.expressionContext);
            IFunction functionReference = lambdaValue.getFunctionReference();
            IValue resolvedValue = functionReference.invokeOn(this.expressionContext, new Object[]{settingConfig});
            if (resolvedValue.getValue() instanceof ISettingConfig) {
                Expression fakeExpression = Expression.createConstant((IValue)resolvedValue);
                QuickSetting quickSetting = new QuickSetting(relativeId, null, null);
                quickSetting.setResourceExpr(fakeExpression);
                return quickSetting;
            }
            return new QuickSetting(relativeId, null, resolvedValue.getString());
        }
        return null;
    }

    @Override
    public ArraySetting getModelData() {
        return (ArraySetting)super.getModelData();
    }

    public @Nullable ISettingConfig getSettingByKey(String key, IContext argContext) {
        Expression keyExpr = ((ArraySetting)this.setting).getKeySelector();
        if (keyExpr != null) {
            for (ISettingConfig member : this.settings) {
                String result = CacheHelper.getValueCaching(this, String.valueOf(member.getId()) + "*key_selector_expr", () -> {
                    try {
                        return keyExpr.resolve(argContext).getFunctionReference().invokeOn(member.getExpressionContext(), new Object[]{member}).getString();
                    }
                    catch (ExpressionException e) {
                        throw new PeripheralExpressionException(LAMBDA_FOR_KEY_EXPR, e, ArrayConfig.class);
                    }
                });
                if (!key.equals(result)) continue;
                return member;
            }
        }
        return null;
    }

    public boolean settingWithKeyExists(String key, IContext argContext) {
        return this.getSettingByKey(key, argContext) != null;
    }

    public @Nullable String getSettingKey(ISettingConfig member, IContext argContext) {
        Expression keyExpr;
        if (!this.settings.contains(member)) {
            LOGGER.log(Level.SEVERE, () -> MessageFormat.format("[DATA] Array with ID \"{0}\" does not contain element with ID \"{1}\" to be able to call getSettingKey()", this.getId(), member.getId()));
        }
        if ((keyExpr = ((ArraySetting)this.setting).getKeySelector()) != null) {
            return CacheHelper.getValueCaching(this, String.valueOf(member.getId()) + "*key_selector_expr", () -> {
                try {
                    return keyExpr.resolve(argContext).getFunctionReference().invokeOn(member.getExpressionContext(), new Object[]{member}).getString();
                }
                catch (ExpressionException e) {
                    throw new PeripheralExpressionException(LAMBDA_FOR_KEY_EXPR, e, ArrayConfig.class);
                }
            });
        }
        return null;
    }

    public StoragePeriphsArraySetting getStorageSetting() {
        return (StoragePeriphsArraySetting)this.storageSetting;
    }

    public boolean moveFront(ISettingConfig childSetting) {
        int index = this.settings.indexOf(childSetting);
        if (index <= 0) {
            return false;
        }
        this.swapSettings(index, index - 1);
        this.updateChildren();
        return true;
    }

    public boolean moveBack(ISettingConfig childSetting) {
        int index = this.settings.indexOf(childSetting);
        if (index >= this.settings.size() - 1) {
            return false;
        }
        this.swapSettings(index, index + 1);
        this.updateChildren();
        return true;
    }

    public boolean moveBeginning(ISettingConfig childSetting) {
        int index = this.settings.indexOf(childSetting);
        if (index <= 0) {
            return false;
        }
        this.addSetting(this.remove(index), 0);
        this.updateChildren();
        return true;
    }

    public boolean moveEnd(ISettingConfig childSetting) {
        int index = this.settings.indexOf(childSetting);
        if (index < 0 || index >= this.settings.size() - 1) {
            return false;
        }
        int newIndex = this.settings.size() - 1;
        this.addSetting(this.remove(index), newIndex);
        this.updateChildren();
        return true;
    }

    private void swapSettings(int index1, int index2) {
        ISettingConfig sett1 = this.settings.get(index1);
        ISettingConfig sett2 = this.settings.get(index2);
        this.settings.set(index2, sett1);
        this.settings.set(index1, sett2);
        this.getChildContext().getRoot().clearCacheForValueChange(sett1);
        this.getChildContext().getRoot().clearCacheForValueChange(sett2);
        this.getChildContext().getRoot().clearCacheForValueChange(this);
        this.getChildContext().getRoot().clearCacheForChildrenChange(this);
    }

    public boolean remove(ISettingConfig childSetting) {
        boolean result = this.settings.remove(childSetting);
        if (result) {
            this.getChildContext().getRoot().clearCacheForValueChange(childSetting);
            this.getChildContext().getRoot().clearCacheForChildrenChange(childSetting);
            this.updateChildren();
            this.getChildContext().getRoot().clearCacheForValueChange(this);
            this.getChildContext().getRoot().clearCacheForChildrenChange(this);
        }
        return result;
    }

    public ISettingConfig remove(int index) {
        ISettingConfig removed = this.settings.remove(index);
        if (removed != null) {
            this.updateChildren();
            this.getChildContext().getRoot().clearCacheForValueChange(this);
            this.getChildContext().getRoot().clearCacheForChildrenChange(this);
        }
        return removed;
    }

    public void removeAll() {
        int i = this.settings.size() - 1;
        while (i >= 0) {
            ISettingConfig removed = this.settings.remove(i);
            this.getChildContext().getRoot().clearCacheForValueChange(removed);
            --i;
        }
        this.updateChildren();
        this.getChildContext().getRoot().clearCacheForValueChange(this);
    }

    private void updateChildren() {
        int i = 0;
        while (i < this.settings.size()) {
            ISettingConfig config = this.settings.get(i);
            if (!config.getName().equals(Integer.toString(i))) {
                config.setName(UtilsText.safeString((String)Integer.toString(i)));
                String childId = SettingUtils.buildId(this.id, config.getName());
                config.setId(childId);
            }
            config.setUiNameSupplier(() -> this.determineUiName(config));
            ++i;
        }
        CopyOnWriteArrayList storageSettings = ((StoragePeriphsArraySetting)this.storageSetting).getSettings();
        storageSettings.clear();
        this.settings.stream().filter(x -> x.isStorable()).forEach(x -> {
            boolean bl = storageSettings.add(x.getStorageSetting());
        });
    }

    public boolean hasAutoSizeExpression() {
        return this.getModelData().getSizeExpr() != null;
    }

    public List<ISettingConfig> updateSize() {
        List<ISettingConfig> modifiedConfigs;
        Expression sizeExpression = this.getModelData().getSizeExpr();
        if (sizeExpression != null) {
            boolean adding;
            Expression addOnIndexExpression = this.getModelData().getAddOnIndexExpr();
            Expression removeFromIndexExpression = this.getModelData().getRemoveFromIndexExpr();
            long newSize = sizeExpression.resolve(this.getExpressionContext()).getLong();
            if (newSize < 0L) {
                newSize = 0L;
            }
            long diff = newSize - (long)this.settings.size();
            long diffAbsolute = Math.abs(diff);
            modifiedConfigs = new ArrayList<ISettingConfig>((int)diffAbsolute);
            boolean bl = adding = diff > 0L;
            if (adding) {
                long i = 0L;
                while (i < diffAbsolute) {
                    IValue addOnIndexFunction;
                    int position;
                    ISettingConfig newItem = this.addNewItem();
                    if (addOnIndexExpression != null && (long)(position = (int)(addOnIndexFunction = addOnIndexExpression.resolve(this.getExpressionContext())).getFunctionReference().invokeOn(this.getExpressionContext(), new Object[]{newItem}).getLong()) != i) {
                        this.moveBeginning(newItem);
                        int j = 0;
                        while (j < position) {
                            this.moveBack(newItem);
                            ++j;
                        }
                        if (this.isOptionSet("REFRESH_DEFAULTS_AUTOSIZE")) {
                            this.applyItemDefaults(newItem);
                        }
                    }
                    modifiedConfigs.add(newItem);
                    ++i;
                }
            } else {
                long i = 0L;
                while (i < diffAbsolute) {
                    int index = this.settings.size() - 1;
                    if (removeFromIndexExpression != null) {
                        index = (int)removeFromIndexExpression.resolve(this.getExpressionContext()).getLong();
                    }
                    if (index < 0 || index >= this.settings.size()) {
                        int finalIndex = index;
                        LOGGER.log(Level.SEVERE, () -> MessageFormat.format("[TOOL] Trying to access index {0} which is out of bounds 0-{1}", String.valueOf(finalIndex), String.valueOf(this.settings.size())));
                    } else {
                        ISettingConfig item = this.settings.get(index);
                        if (this.remove(item)) {
                            modifiedConfigs.add(item);
                        }
                    }
                    ++i;
                }
            }
        } else {
            BigRational minValue = this.getModelData().getMinValue(this.getExpressionContext());
            if (minValue != null) {
                long minSize = minValue.longValue();
                long diff = minSize - (long)this.settings.size();
                long size = Math.abs(diff);
                modifiedConfigs = new ArrayList<ISettingConfig>((int)size);
                if (diff > 0L) {
                    long i = 0L;
                    while (i < size) {
                        ISettingConfig newItem = this.addNewItem();
                        modifiedConfigs.add(newItem);
                        ++i;
                    }
                }
            } else {
                modifiedConfigs = Collections.emptyList();
            }
        }
        this.sortArrayContent();
        return modifiedConfigs;
    }

    private void sortArrayContent() {
        block7: {
            block8: {
                Object optionValue = this.getOptionValue("UI_SORT_CONTENT_AS");
                if (optionValue == null) break block7;
                if (!(optionValue instanceof String)) break block8;
                SortTarget sortTarget = this.getSortTargetValue();
                if (sortTarget == SortTarget.UNKNOWN) break block7;
                switch ((String)optionValue) {
                    case "ASC_NATURAL": {
                        Object targetSetting = this.getOptionValue("UI_SORT_TARGET_SETTING");
                        String targetSettingId = targetSetting != null && targetSetting instanceof String ? (String)targetSetting : null;
                        Collections.sort(this.settings, (o1, o2) -> ComparatorHelpers.compareAscendingNatural((String)o1.getTargetValue(sortTarget, targetSettingId, this.getExpressionContext()), (String)o2.getTargetValue(sortTarget, targetSettingId, this.getExpressionContext())));
                        this.updateChildren();
                        break;
                    }
                    default: {
                        LOGGER.severe(String.format("[DATA] Unknown %1s option value: %2s of setting: %3s", "UI_SORT_CONTENT_AS", optionValue, this.setting.getId()));
                        break;
                    }
                }
                break block7;
            }
            LOGGER.log(Level.SEVERE, String.format("[DATA] The current type is not supported for %1s option. Only the string values are supported.", "UI_SORT_TARGET"));
        }
    }

    @Override
    public @NonNull String getTypeName() {
        return "array";
    }

    private String determineUiName(ISettingConfig config) {
        String key = this.getSettingKey(config, this.getExpressionContext());
        return key != null ? key : config.getName();
    }

    @Override
    public void setDefaultValue() {
        for (ISettingConfig child : this.getChildren()) {
            child.setDefaultValue();
        }
    }

    public boolean canAddItem() {
        return !ScalarUtils.isAboveRange((ASettingConfig)this, this.getChildren().size() + 1);
    }

    public boolean canRemoveItem() {
        return !ScalarUtils.isBelowRange((ASettingConfig)this, this.getChildren().size() - 1);
    }

    public void applyDefaultsToItems() {
        this.updateSize();
        for (ISettingConfig arrayItem : this.settings) {
            this.applyItemDefaults(arrayItem);
        }
    }

    @Override
    public void initValue() {
        this.updateSize();
        super.initValue();
    }

    public Representation getRepresentation() {
        return this.representation;
    }

    public void setRepresentation(Representation representation) {
        this.representation = representation;
    }

    @Override
    public void dispose() {
        this.settings.forEach(IChild::dispose);
        this.settings.clear();
        super.dispose();
    }

    @Override
    public void applySynchronizedSetting(ISettingConfig config) {
        this.applyOtherInternal(config, true);
    }

    private void applyOtherInternal(ISettingConfig config, boolean checkSynchronization) {
        if (config instanceof ScalarConfig) {
            long value;
            ScalarConfig scalarConfig = (ScalarConfig)config;
            @NonNull Object objectValue = scalarConfig.getValue();
            if (objectValue instanceof Long) {
                value = (Long)objectValue;
            } else if (objectValue instanceof String) {
                String stringValue = (String)objectValue;
                try {
                    value = Long.parseLong(stringValue);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(String.format("Wrong format of number supplied by string: %1s", stringValue), e);
                }
            } else {
                throw new IllegalArgumentException(String.format("Unexpected setting type %1s - expected int or string", objectValue.getClass()));
            }
            ArrayConfig arrayConfig = (ArrayConfig)this.childContext.getRoot().getConfigFactory().createSettingConfig(this.id, config.getName(), this.setting, this.childContext, this.mcu);
            int i = 0;
            while ((long)i < value) {
                arrayConfig.addNewItem();
                ++i;
            }
            this.childContext.getRoot().clearCacheForChildrenChange(arrayConfig);
            config = arrayConfig;
        }
        if (!(config instanceof ArrayConfig)) {
            throw new IllegalArgumentException(String.format("Unexpected setting type with id %1s - expected %2s", config.getId(), ArrayConfig.class.getName()));
        }
        ArrayConfig array = (ArrayConfig)config;
        int i = 0;
        while (i < array.getChildren().size()) {
            ISettingConfig member = array.getValue(i);
            assert (member != null);
            String childName = member.getName();
            String childId = SettingUtils.buildId(this.id, childName);
            ISettingConfig settingConfig = this.getValue(i);
            if (settingConfig == null) {
                settingConfig = this.childContext.getRoot().getConfigFactory().createSettingConfig(childId, childName, this.instanceSetting, this.childContext, this.mcu);
                settingConfig.delayedInitAfterCreation();
                this.addSetting(settingConfig);
                if (settingConfig.isStorable()) {
                    ((StoragePeriphsArraySetting)this.storageSetting).getSettings().add(settingConfig.getStorageSetting());
                }
            }
            ISettingConfig settingConfigFinal = settingConfig;
            settingConfig.setUiNameSupplier(() -> this.determineUiName(settingConfigFinal));
            if (!checkSynchronization) {
                settingConfig.applyOther(member);
            } else if (settingConfig.isSynchronizationEnabled() || this.isOptionAvailable("SYNC_SIZE")) {
                settingConfig.applySynchronizedSetting(member);
            }
            ++i;
        }
        if (this.settings.size() > array.settings.size()) {
            this.settings.subList(array.settings.size(), this.settings.size()).clear();
            ((StoragePeriphsArraySetting)this.storageSetting).getSettings().subList(array.settings.size(), this.settings.size()).clear();
        }
        this.updateStorageAvailability();
    }

    @Override
    public StringBuilder dump(StringBuilder builder, DumpFormatOptions options) {
        return DumpHelper.dump(builder, options, this);
    }

    public static enum Representation {
        VERTICAL_FORM("VERTICAL_FORM", Messages.get().ArrayConfig_RepresentationVerticalForm),
        HORIZONTAL_FORM("HORIZONTAL_FORM", Messages.get().ArrayConfig_RepresentationHorizontalForm),
        VERTICAL_TABLE("VERTICAL_TABLE", Messages.get().ArrayConfig_RepresentationVerticalTable),
        HORIZONTAL_TABLE("HORIZONTAL_TABLE", Messages.get().ArrayConfig_RepresentationHorizontalTable),
        VERTICAL_RADIOS("VERTICAL_RADIOS", Messages.get().ArrayConfig_RepresentationVerticalRadios),
        HORIZONTAL_RADIOS("HORIZONTAL_RADIOS", Messages.get().ArrayConfig_RepresentationHorizontalRadios),
        MASTER_DETAIL("MASTER_DETAIL", Messages.get().ArrayConfig_RepresentationMasterDetail),
        TABS("TABS", Messages.get().ArrayConfig_RepresentationTabs);

        private String id;
        private String label;

        private Representation(String id, String label) {
            this.id = id;
            this.label = label;
        }

        public String getId() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        public static @Nullable Representation getById(String id) {
            Representation[] representationArray = Representation.values();
            int n = representationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Representation r = representationArray[n2];
                if (r.getId().equalsIgnoreCase(id)) {
                    return r;
                }
                ++n2;
            }
            return null;
        }

        public static @Nullable Representation getByLabel(String label) {
            Representation[] representationArray = Representation.values();
            int n = representationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Representation r = representationArray[n2];
                if (r.getLabel().equalsIgnoreCase(label)) {
                    return r;
                }
                ++n2;
            }
            return null;
        }

        public static List<String> getAllIds() {
            ArrayList<String> ids = new ArrayList<String>();
            Representation[] representationArray = Representation.values();
            int n = representationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Representation r = representationArray[n2];
                ids.add(r.getId());
                ++n2;
            }
            return ids;
        }
    }
}

