/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.resourcetables.model.config;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.common.utils.lang.CollectionMap;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.provider.configuration.dependencies.IDependency;
import com.nxp.swtools.provider.configuration.storage.periphs.AStoragePeriphsSetting;
import com.nxp.swtools.resourcetables.model.Messages;
import com.nxp.swtools.resourcetables.model.config.ArrayConfig;
import com.nxp.swtools.resourcetables.model.config.AssignConfig;
import com.nxp.swtools.resourcetables.model.config.CacheHelper;
import com.nxp.swtools.resourcetables.model.config.ChildContext;
import com.nxp.swtools.resourcetables.model.config.ChildProviderHelper;
import com.nxp.swtools.resourcetables.model.config.ChildValidationHelper;
import com.nxp.swtools.resourcetables.model.config.ExpressionContext;
import com.nxp.swtools.resourcetables.model.config.ICacheable;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IChildProvidable;
import com.nxp.swtools.resourcetables.model.config.IComponentConfig;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.config.IConfigSetConfig;
import com.nxp.swtools.resourcetables.model.config.IFunctionalGroup;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import com.nxp.swtools.resourcetables.model.config.QuickSelectionHelper;
import com.nxp.swtools.resourcetables.model.config.RegisterConfig;
import com.nxp.swtools.resourcetables.model.config.RegistersModelSingleton;
import com.nxp.swtools.resourcetables.model.config.ScalarConfig;
import com.nxp.swtools.resourcetables.model.config.ScalarUtils;
import com.nxp.swtools.resourcetables.model.data.IQuickSelection;
import com.nxp.swtools.resourcetables.model.data.IQuickSetting;
import com.nxp.swtools.resourcetables.model.data.Level;
import com.nxp.swtools.resourcetables.model.data.SettingUtils;
import com.nxp.swtools.resourcetables.model.data.SortTarget;
import com.nxp.swtools.resourcetables.model.data.setting.ASetting;
import com.nxp.swtools.resourcetables.model.data.setting.ArraySetting;
import com.nxp.swtools.resourcetables.model.data.setting.BoolSetting;
import com.nxp.swtools.resourcetables.model.data.setting.FloatSetting;
import com.nxp.swtools.resourcetables.model.data.setting.ISetting;
import com.nxp.swtools.resourcetables.model.data.setting.IntegerSetting;
import com.nxp.swtools.resourcetables.model.data.setting.StringSetting;
import com.nxp.swtools.resourcetables.model.mcu.ICommonMcu;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public abstract class ASettingConfig
implements ISettingConfig,
ICacheable {
    private static final String SETTING_WITH_ID = " >>> Setting with id: ";
    private static final String COMPONENT_COMMA = "Component: ";
    protected static final Logger LOGGER = LogManager.getLogger(ASettingConfig.class);
    protected String id;
    protected String name;
    protected final ISetting setting;
    protected final ICommonMcu mcu;
    protected final ChildContext childContext;
    protected final IContext expressionContext;
    protected final AStoragePeriphsSetting storageSetting;
    protected Supplier<String> uiNameSupplier;
    @Nullable
    private List<AssignConfig> assignConfigs;
    @Nullable
    private Map<String, ISettingConfig> relatedSettings;

    protected ASettingConfig(String id, String name, ISetting setting, AStoragePeriphsSetting storageSetting, ChildContext parentContext, ICommonMcu mcu) {
        this.id = id;
        this.name = name;
        this.mcu = mcu;
        this.setting = setting;
        this.storageSetting = storageSetting;
        this.storageSetting.setName(name);
        this.childContext = parentContext.createForChild(this);
        this.expressionContext = new ExpressionContext(this.childContext, mcu);
        this.uiNameSupplier = () -> setting.getUIName(this.expressionContext);
    }

    protected boolean applyQuickSelectionFromResource(@Nullable IQuickSelection quickSelection, IChild relativeTo) {
        ISettingConfig config;
        Expression resource;
        IQuickSetting setToUse = QuickSelectionHelper.getQuickSelection(quickSelection, this, relativeTo);
        if (setToUse != null && (resource = setToUse.getResourceExpr()) != null && (config = this.getConfigFromExpression(relativeTo.getChildContext(), resource)) != null) {
            this.applyOther(config);
            return true;
        }
        return false;
    }

    public @Nullable ISettingConfig getConfigFromExpression(ChildContext context, Expression expression) {
        ASetting settingLoc;
        Object value;
        IValue resolvedResource = expression.resolve(this.getExpressionContext());
        if (resolvedResource.getType() == IValue.Type.OBJECT && (value = resolvedResource.getValue()) instanceof ISettingConfig) {
            return (ISettingConfig)value;
        }
        value = resolvedResource.getString();
        switch (resolvedResource.getType()) {
            case LONG: 
            case BIG_INTEGER: {
                IntegerSetting.IntegerType integerType = IntegerSetting.IntegerType.int64_t;
                BigInteger currentValue = new BigInteger((String)value, ScalarUtils.detectIntegerBase((String)value));
                BigInteger maximalValue = BigInteger.valueOf(Long.MAX_VALUE);
                if (currentValue.compareTo(maximalValue) > 0) {
                    integerType = IntegerSetting.IntegerType.uint64_t;
                }
                settingLoc = new IntegerSetting("", null, null, null, integerType, null, null, null, null, null, null, null);
                break;
            }
            case BIG_RATIONAL: {
                settingLoc = new FloatSetting("", null, null, null, FloatSetting.Type.quadruple_precision, null, null, null, null, null, null, null);
                break;
            }
            case BOOLEAN: {
                settingLoc = new BoolSetting("", null, null, null, null, null, null, null, null);
                break;
            }
            default: {
                settingLoc = new StringSetting("", "", null, null, null, null, null, null, null, null);
            }
        }
        ScalarConfig scalarConfig = new ScalarConfig("", "", settingLoc, context, this.mcu);
        scalarConfig.setValue((String)value, false);
        return scalarConfig;
    }

    protected String getComponentName() {
        IComponentConfig componentConfig = this.getChildContext().getComponentConfig();
        return componentConfig != null ? componentConfig.getName() : "";
    }

    protected String getLogHeader() {
        return COMPONENT_COMMA + this.getComponentName() + SETTING_WITH_ID + this.getId();
    }

    protected SortTarget getSortTargetValue() {
        Object sortTargetValue;
        block12: {
            sortTargetValue = this.getOptionValue("UI_SORT_TARGET");
            if (!(sortTargetValue instanceof String)) break block12;
            switch ((String)sortTargetValue) {
                case "LABEL": {
                    return SortTarget.LABEL;
                }
                case "VALUE": {
                    return SortTarget.VALUE;
                }
            }
        }
        if (sortTargetValue == null) {
            LOGGER.severe(String.format("[DATA] Missing %1s option in setting: %2s", "UI_SORT_TARGET", this.setting.getId()));
        } else {
            LOGGER.severe(String.format("[DATA] Unknown %1s option value: %2s of setting: %3s", "UI_SORT_TARGET", sortTargetValue, this.setting.getId()));
        }
        return SortTarget.UNKNOWN;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isOptionSet(String option) {
        return this.setting.isOptionSet(option) && this.isOptionAvailable(option);
    }

    @Override
    public boolean isOptionAvailable(String option) {
        return this.setting.isOptionAvailable(option, this.expressionContext);
    }

    @Override
    public @Nullable Object getOptionValue(String option) {
        return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*option_value*" + option, () -> this.setting.getOptionValue(option, this.getExpressionContext()));
    }

    @Override
    public ISetting getModelData() {
        return this.setting;
    }

    @Override
    public IContext getExpressionContext() {
        return this.expressionContext;
    }

    @Override
    public boolean canBeStoredUnavailable() {
        IChildProvidable parent = this.childContext.getParent();
        if (parent != null && parent.canBeStoredUnavailable()) {
            return !this.isOptionSet("STORE_UNAVAILABLE_STOP") || !this.isOptionAvailable("STORE_UNAVAILABLE_STOP");
        }
        return ISettingConfig.super.canBeStoredUnavailable();
    }

    @Override
    public boolean isAvailable() {
        return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*available", () -> {
            IChildProvidable parent = this.childContext.getParent();
            boolean available = false;
            available = parent != null && CacheHelper.isKeyCached(this, String.valueOf(parent.getId()) + "*available") ? parent.isAvailable() && this.setting.isAvailable(this.expressionContext) : this.setting.isAvailable(this.expressionContext) && (parent == null || parent.isAvailable());
            return available;
        });
    }

    @Override
    public boolean isEnabled() {
        return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*enabled", () -> {
            IChildProvidable parent = this.childContext.getParent();
            boolean enabled = false;
            enabled = parent != null && CacheHelper.isKeyCached(this, String.valueOf(parent.getId()) + "*enabled") ? parent.isEnabled() && this.setting.isEnabled(this.expressionContext) : this.setting.isEnabled(this.expressionContext) && (parent == null || parent.isEnabled());
            return enabled;
        });
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUiName() {
        return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*ui_name", this.uiNameSupplier);
    }

    public @Nullable String getDescription() {
        StringBuilder builder = new StringBuilder();
        String settingDescription = this.setting.getResolvedDescription(this.expressionContext);
        if (settingDescription != null) {
            builder.append(settingDescription);
        }
        this.addDescriptionOfRegisterAssigns(builder);
        return builder.length() == 0 ? null : builder.toString();
    }

    @Override
    public boolean hasDescription() {
        return this.setting.hasDescription();
    }

    private void addDescriptionOfRegisterAssigns(StringBuilder builder) {
        IComponentInstanceConfig instance = this.getChildContext().getComponentInstanceConfig();
        if (!this.getAssignConfigs().isEmpty() && instance != null && instance.getComponent().isRegistersInitialization()) {
            builder.append("<br/>").append(Messages.get().ASettingConfig_InfluencedRegistersBitfields);
            StringJoiner joiner = new StringJoiner(", ");
            for (AssignConfig assign : this.getAssignConfigs()) {
                if (!assign.isEnabled()) continue;
                for (RegisterConfig register : assign.getRegisters()) {
                    try {
                        this.addDescriptionOfRegisterAssign(UtilsText.safeString((String)instance.getPeripheral()), joiner, register);
                    }
                    catch (RegistersModelSingleton.RegisterNotFoundException e) {
                        e.log(this.getId());
                    }
                }
            }
            builder.append(joiner.toString());
        }
    }

    private void addDescriptionOfRegisterAssign(String defaultPeripheral, StringJoiner joiner, RegisterConfig registerAssign) {
        String peripheral = registerAssign.getPeripheral(this.getExpressionContext());
        if (peripheral == null) {
            peripheral = defaultPeripheral;
        }
        String registerWholeName = RegistersModelSingleton.computeFullNameOfRegister(peripheral, registerAssign.getName(this.getExpressionContext()));
        String bitfieldName = registerAssign.getBitfield(this.getExpressionContext());
        IFunctionalGroup functionalGroup = this.getChildContext().getFunctionalGroup();
        StringBuilder registerStringBuilder = new StringBuilder();
        if (functionalGroup != null) {
            BigInteger valueOfBitField = RegistersModelSingleton.getInstance().getValueOfBitField(functionalGroup, registerWholeName, bitfieldName);
            registerStringBuilder.append(registerWholeName).append("[").append(bitfieldName).append("]").append("=").append(valueOfBitField);
        }
        joiner.add(registerStringBuilder.toString());
    }

    public @Nullable String getState() {
        if (!this.isEnabled()) {
            return Messages.get().ASettingConfig_Inactive;
        }
        return null;
    }

    public @Nullable String getStateDescription() {
        if (!this.isEnabled()) {
            return Messages.get().ASettingConfig_SettingIsInactive;
        }
        return null;
    }

    @Override
    public ChildContext getChildContext() {
        return this.childContext;
    }

    @Override
    public IDependency @Nullable [] getOwnDependencies(String source) {
        if (this.isAvailable() && this.isEnabled()) {
            return ChildValidationHelper.getDependencies(this.setting.getValidation(), this.getExpressionContext(), source, this.makeOriginatorId(this.childContext));
        }
        return null;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.storageSetting.setName(name);
    }

    @Override
    public void setId(String id) {
        this.id = id;
        this.updateRelatedSettingsId();
    }

    @Override
    public void setUiNameSupplier(Supplier<String> supplier) {
        this.uiNameSupplier = supplier;
    }

    @Override
    public @Nullable String getError() {
        return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*error", () -> this.getProblems(Level.ERROR));
    }

    @Override
    public @Nullable String getWarning() {
        return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*warning", () -> this.getProblems(Level.WARNING));
    }

    @Override
    public @Nullable String getInfo() {
        return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*info", () -> this.getProblems(Level.INFO));
    }

    @Override
    public @Nullable String getProblems(Level level) {
        return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*problems*" + (Object)((Object)level), () -> ISettingConfig.super.getProblems(level));
    }

    @Override
    public String @Nullable [] getOwnProblems(Level level) {
        return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*own_problems*" + (Object)((Object)level), () -> ISettingConfig.super.getOwnProblems(level));
    }

    @Override
    public List<String> getProblemsPaths(Level level) {
        return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*problems_paths*" + (Object)((Object)level), () -> ISettingConfig.super.getProblemsPaths(level));
    }

    @Override
    public Map<String, Object> getCache() {
        IConfigSetConfig configSetConfig = this.childContext.getConfigSetConfig();
        if (configSetConfig != null) {
            return configSetConfig.getCache();
        }
        return new HashMap<String, Object>();
    }

    @Override
    public CollectionMap<String, CollectionsUtils.Pair<String, ICacheable>> getDependencyMap() {
        IConfigSetConfig configSetConfig = this.childContext.getConfigSetConfig();
        if (configSetConfig != null) {
            return configSetConfig.getDependencyMap();
        }
        return new CollectionMap();
    }

    public String toString() {
        return "Setting: [Type: " + this.getTypeName() + ", Id: " + this.getId() + "]";
    }

    @Override
    public String getTargetValue(SortTarget target, @Nullable String settingId, IContext context) {
        if (settingId != null) {
            LOGGER.severe(String.format("[DATA] Trying to find sub-setting, %1s, in nonstructural setting is not allowed.", settingId));
        }
        switch (target) {
            case LABEL: {
                return this.getUiName();
            }
            case VALUE: {
                return this.getValue().toString();
            }
        }
        return "";
    }

    @Override
    public synchronized List<AssignConfig> getAssignConfigs() {
        return Collections.unmodifiableList(CollectionsUtils.safeList(this.assignConfigs));
    }

    @Override
    public synchronized void addAssign(AssignConfig assignConfig) {
        List<AssignConfig> assignConfigsLoc = this.assignConfigs;
        if (assignConfigsLoc == null) {
            this.assignConfigs = assignConfigsLoc = new ArrayList<AssignConfig>();
        }
        assignConfigsLoc.add(assignConfig);
    }

    @Override
    public boolean isSynchronizationEnabled() {
        return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*sync", () -> {
            IChildProvidable parent = this.childContext.getParent();
            boolean available = false;
            if (parent != null && CacheHelper.isKeyCached(this, String.valueOf(parent.getId()) + "*sync")) {
                available = parent.isSynchronizationEnabled() || this.setting.isOptionAvailable("SYNC_VALUE", this.expressionContext) || this.setting instanceof ArraySetting && this.setting.isOptionAvailable("SYNC_SIZE", this.expressionContext);
            } else {
                boolean bl = available = this.setting instanceof ArraySetting && this.setting.isOptionAvailable("SYNC_SIZE", this.expressionContext) || this.setting.isOptionAvailable("SYNC_VALUE", this.expressionContext) || parent != null && parent.isSynchronizationEnabled();
            }
            if (this instanceof ArrayConfig && this.isOptionAvailable("SYNC_SIZE") && this.isOptionAvailable("SYNC_VALUE")) {
                LOGGER.severe(MessageFormat.format("[DATA] Both SYNC_VALUE and SYNC_SIZE are available on the array with ID \"{0}\". The array will not be synchronized", this.getId()));
                return false;
            }
            if (parent instanceof ArrayConfig && parent.isOptionAvailable("SYNC_SIZE")) {
                return false;
            }
            return available;
        });
    }

    @Override
    public void synchronizeValue(@Nullable IChild config) {
        if (this.isSynchronizationEnabled()) {
            if (config != null) {
                if (!(config instanceof ASettingConfig)) {
                    throw new IllegalArgumentException(String.format("[TOOL]Unexpected setting type with id %1s - expected %2s", config.getId(), ASettingConfig.class.getName()));
                }
                ASettingConfig setConfig = (ASettingConfig)config;
                this.applyOther(setConfig);
            } else {
                IChild mainSetting = this.childContext.getRoot().getSynchronizedSettingByChild(this);
                if (mainSetting != null) {
                    if (!(mainSetting instanceof ASettingConfig)) {
                        throw new IllegalArgumentException(String.format("[TOOL]Unexpected setting type with id %1s - expected %2s", mainSetting.getId(), ASettingConfig.class.getName()));
                    }
                    ASettingConfig setConfig = (ASettingConfig)mainSetting;
                    this.applyOther(setConfig);
                }
            }
            ChildProviderHelper.unsetParentQuickSelections(this);
        }
    }

    @Override
    public boolean isControlHidden() {
        return CacheHelper.getValueCaching(this, String.valueOf(this.getId()) + "*control_hidden", () -> {
            IChildProvidable parent = this.childContext.getParent();
            boolean controlHidden = false;
            controlHidden = parent != null && CacheHelper.isKeyCached(this, String.valueOf(parent.getId()) + "*control_hidden") ? parent.isControlHidden() || this.setting.isOptionAvailable("UI_CONTROL_HIDDEN", this.expressionContext) : this.setting.isOptionAvailable("UI_CONTROL_HIDDEN", this.expressionContext) || parent != null && parent.isControlHidden();
            return controlHidden;
        });
    }

    @Override
    public void dispose() {
        if (this.assignConfigs != null) {
            this.assignConfigs.clear();
            this.assignConfigs = null;
        }
        this.childContext.dispose();
    }

    @Override
    public @Nullable List<ISettingConfig> getAllRelatedSettings() {
        if (this.relatedSettings != null) {
            return CollectionsUtils.unmodifiableList(CollectionsUtils.safeMap(this.relatedSettings).values().stream().collect(Collectors.toList()));
        }
        return null;
    }

    @Override
    public void populateRelatedSettingsList(@Nullable Map<String, AStoragePeriphsSetting> storageConfigs) {
        IConfigSetConfig parent = this.childContext.getConfigSetConfig();
        LinkedHashMap<String, ISetting> relatedSettingsModel = this.getModelData().getRelatedSettings();
        if (parent != null && !relatedSettingsModel.isEmpty()) {
            this.relatedSettings = new LinkedHashMap<String, ISettingConfig>();
            for (Map.Entry<String, ISetting> entry : relatedSettingsModel.entrySet()) {
                AStoragePeriphsSetting storageValue;
                ISetting relatedSetting = entry.getValue();
                String relSettId = SettingUtils.buildId("related_settings_auto", this.id, relatedSetting.getId());
                ISettingConfig relatedSettingInstance = null;
                if (storageConfigs != null && (storageValue = storageConfigs.remove(relSettId)) != null) {
                    relatedSettingInstance = this.childContext.getRoot().getConfigFactory().createSettingConfig(relSettId, relatedSetting, parent.getChildContext(), storageValue, this.mcu);
                }
                if (relatedSettingInstance == null) {
                    relatedSettingInstance = this.childContext.getRoot().getConfigFactory().createSettingConfig(relSettId, relatedSetting.getId(), relatedSetting, parent.getChildContext(), this.mcu);
                }
                this.addRelatedSetting(relatedSettingInstance);
            }
        }
    }

    @Override
    public List<AStoragePeriphsSetting> getStorageOfRelatedSettings() {
        ArrayList<AStoragePeriphsSetting> relatedSettingsStorage = new ArrayList<AStoragePeriphsSetting>();
        if (this.relatedSettings != null) {
            this.relatedSettings.values().forEach(child -> {
                child.updateStorageAvailability();
                AStoragePeriphsSetting settingStorage = child.getStorageSetting();
                settingStorage.setName(child.getId());
                relatedSettingsStorage.add(settingStorage);
            });
        }
        return relatedSettingsStorage;
    }

    @Override
    public void updateRelatedSettingsId() {
        if (this.relatedSettings != null) {
            Map<String, ISettingConfig> relatedSettingsLoc = this.relatedSettings;
            List<ISettingConfig> relatedSettingsList = this.getAllRelatedSettings();
            if (relatedSettingsList != null) {
                relatedSettingsLoc.clear();
                String newId = SettingUtils.buildId("related_settings_auto", this.getId());
                for (ISettingConfig relatedChild : relatedSettingsList) {
                    String childId = SettingUtils.buildId(newId, relatedChild.getModelData().getId());
                    relatedChild.setId(childId);
                    relatedSettingsLoc.put(childId, relatedChild);
                }
            }
        }
    }

    @Override
    public void addRelatedSetting(ISettingConfig relatedSetting) {
        if (this.relatedSettings != null) {
            this.relatedSettings.put(relatedSetting.getName(), relatedSetting);
        }
    }
}

