/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.sdk.registry.core.symbol;

import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.Messages;
import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.SdkRegistryCoreActivator;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkRegistryLogger;
import com.nxp.s32ds.cle.runtime.sdk.registry.symbol.SymbolSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.symbol.SymbolSdkKind;
import com.nxp.s32ds.cle.runtime.sdk.registry.symbol.SymbolSdkRegistry;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SymbolSdkDescriptors {
    private SymbolSdkDescriptors() {
    }

    public static SymbolSdkRegistry getSymbolSdkRegistry() {
        return SdkRegistryCoreActivator.getInstance().getSymbolSdkRegistry();
    }

    public static List<SymbolSdkDescriptor> getSymbolSdkDescriptors() {
        return SymbolSdkDescriptors.getSymbolSdkRegistry().getSymbolSdkDescriptors();
    }

    public static List<SymbolSdkDescriptor> getSymbolSdkDescriptorsByName(String name) {
        return SymbolSdkDescriptors.getSymbolSdkRegistry().getSymbolSdkDescriptorsByName(name);
    }

    public static List<SymbolSdkDescriptor> getSymbolSdkDescriptorsBySdkId(String sdkId) {
        return SymbolSdkDescriptors.getSymbolSdkRegistry().getSymbolSdkDescriptorsBySdkId(sdkId);
    }

    public static List<SymbolSdkDescriptor> getSymbolSdkDescriptorsBySdkIdAndToolChainId(String sdkId, String toolChainId) {
        return SymbolSdkDescriptors.getSymbolSdkDescriptorsBySdkId(sdkId).stream().filter(symbolSdkDescriptor -> SymbolSdkDescriptors.matchParameter(toolChainId, symbolSdkDescriptor.getToolChainId())).collect(Collectors.toList());
    }

    public static List<SymbolSdkDescriptor> getSymbolSdkDescriptors(String sdkId, String toolChainId, String langId, SymbolSdkKind kind) {
        return SymbolSdkDescriptors.getSymbolSdkDescriptorsBySdkId(sdkId).stream().filter(symbolSdkDescriptor -> SymbolSdkDescriptors.matchParameter(toolChainId, symbolSdkDescriptor.getToolChainId()) && SymbolSdkDescriptors.matchParameter(langId, symbolSdkDescriptor.getLangId()) && (kind == null || kind == symbolSdkDescriptor.getKind())).collect(Collectors.toList());
    }

    public static List<SymbolSdkDescriptor> getDefinedSymbolSdkDescriptors(String sdkId, String toolChainId) {
        return SymbolSdkDescriptors.getSymbolSdkDescriptorsBySdkId(sdkId).stream().filter(symbolSdkDescriptor -> SymbolSdkDescriptors.matchParameter(toolChainId, symbolSdkDescriptor.getToolChainId()) && SymbolSdkKind.DEFINED_SYMBOL == symbolSdkDescriptor.getKind()).collect(Collectors.toList());
    }

    public static List<SymbolSdkDescriptor> getUndefinedSymbolSdkDescriptors(String sdkId, String toolChainId) {
        return SymbolSdkDescriptors.getSymbolSdkDescriptorsBySdkId(sdkId).stream().filter(symbolSdkDescriptor -> SymbolSdkDescriptors.matchParameter(toolChainId, symbolSdkDescriptor.getToolChainId()) && SymbolSdkKind.UNDEFINED_SYMBOL == symbolSdkDescriptor.getKind()).collect(Collectors.toList());
    }

    public static void addSymbolSdkDescriptor(SymbolSdkDescriptor descriptor) {
        SymbolSdkDescriptors.getSymbolSdkRegistry().addSymbolSdkDescriptor(descriptor);
        SdkRegistryLogger.logDebugInfo(NLS.bind((String)Messages.SymbolSdkDescriptors_register_descriptor_message, (Object)descriptor.getName(), (Object)descriptor.getSdkId()));
    }

    public static void removeSymbolSdkDescriptor(SymbolSdkDescriptor descriptor) {
        SymbolSdkDescriptors.getSymbolSdkRegistry().removeSymbolSdkDescriptor(descriptor);
        SdkRegistryLogger.logDebugInfo(NLS.bind((String)Messages.SymbolSdkDescriptors_unregister_descriptor_message, (Object)descriptor.getName(), (Object)descriptor.getSdkId()));
    }

    public static void removeSymbolSdkDescriptors(String sdkId) {
        SymbolSdkDescriptors.getSymbolSdkRegistry().removeSymbolSdkDescriptorsBySdkId(sdkId);
        SdkRegistryLogger.logDebugInfo(NLS.bind((String)Messages.SymbolSdkDescriptors_unregister_descriptors_message, (Object)sdkId));
    }

    private static boolean matchParameter(String parameter, String symbolParameter) {
        if (parameter == null) {
            return symbolParameter == null || symbolParameter.isEmpty();
        }
        if (symbolParameter == null) {
            return parameter.isEmpty();
        }
        return parameter.equals(symbolParameter);
    }

    public static void convertToXml(String sdkId, String toolChainId, Document document, Element holderElement) {
        List<SymbolSdkDescriptor> symbols = SymbolSdkDescriptors.getSymbolSdkDescriptorsBySdkIdAndToolChainId(sdkId, toolChainId);
        if (!symbols.isEmpty()) {
            Element symbolsElement = document.createElement("symbols");
            symbols.forEach(symbol -> {
                Element element2 = symbol.convertToXml(document, symbolsElement);
            });
            holderElement.appendChild(symbolsElement);
        }
    }
}

