/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.sdk.registry.core.platform;

import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.platform.PlatformHostSdkDescriptorImplementation;
import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.platform.PlatformTargetSdkDescriptorImplementation;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.platform.PlatformHostSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.platform.PlatformTargetSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.platform.PlatformHostSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.platform.PlatformSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.platform.PlatformTargetSdkDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PlatformSdkDescriptors {
    private PlatformSdkDescriptors() {
    }

    public static void addPlatformSdkDescriptors(Element element, String sdkId) {
        PlatformTargetSdkDescriptors.addPlatformTargetSdkDescriptor(new PlatformTargetSdkDescriptorImplementation(element, sdkId));
        PlatformHostSdkDescriptors.addPlatformHostSdkDescriptor(new PlatformHostSdkDescriptorImplementation(element, sdkId));
    }

    public static Map<String, PlatformSdkDescriptor> getPlatformSdkDescriptorsBySdkId(String sdkId) {
        PlatformHostSdkDescriptor platformHostSdkDescriptor;
        HashMap<String, PlatformSdkDescriptor> result = new HashMap<String, PlatformSdkDescriptor>();
        PlatformTargetSdkDescriptor platformTargetSdkDescriptor = PlatformTargetSdkDescriptors.getPlatformTargetSdkDescriptorBySdkId(sdkId);
        if (platformTargetSdkDescriptor != null) {
            result.put("com.nxp.s32ds.cle.runtime.sdk.registry.platform.target", (PlatformSdkDescriptor)platformTargetSdkDescriptor);
        }
        if ((platformHostSdkDescriptor = PlatformHostSdkDescriptors.getPlatformHostSdkDescriptorBySdkId(sdkId)) != null) {
            result.put("com.nxp.s32ds.cle.runtime.sdk.registry.platform.host", (PlatformSdkDescriptor)platformHostSdkDescriptor);
        }
        return result;
    }

    public static Map<String, String> getPlatformSdkDescriptorsIds(String sdkId) {
        HashMap<String, String> result = new HashMap<String, String>();
        PlatformTargetSdkDescriptor platformTargetSdkDescriptor = PlatformTargetSdkDescriptors.getPlatformTargetSdkDescriptorBySdkId(sdkId);
        result.put("com.nxp.s32ds.cle.runtime.sdk.registry.platform.target", platformTargetSdkDescriptor != null ? platformTargetSdkDescriptor.getPlatformParameter() : "");
        PlatformHostSdkDescriptor platformHostSdkDescriptor = PlatformHostSdkDescriptors.getPlatformHostSdkDescriptorBySdkId(sdkId);
        result.put("com.nxp.s32ds.cle.runtime.sdk.registry.platform.host", platformHostSdkDescriptor != null ? platformHostSdkDescriptor.getPlatformParameter() : "");
        return result;
    }

    public static void removePlatformSdkDescriptors(String sdkId) {
        PlatformHostSdkDescriptor platformHostSdkDescriptor;
        PlatformTargetSdkDescriptor platformTargetSdkDescriptor = PlatformTargetSdkDescriptors.getPlatformTargetSdkDescriptorBySdkId(sdkId);
        if (platformTargetSdkDescriptor != null) {
            PlatformTargetSdkDescriptors.removePlatformTargetSdkDescriptor(platformTargetSdkDescriptor);
        }
        if ((platformHostSdkDescriptor = PlatformHostSdkDescriptors.getPlatformHostSdkDescriptorBySdkId(sdkId)) != null) {
            PlatformHostSdkDescriptors.removePlatformHostSdkDescriptor(platformHostSdkDescriptor);
        }
    }

    public static void convertToXml(String sdkId, Document document, Element holderElement) {
        Map<String, PlatformSdkDescriptor> platformDescriptors = PlatformSdkDescriptors.getPlatformSdkDescriptorsBySdkId(sdkId);
        if (platformDescriptors.isEmpty()) {
            return;
        }
        Element platformElement = document.createElement("platform");
        platformDescriptors.values().forEach(platform -> {
            Element element2 = platform.convertToXml(document, platformElement);
        });
        holderElement.appendChild(platformElement);
    }
}

