/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.sdk.registry.core.lang;

import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.Messages;
import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.SdkRegistryCoreActivator;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkRegistryLogger;
import com.nxp.s32ds.cle.runtime.sdk.registry.lang.LangSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.lang.LangSdkRegistry;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LangSdkDescriptors {
    private LangSdkDescriptors() {
    }

    public static LangSdkRegistry getLangSdkRegistry() {
        return SdkRegistryCoreActivator.getInstance().getLangSdkRegistry();
    }

    public static List<LangSdkDescriptor> getLangSdkDescriptors() {
        return LangSdkDescriptors.getLangSdkRegistry().getLangSdkDescriptors();
    }

    public static List<LangSdkDescriptor> getLangSdkDescriptorsByLangId(String langId) {
        return LangSdkDescriptors.getLangSdkRegistry().getLangSdkDescriptorsByLangId(langId);
    }

    public static List<LangSdkDescriptor> getLangSdkDescriptorsBySdkId(String sdkId) {
        return LangSdkDescriptors.getLangSdkRegistry().getLangSdkDescriptorsBySdkId(sdkId);
    }

    public static LangSdkDescriptor getLangSdkDescriptorBySdkId(String sdkId) {
        List<LangSdkDescriptor> langSdkDescriptors = LangSdkDescriptors.getLangSdkDescriptorsBySdkId(sdkId);
        return !langSdkDescriptors.isEmpty() ? langSdkDescriptors.get(0) : null;
    }

    public static void addLangSdkDescriptor(LangSdkDescriptor descriptor) {
        LangSdkDescriptors.getLangSdkRegistry().addLangSdkDescriptor(descriptor);
        SdkRegistryLogger.logDebugInfo(NLS.bind((String)Messages.LangSdkDescriptors_register_descriptor_message, (Object)descriptor.getLangId(), (Object)descriptor.getSdkId()));
    }

    public static void removeLangSdkDescriptor(LangSdkDescriptor descriptor) {
        LangSdkDescriptors.getLangSdkRegistry().removeLangSdkDescriptor(descriptor);
        SdkRegistryLogger.logDebugInfo(NLS.bind((String)Messages.LangSdkDescriptors_unregister_descriptor_message, (Object)descriptor.getLangId(), (Object)descriptor.getSdkId()));
    }

    public static void removeLangSdkDescriptors(String sdkId) {
        LangSdkDescriptors.getLangSdkRegistry().removeLangSdkDescriptorsBySdkId(sdkId);
        SdkRegistryLogger.logDebugInfo(NLS.bind((String)Messages.LangSdkDescriptors_unregister_descriptors_message, (Object)sdkId));
    }

    public static void convertToXml(String sdkId, Document document, Element holderElement) {
        LangSdkDescriptors.getLangSdkDescriptorsBySdkId(sdkId).forEach(lang -> {
            Element element2 = lang.convertToXml(document, holderElement);
        });
    }
}

