/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.controller;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.controller.Messages;
import com.nxp.swtools.resourcetables.model.config.AssignConfig;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.config.IFunctionalGroup;
import com.nxp.swtools.resourcetables.model.config.RegisterConfig;
import com.nxp.swtools.resourcetables.model.config.RegistersModelSingleton;
import com.nxp.swtools.utils.events.IEventListener;
import com.nxp.swtools.utils.registers.BitFieldInfo;
import com.nxp.swtools.utils.registers.IRegistersContentProvider;
import com.nxp.swtools.utils.registers.RegistersContentProviderProperties;
import com.nxp.swtools.utils.view.IViewRefreshManager;
import com.nxp.swtools.utils.view.IViewRefreshManagerHandler;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RegistersContentProvider
implements IRegistersContentProvider,
IViewRefreshManagerHandler {
    protected static final Logger LOGGER = LogManager.getLogger(RegistersContentProvider.class);
    private final Map<String, BigInteger> previousValues = new HashMap<String, BigInteger>();
    @Nullable
    protected IViewRefreshManager refreshManager;
    private IEventListener eventListener = event -> {
        if (this.refreshManager != null) {
            this.refreshManager.refresh();
        }
    };

    public Collection<BitFieldInfo> getContent() {
        return this.getBitfieldInfos(Collections.emptyList(), Collections.emptyList());
    }

    private Collection<BitFieldInfo> getBitfieldInfos(Collection<String> allowedRegisters, Collection<String> allowedBitfields) {
        IRegistersDatabaseAPI registersDb = Controller.getInstance().getMcu().getRegistersDb();
        if (registersDb == null) {
            return Collections.emptyList();
        }
        HashMap<String, BigInteger> newValues = new HashMap<String, BigInteger>();
        LinkedList<BitFieldInfo> bitfields = new LinkedList<BitFieldInfo>();
        RegistersModelSingleton registerMapConfig = RegistersModelSingleton.getInstance();
        IFunctionalGroup functionalGroup = Controller.getInstance().getFunctionalGroup();
        for (String register : new HashSet(registerMapConfig.getConfiguredRegisterNames(functionalGroup))) {
            if (register.equals("") || !allowedRegisters.isEmpty() && !allowedRegisters.contains(register)) continue;
            String[] split = register.split("::");
            if (split.length != 2) {
                LOGGER.log(Level.SEVERE, "[TOOL] Register name {0} does not contain peripheral and register separated by two colons", register);
                continue;
            }
            String peripheral = split[0];
            String name = split[1];
            for (Map.Entry entry : new HashMap(registerMapConfig.getBitFields(functionalGroup, register)).entrySet()) {
                String fullBitfieldName;
                BigInteger previousValue;
                boolean changed = false;
                String bitfieldName = (String)entry.getKey();
                if (!allowedBitfields.isEmpty() && !allowedBitfields.contains(bitfieldName)) continue;
                RegistersModelSingleton.BitFieldValue bitfieldValue = (RegistersModelSingleton.BitFieldValue)entry.getValue();
                BigInteger unknownBitsMask = bitfieldValue.getUnknownBitsMask();
                BigInteger newValue = bitfieldValue.getValue();
                BitFieldInfo bitfield = BitFieldInfo.create((String)peripheral, (String)name, (String)bitfieldName, (BigInteger)newValue, (BigInteger)unknownBitsMask, (boolean)(changed = (previousValue = this.previousValues.get(fullBitfieldName = RegistersModelSingleton.computeFullNameOfBitfield((String)register, (String)bitfieldName))) != null ? previousValue.compareTo(newValue) != 0 : true), (IRegistersDatabaseAPI)registersDb);
                if (bitfield == null) continue;
                bitfields.add(bitfield);
                newValues.put(fullBitfieldName, newValue);
            }
        }
        this.previousValues.clear();
        this.previousValues.putAll(newValues);
        return bitfields;
    }

    public Collection<BitFieldInfo> getContent(RegistersContentProviderProperties properties) {
        IComponentInstanceConfig instance;
        if (properties.getShowOnlyCurrentSource() && (instance = RegistersModelSingleton.getInstance().getSelectedInstance()) != null) {
            HashSet<String> allowedRegisters = new HashSet<String>();
            HashSet<String> allowedBitfields = new HashSet<String>();
            for (AssignConfig assign : instance.getAllAssigns()) {
                IContext context = assign.getParent().getExpressionContext();
                for (RegisterConfig register : assign.getRegisters()) {
                    try {
                        String peripheral = register.getPeripheral(context);
                        String name = register.getName(context);
                        allowedRegisters.add(RegistersModelSingleton.computeFullNameOfRegister((String)instance.getPeripheral(), (String)peripheral, (String)name));
                        allowedBitfields.add(register.getBitfield(context));
                    }
                    catch (RegistersModelSingleton.RegisterNotFoundException e) {
                        e.log(assign.getParent().getId());
                    }
                }
            }
            return this.getBitfieldInfos(allowedRegisters, allowedBitfields);
        }
        return super.getContent(properties);
    }

    public boolean isCurrentComponentOnlySupported() {
        return true;
    }

    public @NonNull String getCurrentComponentOnlySuffix() {
        IComponentInstanceConfig instance = RegistersModelSingleton.getInstance().getSelectedInstance();
        if (instance == null) {
            return "";
        }
        return instance.getName();
    }

    public void changeValues(List<BitFieldInfo> infos) {
        for (BitFieldInfo info : infos) {
            BigInteger value = info.getValue();
            if (value == null) {
                LOGGER.log(Level.SEVERE, "[TOOL] BitFieldInfo with null value was given to make change: {0}", value);
                continue;
            }
            IFunctionalGroup group = Controller.getInstance().getFunctionalGroup();
            String fullRegisterName = RegistersModelSingleton.computeFullNameOfRegister((String)info.getPeripheral(), (String)info.getRegister());
            RegistersModelSingleton.BitFieldValue bitFieldValue = (RegistersModelSingleton.BitFieldValue)RegistersModelSingleton.getInstance().getBitFields(group, fullRegisterName).get(info.getBitFieldName());
            if (bitFieldValue == null) {
                LOGGER.log(Level.SEVERE, "[TOOL] BitFieldInfo that was not configured yet was given to make change: {0}", value);
                continue;
            }
            int bitFiledWidth = group.getExpressionContext().getBitFiledWidth(fullRegisterName, info.getBitFieldName());
            BigInteger mask = BigInteger.ONE.shiftLeft(bitFiledWidth).subtract(BigInteger.ONE);
            if (!RegistersModelSingleton.getInstance().notifyAboutValueChange(group, info.getPeripheral(), info.getRegister(), info.getBitFieldName(), null, value, mask)) continue;
            bitFieldValue.setValue(value);
        }
        Controller.getInstance().handleSettingChange(2, RegistersContentProvider.class, Messages.get().RegisterContentProvider_RefreshAfterSettingValueInRegistersView);
    }

    public boolean isValueEditingSupported() {
        return true;
    }

    public void setRefreshManager(IViewRefreshManager refreshManager) {
        this.refreshManager = refreshManager;
    }

    public void create() {
        Controller.getInstance().addListener(Integer.MAX_VALUE, this.eventListener);
        Controller.getInstance().setRegistersRefreshManager(this);
    }

    public void refresh() {
        IViewRefreshManager refreshManagerLoc = this.refreshManager;
        if (refreshManagerLoc != null) {
            refreshManagerLoc.refresh();
        }
    }

    public void dispose() {
        Controller.getInstance().removeListener(this.eventListener);
    }
}

