/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.controller;

import com.nxp.swtools.codemanager.CodeManager;
import com.nxp.swtools.codemanager.ICodeGenerator;
import com.nxp.swtools.codemanager.IToolSpecificCodeManager;
import com.nxp.swtools.common.ui.utils.progress.UIJobHelper;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.ExpressionException;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.lang.CollectionMap;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.periphs.controller.APeriphController;
import com.nxp.swtools.periphs.controller.Messages;
import com.nxp.swtools.periphs.controller.MigrationHelper;
import com.nxp.swtools.periphs.controller.PeripheralsGenericProblem;
import com.nxp.swtools.periphs.controller.PeripheralsProblem;
import com.nxp.swtools.periphs.controller.PeriphsSpecificCodeManager;
import com.nxp.swtools.periphs.controller.RegistersContentProvider;
import com.nxp.swtools.periphs.controller.ValidationParams;
import com.nxp.swtools.periphs.controller.generation.PeripheralsSourceCodeRefreshHandler;
import com.nxp.swtools.periphs.model.config.ComponentConfig;
import com.nxp.swtools.periphs.model.config.ComponentInstanceConfig;
import com.nxp.swtools.periphs.model.config.DummyComponentInstanceConfig;
import com.nxp.swtools.periphs.model.config.FunctionalGroup;
import com.nxp.swtools.periphs.model.config.PeriphsProfile;
import com.nxp.swtools.periphs.model.data.Components;
import com.nxp.swtools.periphs.model.data.ComputeScoreWrapper;
import com.nxp.swtools.periphs.model.data.ConfigurationComponent;
import com.nxp.swtools.periphs.model.data.mcu.EmptyMcu;
import com.nxp.swtools.periphs.model.data.mcu.IMcu;
import com.nxp.swtools.periphs.model.resources.AProcessorFilterForPeripherals;
import com.nxp.swtools.periphs.model.resources.ProcessorFilterForPeripherals;
import com.nxp.swtools.periphs.model.templates.component.ComponentTemplate;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.ConfigChangeReason;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.IConfigChangeContext;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.ISharedConfigurationListener;
import com.nxp.swtools.provider.configuration.SharedConfigurationAdapter;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.dependencies.DependencyCreator;
import com.nxp.swtools.provider.configuration.dependencies.DependencyFactory;
import com.nxp.swtools.provider.configuration.dependencies.IDependency;
import com.nxp.swtools.provider.configuration.helper.CommonConfigImpl;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.configuration.storage.StorageConfigurationPreferences;
import com.nxp.swtools.provider.configuration.storage.StorageDependency;
import com.nxp.swtools.provider.configuration.storage.StorageDependencyFeature;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsComponentInstance;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsFuncGroup;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsTool;
import com.nxp.swtools.provider.features.SdkFeaturesProvider;
import com.nxp.swtools.provider.toolchainproject.ISdkComponentInProject;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.resourcetables.model.config.ArrayConfig;
import com.nxp.swtools.resourcetables.model.config.AssignConfig;
import com.nxp.swtools.resourcetables.model.config.ChildProviderHelper;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IChildProvidable;
import com.nxp.swtools.resourcetables.model.config.IComponentConfig;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.config.IConfigSetConfig;
import com.nxp.swtools.resourcetables.model.config.IFunctionalGroup;
import com.nxp.swtools.resourcetables.model.config.IPresettable;
import com.nxp.swtools.resourcetables.model.config.IRoot;
import com.nxp.swtools.resourcetables.model.config.ISettingConfig;
import com.nxp.swtools.resourcetables.model.config.RegisterConfig;
import com.nxp.swtools.resourcetables.model.config.RegistersModelSingleton;
import com.nxp.swtools.resourcetables.model.config.ScalarConfig;
import com.nxp.swtools.resourcetables.model.config.SetConfig;
import com.nxp.swtools.resourcetables.model.data.ComponentOperationTypeEnum;
import com.nxp.swtools.resourcetables.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.resourcetables.model.data.IConfigurationComponent;
import com.nxp.swtools.resourcetables.model.data.IQuickSelection;
import com.nxp.swtools.resourcetables.model.data.MasterPeripheral;
import com.nxp.swtools.resourcetables.model.data.Mode;
import com.nxp.swtools.resourcetables.model.data.SWComponent;
import com.nxp.swtools.resourcetables.model.mcu.ICommonMcu;
import com.nxp.swtools.resourcetables.properties.Properties;
import com.nxp.swtools.utils.ConfigurationUtils;
import com.nxp.swtools.utils.events.ToolEvent;
import com.nxp.swtools.utils.preferences.KEPreferences;
import com.nxp.swtools.utils.profiler.Profiler;
import com.nxp.swtools.utils.scripting.ScriptResult;
import com.nxp.swtools.utils.snippets.SnippetCategory;
import com.nxp.swtools.utils.snippets.SnippetInfo;
import com.nxp.swtools.utils.snippets.SnippetNode;
import com.nxp.swtools.utils.wizards.exportWizard.AExportWizard;
import com.nxp.swtools.validation.engine.GenericProblem;
import com.nxp.swtools.validation.engine.IGenericProblem;
import com.nxp.swtools.validation.engine.ValidationEngineFactory;
import java.io.File;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Version;

public class Controller
extends APeriphController
implements ICodeGenerator {
    private boolean disposed = false;
    protected CodeManager codeManager;
    protected boolean isOn;
    @Nullable
    protected final Display display;
    volatile boolean otherToolChanged = false;
    boolean reactToOtherToolChangesImmediately;
    @Nullable
    PeripheralsSourceCodeRefreshHandler codeRefreshManagerHandler = null;
    @Nullable
    RegistersContentProvider registerRefreshManagerHandler = null;
    private Map<String, Collection<IGenericProblem>> externalProblemsList = new HashMap<String, Collection<IGenericProblem>>();

    private Controller() {
        super((AProcessorFilterForPeripherals)ProcessorFilterForPeripherals.getInstance());
        this.codeManager = new CodeManager((IToolSpecificCodeManager)new PeriphsSpecificCodeManager(this));
        final ISharedConfiguration sharedConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
        this.reloadFromSharedConfig(sharedConfig, ConfigChangeReason.UNKNOWN);
        this.display = SWToolsProperties.isHeadlessOn() ? null : Display.getCurrent();
        SharedConfigurationFactory.getSharedConfigurationSingleton().addListener((ISharedConfigurationListener)new SharedConfigurationAdapter(){

            public void configurationReloaded(ISharedConfiguration sharedConfiguration, ConfigChangeReason reason) {
                if (reason != ConfigChangeReason.UNDO_REDO || !Controller.this.profile.getStoragePeripheralsTool().equals((StorageTool)sharedConfiguration.getTools().getPeripherals(), StorageTool.CompareMode.MEX_AND_YAML) || Controller.this.profile.isYamlEnabled() != sharedConfiguration.getPreferences().isYamlOutputEnabled()) {
                    Controller.this.reloadFromSharedConfig(sharedConfiguration, reason);
                } else {
                    Controller.this.otherToolChanged = true;
                }
            }

            public void configurationChanged(ISharedConfiguration sharedConfiguration, IConfigChangeContext changeContext) {
                Object source = changeContext.getSource();
                if (source instanceof StorageConfigurationPreferences) {
                    Controller.this.profile.setYamlEnabled(((StorageConfigurationPreferences)source).isYamlOutputEnabled());
                    Controller.this.requestRegenerateCode();
                } else if (changeContext.getChangeType() == IConfigChangeContext.ConfigChangeType.TOOL_TOGGLE) {
                    if ("Peripherals".equals(changeContext.getToolId())) {
                        this.configurationReloaded(sharedConfiguration, ConfigChangeReason.UNKNOWN);
                        if (Controller.this.otherToolChanged) {
                            RegistersModelSingleton.getInstance().refreshRegistersFromAssigns(Controller.this.getFunctionalGroup());
                        }
                    } else {
                        Controller.this.softRefresh();
                    }
                } else if (source instanceof CommonConfigImpl) {
                    CommonConfigImpl commonConfigImpl = (CommonConfigImpl)source;
                    ProcessorCore selectedCore = commonConfigImpl.getSelectedCore();
                    if (selectedCore != null) {
                        Controller.this.profile.setActiveCoreId(selectedCore.getID());
                        Controller.this.handleSettingChange(1, sharedConfig, null);
                    }
                } else if (!"Peripherals".equals(changeContext.getToolId())) {
                    Controller.this.otherToolChanged = true;
                    if (Controller.this.reactToOtherToolChangesImmediately) {
                        Controller.this.refreshIfChangeInOtherTool();
                    }
                }
            }

            public void commonConfigurationChanged(ISharedConfiguration sharedConfiguration) {
                if (!sharedConfiguration.getCommonConfig().getMcuIdentification().equals(Controller.this.mcu.getMcuIdentification())) {
                    this.configurationReloaded(sharedConfig, ConfigChangeReason.UNKNOWN);
                }
            }

            public int getListenerOrder() {
                return 1073741923;
            }
        });
    }

    public void refreshIfChangeInOtherTool() {
        if (this.isOn && this.otherToolChanged) {
            this.softRefresh();
            this.otherToolChanged = false;
        }
    }

    public boolean waitUntilRegenerated() {
        return this.codeManager.waitUntilRegenerated();
    }

    public boolean isGeneratingCode() {
        return this.codeManager.isGeneratingCode();
    }

    public boolean isCodeDirty() {
        return this.codeManager.isCodeDirty();
    }

    @Override
    public void handleSettingChangeSpecificImplementation(int eventType, @Nullable Object eventOriginator, @Nullable String actionLabel, boolean setDirty, boolean clearCache) {
        block12: {
            Profiler profiler;
            BigInteger index = profiler.start(Controller.class, (Object)(!(profiler = Profiler.getInstance((Object)"Peripherals")).isEnabled() ? "" : "Controller handleSettingChange '" + UtilsText.safeString((String)actionLabel) + "' caused by '" + (eventOriginator == null ? "" : eventOriginator.toString()) + "'"));
            try {
                try {
                    if (clearCache) {
                        this.profile.clearCache();
                    }
                    this.handleArraysAutoSize();
                    for (ScalarConfig variable : this.getAllVariableConfigsInProfile((IRoot)this.profile)) {
                        this.resolveAssigns((IChild)variable);
                    }
                    RegistersModelSingleton registerModelInstance = RegistersModelSingleton.getInstance();
                    if (registerModelInstance.isRegenerationNeeded()) {
                        registerModelInstance.refreshRegistersFromAssigns(this.getFunctionalGroup());
                    }
                    this.profile.updateStorageAvailability();
                    if (!KEPreferences.isGenerateFullInstanceIdentification()) {
                        this.regenerateInstanceNames();
                    }
                    this.requestCodeGeneration();
                    ISharedConfiguration currentSharedConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
                    if (this.isOn && this.isMcuSupported() && eventOriginator != currentSharedConfig) {
                        currentSharedConfig.getTools().setPeripherals(this.profile.getStoragePeripheralsTool());
                        if (setDirty) {
                            this.setDirty(currentSharedConfig, actionLabel);
                        }
                    }
                    profiler.stop(index, Controller.class, null);
                    if (this.display == null) {
                        this.updateValidationParams();
                        break block12;
                    }
                    UIJobHelper.runNowOrInJob(() -> {
                        this.updateValidationParams();
                        this.fireListeners(new ToolEvent.Builder(eventType).setOriginator(eventOriginator).build());
                    }, (String)"Handling changes", (Display)this.display);
                }
                catch (ExpressionException exception) {
                    exception.log();
                    profiler.push();
                }
            }
            finally {
                profiler.push();
            }
        }
    }

    private void handleArraysAutoSize() {
        boolean modification = false;
        for (ArrayConfig array : this.getAllArrayConfigsInProfile((IRoot)this.profile)) {
            int oldSize = array.getChildren().size();
            List modifiedItems = array.updateSize();
            int newSize = array.getChildren().size();
            if (oldSize > newSize) {
                RegistersModelSingleton.getInstance().unregisterAllAssigns(this.functionalGroup, (Collection)modifiedItems);
            } else {
                RegistersModelSingleton.getInstance().registerAllAssigns(this.functionalGroup, (Collection)modifiedItems);
            }
            modification |= !modifiedItems.isEmpty();
        }
        if (modification) {
            RegistersModelSingleton.getInstance().refreshRegistersFromAssigns(this.getFunctionalGroup());
        }
    }

    public void handleEvents(Collection<ToolEvent> events) {
        UIJobHelper.runNowOrInJob(() -> super.handleEvents(events), (String)"Firing event", (Display)this.display);
    }

    void setDirty(ISharedConfiguration currentSharedConfig, @Nullable String actionLabel) {
        this.setDirty(currentSharedConfig, "Peripherals", this.functionalGroup.getStorageFuncGroup(), actionLabel, IConfigChangeContext.ConfigChangeType.TOOL_SETTING_CHANGE);
    }

    private void addDefaultFunctionalGroup(ISharedConfiguration sharedConfig) {
        FunctionalGroup functionalGroupLoc = Controller.createFunctionalGroup(this.profile.getChildContext(), this.profile.getMcu());
        functionalGroupLoc.setCalledFromDefaultInit(true);
        if (!functionalGroupLoc.setCoreFrom(sharedConfig.getCommonConfig())) {
            functionalGroupLoc.setMasterCoreAsUsed();
        }
        this.profile.addFunctionalGroup((IFunctionalGroup)functionalGroupLoc);
        this.addAutoAddingInstances((IFunctionalGroup)functionalGroupLoc);
    }

    protected void reloadFromSharedConfig(ISharedConfiguration sharedConfig, ConfigChangeReason reason) {
        IFunctionalGroup matchingNameGroup;
        BigInteger index = Profiler.getInstance((Object)"Peripherals").start(Controller.class, (Object)MessageFormat.format("Reload from shared configuration \"{0}\"", sharedConfig));
        Properties.disableVerification();
        switch (reason) {
            case NEW_CONFIG: 
            case MCU_CHANGE: 
            case LOAD_CONFIG: 
            case CLEAR_CONFIG: {
                RegistersModelSingleton.getInstance().clear();
            }
        }
        PeriphsProfile oldProfile = this.profile;
        this.profile = this.loadProfileFromSharedConfig(sharedConfig);
        this.mcu = this.profile.getMcu();
        if (this.mcu != oldProfile.getMcu()) {
            oldProfile.getMcu().dispose();
        }
        oldProfile.dispose();
        boolean wasOn = this.isOn;
        this.isOn = this.profile.getStoragePeripheralsTool().isEnabled();
        if (this.isOn && !wasOn) {
            RegistersModelSingleton.getInstance().initialize((ICommonMcu)this.getMcu());
        }
        switch (reason) {
            case NEW_CONFIG: 
            case MCU_CHANGE: 
            case LOAD_CONFIG: {
                RegistersModelSingleton.getInstance().initialize((ICommonMcu)this.getMcu());
            }
        }
        if (this.profile.getFunctionalGroups().isEmpty()) {
            this.addDefaultFunctionalGroup(sharedConfig);
        }
        this.functionalGroup = (matchingNameGroup = this.profile.getFunctionalGroup(this.functionalGroup.getName())) != null ? matchingNameGroup : (IFunctionalGroup)this.profile.getFunctionalGroups().get(0);
        for (IFunctionalGroup group : this.profile.getFunctionalGroups()) {
            this.addAutoAddingInstances(group);
        }
        Properties.enableVerification();
        if (!this.isOn) {
            this.disablePeripheralsTool();
        }
        if (reason == ConfigChangeReason.LOAD_CONFIG) {
            this.handleAutomaticMigrations();
        }
        switch (reason) {
            case LOAD_CONFIG: 
            case RELOAD: 
            case UNDO_REDO: {
                RegistersModelSingleton.getInstance().getAssignCreationLatch().waitOnSemaphore();
                RegistersModelSingleton.getInstance().refreshRegistersFromAssigns(this.getFunctionalGroup());
            }
        }
        if (reason == ConfigChangeReason.RELOAD) {
            this.profile.clearCache();
            for (IFunctionalGroup group : this.profile.getFunctionalGroups()) {
                group.handleUniqueIntegers();
            }
        }
        Profiler.getInstance((Object)"Peripherals").stop(index, Controller.class, null);
        this.handleSettingChange(1, sharedConfig, null);
    }

    private void handleAutomaticMigrations() {
        this.runTransaction(() -> {
            List allInstances;
            List<CollectionsUtils.Pair<IComponentInstanceConfig, ConfigurationComponentTypeId>> pairsToBeMigrated;
            while (!(pairsToBeMigrated = MigrationHelper.getComponentsToBeMigratedAutomatically(allInstances = (List)this.profile.getFunctionalGroups().stream().flatMap(group -> group.getInstances().values().stream()).collect(CollectorsUtils.toList()), this.getMcu().getAvailableComponents())).isEmpty()) {
                HashSet<String> alredyUsedTypeIds = new HashSet<String>();
                for (CollectionsUtils.Pair<IComponentInstanceConfig, ConfigurationComponentTypeId> pair : pairsToBeMigrated) {
                    IComponentInstanceConfig instance = (IComponentInstanceConfig)pair.getFirst();
                    ConfigurationComponentTypeId newTypeId = (ConfigurationComponentTypeId)pair.getSecond();
                    String originalTypeId = instance.getComponentTypeId();
                    if (alredyUsedTypeIds.contains(originalTypeId)) {
                        LOGGER.log(Level.SEVERE, () -> MessageFormat.format("[TOOL] Component with typeID \"{0}\" has automatic migration from the same original component typeID \"{1}\". Only first migration is performed.", newTypeId.getTypeId(), originalTypeId));
                        continue;
                    }
                    alredyUsedTypeIds.add(originalTypeId);
                    IComponentInstanceConfig newInstance = MigrationHelper.migrate(instance, newTypeId, this, Controller.class);
                    if (newInstance != null) continue;
                    LOGGER.log(Level.SEVERE, () -> MessageFormat.format("[TOOL] [{0}] Automatic migration failed", instance.getComponentTypeId()));
                }
            }
        });
    }

    protected void disablePeripheralsTool() {
        EmptyMcu mcuLoc = new EmptyMcu(UtilsText.safeString((String)Messages.get().Controller_ToolDisabled));
        PeriphsProfile profileLoc = new PeriphsProfile((IMcu)mcuLoc, SharedConfigurationFactory.createSharedConfiguration());
        FunctionalGroup disabledFunctionalGroup = Controller.createFunctionalGroup(profileLoc.getChildContext(), (IMcu)mcuLoc);
        profileLoc.addFunctionalGroup((IFunctionalGroup)disabledFunctionalGroup);
        this.setMcu((IMcu)mcuLoc);
        this.setProfile(profileLoc);
        this.functionalGroup = disabledFunctionalGroup;
    }

    private PeriphsProfile loadProfileFromSharedConfig(ISharedConfiguration sharedConfig) {
        StoragePeriphsTool storagePeripheralsTool = sharedConfig.getTools().getPeripherals();
        IMcu profileMcu = this.getMcuFromSharedConfig(sharedConfig);
        if (storagePeripheralsTool != null && storagePeripheralsTool.isEnabled() && Controller.isMcuSupported(profileMcu)) {
            return new PeriphsProfile(profileMcu, storagePeripheralsTool, sharedConfig);
        }
        PeriphsProfile profileLoc = new PeriphsProfile(profileMcu, sharedConfig);
        if (storagePeripheralsTool != null && !storagePeripheralsTool.isEnabled()) {
            profileLoc.getStoragePeripheralsTool().setEnabled(false);
        }
        if (storagePeripheralsTool == null && Controller.isMcuSupported(profileMcu)) {
            sharedConfig.getTools().setPeripherals(profileLoc.getStoragePeripheralsTool());
        }
        return profileLoc;
    }

    public void regenerateCode() {
        this.codeManager.requestRegenerateCode();
    }

    public void forceCodeRegeneration() {
        this.regenerateCode();
    }

    public void setFunctionalGroupProperties(IFunctionalGroup group, String name, String description, String idPrefix, boolean calledFromDefaultInit, String selectedCore, Object caller) {
        Runnable setDetailsFunction = () -> {
            group.setName(name);
            group.setDescription(description);
            group.setIdPrefix(idPrefix);
            group.setCore(selectedCore);
            this.setCalledFromDefaultInit(group, calledFromDefaultInit, caller);
        };
        this.runTransaction(setDetailsFunction);
    }

    public IFunctionalGroup addFunctionalGroup(String name, String description, String idPrefix, boolean calledFromDefaultInit, String selectedCore, Object caller) {
        return this.addFunctionalGroup(name, description, idPrefix, calledFromDefaultInit, selectedCore, true, caller);
    }

    public IFunctionalGroup addFunctionalGroup(String name, String description, String idPrefix, boolean calledFromDefaultInit, String selectedCore, boolean handleChanges, Object caller) {
        Supplier<IFunctionalGroup> addFunctionalGroupFunction = () -> {
            FunctionalGroup newGroup = Controller.createFunctionalGroup(this.profile.getChildContext(), this.profile.getMcu());
            newGroup.setName(name);
            newGroup.setDescription(description);
            newGroup.setIdPrefix(idPrefix);
            newGroup.setCore(selectedCore);
            this.profile.addFunctionalGroup((IFunctionalGroup)newGroup);
            this.addAutoAddingInstances((IFunctionalGroup)newGroup);
            if (handleChanges) {
                this.handleSettingChange(1, caller, UtilsText.safeString((String)Messages.get().Controller_Action_AddFunctionalGroup));
            }
            this.setCalledFromDefaultInit((IFunctionalGroup)newGroup, calledFromDefaultInit, handleChanges, caller);
            this.setFunctionalGroup((IFunctionalGroup)newGroup, handleChanges, caller);
            return newGroup;
        };
        IFunctionalGroup result = (IFunctionalGroup)this.runTransaction(addFunctionalGroupFunction).get();
        assert (result != null);
        return result;
    }

    public boolean isFunctionalGroupsLimitReached() {
        return this.profile.getFunctionalGroups().size() >= Controller.getInstance().getMaximumNumberOfFunctionalGroups();
    }

    public boolean removeFunctionalGroup(IFunctionalGroup group, Object caller) {
        int oldIdx = this.profile.getFunctionalGroups().indexOf(group);
        if (oldIdx >= 0 && this.profile.getFunctionalGroups().size() <= 1) {
            throw new IllegalStateException(MessageFormat.format("Cannot remove the {0} functional group. Minimal number of functional groups in profile is: 1", group.getName()));
        }
        boolean result = this.profile.removeFunctionalGroup(group);
        if (result) {
            RegistersModelSingleton.getInstance().unregisterAllAssigns(group);
            if (group == this.functionalGroup) {
                int newIdx = oldIdx;
                if (this.profile.getFunctionalGroups().size() >= newIdx) {
                    newIdx = this.profile.getFunctionalGroups().size() - 1;
                }
                if (newIdx < 0) {
                    newIdx = 0;
                }
                this.functionalGroup = (IFunctionalGroup)this.profile.getFunctionalGroups().get(newIdx);
            }
            this.handleSettingChange(1, caller, UtilsText.safeString((String)Messages.get().Controller_Action_RemoveFunctionalGroup));
        }
        return result;
    }

    public @Nullable ScriptResult getGeneratedCode() {
        return this.codeManager.getGeneratedCode();
    }

    public @Nullable ScriptResult waitAndGetGeneratedCode() {
        if (this.waitUntilRegenerated()) {
            return this.codeManager.getGeneratedCode();
        }
        return null;
    }

    public AExportWizard.GenerationResult waitAndGetGenerationResult(String coreId) {
        this.codeManager.waitUntilRegenerated();
        return this.getGenerationResult(coreId);
    }

    public AExportWizard.GenerationResult getGenerationResult(String coreId) {
        ScriptResult scriptResult = this.getGeneratedCode();
        String error = this.getToolError();
        if (error != null) {
            return AExportWizard.GenerationResult.fail((String)error);
        }
        if (scriptResult == null || scriptResult.isFailed()) {
            return AExportWizard.GenerationResult.fail((String)Messages.get().Controller_SourcesGeneration_CannotGenerateDueToInternalError);
        }
        return AExportWizard.GenerationResult.success((Map)CollectionsUtils.safeMap((Map)scriptResult.getOpenedFiles(coreId)), (Map)CollectionsUtils.safeMap((Map)scriptResult.getOpenedBinaryFiles(coreId)));
    }

    public static Controller getInstance() {
        try {
            Controller controller = (Controller)((Object)SWTFactoryProxy.INSTANCE.getSingletonInstance(Controller.class));
            if (controller.disposed) {
                throw new IllegalStateException("Controller is disposed");
            }
            return controller;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Cannot obtain instance of a controller", e);
        }
    }

    public void dispose() {
        this.disposed = true;
    }

    public void setMcu(IMcu mcu) {
        this.mcu = mcu;
    }

    @Override
    public List<ConfigurationComponentTypeId> getComponentsOfPeripheral(String peripheralInstance) {
        String peripheralType = this.mcu.getPeripheralType(peripheralInstance);
        DummyComponentInstanceConfig dummy = new DummyComponentInstanceConfig(this.functionalGroup, peripheralInstance, this.functionalGroup.getChildContext(), (ICommonMcu)this.mcu);
        IContext context = dummy.getExpressionContext();
        try {
            return (List)this.mcu.getAvailableComponents().getConfigCompTypeIds().stream().filter(typeId -> !typeId.getConfigurationComponent().isGlobalOnly()).filter(typeId -> typeId.getConfigurationComponent().getScenarios().stream().filter(mode -> mode.isAvailable(context)).map(mode -> mode.getMasterPeripheral()).filter(Objects::nonNull).flatMap(masterPeripheral -> {
                assert (masterPeripheral != null);
                return masterPeripheral.getPeripherals().stream();
            }).anyMatch(masterPeripheralType -> masterPeripheralType.equals(peripheralType))).collect(CollectorsUtils.toList());
        }
        catch (ExpressionException ex) {
            ex.log();
            return new ArrayList<ConfigurationComponentTypeId>();
        }
    }

    public List<String> getConfigSets(String component, String mode) {
        ArrayList<String> refs = new ArrayList<String>();
        ConfigurationComponent configurationComponent = this.getConfigurationComponent(component);
        if (configurationComponent != null) {
            try {
                configurationComponent.getScenarios().stream().filter(x -> mode.equals(x.getUIName(this.profile.getExpressionContext()))).forEach(y -> {
                    boolean bl = refs.addAll(y.getConfigSetRefs());
                });
            }
            catch (ExpressionException ex) {
                ex.log();
            }
        }
        return refs;
    }

    public List<String> getModes(String component) {
        HashSet modes = new HashSet();
        ConfigurationComponent configurationComponent = this.getConfigurationComponent(component);
        if (configurationComponent != null) {
            try {
                configurationComponent.getScenarios().forEach(y -> {
                    boolean bl = modes.add(y.getUIName(this.profile.getExpressionContext()));
                });
            }
            catch (ExpressionException ex) {
                ex.log();
            }
        }
        return new ArrayList<String>(modes);
    }

    public List<String> getPeripherals() {
        return this.mcu.getPeripherals();
    }

    @Override
    public List<String> getActiveCorePeripherals() {
        return this.filterPeripheralsForCore(this.functionalGroup.getCore(), this.mcu.getPeripherals());
    }

    @Override
    public List<String> filterPeripheralsForCore(String core, Collection<String> peripherals) {
        return (List)peripherals.stream().filter(name -> this.mcu.isPeripheralAvailableForCore(core, name)).collect(CollectorsUtils.toList());
    }

    public void setProfile(PeriphsProfile profile) {
        this.profile = profile;
    }

    public @Nullable IComponentConfig createOrGetComponent(String compTypeId, Object caller) {
        ConfigurationComponentTypeId configCompTypeId = this.mcu.getAvailableComponents().getConfigCompTypeId(compTypeId);
        if (configCompTypeId == null) {
            throw new IllegalArgumentException("Component with type id: " + compTypeId + " does not exist");
        }
        IConfigurationComponent configComp = configCompTypeId.getConfigurationComponent();
        IComponentConfig component = this.profile.getComponent(configComp.getId());
        if (component != null) {
            if (!component.getComponentTypeId().equals(configCompTypeId.getTypeId())) {
                LOGGER.severe(() -> MessageFormat.format("[TOOL] Component with type ID \"{0}\" cannot be added to the profile because there already is another component with the same type", compTypeId));
            }
            return component;
        }
        component = new ComponentConfig(configCompTypeId, this.profile.getChildContext(), (ICommonMcu)this.mcu);
        this.profile.addComponent(component);
        for (String componentType : configComp.getListOfGlobalComponentsToBeAddedAutomatically()) {
            this.createGlobalComponentThatShouldBeAddedAutomatically(componentType, configCompTypeId.getTypeId(), caller);
        }
        this.handleSettingChange(1, caller, UtilsText.safeString((String)Messages.get().Controller_Action_CreateComponent));
        return component;
    }

    private void createGlobalComponentThatShouldBeAddedAutomatically(String componentType, String configCompTypeId, Object caller) {
        List typeIds = this.mcu.getAvailableComponents().getComponentTypeIdsByType(componentType);
        if (typeIds == null || typeIds.isEmpty()) {
            LOGGER.log(Level.SEVERE, () -> MessageFormat.format("[DATA][{0}] Requested global component {1} which should be added automatically was not found", configCompTypeId, componentType));
            return;
        }
        if (typeIds.size() > 1) {
            LOGGER.log(Level.SEVERE, () -> MessageFormat.format("[DATA][{0}] Requested global component {1} has more versions and therefore is not global", configCompTypeId, componentType));
            return;
        }
        ConfigurationComponentTypeId componentTypeId = (ConfigurationComponentTypeId)typeIds.get(0);
        if (!componentTypeId.getConfigurationComponent().isGlobalOnly()) {
            LOGGER.log(Level.SEVERE, () -> MessageFormat.format("[DATA][{0}] Requested global component {1} which should be automatically added is not global component", configCompTypeId, componentType));
            return;
        }
        IComponentConfig autoAddedComponent = this.createOrGetComponent(componentTypeId.getTypeId(), caller);
        if (autoAddedComponent == null) {
            LOGGER.log(Level.SEVERE, () -> MessageFormat.format("[TOOL][{0}] Requested global component {1} which should be automatically added could not be created", configCompTypeId, componentType));
        }
    }

    public @Nullable IComponentInstanceConfig createComponentInstance(String compTypeId, @Nullable String usingPeripheral, Object caller) {
        return this.createComponentInstance(compTypeId, usingPeripheral, this.functionalGroup.getName(), caller);
    }

    private @Nullable IComponentInstanceConfig createComponentInstanceInternal(String compTypeId, @Nullable String usingPeripheral, String group, Object caller) {
        Properties.disableVerification();
        ConfigurationComponentTypeId configCompTypeId = this.mcu.getAvailableComponents().getConfigCompTypeId(compTypeId);
        if (configCompTypeId == null) {
            LOGGER.log(Level.SEVERE, "[TOOL] Component with type ID \"{0}\" does not exist", compTypeId);
            return null;
        }
        IConfigurationComponent configComp = configCompTypeId.getConfigurationComponent();
        if (configComp.isGlobalOnly()) {
            LOGGER.log(Level.SEVERE, "[TOOL] Component with type ID \"{0}\" is global only and cannot be instantiated", compTypeId);
            return null;
        }
        IComponentConfig component = this.createOrGetComponent(compTypeId, caller);
        IFunctionalGroup funcGroup = this.profile.getFunctionalGroup(group);
        if (component == null || funcGroup == null) {
            return null;
        }
        Mode modeToSelect = this.getComponentMode(configComp, funcGroup, usingPeripheral);
        String peripheralToUse = null;
        if (modeToSelect != null) {
            if (usingPeripheral == null) {
                List<String> availablePeripherals = this.getAvailablePeripherals(funcGroup, modeToSelect);
                List<String> usablePeripherals = this.getUsablePeripherals(funcGroup, modeToSelect);
                peripheralToUse = availablePeripherals.isEmpty() ? (usablePeripherals.isEmpty() ? null : usablePeripherals.get(0)) : availablePeripherals.get(0);
            } else {
                MasterPeripheral masterPeripheral = modeToSelect.getMasterPeripheral();
                if (masterPeripheral != null && masterPeripheral.getPeripherals().stream().anyMatch(x -> funcGroup.getAvailablePeripherals(x).contains(usingPeripheral))) {
                    peripheralToUse = usingPeripheral;
                }
            }
        }
        if (modeToSelect == null) {
            LOGGER.log(Level.SEVERE, "[DATA] The component \"{0}\" has no available mode for the current MCU", compTypeId);
            return null;
        }
        if (peripheralToUse == null && modeToSelect.getMasterPeripheral() != null) {
            LOGGER.log(Level.SEVERE, "[DATA] There is no peripheral that can be used to create component instance of component \"{0}\"", compTypeId);
            return null;
        }
        String name = this.createInstanceName(Controller.getAutomaticName(component, peripheralToUse), funcGroup);
        ComponentInstanceConfig componentSetting = new ComponentInstanceConfig(component.getComponent(), funcGroup, name, modeToSelect, Collections.emptyMap(), peripheralToUse, component.getChildContext(), (ICommonMcu)this.mcu, UUID.randomUUID().toString(), false);
        componentSetting.setUUID(UUID.randomUUID().toString());
        if (SWToolsPlatform.isRunningInEclipseIde()) {
            StringBuilder swComponents = new StringBuilder();
            configComp.getComponents().forEach(x -> swComponents.append(x.getName()).append(";"));
            this.fireListeners(new ToolEvent.Builder(8).setOriginator((Object)swComponents).build());
        }
        componentSetting.synchronizeValue(null);
        this.profile.synchronizeFunctionalGroups(this.functionalGroup, null, null, ComponentOperationTypeEnum.ADD);
        RegistersModelSingleton.getInstance().refreshRegistersFromAssigns(this.functionalGroup);
        this.handleSettingChange(1, Controller.class, UtilsText.safeString((String)Messages.get().Controller_Action_CreateComponentInstance));
        Properties.enableVerification();
        return componentSetting;
    }

    private @Nullable IComponentInstanceConfig createComponentInstanceFromTemplateInternal(ComponentTemplate template, @Nullable String usingPeripheral, String group, Object caller) {
        IConfigurationComponent configComp;
        Properties.disableVerification();
        String compTypeId = template.getTypeId();
        ConfigurationComponentTypeId configCompTypeId = this.mcu.getAvailableComponents().getConfigCompTypeId(compTypeId);
        IConfigurationComponent iConfigurationComponent = configComp = configCompTypeId == null ? null : configCompTypeId.getConfigurationComponent();
        if (configComp == null || configComp.isGlobalOnly()) {
            LOGGER.log(Level.SEVERE, "[TOOL] Component with type ID \"{0}\" does not exist or is global only and cannot be instantiated", compTypeId);
            return null;
        }
        IComponentConfig component = this.createOrGetComponent(compTypeId, caller);
        IFunctionalGroup funcGroup = this.profile.getFunctionalGroup(group);
        if (component == null || funcGroup == null) {
            return null;
        }
        StoragePeriphsComponentInstance instanceStorage = template.getInstance();
        if (usingPeripheral == null) {
            String originalPeripheral = instanceStorage.getPeripheral();
            if (originalPeripheral != null && !this.getComponentInstancesByPeripheral(originalPeripheral).isEmpty()) {
                Collection<String> availablePeripherals = this.getAvailablePeripherals(funcGroup, configComp);
                if (availablePeripherals.isEmpty()) {
                    Iterator<String> usablePeripherals = this.getUsablePeripherals(funcGroup, configComp).iterator();
                    if (usablePeripherals.hasNext()) {
                        usingPeripheral = usablePeripherals.next();
                    }
                } else {
                    Iterator<String> iterator = availablePeripherals.iterator();
                    usingPeripheral = iterator.next();
                }
            } else {
                usingPeripheral = originalPeripheral;
            }
        }
        instanceStorage.setPeripheral(usingPeripheral);
        instanceStorage.setName(this.createInstanceName(Controller.getAutomaticName(component, usingPeripheral), funcGroup));
        instanceStorage.setUUID(UUID.randomUUID().toString());
        ComponentInstanceConfig instance = new ComponentInstanceConfig(configComp, funcGroup, instanceStorage, component.getChildContext(), (ICommonMcu)this.mcu);
        instance.setOriginalUseCase(template.getName());
        if (SWToolsPlatform.isRunningInEclipseIde()) {
            StringBuilder swComponents = new StringBuilder();
            configComp.getComponents().forEach(x -> swComponents.append(x.getName()).append(";"));
            this.fireListeners(new ToolEvent.Builder(8).setOriginator((Object)swComponents).build());
        }
        RegistersModelSingleton.getInstance().refreshRegistersFromAssigns(this.functionalGroup);
        this.handleSettingChange(1, Controller.class, UtilsText.safeString((String)Messages.get().Controller_Action_CreateComponentInstance));
        Properties.enableVerification();
        return instance;
    }

    private void createComponentThatShouldBeAddedAutomatically(String componentType, String configCompTypeId, String groupName, Object caller) {
        long limit;
        long count;
        List typeIds = this.mcu.getAvailableComponents().getComponentTypeIdsByType(componentType);
        IFunctionalGroup groupByName = this.profile.getFunctionalGroup(groupName);
        if (groupByName == null) {
            LOGGER.log(Level.SEVERE, "[TOOL] Target functional group with name {0} does not exist", groupName);
            return;
        }
        if (typeIds == null || typeIds.isEmpty()) {
            LOGGER.log(Level.SEVERE, () -> MessageFormat.format("[DATA][{0}] Requested component {1} which should be added automatically was not found", configCompTypeId, componentType));
            return;
        }
        if (typeIds.size() > 1) {
            LOGGER.log(Level.SEVERE, () -> MessageFormat.format("[DATA][{0}] Requested component {1} has more versions", configCompTypeId, componentType));
            return;
        }
        Expression limitExpression = ((ConfigurationComponentTypeId)typeIds.get(0)).getConfigurationComponent().getAutoAddComponentsLimit();
        if (limitExpression != null && (count = groupByName.getInstancesOfType(componentType).stream().filter(i -> i.isAvailable() && i.isEnabled()).count()) >= (limit = limitExpression.resolve(groupByName.getExpressionContext()).getLong())) {
            return;
        }
        IComponentInstanceConfig autoAddedComponent = this.createComponentInstanceInternal(((ConfigurationComponentTypeId)typeIds.get(0)).getTypeId(), null, groupName, Controller.class);
        if (autoAddedComponent == null) {
            LOGGER.log(Level.SEVERE, () -> MessageFormat.format("[TOOL][{0}] Requested component {1} which should be automatically added could not be created", configCompTypeId, componentType));
        }
    }

    @Override
    public @Nullable IComponentInstanceConfig createComponentInstance(String compTypeId, @Nullable String usingPeripheral, String group, Object caller) {
        return (IComponentInstanceConfig)CollectionsUtils.nullableOptionalGet((Optional)this.runTransaction(() -> {
            ConfigurationComponentTypeId configCompTypeId = this.mcu.getAvailableComponents().getConfigCompTypeId(compTypeId);
            if (configCompTypeId == null) {
                LOGGER.log(Level.SEVERE, "[TOOL] Component with type ID \"{0}\" does not exist", compTypeId);
                return null;
            }
            IConfigurationComponent configComp = configCompTypeId.getConfigurationComponent();
            if (configComp.isGlobalOnly()) {
                LOGGER.log(Level.SEVERE, "[TOOL] Component with type ID \"{0}\" is global only and cannot be instantiated", compTypeId);
                return null;
            }
            for (String componentTypeToBeAutoAdded : configComp.getListOfComponentsToBeAddedAutomatically()) {
                this.createComponentThatShouldBeAddedAutomatically(componentTypeToBeAutoAdded, compTypeId, group, Controller.class);
            }
            return this.createComponentInstanceInternal(compTypeId, usingPeripheral, group, caller);
        }));
    }

    @Override
    public @Nullable IComponentInstanceConfig createComponentInstanceFromTemplate(ComponentTemplate template, @Nullable String usingPeripheral, String group, Object caller) {
        return (IComponentInstanceConfig)CollectionsUtils.nullableOptionalGet((Optional)this.runTransaction(() -> {
            String compTypeId = template.getTypeId();
            ConfigurationComponentTypeId configCompTypeId = this.mcu.getAvailableComponents().getConfigCompTypeId(compTypeId);
            if (configCompTypeId == null) {
                LOGGER.log(Level.SEVERE, "[TOOL] Component with type ID \"{0}\" does not exist", compTypeId);
                return null;
            }
            IConfigurationComponent configComp = configCompTypeId.getConfigurationComponent();
            if (configComp.isGlobalOnly()) {
                LOGGER.log(Level.SEVERE, "[TOOL] Component with type ID \"{0}\" is global only and cannot be instantiated", compTypeId);
                return null;
            }
            for (String componentTypeToBeAutoAdded : configComp.getListOfComponentsToBeAddedAutomatically()) {
                this.createComponentThatShouldBeAddedAutomatically(componentTypeToBeAutoAdded, compTypeId, group, Controller.class);
            }
            return this.createComponentInstanceFromTemplateInternal(template, usingPeripheral, group, caller);
        }));
    }

    private List<Mode> getAvailableModes(IConfigurationComponent configComp, IFunctionalGroup funcGroup, @Nullable String requiredPeripheral) {
        try {
            ArrayList<Mode> availableModes = new ArrayList<Mode>();
            List modes = configComp.getScenarios();
            DummyComponentInstanceConfig dummy = new DummyComponentInstanceConfig(funcGroup, null, funcGroup.getChildContext(), (ICommonMcu)this.mcu);
            for (Mode mode : modes) {
                MasterPeripheral masterPeripheral = mode.getMasterPeripheral();
                if (masterPeripheral != null) {
                    ArrayList<String> availablePeripherals = new ArrayList<String>();
                    for (String peripheralType : masterPeripheral.getPeripherals()) {
                        for (String peripheral : funcGroup.getAvailablePeripherals(peripheralType)) {
                            dummy.setPeripheral(peripheral);
                            if (!mode.isAvailable(dummy.getExpressionContext())) continue;
                            availablePeripherals.add(peripheral);
                        }
                    }
                    if (requiredPeripheral != null) {
                        if (!availablePeripherals.contains(requiredPeripheral)) continue;
                        availableModes.add(mode);
                        continue;
                    }
                    if (availablePeripherals.isEmpty()) continue;
                    availableModes.add(mode);
                    continue;
                }
                dummy.setPeripheral(null);
                if (!mode.isAvailable(dummy.getExpressionContext())) continue;
                availableModes.add(mode);
            }
            return availableModes;
        }
        catch (ExpressionException ex) {
            ex.log();
            return new ArrayList<Mode>();
        }
    }

    private @Nullable Mode getFirstUsableMode(IFunctionalGroup funcGroup, List<Mode> availableModes, @Nullable String peripheral) {
        for (Mode mode : availableModes) {
            if (mode.getMasterPeripheral() == null) {
                return mode;
            }
            List<String> availablePeripherals = this.getAvailablePeripherals(funcGroup, mode);
            if (!(peripheral == null ? !availablePeripherals.isEmpty() : availablePeripherals.contains(peripheral))) continue;
            return mode;
        }
        return null;
    }

    @Override
    public boolean isAnyPeripheralAvailable(String funcGroupName, IConfigurationComponent configComp) {
        IFunctionalGroup funcGroup = this.profile.getFunctionalGroup(funcGroupName);
        if (funcGroup == null) {
            return false;
        }
        for (Mode mode : configComp.getScenarios()) {
            List<String> availablePeripherals = this.getAvailablePeripherals(funcGroup, mode);
            if (availablePeripherals.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<String> getAvailablePeripherals(IFunctionalGroup funcGroup, IConfigurationComponent configComp) {
        HashSet<String> availablePeripherals = new HashSet<String>();
        for (Mode mode : configComp.getScenarios()) {
            List<String> availableModePeripherals = this.getAvailablePeripherals(funcGroup, mode);
            if (availableModePeripherals.isEmpty()) continue;
            availablePeripherals.addAll(availableModePeripherals);
        }
        return availablePeripherals;
    }

    @Override
    protected List<String> getAvailablePeripherals(IFunctionalGroup funcGroup, Mode mode) {
        List<String> usablePeripherals = this.getUsablePeripherals(funcGroup, mode);
        ArrayList<String> availablePeripherals = new ArrayList<String>();
        for (String peripheral : usablePeripherals) {
            if (!funcGroup.isPeripheralUsed(peripheral)) {
                availablePeripherals.add(peripheral);
                continue;
            }
            MasterPeripheral masterPeripheral = mode.getMasterPeripheral();
            if (masterPeripheral == null || masterPeripheral.isExclusive()) continue;
            boolean isExclusive = false;
            for (IComponentInstanceConfig component : this.getComponentInstanceConfigs(peripheral)) {
                if (!component.isPeripheralUsedExlusively(peripheral)) continue;
                isExclusive = true;
            }
            if (isExclusive) continue;
            availablePeripherals.add(peripheral);
        }
        return availablePeripherals;
    }

    @Override
    public Collection<String> getUsablePeripherals(IFunctionalGroup funcGroup, IConfigurationComponent configurationComponent) {
        LinkedHashSet<String> peripherals = new LinkedHashSet<String>();
        for (Mode mode : configurationComponent.getScenarios()) {
            List<String> usablePeripherals = this.getUsablePeripherals(funcGroup, mode);
            peripherals.addAll(usablePeripherals);
        }
        return peripherals;
    }

    private List<String> getUsablePeripherals(IFunctionalGroup funcGroup, Mode mode) {
        ArrayList<String> usablePeripherals = new ArrayList<String>();
        ArrayList peripheralInstances = new ArrayList();
        MasterPeripheral masterPeripheral = mode.getMasterPeripheral();
        if (masterPeripheral != null) {
            List peripheralTypes = masterPeripheral.getPeripherals();
            for (String type : peripheralTypes) {
                peripheralInstances.addAll(funcGroup.getAvailablePeripherals(type));
            }
        }
        DummyComponentInstanceConfig dummyInstance = new DummyComponentInstanceConfig(funcGroup, null, funcGroup.getChildContext(), (ICommonMcu)this.mcu);
        for (String peripheralInstance : peripheralInstances) {
            dummyInstance.setPeripheral(peripheralInstance);
            if (!mode.isAvailable(dummyInstance.getExpressionContext())) continue;
            usablePeripherals.add(peripheralInstance);
        }
        return usablePeripherals;
    }

    public boolean isInstancesLimitReached(String group) {
        IFunctionalGroup funcGroup = this.profile.getFunctionalGroup(group);
        return funcGroup != null && funcGroup.getInstances().size() >= 100;
    }

    public boolean isInstancesLimitReached() {
        return this.isInstancesLimitReached(this.functionalGroup.getName());
    }

    public String createInstanceName(String componentType, IFunctionalGroup group) {
        if (this.shouldGenerateSuffix(componentType)) {
            return UtilsText.createUniqueName((String)componentType, this.getUsedNamesInGroupsWithSamePrefix(group.getIdPrefix()), (boolean)true, (boolean)false);
        }
        return UtilsText.createUniqueName((String)componentType, this.getUsedNamesInGroupsWithSamePrefix(group.getIdPrefix()), (boolean)true, (boolean)KEPreferences.isGenerateFullInstanceIdentification());
    }

    @Override
    public Collection<String> getUsedNamesInGroupsWithSamePrefix(String prefix) {
        HashSet<String> usedNames = new HashSet<String>();
        List groupsWithPrefix = this.getProfile().getFunctionalGroupsWithPrefix(prefix);
        groupsWithPrefix.forEach(g -> {
            boolean bl = usedNames.addAll(g.getInstances().keySet());
        });
        return usedNames;
    }

    public boolean removeComponents(Collection<String> components, Object caller) {
        boolean wasRemoved = false;
        for (String component : components) {
            wasRemoved |= this.profile.removeComponent(component);
            for (IFunctionalGroup group : this.profile.getFunctionalGroups()) {
                wasRemoved |= group.removeAllInstances(component);
            }
        }
        if (wasRemoved) {
            this.handleSettingChange(1, caller, UtilsText.safeString((String)Messages.get().Controller_Action_RemoveComponent));
            if (SWToolsPlatform.isRunningInEclipseIde()) {
                StringBuilder removedComponents = new StringBuilder();
                for (String component : components) {
                    ConfigurationComponentTypeId confCopmpTypeId = this.mcu.getAvailableComponents().getConfigCompTypeIdByType(component);
                    if (confCopmpTypeId == null) continue;
                    confCopmpTypeId.getConfigurationComponent().getComponents().forEach(x -> removedComponents.append(x.getName()).append(";"));
                }
                this.fireListeners(new ToolEvent.Builder(16).setOriginator((Object)removedComponents).build());
            }
        }
        return wasRemoved;
    }

    public boolean removeComponentInstances(CollectionMap<String, String> instances, Object caller) {
        Supplier<Boolean> removeInstancesFunction = () -> {
            boolean anyRemoved = false;
            for (Map.Entry entry : instances.entrySet()) {
                String component = (String)entry.getKey();
                IComponentConfig componentConfig = this.getConfiguredComponent(component);
                if (componentConfig == null) continue;
                Collection instancesCollection = (Collection)entry.getValue();
                anyRemoved |= this.removeComponentInstances(instancesCollection, false, caller);
            }
            if (anyRemoved) {
                this.handleSettingChange(1, caller, UtilsText.safeString((String)Messages.get().Controller_Action_RemoveComponentInstance));
            }
            return anyRemoved;
        };
        Boolean result = (Boolean)CollectionsUtils.nullableOptionalGet((Optional)this.runTransaction(removeInstancesFunction));
        if (result != null) {
            return result;
        }
        return false;
    }

    public boolean removeComponentInstances(IFunctionalGroup group, Collection<String> instances, boolean update, Object caller) {
        boolean anyRemoved = false;
        boolean assignsChanged = false;
        for (String instance : instances) {
            IComponentInstanceConfig componentInstance = group.getInstance(instance);
            if (componentInstance != null) {
                for (AssignConfig assignConfig : Controller.getAssignsInComponentInstances(Arrays.asList(componentInstance))) {
                    for (RegisterConfig register : assignConfig.getRegisters()) {
                        RegistersModelSingleton.getInstance().unregisterAssign(group, register, assignConfig);
                        assignsChanged = true;
                    }
                }
            }
            if (!(anyRemoved |= group.removeInstance(UtilsText.safeString((String)instance)))) continue;
            this.profile.synchronizeFunctionalGroups(this.functionalGroup, instance, null, ComponentOperationTypeEnum.REMOVE);
        }
        if (assignsChanged) {
            RegistersModelSingleton.getInstance().refreshRegistersFromAssigns(group);
        }
        if (anyRemoved && update) {
            this.handleSettingChange(1, caller, UtilsText.safeString((String)Messages.get().Controller_Action_RemoveComponentInstance));
        }
        return anyRemoved;
    }

    public boolean removeComponentInstances(Collection<String> instances, boolean update, Object caller) {
        return this.removeComponentInstances(this.functionalGroup, instances, update, caller);
    }

    @Override
    public void reloadFromSharedConfig() {
        ISharedConfiguration sharedConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
        this.reloadFromSharedConfig(sharedConfig, ConfigChangeReason.RELOAD);
    }

    public void refresh() {
        SdkFeaturesProvider.flushCache();
        this.mcu = new EmptyMcu("Clearing cache");
        this.reloadFromSharedConfig();
    }

    public void softRefresh() {
        this.handleSettingChange(1, (Object)this, null, false, true);
        if (this.otherToolChanged) {
            RegistersModelSingleton.getInstance().refreshRegistersFromAssigns(this.getFunctionalGroup());
        }
    }

    public String createUniqueFuncGroupName(String namePrefix) {
        return UtilsText.createUniqueName((String)namePrefix, this.profile.getFunctionalGroups().stream().map(x -> x.getName()), (boolean)false);
    }

    public boolean hasGlobalConfigSet(String componentType) {
        IConfigSetConfig globalConfigSet;
        IComponentConfig componentConfig = this.getConfiguredComponent(componentType);
        return componentConfig != null && (globalConfigSet = componentConfig.getGlobalConfigSet()) != null;
    }

    public void setCalledFromDefaultInit(IFunctionalGroup group, boolean called, Object caller) {
        this.setCalledFromDefaultInit(group, called, true, caller);
    }

    public void setCalledFromDefaultInit(IFunctionalGroup group, boolean called, boolean handleChanges, Object caller) {
        if (!this.profile.getFunctionalGroups().contains(group)) {
            throw new IllegalStateException("Functional group must be from the active profile");
        }
        if (this.isMcuSupported()) {
            if (called) {
                this.profile.getFunctionalGroups().forEach(x -> x.setCalledFromDefaultInit(false));
                group.setCalledFromDefaultInit(true);
            } else {
                group.setCalledFromDefaultInit(false);
            }
            if (handleChanges) {
                this.handleSettingChange(1, caller, UtilsText.safeString((String)Messages.get().Controller_Action_SetCalledFromDefaultInit));
            }
        }
    }

    void updateValidationParams() {
        LinkedHashSet<Object> allProblems = new LinkedHashSet<Object>();
        if (this.isOn) {
            PeripheralsGenericProblem unsupportedMcuProblem = this.getUnsupportedMcuProblem();
            if (unsupportedMcuProblem != null) {
                if (!unsupportedMcuProblem.getMessage().equals(Messages.get().Controller_McuNotSelectedMessage)) {
                    allProblems.add((Object)unsupportedMcuProblem);
                }
            } else {
                allProblems.addAll(this.collectLocalProblems());
                allProblems.addAll(this.collectExternalProblems());
                allProblems.addAll(this.collectGlobalProblems());
                allProblems.addAll(this.collectScriptProblems());
            }
        }
        ValidationEngineFactory.addAndRemoveProblems((String)"Peripherals", null, allProblems);
    }

    private Collection<IGenericProblem> collectExternalProblems() {
        return (Collection)this.externalProblemsList.values().stream().flatMap(x -> x.stream()).collect(CollectorsUtils.toList());
    }

    public void addExternalProblems(String id, Collection<IGenericProblem> collection) {
        Collection set = this.externalProblemsList.computeIfAbsent(id, k -> new HashSet());
        assert (set != null);
        set.addAll(collection);
    }

    public void removeExternalProblems(String id, Collection<IGenericProblem> problems) {
        Collection collection = this.externalProblemsList.computeIfAbsent(id, k -> new HashSet());
        assert (collection != null);
        collection.removeAll(problems);
    }

    public void clearExternalProblems(String id) {
        Collection<IGenericProblem> collection = this.externalProblemsList.get(id);
        if (collection != null) {
            collection.clear();
        }
    }

    public void refreshProblems() {
        this.updateValidationParams();
    }

    private Collection<GenericProblem> collectGlobalProblems() {
        ValidationParams globalParams = new ValidationParams(this.profile.getConfiguredComponents().values(), Controller.makeDependencySourceName(null));
        StoragePeriphsTool periphs = SharedConfigurationFactory.getSharedConfigurationSingleton().getTools().getPeripherals();
        if (periphs != null) {
            List<IDependency> globalDeps = periphs.getGlobalDependencies();
            if (globalDeps == null) {
                globalDeps = new ArrayList<IDependency>();
            }
            globalDeps = Controller.removeToolDependencies((Collection<IDependency>)globalDeps);
            globalDeps.addAll(globalParams.getDependencies());
            ArrayList<StorageDependency> componentDeps = new ArrayList<StorageDependency>();
            for (IComponentConfig config : this.profile.getConfiguredComponents().values()) {
                if (!config.getComponent().isGlobalOnly() && !this.hasAtLeastOneInstanceEnabled(config)) continue;
                for (SWComponent component : config.getComponent().getComponents()) {
                    if (!component.getRequired()) continue;
                    String configName = null;
                    StorageDependencyFeature fEnabled = new StorageDependencyFeature();
                    fEnabled.setName("enabled");
                    fEnabled.setEvaluation("equal");
                    fEnabled.setConfiguration(configName);
                    fEnabled.addData(Boolean.TRUE.toString(), "Boolean", null, null, null);
                    componentDeps.add(Controller.createSwComponentDependency(component, fEnabled, 2, MessageFormat.format(UtilsText.safeString((String)Messages.get().Controller_ProblemComponentMissing), this.getSdkComponentName(component)), configName, config));
                    Version version = component.getVersion();
                    if (version == null) continue;
                    StorageDependencyFeature fVersion = new StorageDependencyFeature();
                    fVersion.setName("version");
                    String matchType = "equivalent";
                    SWComponent.Match match = component.getMatch();
                    if (match != null) {
                        switch (match) {
                            case PERFECT: {
                                matchType = "perfect";
                                break;
                            }
                            case COMPATIBLE: {
                                matchType = "compatible";
                                break;
                            }
                            case GREATER_OR_EQUAL: {
                                matchType = "greaterOrEqual";
                                break;
                            }
                            default: {
                                matchType = "equivalent";
                            }
                        }
                    }
                    fVersion.setEvaluation(matchType);
                    fVersion.setConfiguration(configName);
                    fVersion.addData(component.getVersionStr(), "Version", null, null, null);
                    componentDeps.add(Controller.createSwComponentDependency(component, fVersion, 1, MessageFormat.format(UtilsText.safeString((String)Messages.get().Controller_ProblemComponentVersionMismatch), this.getSdkComponentName(component)), configName, config));
                }
            }
            globalDeps.addAll(componentDeps);
            globalDeps.addAll(this.collectDependenciesOnOtherToolsProblems());
            if (globalDeps.isEmpty()) {
                globalDeps = null;
            }
            periphs.setGlobalDependencies(globalDeps);
        }
        return globalParams.getProblems();
    }

    private boolean hasAtLeastOneInstanceEnabled(IComponentConfig config) {
        return !this.getAllEnabledComponentInstances(config.getComponentTypeId()).isEmpty();
    }

    private static StorageDependency createSwComponentDependency(SWComponent driver, StorageDependencyFeature feature, int problemLevel, String description, @Nullable String configName, IComponentConfig component) {
        StorageDependency dep = new StorageDependency();
        dep.setDependencyCreator(DependencyCreator.TOOL);
        dep.setDescription(description);
        ArrayList<StorageDependencyFeature> depFeatures = new ArrayList<StorageDependencyFeature>();
        dep.setFeatures(depFeatures);
        depFeatures.add(feature);
        dep.setProblemLevel(problemLevel);
        dep.setResourceId(driver.getName());
        dep.setResourceType("SWComponent");
        dep.setSource(Controller.makeDependencySourceName(configName));
        dep.setOriginatorId(component.makeOriginatorId(component.getChildContext()));
        return dep;
    }

    private Collection<GenericProblem> collectLocalProblems() {
        ArrayList<GenericProblem> localProbs = new ArrayList<GenericProblem>();
        boolean calledFromDefaultInit = false;
        if (this.profile.getFunctionalGroups().size() > this.getMaximumNumberOfFunctionalGroups()) {
            localProbs.add(new GenericProblem("Peripherals", 2, MessageFormat.format(Messages.get().Controller_ProblemMultipleFunctionalGroups, this.profile.getFunctionalGroups().size(), this.getMaximumNumberOfFunctionalGroups()), "Peripherals", com.nxp.swtools.utils.Messages.get().FunctionsToolbarContribution_FunctionsLabel, MessageFormat.format(Messages.get().Controller_ProblemMultipleFunctionalGroupsTooltip, this.getMaximumNumberOfFunctionalGroups())));
        }
        for (IFunctionalGroup group : this.profile.getFunctionalGroups()) {
            calledFromDefaultInit |= group.isCalledFromDefaultInit();
            ValidationParams params = new ValidationParams((IChildProvidable)group, Controller.makeDependencySourceName(group.getId()));
            StoragePeriphsFuncGroup funcGroup = group.getStorageFuncGroup();
            List<IDependency> localDeps = funcGroup.getDependencies();
            localDeps = Controller.removeToolDependencies((Collection<IDependency>)localDeps);
            localDeps.addAll(params.getDependencies());
            funcGroup.setDependencies(localDeps);
            localProbs.addAll(params.getProblems());
            IToolchainProjectWithSdk toolchainProject = SharedConfigurationFactory.getSharedConfigurationSingleton().getToolchainProject();
            if (toolchainProject == null || !toolchainProject.wasProjectDetected()) continue;
            for (IComponentInstanceConfig instance : group.getInstances().values()) {
                for (SWComponent swCompRef : instance.getComponent().getComponents()) {
                    BigInteger matchScore;
                    String toolchainRevision;
                    String sdkComponentName = swCompRef.getName();
                    ISdkComponentInProject toolchainSdkComponent = toolchainProject.getSdkComponent(sdkComponentName);
                    if (toolchainSdkComponent == null || (toolchainRevision = toolchainSdkComponent.getRevision()) == null || (matchScore = Components.computeMatchScore((ComputeScoreWrapper)ComputeScoreWrapper.from((SWComponent)swCompRef), (ComputeScoreWrapper)ComputeScoreWrapper.from((ISdkComponentInProject)toolchainSdkComponent), (String)swCompRef.getMatchString(), (Version)swCompRef.getUntilVersion())) != null) continue;
                    localProbs.add(new PeripheralsProblem((IChild)instance, Messages.get().Controller_ProblemComponentRevisionMismatch, com.nxp.swtools.resourcetables.model.data.Level.ERROR));
                }
            }
        }
        if (!calledFromDefaultInit) {
            localProbs.add(new PeripheralsGenericProblem("Peripherals", PeripheralsGenericProblem.Type.NO_DEFAULT_INIT_GROUP, UtilsText.safeString((String)Messages.get().Controller_NoDefaultInitializationGroup)));
        }
        return localProbs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<GenericProblem> collectScriptProblems() {
        ArrayList<GenericProblem> scriptProblems = new ArrayList<GenericProblem>();
        ScriptResult generationResult = null;
        CodeManager codeManager = this.codeManager;
        synchronized (codeManager) {
            if (this.codeManager.isGeneratingCode()) {
                return scriptProblems;
            }
            generationResult = this.codeManager.getGeneratedCode();
        }
        String resource = "Sources";
        boolean isCodePreviewEnabled = SharedConfigurationFactory.getSharedConfigurationSingleton().getPreferences().isCodePreviewEnabled();
        if (generationResult != null && isCodePreviewEnabled && generationResult.isFailedDueTimeout()) {
            String errorMessage = UtilsText.safeString((String)Messages.get().Controller_SourcesGeneration_GenerationFailedDueTimeout);
            scriptProblems.add(new GenericProblem("Peripherals", 2, errorMessage, Controller.makeDependencySourceName(null), resource, errorMessage));
        } else if (generationResult == null && isCodePreviewEnabled || generationResult != null && generationResult.isFailed()) {
            String errorMessage = UtilsText.safeString((String)Messages.get().Controller_SourcesGeneration_CannotGenerateDueToInternalError);
            scriptProblems.add(new GenericProblem("Peripherals", 2, errorMessage, Controller.makeDependencySourceName(null), resource, errorMessage));
        } else {
            int n;
            int n2;
            String[] stringArray;
            if (generationResult != null && !UtilsText.isEmpty((String)generationResult.getErrors())) {
                String[] errors;
                stringArray = errors = generationResult.getErrors().split("\n");
                n2 = errors.length;
                n = 0;
                while (n < n2) {
                    String error = stringArray[n];
                    if (error != null && !error.isEmpty()) {
                        scriptProblems.add(new GenericProblem("Peripherals", 2, error, Controller.makeDependencySourceName(null), resource, error));
                    }
                    ++n;
                }
            }
            if (generationResult != null && !UtilsText.isEmpty((String)generationResult.getWarnings())) {
                String[] warnings;
                stringArray = warnings = generationResult.getWarnings().split("\n");
                n2 = warnings.length;
                n = 0;
                while (n < n2) {
                    String warning = stringArray[n];
                    if (warning != null && !warning.isEmpty()) {
                        scriptProblems.add(new GenericProblem("Peripherals", 1, warning, Controller.makeDependencySourceName(null), resource, warning));
                    }
                    ++n;
                }
            }
        }
        return scriptProblems;
    }

    private Collection<StorageDependency> collectDependenciesOnOtherToolsProblems() {
        if (!Platform.isRunning()) {
            return Collections.emptyList();
        }
        ArrayList<StorageDependency> dependenciesProblems = new ArrayList<StorageDependency>();
        for (String tool : this.getProfile().getOtherRequiredTools()) {
            String error = MessageFormat.format(Messages.get().Controller_RequiredToolDisabled, tool);
            StorageDependency storageDependency = new StorageDependency();
            storageDependency.setDependencyCreator(DependencyCreator.TOOL);
            storageDependency.setDescription(error);
            storageDependency.setResourceType("Tool");
            storageDependency.setResourceId(tool);
            storageDependency.setSource("Peripherals");
            storageDependency.setProblemLevel(2);
            StorageDependencyFeature feature = new StorageDependencyFeature();
            feature.setName("enabled");
            feature.setData(Arrays.asList(DependencyFactory.createFeatureData((String)"true", null)));
            feature.setEvaluation("equal");
            storageDependency.setFeatures(Arrays.asList(feature));
            dependenciesProblems.add(storageDependency);
        }
        return dependenciesProblems;
    }

    private String getSdkComponentName(SWComponent swComp) {
        return this.mcu.getAvailableComponents().getSdkComponentName(swComp.getName());
    }

    private static List<IDependency> removeToolDependencies(Collection<IDependency> dependencies) {
        return (List)dependencies.stream().filter(d -> DependencyCreator.UNKNOWN != d.getDependencyCreator() && (!d.getSource().startsWith("Peripherals") || d.getSource().startsWith("Peripherals") && DependencyCreator.TOOL != d.getDependencyCreator())).collect(CollectorsUtils.toList());
    }

    public static String makeDependencySourceName(@Nullable String configName) {
        if (UtilsText.isEmpty((String)configName)) {
            return "Peripherals";
        }
        return "Peripherals:" + configName;
    }

    @Override
    public boolean isMcuSupported(ICommonConfig mcuId) {
        return ProcessorFilterForPeripherals.isSupported((ICommonConfig)mcuId);
    }

    public @Nullable String getUnsupportedMcuError() {
        PeripheralsGenericProblem problem = this.getUnsupportedMcuProblem();
        return problem == null ? null : problem.getMessage();
    }

    public @Nullable String getToolError() {
        if (this.isOn) {
            return this.getUnsupportedMcuError();
        }
        return null;
    }

    public List<IComponentInstanceConfig> getAllComponentInstances(String componentType) {
        return (List)this.getAllInstances().stream().filter(ci -> ci.getComponent().getId().equals(componentType)).collect(CollectorsUtils.toList());
    }

    public List<IComponentInstanceConfig> getAllInstances() {
        return this.profile.getAllInstances();
    }

    public List<IComponentInstanceConfig> getAllEnabledComponentInstances(String componentTypeId) {
        return (List)this.profile.getAllInstances().stream().filter(ci -> ci.getComponentTypeId().equals(componentTypeId) && ci.isEnabled()).collect(CollectorsUtils.toList());
    }

    public boolean isTurnedOn() {
        return this.isOn;
    }

    private @Nullable PeripheralsGenericProblem getUnsupportedMcuProblem() {
        if (!Controller.isMcuSupported(this.mcu) && this.isOn) {
            String toolId = "Peripherals";
            return new PeripheralsGenericProblem(toolId, PeripheralsGenericProblem.Type.MCU_UNSUPPORTED, ((EmptyMcu)this.mcu).getReason());
        }
        return null;
    }

    public void resetToProcessorDefault(IFunctionalGroup functionalGroupLoc) {
        if (SWToolsPlatform.isRunningInEclipseIde()) {
            Map instances = functionalGroupLoc.getInstances();
            StringBuilder swComponents = new StringBuilder();
            for (IComponentInstanceConfig config : instances.values()) {
                config.getComponent().getComponents().forEach(x -> swComponents.append(x.getName()).append(";"));
            }
            if (swComponents.length() != 0) {
                this.fireListeners(new ToolEvent.Builder(16).setOriginator((Object)swComponents).build());
            }
        }
        this.runTransaction(() -> {
            List components = (List)functionalGroupLoc.getInstances().values().stream().map(i -> i.getComponent().getId()).distinct().collect(CollectorsUtils.toList());
            functionalGroupLoc.setConfiguredComponents(new HashMap());
            List componentsToRemove = (List)components.stream().filter(c -> this.getAllComponentInstances((String)c).isEmpty()).collect(CollectorsUtils.toList());
            if (!componentsToRemove.isEmpty()) {
                this.removeComponents(componentsToRemove, Controller.class);
            }
            this.handleSettingChange(1, (Object)this, UtilsText.safeString((String)Messages.get().Controller_Action_ResetToProcessorDefaults));
        });
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void resetToProcessorMexDefaults(IFunctionalGroup groupToReset) {
        File presetMex = this.getProcessorMex();
        if (presetMex != null && presetMex.exists()) {
            ISharedConfiguration configFromFile = ConfigurationUtils.loadConfigurationFromFile((File)presetMex);
            if (configFromFile != null) {
                StoragePeriphsTool tool = configFromFile.getTools().getPeripherals();
                if (tool != null) {
                    StoragePeriphsFuncGroup functionalGroupStorage;
                    StoragePeriphsFuncGroup storagePeriphsFuncGroup = functionalGroupStorage = tool.getFuncGroups().size() == 1 ? (StoragePeriphsFuncGroup)tool.getFuncGroups().get(0) : (StoragePeriphsFuncGroup)CollectionsUtils.nullableOptionalGet(tool.getFuncGroups().stream().filter(x -> x.getName().equals(groupToReset.getName())).findAny());
                    if (functionalGroupStorage != null) {
                        PeriphsProfile profileLoc = this.getProfile();
                        @Nullable List components = (List)functionalGroupStorage.getInstances().stream().map(i -> this.getMcu().getAvailableComponents().getConfigCompTypeId(i.getType_id())).collect(CollectorsUtils.toList());
                        for (ConfigurationComponentTypeId componentTypeId : components) {
                            IComponentConfig component;
                            if (componentTypeId == null || (component = this.createOrGetComponent(componentTypeId.getTypeId(), Controller.class)) != null) continue;
                            LOGGER.log(Level.SEVERE, "Component with typeId \"{0}\" cannot be created during reload functional group from default processor MEX", componentTypeId.getTypeId());
                        }
                        FunctionalGroup newFunctionalGroup = null;
                        if (profileLoc.isFunctionalGroupSynchronizationEnabled() && profileLoc.getFunctionalGroups().size() > 1) {
                            StoragePeriphsFuncGroup groupStorage = groupToReset.getStorageFuncGroup();
                            groupStorage.setInstances(functionalGroupStorage.getInstances());
                            newFunctionalGroup = new FunctionalGroup(profileLoc.getChildContext(), groupStorage, groupToReset.getMcu());
                        } else {
                            newFunctionalGroup = new FunctionalGroup(profileLoc.getChildContext(), functionalGroupStorage, groupToReset.getMcu());
                        }
                        profileLoc.removeFunctionalGroup(groupToReset);
                        profileLoc.addFunctionalGroup((IFunctionalGroup)newFunctionalGroup);
                        this.setFunctionalGroup((IFunctionalGroup)newFunctionalGroup, false, Controller.class);
                        this.handleSettingChange(1, (Object)this, UtilsText.safeString((String)Messages.get().Controller_Action_ResetToProcessorMexDefaults));
                    }
                } else {
                    LOGGER.log(Level.WARNING, "Cannot reset to processor default configuration. Configuration from file \"{0}\"  does not contain Peripherals tool.", presetMex.getAbsolutePath());
                }
            } else {
                LOGGER.log(Level.SEVERE, "Cannot reset to processor default configuration. Could not load configuration from file \"{0}\".", presetMex.getAbsolutePath());
            }
        }
    }

    public void resetToStorageFuncGroup(List<StoragePeriphsFuncGroup> functions, String selectedConfiguration, StoragePeriphsFuncGroup changedFuncGroup) {
        StoragePeriphsFuncGroup boardFuncGroup = null;
        for (StoragePeriphsFuncGroup storageFuncGroup : functions) {
            if (!Objects.equals(storageFuncGroup.getConfigurationName(), selectedConfiguration)) continue;
            boardFuncGroup = storageFuncGroup;
            break;
        }
        if (boardFuncGroup != null) {
            changedFuncGroup.fillWithValues(boardFuncGroup);
            int initCounter = 0;
            for (StoragePeriphsFuncGroup storageFuncGroup : this.profile.getStoragePeripheralsTool().getFuncGroups()) {
                if (!storageFuncGroup.isCalledFromInit()) continue;
                ++initCounter;
            }
            if (initCounter > 1) {
                changedFuncGroup.setCalledFromInit(false);
            }
            this.reloadFromSharedConfig();
        }
    }

    @Override
    public boolean hasModeWithMasterPeripheralNotDefined(IConfigurationComponent configurationComponent, String funcGroupName) {
        IFunctionalGroup funcGroup = this.profile.getFunctionalGroup(funcGroupName);
        if (funcGroup != null) {
            return CollectionsUtils.containsNullValue(this.getAvailableModes(configurationComponent, funcGroup, null).stream().map(m -> m.getMasterPeripheral()));
        }
        return false;
    }

    public void setSourceCodeRefreshManager(@Nullable PeripheralsSourceCodeRefreshHandler managerHandler) {
        this.codeRefreshManagerHandler = managerHandler;
    }

    public void removeSourceCodeRefreshManager() {
        this.codeRefreshManagerHandler = null;
    }

    public void setRegistersRefreshManager(@Nullable RegistersContentProvider managerHandler) {
        this.registerRefreshManagerHandler = managerHandler;
    }

    public void removeRegistersRefreshManager() {
        this.registerRefreshManagerHandler = null;
    }

    @Override
    public boolean canCopy(ISettingConfig setting) {
        return true;
    }

    public void createComponentInstance(Map<String, @Nullable String> selectedPeripheralsPerComponents) {
        for (Map.Entry<String, String> componentPeripheral : selectedPeripheralsPerComponents.entrySet()) {
            String compTypeId = componentPeripheral.getKey().split(":")[0];
            ConfigurationComponentTypeId configCompType = this.mcu.getAvailableComponents().getConfigCompTypeId(compTypeId);
            if (configCompType != null) {
                IConfigurationComponent configComp = configCompType.getConfigurationComponent();
                if (configComp.isGlobalOnly()) {
                    LOGGER.severe(() -> MessageFormat.format("[TOOL] Component with type ID \"{0}\" does not exist or is global only and cannot be instantiated", configCompType.getTypeId()));
                    continue;
                }
                if (!this.canCreateInstances(configComp, this.functionalGroup.getName())) continue;
                Collection instances = this.functionalGroup.getInstancesOfType(configComp.getId());
                if (!instances.isEmpty()) {
                    LOGGER.info("[TOOL] The component has instance for the current functional group!");
                    continue;
                }
                String peripheralToUse = componentPeripheral.getValue();
                Mode modeToSelect = this.getComponentMode(configComp, this.functionalGroup, peripheralToUse);
                if (modeToSelect == null) {
                    LOGGER.severe("[DATA] The component has no available mode for the current MCU!");
                    continue;
                }
                if (peripheralToUse == null && modeToSelect.getMasterPeripheral() != null) {
                    LOGGER.severe("[DATA] There is no peripheral that can be used to create component instance!");
                    continue;
                }
                IComponentConfig component = this.createOrGetComponent(configCompType.getTypeId(), (Object)this);
                if (component == null) {
                    LOGGER.info("[TOOL] The component of given type does not exist.");
                    continue;
                }
                String name = this.createInstanceName(Controller.getAutomaticName(component, peripheralToUse), this.functionalGroup);
                ComponentInstanceConfig componentSetting = new ComponentInstanceConfig(component.getComponent(), this.functionalGroup, name, modeToSelect, peripheralToUse, component.getChildContext(), (ICommonMcu)this.mcu);
                componentSetting.setUUID(UUID.randomUUID().toString());
                componentSetting.synchronizeValue(null);
                continue;
            }
            LOGGER.severe(() -> MessageFormat.format("[TOOL] Component with type ID \"{0}\" does not exist and cannot be instantiated", compTypeId));
        }
        this.handleSettingChange(1, Controller.class, UtilsText.safeString((String)Messages.get().Controller_Action_CreateComponentInstance));
    }

    public Map<String, @Nullable List<String>> getPeripheralsForComponents(List<String> addIds) {
        LinkedHashMap<String, @Nullable List<String>> peripherals = new LinkedHashMap<String, List<String>>();
        Map<String, String> componentsBySwComp = this.getComponentsBySwComponents(addIds);
        for (Map.Entry<String, String> compId : componentsBySwComp.entrySet()) {
            HashSet<String> peripheralsForComponent = new HashSet<String>();
            ConfigurationComponentTypeId configCompType = this.mcu.getAvailableComponents().getConfigCompTypeIdByType(compId.getKey());
            if (configCompType != null) {
                IConfigurationComponent component = configCompType.getConfigurationComponent();
                if (component.isGlobalOnly()) {
                    LOGGER.severe(() -> MessageFormat.format("[TOOL] Component with type ID \"{0}\" is global only and cannot be instantiated", configCompType.getTypeId()));
                    continue;
                }
                if (!this.canCreateInstances(component, this.functionalGroup.getName())) continue;
                Collection instances = this.functionalGroup.getInstancesOfType(component.getId());
                if (!instances.isEmpty()) {
                    LOGGER.info("[TOOL] The component has instance for the current functional group!");
                    continue;
                }
                String peripheralsKey = String.valueOf(configCompType.getTypeId()) + ":" + compId.getValue();
                for (Mode mode : component.getScenarios()) {
                    Mode modeToSelect = mode;
                    MasterPeripheral compMasterPeriph = modeToSelect.getMasterPeripheral();
                    if (compMasterPeriph != null) {
                        List<String> availablePeripherals = this.getAvailablePeripherals(this.functionalGroup, modeToSelect);
                        List<String> usablePeripherals = this.getUsablePeripherals(this.functionalGroup, modeToSelect);
                        if (!compMasterPeriph.isExclusive()) {
                            peripheralsForComponent.addAll(usablePeripherals);
                            peripherals.put(peripheralsKey, usablePeripherals);
                            continue;
                        }
                        peripheralsForComponent.addAll(availablePeripherals);
                        if (availablePeripherals.isEmpty()) continue;
                        peripherals.put(peripheralsKey, availablePeripherals);
                        continue;
                    }
                    peripherals.put(peripheralsKey, null);
                }
                if (peripheralsForComponent.isEmpty()) {
                    peripherals.put(peripheralsKey, null);
                    LOGGER.severe("[DATA] The component has no available mode for the current MCU!");
                    continue;
                }
                peripherals.put(peripheralsKey, new ArrayList(peripheralsForComponent));
                continue;
            }
            LOGGER.severe(() -> MessageFormat.format("[TOOL] Component with type ID \"{0}\" does not exist and cannot be instantiated", compId));
        }
        return peripherals;
    }

    public Map<String, String> getComponentsBySwComponents(List<String> addIds) {
        LinkedHashMap<String, String> componentsBySwComp = new LinkedHashMap<String, String>();
        Collection components = this.mcu.getAvailableComponents().getConfigComps();
        for (String id : addIds) {
            for (IConfigurationComponent component : components) {
                for (SWComponent swComponent : component.getComponents()) {
                    if (!swComponent.getName().equals(id)) continue;
                    componentsBySwComp.put(component.getId(), id);
                }
            }
        }
        return componentsBySwComp;
    }

    public List<IConfigurationComponent> getComponentsByConfigSet(String configSetId) {
        ArrayList<IConfigurationComponent> componentsByConfigSet = new ArrayList<IConfigurationComponent>();
        Collection components = this.mcu.getAvailableComponents().getConfigComps();
        for (IConfigurationComponent component : components) {
            if (component.getConfigSet(configSetId) == null) continue;
            componentsByConfigSet.add(component);
        }
        return componentsByConfigSet;
    }

    public void removeComponentsSwCompInstances(Collection<String> instances) {
        Map<String, String> componentsBySwComp = this.getComponentsBySwComponents(new ArrayList<String>(instances));
        boolean wasRemoved = false;
        for (Map.Entry<String, String> component : componentsBySwComp.entrySet()) {
            wasRemoved |= this.profile.removeComponent(component.getKey());
            for (IFunctionalGroup group : this.profile.getFunctionalGroups()) {
                wasRemoved |= group.removeAllInstances(component.getKey());
            }
        }
        if (wasRemoved) {
            this.handleSettingChange(1, (Object)this, UtilsText.safeString((String)Messages.get().Controller_Action_RemoveComponent));
        }
    }

    private @Nullable Mode getComponentMode(IConfigurationComponent configComp, IFunctionalGroup funcGroup, @Nullable String peripheral) {
        List<Mode> availableModes = this.getAvailableModes(configComp, funcGroup, peripheral);
        Mode firstUsableMode = this.getFirstUsableMode(funcGroup, availableModes, peripheral);
        Mode modeToSelect = availableModes.isEmpty() ? null : (firstUsableMode != null ? firstUsableMode : availableModes.get(0));
        return modeToSelect;
    }

    @Override
    protected void resolveAssigns(@NonNull IChild config) {
        List assigns = Collections.emptyList();
        if (config instanceof ISettingConfig) {
            assigns = ((ISettingConfig)config).getAssignConfigs();
        }
        if (config instanceof SetConfig.SetPresence) {
            assigns = ((SetConfig.SetPresence)config).getAssignConfigs();
        }
        for (AssignConfig assign : assigns) {
            if (!assign.isEnabled()) continue;
            this.resolveAssignToRegisters(assign);
        }
        if (config.isOptionSet("REGISTERS_REFRESH")) {
            RegistersModelSingleton.getInstance().refreshRegistersFromAssigns(this.getFunctionalGroup());
        }
    }

    public void resolveAssignToRegisters(AssignConfig assign) {
        RegistersModelSingleton registersMapConfig = RegistersModelSingleton.getInstance();
        for (RegisterConfig register : assign.getRegisters()) {
            registersMapConfig.setValueOfBitfield(this.functionalGroup, register, assign.getParent(), null, assign, true);
        }
    }

    private List<ArrayConfig> getAllArrayConfigsInProfile(IRoot profile) {
        ArrayList<ArrayConfig> arrays = new ArrayList<ArrayConfig>();
        for (Map.Entry entry : profile.getGlobalConfigSets().entrySet()) {
            arrays.addAll(this.getAllArrayConfigs((IChildProvidable)entry.getValue()));
        }
        arrays.addAll((Collection)profile.getAllInstances().stream().map(x -> this.getAllArrayConfigs((IChildProvidable)x)).flatMap(Collection::stream).collect(CollectorsUtils.toList()));
        return arrays;
    }

    private List<ArrayConfig> getAllArrayConfigs(IChildProvidable providable) {
        ArrayList<ArrayConfig> result = new ArrayList<ArrayConfig>();
        List children = providable.getChildren();
        for (IChild child : children) {
            if ("array".equals(child.getTypeName())) {
                result.add((ArrayConfig)child);
            }
            if (!(child instanceof IChildProvidable)) continue;
            result.addAll(this.getAllArrayConfigs((IChildProvidable)child));
        }
        return result;
    }

    private List<ScalarConfig> getAllVariableConfigsInProfile(IRoot profile) {
        return (List)profile.getAllInstances().stream().map(x -> this.getAllVariableConfigs((IChildProvidable)x)).flatMap(Collection::stream).collect(CollectorsUtils.toList());
    }

    private List<ScalarConfig> getAllVariableConfigs(IChildProvidable providable) {
        ArrayList<ScalarConfig> result = new ArrayList<ScalarConfig>();
        List children = providable.getChildren();
        for (IChild child : children) {
            if ("variable".equals(child.getTypeName())) {
                result.add((ScalarConfig)child);
            }
            if (!(child instanceof IChildProvidable)) continue;
            result.addAll(this.getAllVariableConfigs((IChildProvidable)child));
        }
        return result;
    }

    @Override
    public int getSettingsChangedEvent() {
        return 2;
    }

    private static List<AssignConfig> getAssignsInComponentInstances(List<IComponentInstanceConfig> instances) {
        List collect = (List)instances.stream().flatMap(instance -> instance.getAllAssigns().stream()).collect(CollectorsUtils.toList());
        return collect;
    }

    public @Nullable PeripheralsSourceCodeRefreshHandler getCodeRefreshManagerHandler() {
        return this.codeRefreshManagerHandler;
    }

    public @Nullable RegistersContentProvider getRegistersRefreshManagerHandler() {
        return this.registerRefreshManagerHandler;
    }

    public void refreshRegistersView() {
        RegistersContentProvider registerRefreshManagerHandlerLoc = this.registerRefreshManagerHandler;
        if (registerRefreshManagerHandlerLoc != null) {
            registerRefreshManagerHandlerLoc.refresh();
        }
    }

    @Override
    protected void setPeripheralSpecificImplementation(IComponentInstanceConfig component, String peripheral) {
        RegistersModelSingleton.getInstance().unregisterAllAssigns(this.getFunctionalGroup(), component);
        super.setPeripheralSpecificImplementation(component, peripheral);
        RegistersModelSingleton.getInstance().registerAllAssigns(this.getFunctionalGroup(), component);
        RegistersModelSingleton.getInstance().refreshRegistersFromAssigns(this.getFunctionalGroup());
    }

    @Override
    public void setComponentInstancesEnabledSpecificImplementation(Collection<IComponentInstanceConfig> configs, boolean enabled) {
        for (IComponentInstanceConfig instance : configs) {
            if (!enabled) {
                RegistersModelSingleton.getInstance().unregisterAllAssigns(this.getFunctionalGroup(), instance);
                continue;
            }
            instance.clearCache();
            RegistersModelSingleton.getInstance().registerAllAssigns(this.getFunctionalGroup(), instance);
        }
        super.setComponentInstancesEnabledSpecificImplementation(configs, enabled);
        RegistersModelSingleton.getInstance().refreshRegistersFromAssigns(this.getFunctionalGroup());
    }

    @Override
    protected void applyQuickSelectionSpecificImplementation(IPresettable presettable, IQuickSelection quickSelection) {
        if (presettable instanceof IChildProvidable) {
            RegistersModelSingleton.getInstance().unregisterAllAssigns(this.getFunctionalGroup(), (IChildProvidable)presettable);
        }
        super.applyQuickSelectionSpecificImplementation(presettable, quickSelection);
        if (presettable instanceof IChildProvidable) {
            RegistersModelSingleton.getInstance().registerAllAssigns(this.getFunctionalGroup(), (IChildProvidable)presettable);
        }
        this.profile.clearCache();
        RegistersModelSingleton.getInstance().getAssignCreationLatch().waitOnSemaphore();
        RegistersModelSingleton.getInstance().refreshRegistersFromAssigns(this.getFunctionalGroup());
    }

    @Override
    protected @Nullable ISettingConfig addItemSpecificImplementation(ArrayConfig arrayConfig) {
        ISettingConfig addedItem = super.addItemSpecificImplementation(arrayConfig);
        if (addedItem != null) {
            RegistersModelSingleton.getInstance().getAssignCreationLatch().waitOnSemaphore();
            RegistersModelSingleton.getInstance().registerAllAssigns(this.getFunctionalGroup(), addedItem);
            if (addedItem instanceof IChildProvidable) {
                for (IChild child : ChildProviderHelper.getAllChildren((IChild)addedItem)) {
                    if (!child.isAvailable() || !child.isEnabled()) continue;
                    this.resolveAssigns(child);
                }
            }
            RegistersModelSingleton.getInstance().refreshRegistersFromAssigns(this.getFunctionalGroup());
        }
        return addedItem;
    }

    @Override
    protected boolean removeItemSpecificImplementation(ArrayConfig arrayConfig, ISettingConfig childConfig) {
        RegistersModelSingleton.getInstance().unregisterAllAssigns(this.getFunctionalGroup(), childConfig);
        RegistersModelSingleton.getInstance().refreshRegistersFromAssigns(this.getFunctionalGroup());
        return super.removeItemSpecificImplementation(arrayConfig, childConfig);
    }

    @Override
    public @Nullable Display getDisplay() {
        return this.display;
    }

    @Override
    public void markPeripheralAsUsed(String peripheral) {
        List componentTypeIdsByType = this.mcu.getAvailableComponents().getComponentTypeIdsByType("custom_init");
        if (componentTypeIdsByType == null) {
            return;
        }
        String typeId = ((ConfigurationComponentTypeId)componentTypeIdsByType.get(0)).getTypeId();
        this.createComponentInstance(typeId, peripheral, Controller.class);
    }

    @Override
    public boolean isPeripheralMarkedAsUsed(String peripheral) {
        boolean containsMarkingInstance = false;
        for (IComponentInstanceConfig instance : this.getFunctionalGroup().getInstancesByPeripheral(peripheral)) {
            if (!this.isInstanceTypeMarkPeripheralAsUsed(instance)) continue;
            containsMarkingInstance = true;
            break;
        }
        return containsMarkingInstance;
    }

    @Override
    public void unmarkPeripheralAsUsed(String peripheral) {
        if (!this.isPeripheralMarkedAsUsed(peripheral)) {
            return;
        }
        List componentInstance = this.getFunctionalGroup().getInstancesByPeripheral(peripheral);
        List markingInstances = (List)componentInstance.stream().filter(i -> this.isInstanceTypeMarkPeripheralAsUsed((IComponentInstanceConfig)i)).limit(1L).map(i -> i.getId()).collect(CollectorsUtils.toList());
        this.removeComponentInstances(markingInstances, true, Controller.class);
    }

    public void setReactToOtherToolChangesImmediately(boolean react) {
        this.reactToOtherToolChangesImmediately = react;
    }

    public List<SnippetNode> getSnippets() {
        ArrayList<SnippetNode> result = new ArrayList<SnippetNode>();
        for (IFunctionalGroup group : this.getProfile().getFunctionalGroups()) {
            Collection instances = group.getInstances().values();
            if (instances.isEmpty()) continue;
            String groupName = group.getName();
            SnippetCategory functionalGroupCategory = new SnippetCategory(groupName, MessageFormat.format(Messages.get().Controller_FunctionalGroupSnippetCategory_Description, groupName));
            for (IComponentInstanceConfig instance : instances) {
                List allSettings = ChildProviderHelper.getAllChildren((IChild)instance);
                Iterator iterator = allSettings.stream().filter(ch -> ch.isAvailable()).filter(ch -> ch.isEnabled()).filter(ch -> ch.providesSnippet()).iterator();
                if (!iterator.hasNext()) continue;
                String instanceName = instance.getName();
                SnippetCategory instanceCategory = new SnippetCategory(instanceName, MessageFormat.format(Messages.get().Controller_InstanceSnippetCategory_Description, instanceName));
                while (iterator.hasNext()) {
                    Object optionValue;
                    Object optionValue2;
                    IChild child = (IChild)iterator.next();
                    LinkedList<IChildProvidable> parents = new LinkedList<IChildProvidable>();
                    IChildProvidable parent = child.getChildContext().getParent();
                    while (parent != null && parent != child.getChildContext().getConfigSetConfig()) {
                        parents.addFirst(parent);
                        parent = parent.getChildContext().getParent();
                    }
                    StringJoiner joiner = new StringJoiner(" / ");
                    parents.forEach(x -> {
                        StringJoiner stringJoiner2 = joiner.add(x.getUiName());
                    });
                    String name = child.getUiName();
                    if (child.isOptionSet("SNIPPET_NAME") && child.isOptionAvailable("SNIPPET_NAME") && (optionValue2 = child.getOptionValue("SNIPPET_NAME")) instanceof String) {
                        name = (String)optionValue2;
                    }
                    joiner.add(name);
                    String description = UtilsText.safeString((String)child.getDescription());
                    if (child.isOptionSet("SNIPPET_DESCRIPTION") && child.isOptionAvailable("SNIPPET_DESCRIPTION") && (optionValue = child.getOptionValue("SNIPPET_DESCRIPTION")) instanceof String) {
                        description = (String)optionValue;
                    }
                    String value = UtilsText.safeToString((Object)child.getValue());
                    instanceCategory.addChild((SnippetNode)new SnippetInfo(joiner.toString(), description, value));
                }
                if (instanceCategory.getChildren().isEmpty()) continue;
                functionalGroupCategory.addChild((SnippetNode)instanceCategory);
            }
            if (functionalGroupCategory.getChildren().isEmpty()) continue;
            result.add((SnippetNode)functionalGroupCategory);
        }
        return result;
    }

    private boolean shouldGenerateSuffix(String componentType) {
        IComponentConfig componentConfig = this.getConfiguredComponent(componentType);
        if (componentConfig != null) {
            boolean uniqueInstance;
            boolean bl = uniqueInstance = componentConfig.getComponent().getComponentMaxInstancesNumber(this.functionalGroup.getExpressionContext()) == 1;
            if (!uniqueInstance) {
                return false;
            }
            IComponentConfig systemComponentConfig = this.profile.getSystemComponentConfig();
            boolean enabled = false;
            if (systemComponentConfig != null) {
                enabled = systemComponentConfig.getComponent().isOptionAvailable("GENERATE_COMPONENT_SUFFIX", systemComponentConfig.getExpressionContext());
            }
            return enabled;
        }
        return false;
    }
}

