/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.freertos.gdb.tad.view.providers;

import com.nxp.freertos.gdb.tad.model.Auxiliary;
import com.nxp.freertos.gdb.tad.model.TadModel;
import com.nxp.freertos.gdb.tad.model.freertos.FreeRTOSConfig;
import com.nxp.freertos.gdb.tad.strings.Texts;
import com.nxp.freertos.gdb.tad.view.column.TadColumnId;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public abstract class TadBarGraphProvider
extends StyledCellLabelProvider {
    protected FreeRTOSConfig dependency;
    protected TadColumnId columnId;
    protected String columnName;
    private boolean showWarning = false;

    protected void paintBarGraph(Event event, double percentage, String text, Color colour, boolean showWarning) {
        this.showWarning = showWarning;
        GC gc = event.gc;
        Color oldColor = gc.getBackground();
        int startX = 0;
        if (showWarning) {
            gc.drawImage(TadModel.WARNING_IMG, event.x, event.y);
            startX = TadModel.WARNING_IMG.getBounds().width;
        }
        if (text != null && percentage >= 0.0 && percentage <= 100.0) {
            int fullHeight = event.height - 1;
            int fullWidth = ((TreeViewerColumn)this.getColumn()).getColumn().getWidth() - 1;
            int width = (int)((double)fullWidth * (percentage / 100.0));
            if (colour != null) {
                gc.setBackground(colour);
            } else {
                float hue = 120.0f - 120.0f * (float)percentage / 100.0f;
                gc.setBackground(new Color((Device)Display.getCurrent(), new RGB((double)hue > 0.0 ? hue : 0.0f, 1.0f, 1.0f)));
            }
            gc.fillRectangle(startX + event.x, event.y, width, fullHeight);
            gc.setForeground(Auxiliary.getContrastColor(gc.getBackground()));
            gc.setFont(Display.getDefault().getSystemFont());
            gc.drawString(text, event.x + fullWidth / 2 - gc.textExtent((String)text).x / 2, event.y, true);
            gc.setBackground(oldColor);
        }
    }

    public String getToolTipText(Object element) {
        if (this.showWarning) {
            return String.format(Texts.get("Warning.Dependency"), this.dependency.toString(), Auxiliary.capitalize(this.columnName));
        }
        return null;
    }

    public void setDependency(FreeRTOSConfig dependency) {
        this.dependency = dependency;
    }

    public void setColumnId(TadColumnId columnId) {
        this.columnId = columnId;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }
}

