/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.freertos.gdb.tad.controller.timerlist;

import com.nxp.freertos.gdb.tad.ReadingException;
import com.nxp.freertos.gdb.tad.controller.TadFactory;
import com.nxp.freertos.gdb.tad.controller.TadFactoryData;
import com.nxp.freertos.gdb.tad.controller.TadFactoryDataStatus;
import com.nxp.freertos.gdb.tad.logger.Logger;
import com.nxp.freertos.gdb.tad.model.freertos.FreeRTOS;
import com.nxp.freertos.gdb.tad.model.freertos.FreeRTOSConfig;
import com.nxp.freertos.gdb.tad.model.readers.MemoryReader;
import com.nxp.freertos.gdb.tad.model.readers.VariableReader;
import com.nxp.freertos.gdb.tad.model.views.TadValue;
import com.nxp.freertos.gdb.tad.model.views.timerlist.Timer;
import com.nxp.freertos.gdb.tad.model.views.timerlist.TimerCallback;
import com.nxp.freertos.gdb.tad.model.views.timerlist.TimerStatus;
import com.nxp.freertos.gdb.tad.strings.Texts;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class TimerFactory
extends TadFactory {
    private final String[] timerLists = new String[]{"pxCurrentTimerList", "pxOverflowTimerList"};

    public TimerFactory(MemoryReader memoryReader, VariableReader variableReader, FreeRTOS freeRTOS) {
        super(memoryReader, variableReader, freeRTOS);
    }

    @Override
    public TadFactoryData getData() {
        LinkedList<Timer> list = new LinkedList<Timer>();
        try {
            String[] stringArray = this.timerLists;
            int n = this.timerLists.length;
            int n2 = 0;
            while (n2 < n) {
                String listName = stringArray[n2];
                list.addAll(this.readTimersFromList(listName));
                ++n2;
            }
            Collections.sort(list, new Comparator<Timer>(){

                @Override
                public int compare(Timer timer1, Timer timer2) {
                    if (timer1.getId() < timer2.getId()) {
                        return -1;
                    }
                    if (timer1.getId() > timer2.getId()) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
        catch (ReadingException e) {
            Logger.exception(e, e.getSummary());
            return new TadFactoryData(list, TadFactoryDataStatus.ERROR, String.format(Texts.get("Error.CouldNotGetFactoryData"), "Timer List"));
        }
        return new TadFactoryData(list, TadFactoryDataStatus.SUCCESS, null);
    }

    private synchronized List<Timer> readTimersFromList(String listName) throws ReadingException {
        LinkedList<Timer> list = new LinkedList<Timer>();
        int numberOfItems = this.readIntVariableSafely(String.valueOf(listName) + ".uxNumberOfItems");
        long listAddress = this.readLongVariableSafely(String.valueOf(listName) + ".xListEnd.pxNext");
        if (numberOfItems <= 0 || listAddress <= 0L) {
            return list;
        }
        int i = 0;
        while (i < numberOfItems) {
            TimerStatus status;
            long address = this.readLongAtAddress(listAddress, this.freeRTOS.getStruct("list_item"), "pvOwner");
            long nameAddress = this.readLongAtAddress(address, this.freeRTOS.getStruct("timer"), "pcTimerName");
            Long number = null;
            if (this.freeRTOS.isMacroEnabled(FreeRTOSConfig.USE_TRACE)) {
                try {
                    number = this.readLongAtAddress(address, this.freeRTOS.getStruct("timer"), "uxTimerNumber");
                }
                catch (ReadingException readingException) {
                    this.freeRTOS.enableMacro(FreeRTOSConfig.USE_TRACE, false);
                }
            }
            TadValue callback = this.readLongAndContextAtAddress(address, this.freeRTOS.getStruct("timer"), "pxCallbackFunction");
            if (this.freeRTOS.isOlderThan(FreeRTOS.FREERTOS_VERSION_10_2_0)) {
                boolean uxAutoReload = this.readIntAtAddress(address, this.freeRTOS.getStruct("timer"), "uxAutoReload") == 1;
                status = new TimerStatus(false, false, uxAutoReload);
            } else {
                int ucStatus = this.readIntAtAddress(address, this.freeRTOS.getStruct("timer"), "ucStatus");
                status = new TimerStatus(ucStatus);
            }
            list.add(new Timer(address, this.readTextAtAddress(nameAddress), this.readIntAtAddress(address, this.freeRTOS.getStruct("timer"), "pvTimerID"), number, this.readLongAtAddress(address, this.freeRTOS.getStruct("timer"), "xTimerPeriodInTicks"), status, new TimerCallback(callback.getValue(), callback.getContext())));
            listAddress = this.readLongAtAddress(listAddress, this.freeRTOS.getStruct("list_item"), "pxNext");
            ++i;
        }
        return list;
    }
}

