/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.freertos.gdb.tad.controller.queuelist;

import com.nxp.freertos.gdb.tad.ReadingException;
import com.nxp.freertos.gdb.tad.controller.TadFactory;
import com.nxp.freertos.gdb.tad.controller.TadFactoryData;
import com.nxp.freertos.gdb.tad.controller.TadFactoryDataStatus;
import com.nxp.freertos.gdb.tad.logger.Logger;
import com.nxp.freertos.gdb.tad.model.freertos.FreeRTOS;
import com.nxp.freertos.gdb.tad.model.freertos.FreeRTOSConfig;
import com.nxp.freertos.gdb.tad.model.readers.MemoryReader;
import com.nxp.freertos.gdb.tad.model.readers.VariableReader;
import com.nxp.freertos.gdb.tad.model.views.queuelist.Queue;
import com.nxp.freertos.gdb.tad.model.views.queuelist.QueueData;
import com.nxp.freertos.gdb.tad.model.views.queuelist.QueueType;
import com.nxp.freertos.gdb.tad.model.views.queuelist.QueueWaitingTask;
import com.nxp.freertos.gdb.tad.model.views.queuelist.QueueWaitingTaskOperation;
import com.nxp.freertos.gdb.tad.strings.Texts;
import java.util.LinkedList;
import java.util.List;

public class QueueFactory
extends TadFactory {
    public QueueFactory(MemoryReader memoryReader, VariableReader variableReader, FreeRTOS freeRTOS) {
        super(memoryReader, variableReader, freeRTOS);
    }

    @Override
    public synchronized TadFactoryData getData() {
        LinkedList<Queue> list = new LinkedList<Queue>();
        if (this.freeRTOS.getQueueRegistrySize() == null) {
            try {
                this.freeRTOS.setQueueRegistrySize(this.getSize("xQueueRegistry"));
            }
            catch (ReadingException readingException) {
                Logger.error(Texts.get("Warning.Dependency.Queue"));
                this.freeRTOS.setQueueRegistrySize(0L);
            }
        }
        if (this.freeRTOS.getQueueRegistrySize() == 0L || this.readAddressOfVariableSafely("xQueueRegistry") < 1L) {
            return new TadFactoryData(list, TadFactoryDataStatus.WARNING, Texts.get("Warning.Dependency.Queue"));
        }
        try {
            long queueRegistryItemSize = this.getStructSize(this.freeRTOS.getStruct("queue_registr_item"));
            if (queueRegistryItemSize > 0L) {
                long numberOfQueues = this.freeRTOS.getQueueRegistrySize() / queueRegistryItemSize;
                int i = 0;
                while ((long)i < numberOfQueues) {
                    String readFrom = "xQueueRegistry[" + i + "]";
                    long queueAddress = this.readAddressOfVariableSafely(readFrom);
                    if (queueAddress > 0L) {
                        Queue queue = this.getQueue(queueAddress);
                        if (queue != null) {
                            list.add(queue);
                        }
                    } else {
                        Logger.error(String.format(Texts.get("Error.CannotReadFrom"), readFrom));
                    }
                    ++i;
                }
            }
        }
        catch (ReadingException e) {
            Logger.exception(e, e.getSummary());
            return new TadFactoryData(list, TadFactoryDataStatus.ERROR, String.format(Texts.get("Error.CouldNotGetFactoryData"), "Queue List"));
        }
        return new TadFactoryData(list, TadFactoryDataStatus.SUCCESS, null);
    }

    private synchronized Queue getQueue(long queueAddress) throws ReadingException {
        List<Long> blocks;
        long pcQueueName;
        long queueHandle;
        try {
            queueHandle = this.readLongAtAddress(queueAddress, this.freeRTOS.getStruct("queue_registr_item"), "xHandle");
            pcQueueName = this.readLongAtAddress(queueAddress, this.freeRTOS.getStruct("queue_registr_item"), "pcQueueName");
        }
        catch (ReadingException readingException) {
            return null;
        }
        if (queueHandle == 0L || pcQueueName == 0L) {
            return null;
        }
        String queueName = this.readTextAtAddress(pcQueueName);
        long maxLength = this.readLongAtAddressSafely(queueHandle, this.freeRTOS.getStruct("queue"), "uxLength");
        long currentLength = this.readLongAtAddressSafely(queueHandle, this.freeRTOS.getStruct("queue"), "uxMessagesWaiting");
        int itemSize = this.readIntAtAddressSafely(queueHandle, this.freeRTOS.getStruct("queue"), "uxItemSize");
        long queueHead = this.readLongAtAddressSafely(queueHandle, this.freeRTOS.getStruct("queue"), "pcHead");
        long writeTo = this.readLongAtAddressSafely(queueHandle, this.freeRTOS.getStruct("queue"), "pcWriteTo");
        long queueTail = this.readLongAtAddressSafely(queueHandle, this.freeRTOS.getStruct("queue"), this.freeRTOS.isOlderThan(FreeRTOS.FREERTOS_VERSION_10_1_0) ? "pcTail" : "u.xQueue.pcTail");
        long readFrom = this.readLongAtAddressSafely(queueHandle, this.freeRTOS.getStruct("queue"), this.freeRTOS.isOlderThan(FreeRTOS.FREERTOS_VERSION_10_1_0) ? "u.pcReadFrom" : "u.xQueue.pcReadFrom");
        Queue queue = new Queue(queueHandle, queueName, maxLength, currentLength, itemSize, queueHead, queueTail, readFrom, writeTo);
        if (this.freeRTOS.isMacroEnabled(FreeRTOSConfig.USE_TRACE)) {
            try {
                int queueTypeNum = this.readIntAtAddress(queueHandle, this.freeRTOS.getStruct("queue"), "ucQueueType");
                queue.setType(this.determineQueueType(queue, queueTypeNum));
            }
            catch (ReadingException readingException) {
                this.freeRTOS.enableMacro(FreeRTOSConfig.USE_TRACE, false);
            }
        }
        QueueWaitingTaskOperation[] queueWaitingTaskOperationArray = QueueWaitingTaskOperation.values();
        int n = queueWaitingTaskOperationArray.length;
        int n2 = 0;
        while (n2 < n) {
            QueueWaitingTaskOperation operation = queueWaitingTaskOperationArray[n2];
            int waitingCount = this.readIntAtAddressSafely(queueHandle, this.freeRTOS.getStruct("queue"), String.valueOf(operation.getValue()) + ".uxNumberOfItems");
            if (waitingCount > 0) {
                queue.addWaitingTask(operation, new QueueWaitingTask(this.readAddressAtAddress(queueHandle, this.freeRTOS.getStruct("queue"), operation.getValue()), this.readTaskName(this.readLongAtAddress(queueHandle, this.freeRTOS.getStruct("queue"), String.valueOf(operation.getValue()) + ".xListEnd.pxNext.pvOwner")), waitingCount));
            }
            ++n2;
        }
        if (queue.getDataSize() > 0 && queue.getHead() > 0L && (blocks = this.readMemoryBlock(queue.getHead(), queue.getDataSize(), 4)) != null && !blocks.isEmpty()) {
            LinkedList<QueueData> data = new LinkedList<QueueData>();
            int i = 0;
            while ((long)i < queue.getCurrentLength()) {
                int index = i * (queue.getDataItemSize() / 4);
                data.add(new QueueData(i + 1, (int)queue.getHead() + index, blocks.subList(index, index + queue.getDataItemSize() / 4)));
                ++i;
            }
            queue.setData(data);
        }
        return queue;
    }

    private QueueType determineQueueType(Queue queue, int type) {
        switch (type) {
            default: {
                if (queue.getDataItemSize() == 0) {
                    return queue.getHead() == 0L ? QueueType.MUTEX : QueueType.BINARY_SEMAPHORE;
                }
                return QueueType.QUEUE;
            }
            case 1: {
                return QueueType.MUTEX;
            }
            case 2: {
                return QueueType.COUNTING_SEMAPHORE;
            }
            case 3: {
                return QueueType.BINARY_SEMAPHORE;
            }
            case 4: 
        }
        return QueueType.RECURSIVE_MUTEX;
    }
}

