/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service;

import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.AbstractDMContext;
import org.eclipse.cdt.dsf.datamodel.AbstractDMEvent;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.ICachingService;
import org.eclipse.cdt.dsf.debug.service.IDisassembly;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.BufferedCommandControl;
import org.eclipse.cdt.dsf.debug.service.command.CommandCache;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcessDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcesses;
import org.eclipse.cdt.dsf.mi.service.IMIRunControl;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.output.CLIInfoThreadsInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIThreadListIdsInfo;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class MIProcesses
extends AbstractDsfService
implements IMIProcesses,
ICachingService {
    private ICommandControlService fCommandControl;
    private CommandCache fContainerCommandCache;
    private CommandFactory fCommandFactory;
    private IGDBBackend fGdbBackend;
    private static final String FAKE_THREAD_ID = "0";
    public static final String UNIQUE_GROUP_ID = "";
    public static final String UNKNOWN_PROCESS_ID = "";

    public MIProcesses(DsfSession session) {
        super(session);
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(requestMonitor){

            protected void handleSuccess() {
                MIProcesses.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.fCommandControl = (ICommandControlService)this.getServicesTracker().getService(ICommandControlService.class);
        BufferedCommandControl bufferedCommandControl = new BufferedCommandControl((ICommandControl)this.fCommandControl, this.getExecutor(), 2);
        this.fCommandFactory = ((IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class)).getCommandFactory();
        this.fGdbBackend = (IGDBBackend)this.getServicesTracker().getService(IGDBBackend.class);
        this.fContainerCommandCache = new CommandCache(this.getSession(), (ICommandControl)bufferedCommandControl);
        this.fContainerCommandCache.setContextAvailable((IDMContext)this.fCommandControl.getContext(), true);
        this.getSession().addServiceEventListener((Object)this, null);
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.getSession().removeServiceEventListener((Object)this);
        super.shutdown(requestMonitor);
    }

    protected BundleContext getBundleContext() {
        return GdbPlugin.getBundleContext();
    }

    @Override
    public IProcesses.IThreadDMContext createThreadContext(IProcesses.IProcessDMContext processDmc, String threadId) {
        return new MIThreadDMC(this.getSession().getId(), processDmc, threadId);
    }

    @Override
    public IProcesses.IProcessDMContext createProcessContext(ICommandControlService.ICommandControlDMContext controlDmc, String pid) {
        return new MIProcessDMC(this.getSession().getId(), controlDmc, pid);
    }

    @Override
    public IMIExecutionDMContext createExecutionContext(IRunControl.IContainerDMContext containerDmc, IProcesses.IThreadDMContext threadDmc, String threadId) {
        return new MIExecutionDMC(this.getSession().getId(), containerDmc, threadDmc, threadId);
    }

    @Override
    public IMIContainerDMContext createContainerContext(IProcesses.IProcessDMContext processDmc, String groupId) {
        return new MIContainerDMC(this.getSession().getId(), processDmc, groupId);
    }

    @Override
    public IMIContainerDMContext createContainerContextFromThreadId(ICommandControlService.ICommandControlDMContext controlDmc, String threadId) {
        return this.createContainerContextFromGroupId(controlDmc, "");
    }

    @Override
    public IMIContainerDMContext createContainerContextFromGroupId(ICommandControlService.ICommandControlDMContext controlDmc, String groupId) {
        IProcesses.IProcessDMContext processDmc = this.createProcessContext(controlDmc, "");
        return this.createContainerContext(processDmc, groupId);
    }

    public void getExecutionData(IProcesses.IThreadDMContext dmc, final DataRequestMonitor<IProcesses.IThreadDMData> rm) {
        if (dmc instanceof MIProcessDMC) {
            rm.setData((Object)new MIThreadDMData("", ((MIProcessDMC)dmc).getProcId()));
            rm.done();
        } else if (dmc instanceof MIThreadDMC) {
            final MIThreadDMC threadDmc = (MIThreadDMC)dmc;
            IProcesses.IProcessDMContext procDmc = (IProcesses.IProcessDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IProcesses.IProcessDMContext.class);
            this.getDebuggingContext((IProcesses.IThreadDMContext)procDmc, new DataRequestMonitor<IDMContext>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    if (this.getData() instanceof IMIContainerDMContext) {
                        IMIContainerDMContext contDmc = (IMIContainerDMContext)this.getData();
                        MIProcesses.this.fContainerCommandCache.execute(MIProcesses.this.fCommandFactory.createCLIInfoThreads(contDmc), (DataRequestMonitor)new DataRequestMonitor<CLIInfoThreadsInfo>((Executor)MIProcesses.this.getExecutor(), (RequestMonitor)rm){

                            protected void handleSuccess() {
                                MIThreadDMData threadData = null;
                                for (CLIInfoThreadsInfo.ThreadInfo thread : ((CLIInfoThreadsInfo)this.getData()).getThreadInfo()) {
                                    if (!thread.getId().equals(threadDmc.getId())) continue;
                                    threadData = new MIThreadDMData(thread.getName(), thread.getOsId());
                                    break;
                                }
                                if (threadData != null) {
                                    rm.setData(threadData);
                                } else {
                                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Could not get thread info", null));
                                }
                                rm.done();
                            }
                        });
                    } else {
                        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid DMC type", null));
                        rm.done();
                    }
                }
            });
        }
    }

    public void getDebuggingContext(IProcesses.IThreadDMContext dmc, DataRequestMonitor<IDMContext> rm) {
        if (dmc instanceof MIProcessDMC) {
            MIProcessDMC procDmc = (MIProcessDMC)dmc;
            rm.setData((Object)this.createContainerContext(procDmc, procDmc.getProcId()));
        } else if (dmc instanceof MIThreadDMC) {
            MIThreadDMC threadDmc = (MIThreadDMC)dmc;
            IMIProcessDMContext procDmc = (IMIProcessDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMIProcessDMContext.class);
            IMIContainerDMContext containerDmc = this.createContainerContext(procDmc, procDmc.getProcId());
            rm.setData((Object)this.createExecutionContext(containerDmc, threadDmc, threadDmc.getId()));
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid thread context.", null));
        }
        rm.done();
    }

    public void isDebuggerAttachSupported(IDMContext dmc, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)false);
        rm.done();
    }

    public void attachDebuggerToProcess(final IProcesses.IProcessDMContext procCtx, final DataRequestMonitor<IDMContext> rm) {
        if (procCtx instanceof IMIProcessDMContext) {
            ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)procCtx, ICommandControlService.ICommandControlDMContext.class);
            this.fCommandControl.queueCommand(this.fCommandFactory.createCLIAttach(controlDmc, ((IMIProcessDMContext)procCtx).getProcId()), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    IMIContainerDMContext containerDmc = MIProcesses.this.createContainerContext(procCtx, "");
                    MIProcesses.this.getSession().dispatchEvent((Object)new ContainerStartedDMEvent(containerDmc), MIProcesses.this.getProperties());
                    rm.setData((Object)containerDmc);
                    rm.done();
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid process context.", null));
            rm.done();
        }
    }

    public void canDetachDebuggerFromProcess(IDMContext dmc, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)false);
        rm.done();
    }

    public void detachDebuggerFromProcess(final IDMContext dmc, final RequestMonitor rm) {
        ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class);
        if (controlDmc != null) {
            IMIRunControl runControl = (IMIRunControl)this.getServicesTracker().getService(IMIRunControl.class);
            if (runControl != null && !runControl.isTargetAcceptingCommands()) {
                this.fGdbBackend.interrupt();
            }
            this.fCommandControl.queueCommand(this.fCommandFactory.createCLIDetach((IDMContext)controlDmc), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    IRunControl.IContainerDMContext containerDmc = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IRunControl.IContainerDMContext.class);
                    if (containerDmc != null) {
                        MIProcesses.this.getSession().dispatchEvent((Object)new ContainerExitedDMEvent(containerDmc), MIProcesses.this.getProperties());
                    }
                    rm.done();
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Invalid context.", null));
            rm.done();
        }
    }

    public void canTerminate(IProcesses.IThreadDMContext thread, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)true);
        rm.done();
    }

    public void isDebugNewProcessSupported(IDMContext dmc, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)false);
        rm.done();
    }

    public void debugNewProcess(IDMContext dmc, String file, Map<String, Object> attributes, DataRequestMonitor<IDMContext> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Not supported", null));
        rm.done();
    }

    public void getProcessesBeingDebugged(IDMContext dmc, final DataRequestMonitor<IDMContext[]> rm) {
        final IMIContainerDMContext containerDmc = (IMIContainerDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMIContainerDMContext.class);
        if (containerDmc != null) {
            this.fContainerCommandCache.execute(this.fCommandFactory.createMIThreadListIds(containerDmc), (DataRequestMonitor)new DataRequestMonitor<MIThreadListIdsInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    rm.setData((Object)MIProcesses.this.makeExecutionDMCs(containerDmc, (MIThreadListIdsInfo)this.getData()));
                    rm.done();
                }
            });
        } else {
            ICommandControlService.ICommandControlDMContext controlDmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ICommandControlService.ICommandControlDMContext.class);
            IMIContainerDMContext newContainerDmc = this.createContainerContextFromGroupId(controlDmc, "");
            rm.setData((Object)new IRunControl.IContainerDMContext[]{newContainerDmc});
            rm.done();
        }
    }

    private IRunControl.IExecutionDMContext[] makeExecutionDMCs(IRunControl.IContainerDMContext containerDmc, MIThreadListIdsInfo info) {
        IProcesses.IProcessDMContext procDmc = (IProcesses.IProcessDMContext)DMContexts.getAncestorOfType((IDMContext)containerDmc, IProcesses.IProcessDMContext.class);
        if (info.getStrThreadIds().length == 0) {
            return new IMIExecutionDMContext[]{this.createExecutionContext(containerDmc, this.createThreadContext(procDmc, FAKE_THREAD_ID), FAKE_THREAD_ID)};
        }
        IRunControl.IExecutionDMContext[] executionDmcs = new IMIExecutionDMContext[info.getStrThreadIds().length];
        int i = 0;
        while (i < info.getStrThreadIds().length) {
            String threadId = info.getStrThreadIds()[i];
            executionDmcs[i] = this.createExecutionContext(containerDmc, this.createThreadContext(procDmc, threadId), threadId);
            ++i;
        }
        return executionDmcs;
    }

    public void getRunningProcesses(IDMContext dmc, DataRequestMonitor<IProcesses.IProcessDMContext[]> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Not supported", null));
        rm.done();
    }

    public void isRunNewProcessSupported(IDMContext dmc, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)false);
        rm.done();
    }

    public void runNewProcess(IDMContext dmc, String file, Map<String, Object> attributes, DataRequestMonitor<IProcesses.IProcessDMContext> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Not supported", null));
        rm.done();
    }

    public void terminate(IProcesses.IThreadDMContext thread, RequestMonitor rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Not supported", null));
        rm.done();
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IResumedDMEvent e) {
        if (e instanceof IRunControl.IContainerResumedDMEvent) {
            this.fContainerCommandCache.setContextAvailable(e.getDMContext(), false);
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
        assert (e instanceof IRunControl.IContainerSuspendedDMEvent) : "Unexpected type of suspended event: " + e.getClass().toString();
        this.fContainerCommandCache.setContextAvailable(e.getDMContext(), true);
        try {
            if (this.fGdbBackend.getUpdateThreadListOnSuspend()) {
                this.fContainerCommandCache.reset(e.getDMContext());
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IStartedDMEvent e) {
        this.fContainerCommandCache.reset();
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IExitedDMEvent e) {
        this.fContainerCommandCache.reset();
    }

    public void flushCache(IDMContext context) {
        this.fContainerCommandCache.reset(context);
    }

    public static class ContainerExitedDMEvent
    extends AbstractDMEvent<IRunControl.IExecutionDMContext>
    implements IRunControl.IExitedDMEvent {
        public ContainerExitedDMEvent(IRunControl.IContainerDMContext context) {
            super((IDMContext)context);
        }
    }

    public static class ContainerStartedDMEvent
    extends AbstractDMEvent<IRunControl.IExecutionDMContext>
    implements IRunControl.IStartedDMEvent {
        public ContainerStartedDMEvent(IRunControl.IContainerDMContext context) {
            super((IDMContext)context);
        }
    }

    @Immutable
    protected static class MIContainerDMC
    extends AbstractDMContext
    implements IMIContainerDMContext,
    IBreakpoints.IBreakpointsTargetDMContext,
    IDisassembly.IDisassemblyDMContext {
        private final String fId;

        public MIContainerDMC(String sessionId, IProcesses.IProcessDMContext processDmc, String groupId) {
            IDMContext[] iDMContextArray;
            if (processDmc == null) {
                iDMContextArray = new IDMContext[]{};
            } else {
                IDMContext[] iDMContextArray2 = new IDMContext[1];
                iDMContextArray = iDMContextArray2;
                iDMContextArray2[0] = processDmc;
            }
            super(sessionId, iDMContextArray);
            this.fId = groupId;
        }

        @Override
        public String getGroupId() {
            return this.fId;
        }

        public String toString() {
            return String.valueOf(this.baseToString()) + ".threadGroup[" + this.fId + "]";
        }

        public boolean equals(Object obj) {
            return super.baseEquals(obj) && (((MIContainerDMC)obj).fId == null ? this.fId == null : ((MIContainerDMC)obj).fId.equals(this.fId));
        }

        public int hashCode() {
            return super.baseHashCode() ^ (this.fId == null ? 0 : this.fId.hashCode());
        }
    }

    @Immutable
    private static class MIExecutionDMC
    extends AbstractDMContext
    implements IMIExecutionDMContext,
    IDisassembly.IDisassemblyDMContext {
        private final String fThreadId;

        protected MIExecutionDMC(String sessionId, IRunControl.IContainerDMContext containerDmc, IProcesses.IThreadDMContext threadDmc, String threadId) {
            IDMContext[] iDMContextArray;
            if (containerDmc == null && threadDmc == null) {
                iDMContextArray = new IDMContext[]{};
            } else if (containerDmc == null) {
                IDMContext[] iDMContextArray2 = new IDMContext[1];
                iDMContextArray = iDMContextArray2;
                iDMContextArray2[0] = threadDmc;
            } else if (threadDmc == null) {
                IDMContext[] iDMContextArray3 = new IDMContext[1];
                iDMContextArray = iDMContextArray3;
                iDMContextArray3[0] = containerDmc;
            } else {
                IDMContext[] iDMContextArray4 = new IDMContext[2];
                iDMContextArray4[0] = containerDmc;
                iDMContextArray = iDMContextArray4;
                iDMContextArray4[1] = threadDmc;
            }
            super(sessionId, iDMContextArray);
            this.fThreadId = threadId;
        }

        @Override
        public String getThreadId() {
            return this.fThreadId;
        }

        public String toString() {
            return String.valueOf(this.baseToString()) + ".thread[" + this.fThreadId + "]";
        }

        public boolean equals(Object obj) {
            return super.baseEquals(obj) && ((MIExecutionDMC)obj).fThreadId.equals(this.fThreadId);
        }

        public int hashCode() {
            return super.baseHashCode() ^ this.fThreadId.hashCode();
        }
    }

    @Immutable
    private static class MIProcessDMC
    extends AbstractDMContext
    implements IMIProcessDMContext {
        private final String fId;

        public MIProcessDMC(String sessionId, ICommandControlService.ICommandControlDMContext controlDmc, String id) {
            IDMContext[] iDMContextArray;
            if (controlDmc == null) {
                iDMContextArray = new IDMContext[]{};
            } else {
                IDMContext[] iDMContextArray2 = new IDMContext[1];
                iDMContextArray = iDMContextArray2;
                iDMContextArray2[0] = controlDmc;
            }
            super(sessionId, iDMContextArray);
            this.fId = id;
        }

        @Override
        public String getProcId() {
            return this.fId;
        }

        public String toString() {
            return String.valueOf(this.baseToString()) + ".proc[" + this.fId + "]";
        }

        public boolean equals(Object obj) {
            if (!this.baseEquals(obj)) {
                return false;
            }
            MIProcessDMC other = (MIProcessDMC)obj;
            if (this.fId == null || other.fId == null) {
                return this.fId == null && other.fId == null;
            }
            if (this.fId.equals("") || other.fId.equals("")) {
                return true;
            }
            return this.fId.equals(other.fId);
        }

        public int hashCode() {
            return this.baseHashCode();
        }
    }

    @Immutable
    private static class MIThreadDMC
    extends AbstractDMContext
    implements IProcesses.IThreadDMContext {
        private final String fId;

        public MIThreadDMC(String sessionId, IProcesses.IProcessDMContext processDmc, String id) {
            IDMContext[] iDMContextArray;
            if (processDmc == null) {
                iDMContextArray = new IDMContext[]{};
            } else {
                IDMContext[] iDMContextArray2 = new IDMContext[1];
                iDMContextArray = iDMContextArray2;
                iDMContextArray2[0] = processDmc;
            }
            super(sessionId, iDMContextArray);
            this.fId = id;
        }

        public String getId() {
            return this.fId;
        }

        public String toString() {
            return String.valueOf(this.baseToString()) + ".OSthread[" + this.fId + "]";
        }

        public boolean equals(Object obj) {
            return super.baseEquals(obj) && (((MIThreadDMC)((Object)obj)).fId == null ? this.fId == null : ((MIThreadDMC)((Object)obj)).fId.equals(this.fId));
        }

        public int hashCode() {
            return super.baseHashCode() ^ (this.fId == null ? 0 : this.fId.hashCode());
        }
    }

    @Immutable
    protected static class MIThreadDMData
    implements IProcesses.IThreadDMData {
        final String fName;
        final String fId;

        public MIThreadDMData(String name, String id) {
            this.fName = name;
            this.fId = id;
        }

        public String getId() {
            return this.fId;
        }

        public String getName() {
            return this.fName;
        }

        public boolean isDebuggerAttached() {
            return true;
        }
    }
}

